/* Razor 1a - Modif by MikaelB
   Razor Preferences dialog */


#include "RazorPreferencesDlg.h"
#include <math.h>

 /* Events */
BEGIN_EVENT_TABLE(RazorPrefs, wxFrame)

  EVT_BUTTON(ID_SAVE_BUTTON,RazorPrefs::OnSave)
  EVT_BUTTON(ID_QUIT_BUTTON,RazorPrefs::OnQuit)

END_EVENT_TABLE()

/* Constructor */
RazorPrefs::RazorPrefs(wxFrame* parent)
   : wxFrame(parent/*(wxFrame *) NULL*/, -1, _T("Razor Preferences Dialog"))
{
  // Add the Razor Preferences dialog
  wxSizer *item = RazorPreferences(this, true, true);

  // Init items
  parent_frm = parent;
  nnsCheckBox = (wxCheckBox*) FindWindow(ID_ENABLE_AUTO_NNS);
  fqsCheckBox = (wxCheckBox*) FindWindow(ID_ENABLE_AUTO_FQS);
  hqrsCheckBox = (wxCheckBox*) FindWindow(ID_ENABLE_AUTO_HQRS);
  nnsTimer = (wxTextCtrl*) FindWindow(ID_AUTO_NNS_TIMER);
  fqsTimer = (wxTextCtrl*) FindWindow(ID_AUTO_FQS_TIMER);
  hqrsTimer = (wxTextCtrl*) FindWindow(ID_AUTO_HQRS_TIMER);
  hqrLimit = (wxTextCtrl*) FindWindow(ID_AUTO_HQRS_HQR);
  dynUpCheckBox = (wxCheckBox*) FindWindow(ID_ENABLE_DYNUPLOAD);
  dynUpPingUrl = (wxTextCtrl*) FindWindow(ID_PING_URL);
  dynUpResponse = (wxTextCtrl*) FindWindow(ID_RESPONSE_VALUE);
  dynUpPingType = (wxRadioBox*) FindWindow(ID_PING_RADIO);     

  // Load prefs
  OnLoad();
  
  // Show frame
  Show(true);
}

/* Destructor */
RazorPrefs::~RazorPrefs()
{
  // Create a config base for saving razor preferences
  wxConfigBase *config = wxConfigBase::Get();
  // If config haven't been created
  if (config == NULL)
    // exit without saving
    return;

  // The section where to save in in file
  CString section = "/Razor_Preferences/";

  // Razor window location and size
  int x1,y1,x2,y2;
  GetPosition(&x1, &y1);
  GetSize(&x2,&y2);

  // Saving window size and position
  config->Write(_T(section+"RAZOR_X_POS"), (long) x1);
  config->Write(_T(section+"RAZOR_Y_POS"), (long) y1);
  config->Write(_T(section+"RAZOR_X_SIZE"), (long) x2);
  config->Write(_T(section+"RAZOR_Y_SIZE"), (long) y2);

  config->Flush(true); 
}

/* When quit */
void RazorPrefs::OnQuit(wxCommandEvent& event)
{
  // Close frame
  Close(true);
}

/* When Save */
void RazorPrefs::OnSave(wxCommandEvent& event)
{
  // Create a config base for saving razor preferences
  wxConfigBase *config = wxConfigBase::Get();
  // If config haven't been created
  if (config == NULL)
    // exit without saving
    return;

  // The section where to save in in file
  CString section = "/Razor_Preferences/";

  // Verify text control values are ok  and save
  wxString temp;
  temp = nnsTimer->GetValue();
  long entier;

  config->Write(_T(section+"AutoRemoveNNS"), nnsCheckBox->GetValue());
  if((temp.ToLong(&entier, 10)) && (entier >= 60) && (entier <= 1800))
    config->Write(_T(section+"AutoNNSTimer"), temp);
  config->Write(_T(section+"AutoRemoveFQS"), fqsCheckBox->GetValue());
  temp = fqsTimer->GetValue();
  if((temp.ToLong(&entier, 10)) && (entier >= 60) && (entier <= 1800))
    config->Write(_T(section+"AutoFQSTimer"), temp);
  config->Write(_T(section+"AutoRemoveHQRS"), hqrsCheckBox->GetValue());
  temp = hqrsTimer->GetValue();
  if((temp.ToLong(&entier, 10)) && (entier >= 60) && (entier <= 1800))
    config->Write(_T(section+"AutoHQRSTimer"), temp);
  temp = hqrLimit->GetValue();  
  if((temp.ToLong(&entier, 10)) && (entier >= 300) && (entier <= 3000))
    config->Write(_T(section+"HQRValue"), temp);
  config->Write(_T(section+"DynamicUpload"), dynUpCheckBox->GetValue());
  config->Write(_T(section+"PingURL"), dynUpPingUrl->GetValue());
  temp = dynUpResponse->GetValue();
  if((temp.ToLong(&entier, 10)) && (entier >= 1) && (entier <= 20))
    config->Write(_T(section+"PingResponse"), temp);
  config->Write(_T(section+"PingType"), dynUpPingType->GetSelection());  

    
  config->Flush(true);

  wxMessageDialog *d = new wxMessageDialog(this, "All theses options aren't functional yet", "No functional",wxOK, wxDefaultPosition);
  d->ShowModal();                  
}

/* When Load */
void RazorPrefs::OnLoad()
{
  // Create a config base for saving razor preferences
  wxConfigBase *config = wxConfigBase::Get();
  // If config haven't been created
  if (config == NULL)
    // exit without saving
    return;

  // The section where to save in in file
  CString section = "/Razor_Preferences/";

  // Load !
  nnsCheckBox->SetValue(config->Read(_T(section+"AutoRemoveNNS"), 0l));
  nnsTimer->SetValue(config->Read(_T(section+"AutoNNSTimer"), _T("180")));
  fqsCheckBox->SetValue(config->Read(_T(section+"AutoRemoveFQS"), 0l));
  fqsTimer->SetValue(config->Read(_T(section+"AutoFQSTimer"), _T("180")));
  hqrsCheckBox->SetValue(config->Read(_T(section+"AutoRemoveHQRS"), 0l));
  hqrsTimer->SetValue(config->Read(_T(section+"AutoHQRSTimer"), _T("180")));
  hqrLimit->SetValue(config->Read(_T(section+"HQRValue"), _T("1200")));
  dynUpCheckBox->SetValue(config->Read(_T(section+"DynamicUpload"), 0l));
  dynUpPingUrl->SetValue(config->Read(_T(section+"PingURL"), _T("")));
  dynUpResponse->SetValue(config->Read(_T(section+"PingResponse"), _T("20")));
  dynUpPingType->SetSelection(config->Read(_T(section+"PingType"), 0l)); 

  int x1,y1,x2,y2;
  x1 = config->Read(_T(section+"RAZOR_X_POS"), 0l);
  y1 = config->Read(_T(section+"RAZOR_Y_POS"), 0l);
  x2 = config->Read(_T(section+"RAZOR_X_SIZE"), 0l);
  y2 = config->Read(_T(section+"RAZOR_Y_SIZE"), 0l);

  // If x1 and y1 != 0
  if((x1 != 0) && (y1 != 0))
    // Redefine location
    Move(x1,y1);

  // If x2 and y2 != 0
  if((x2 != 0) && (y2 != 0))
    // Redefine size
    SetClientSize(x2,y2);
}

