//this file is part of xMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.xmule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// StatsSetup.cpp : implementation file
//

#include "stdafx.h"
#include "xmule.h"
#include "StatsSetup.h"
#include "otherfunctions.h"


// CStatsSetup dialog

IMPLEMENT_DYNAMIC(CStatsSetup, CDialog)
CStatsSetup::CStatsSetup()
	: CDialog(CStatsSetup::IDD, 0)
{
}

CStatsSetup::~CStatsSetup()
{
}

void CStatsSetup::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COLORSELECTOR, m_color);
}

BOOL CStatsSetup::OnInitDialog(){
	CDialog::OnInitDialog();
	
	((CSliderCtrl*)GetDlgItem(IDC_SLIDER))->SetPos(theApp.glob_prefs->GetTrafficOMeterInterval());
	((CSliderCtrl*)GetDlgItem(IDC_SLIDER2))->SetPos(theApp.glob_prefs->GetStatsInterval()-4);
	((CSliderCtrl*)GetDlgItem(IDC_SLIDER3))->SetPos(theApp.glob_prefs->GetStatsAverageMinutes()-1);
	
	Localize();
	m_color.SetCurSel(0);
	ShowColors(0);
	return true;
}


void CStatsSetup::OnDestroy() {
}

BEGIN_MESSAGE_MAP(CStatsSetup, CDialog)
	ON_CBN_CLOSEUP(IDC_COLORSELECTOR,OnSelection)
    ON_WM_DESTROY()
	ON_WM_HSCROLL()
	ON_BN_CLICKED(IDC_SAVECOLOR , SaveColors)
END_MESSAGE_MAP()


// CStatsSetup message handlers

void CStatsSetup::Localize(){

	GetDlgItem(IDC_GRAPHS)->SetWindowText(GetResString(IDS_GRAPHS));
	GetDlgItem(IDC_STREE)->SetWindowText(GetResString(IDS_STREE));
	SetWindowText(GetResString(IDS_STATSSETUPINFO));

	ShowInterval();
/*
	m_color.AddString("Background");
	m_color.AddString("Grid");
	m_color.AddString("Download current");
	m_color.AddString("Download time average");
	m_color.AddString("Download session average");
	m_color.AddString("Upload current");
	m_color.AddString("Upload time average");
	m_color.AddString("Upload session average");
	m_color.AddString("active downloads");
	m_color.AddString("active uploads");
	m_color.AddString("Connections");
*/
}

void CStatsSetup::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{

	CSliderCtrl* slider =(CSliderCtrl*)pScrollBar;
	int position = slider->GetPos();
	
	if (pScrollBar==GetDlgItem(IDC_SLIDER)) {
		theApp.glob_prefs->SetTrafficOMeterInterval(position);
	} else if (pScrollBar==GetDlgItem(IDC_SLIDER2)) {
			if (position>0) position+=4;
			theApp.glob_prefs->SetStatsInterval(position);
	} else theApp.glob_prefs->SetStatsAverageMinutes(position+1);

	ShowInterval();

	UpdateData(false); 
	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CStatsSetup::SaveColors() {
	/*
	DWORD color;
	CString buffer;
	int r,g,b;

	GetDlgItem(IDC_RED)->GetWindowText(buffer);	  r=atoi(buffer);
	GetDlgItem(IDC_GREEN)->GetWindowText(buffer); g=atoi(buffer);
	GetDlgItem(IDC_BLUE)->GetWindowText(buffer);  b=atoi(buffer);

	color=RGB(r,g,b);
	theApp.glob_prefs->SetStatsColor(m_color.GetCurSel(),color);
*/
}

void CStatsSetup::ShowColors(int nr) {
	/*
	COLORREF color=theApp.glob_prefs->GetStatsColor(nr);
	char buffer[5];
	int r=GetRValue(color);
	
	sprintf(buffer,"%i",GetRValue(color));GetDlgItem(IDC_RED)->SetWindowText(buffer);
	sprintf(buffer,"%i",GetGValue(color));GetDlgItem(IDC_GREEN)->SetWindowText(buffer);
	sprintf(buffer,"%i",GetBValue(color));GetDlgItem(IDC_BLUE)->SetWindowText(buffer);
	*/
}


void CStatsSetup::OnSelection() {
	ShowColors(m_color.GetCurSel());
}

void CStatsSetup::ShowInterval() {

	if (theApp.glob_prefs->GetTrafficOMeterInterval()==0) m_SliderValue1.Format(GetResString(IDS_DISABLED));
		else m_SliderValue1.Format(GetResString(IDS_STATS_UPDATELABEL), theApp.glob_prefs->GetTrafficOMeterInterval());

	if (theApp.glob_prefs->GetStatsInterval()==0) m_SliderValue2.Format(GetResString(IDS_DISABLED));
		else m_SliderValue2.Format(GetResString(IDS_STATS_UPDATELABEL), theApp.glob_prefs->GetStatsInterval());

	GetDlgItem(IDC_SLIDERINFO)->SetWindowText(m_SliderValue1);
	GetDlgItem(IDC_SLIDERINFO2)->SetWindowText(m_SliderValue2);

	m_SliderValue2.Format(GetResString(IDS_STATS_AVGLABEL), theApp.glob_prefs->GetStatsAverageMinutes());
	GetDlgItem(IDC_SLIDERINFO3)->SetWindowText(m_SliderValue2);
}
