/*
 * Copyright 2000 Francois Gouget <fgouget@codeweavers.com> for CodeWeavers
 */

#ifndef STRICT
#define STRICT
#endif

#include <dlfcn.h>
#include <windows.h>



/*
 * Describe the wrapped application
 */

/**
 * This is either CUIEXE for a console based application or
 * GUIEXE for a regular windows application.
 */
#define GUIEXE 0
#define CUIEXE 1
#define      APP_TYPE      GUIEXE

/**
 * This is the name of the library containing the application,
 * e.g. 'hello.dll' if the application is called 'hello.exe'.
 */
static char* appName     = "src";

/**
 * This is the name of the application's Windows module. If left NULL
 * then appName is used.
 */
static char* appModule   = NULL;

/**
 * This is the application's entry point. This is usually "WinMain" for a
 * GUIEXE and 'main' for a CUIEXE application.
 */
static char* appInit     = "WinMain";

/**
 * This is either non-NULL for MFC-based applications and is the name of the
 * MFC's module. This is the module in which we will take the 'WinMain'
 * function.
 */
static char* mfcModule   = "mfc";



/*
 * Implement the main.
 */

#if APP_TYPE == GUIEXE
typedef int WINAPI (*WinMainFunc)(HINSTANCE hInstance, HINSTANCE hPrevInstance,
				  PSTR szCmdLine, int iCmdShow);
#else
typedef int WINAPI (*MainFunc)(int argc, char** argv, char** envp);
#endif

#if APP_TYPE == GUIEXE
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
                   PSTR szCmdLine, int iCmdShow)
#else
int WINAPI main(int argc, char** argv, char** envp)
#endif
{
    void* appLibrary;
    HINSTANCE hApp = 0, hMFC = 0, hMain = 0;
    void* appMain;
    char* libName;
    int retcode;

    /* Load the application's library */
    libName=(char*)malloc(2+strlen(appName)+3+1);
    /* FIXME: we should get the wrapper's path and use that as the base for
     * the library
     */
    sprintf(libName,"./%s.so",appName);
    appLibrary=dlopen(libName,RTLD_NOW);
    if (appLibrary==NULL) {
        sprintf(libName,"%s.so",appName);
        appLibrary=dlopen(libName,RTLD_NOW);
    }
    if (appLibrary==NULL) {
        char format[]="Could not load the %s library:\r\n%s";
        char* error;
        char* msg;

        error=dlerror();
        msg=(char*)malloc(strlen(format)+strlen(libName)+strlen(error));
        sprintf(msg,format,libName,error);
        MessageBox(NULL,msg,"dlopen error",MB_OK);
        free(msg);
        return 1;
    }

    /* Then if this application is MFC based, load the MFC module */
    /* FIXME: I'm not sure this is really necessary */
    if (mfcModule!=NULL) {
        hMFC=LoadLibrary(mfcModule);
        if (hMFC==NULL) {
            char format[]="Could not load the MFC module %s (%d)";
            char* msg;

            msg=(char*)malloc(strlen(format)+strlen(mfcModule)+11);
            sprintf(msg,format,mfcModule,GetLastError());
            MessageBox(NULL,msg,"LoadLibrary error",MB_OK);
            free(msg);
            return 1;
        }
        /* MFC is a special case: the WinMain is in the MFC library,
         * instead of the application's library.
         */
        hMain=hMFC;
    } else {
        hMFC=NULL;
    }

    /* Load the application's module */
    if (appModule==NULL) {
        appModule=appName;
    }
    hApp=LoadLibrary(appModule);
    if (hApp==NULL) {
        char format[]="Could not load the application's module %s (%d)";
        char* msg;

        msg=(char*)malloc(strlen(format)+strlen(appModule)+11);
        sprintf(msg,format,appModule,GetLastError());
        MessageBox(NULL,msg,"LoadLibrary error",MB_OK);
        free(msg);
        return 1;
    } else if (hMain==NULL) {
        hMain=hApp;
    }

    /* Get the address of the application's entry point */
    appMain=GetProcAddress(hMain, appInit);
    if (appMain==NULL) {
        char format[]="Could not get the address of %s (%d)";
        char* msg;

        msg=(char*)malloc(strlen(format)+strlen(appInit)+11);
        sprintf(msg,format,appInit,GetLastError());
        MessageBox(NULL,msg,"GetProcAddress error",MB_OK);
        free(msg);
        return 1;
    }

    /* And finally invoke the application's entry point */
#if APP_TYPE == GUIEXE
    retcode=(*((WinMainFunc)appMain))(hApp,hPrevInstance,szCmdLine,iCmdShow);
#else
    retcode=(*((MainFunc)appMain))(argc,argv,envp);
#endif

    /* Cleanup and done */
    FreeLibrary(hApp);
    if (hMFC!=NULL) {
        FreeLibrary(hMFC);
    }
    dlclose(appLibrary);
    free(libName);

    return retcode;
}
