//this file is part of xMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.xmule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#ifndef KNOWNFILELIST_H
#define KNOWNFILELIST_H

class CKnownFile;
#include "xmule.h"

#include <wx/hashmap.h>
WX_DECLARE_HASH_MAP(wxString,CKnownFile*,wxStringHash,wxStringEqual,KnownFileMap);

class CKnownFileList
{
//	friend class CSharedFilesWnd;
//	friend class CFileStatistic;
public:
	CKnownFileList(char* in_appdir);
	~CKnownFileList();
	bool	SafeAddKFile(CKnownFile* toadd);
	bool	Init();
	void	Save();
	void	Clear();
	CKnownFile*	FindKnownFile(char* filename,uint32 in_date,uint32 in_size);


	uint16 requested;
	uint32 transfered;
	uint16 accepted;

private:
	wxMutex	list_mut;

	bool	Append(CKnownFile*);
	char*	appdir;

	KnownFileMap	m_map;
};



#endif
