//this file is part of xMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.xmule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifdef PRECOMP
#	include "xmule-headers.h"
#else
#	include "SearchList.h"
#	include "muuli_wdr.h"
#	include "SearchDlg.h"
#endif

#include "wx/xrc/xmlres.h"
#include "wx/xrc/xh_all.h"

// CARE: This will lock the notebook when it does find a control.
//       Call the function UngetSearchListControl() to unlock the notebook. But
//       only after you are done with the Control returned by this function.
//
static CSearchListCtrl* GetSearchListControl(uint32 nSearchID)
{
	CMuleNotebook* nb=XRCCTRL(*(theApp.xmuledlg->searchwnd),"ID_NOTEBOOK",CMuleNotebook);
	if ( !nb ) return NULL;

	nb->m_LockTabs.Lock();

	for (int tabCounter=0; tabCounter < nb->GetPageCount(); tabCounter++) {
		if(nb->GetUserData(tabCounter)==nSearchID) {
			return (CSearchListCtrl*)theApp.xmuledlg->searchwnd->FindWindowById(ID_SEARCHLISTCTRL,nb->GetPage(tabCounter));
		}
	}

	nb->m_LockTabs.Unlock();
	return NULL;
}

static void UngetSearchListControl(CSearchListCtrl* ctrl)
{
	if ( !ctrl ) return;			// NB was already unlocked

	CMuleNotebook* nb=XRCCTRL(*(theApp.xmuledlg->searchwnd),"ID_NOTEBOOK",CMuleNotebook);
	nb->m_LockTabs.Unlock();
}

CSearchFile::CSearchFile(CFile* in_data,uint32 nSearchID){

	m_nSearchID = nSearchID;
	if ( 16 != in_data->Read(&m_abyFileHash,16) )
		throw CInvalidPacket();
	if ( 4 != in_data->Read(&clientip,4) )
		throw CInvalidPacket();
	if ( 2 != in_data->Read(&clientport,2) )
		throw CInvalidPacket();
	uint32 tagcount;
	if ( 4 != in_data->Read(&tagcount,4) )
		throw CInvalidPacket();
	
	for (uint32 i=0; i<tagcount; i++){
			CTag* toadd = new CTag(in_data);
			taglist.Add(toadd);
		}
		char* tempName = GetStrTagValue(FT_FILENAME);
	if ( !tempName )
		throw CInvalidPacket("No filename in search result");

	int iSize = (int)strlen(tempName)+1;
	if ( iSize < 2 ) iSize = 2;		// required by tag format
		m_pszFileName = new char[iSize];
			strcpy(m_pszFileName,tempName);
		m_nFileSize = GetIntTagValue(FT_FILESIZE);
	}

CSearchFile::~CSearchFile(){
	for (int i = 0; i != taglist.GetSize();i++)
		safe_delete(taglist[i]);
	taglist.RemoveAll();
	taglist.SetSize(0);
}

uint32 CSearchFile::GetIntTagValue(uint8 tagname){
	for (int i = 0; i != taglist.GetSize(); i++){
		if (taglist[i]->tag->specialtag == tagname)
			return taglist[i]->tag->intvalue;
	}
	return 0;
}

char* CSearchFile::GetStrTagValue(uint8 tagname){
	for (int i = 0; i != taglist.GetSize(); i++){
		if (taglist[i]->tag->specialtag == tagname)
			return taglist[i]->tag->stringvalue;
	}
	return 0;
}

uint32 CSearchFile::AddSources(uint32 count){
	for (int i = 0; i != taglist.GetSize(); i++){
		if (taglist[i]->tag->specialtag == FT_SOURCES){
			taglist[i]->tag->intvalue += count;
			return taglist[i]->tag->intvalue;
		}
	}
	return 0;
}

uint32 CSearchFile::GetSourceCount(){
	return GetIntTagValue(FT_SOURCES);
}

CSearchList::CSearchList(){
}

CSearchList::~CSearchList(){
	Clear();
}

void CSearchList::Clear(){
	for(POSITION pos = list.GetHeadPosition(); pos != NULL; pos = list.GetHeadPosition()) {
		delete list.GetAt(pos);
		list.RemoveAt(pos);
	}
}

void CSearchList::RemoveResults( uint32 nSearchID){
	// this will not delete the item from the window, make sure your code does it if you call this
	POSITION pos1, pos2;
	for (pos1 = list.GetHeadPosition();( pos2 = pos1 ) != NULL;){
		list.GetNext(pos1);
		CSearchFile* cur_file =	list.GetAt(pos2);
		if( cur_file->GetSearchID() == nSearchID ){
			list.RemoveAt(pos2);
			delete cur_file;
		}
	}
}

void CSearchList::ShowResults( uint32 nSearchID){
	CSearchListCtrl* outputwnd = GetSearchListControl(nSearchID);
	if ( outputwnd ) {
		//outputwnd->SetRedraw(false);
		for (POSITION pos = list.GetHeadPosition(); pos !=0;list.GetNext(pos)){
			if( ((CSearchFile*)list.GetAt(pos))->GetSearchID() == nSearchID ){
				outputwnd->AddResult(list.GetAt(pos));
			}
		}
		//outputwnd->SetRedraw(true);
	}
	UngetSearchListControl(outputwnd);
}

// Ok, nobody knows why is this here, so disabling it until someone needs it.
#if 0
	void CSearchList::RemoveResults( CSearchFile* todel ){
		for (POSITION pos = list.GetHeadPosition(); pos !=0;list.GetNext(pos)){
			if( (CSearchFile*)list.GetAt(pos) == todel ){
			// this should also be routed to the selected page only
			CMuleNotebook* nb=(CMuleNotebook*)theApp.xmuledlg->searchwnd->FindWindowById(ID_NOTEBOOK);
			if(nb->GetSelection()==-1)
			return;
			CSearchListCtrl* ctrl=(CSearchListCtrl*)nb->FindWindowById(ID_SEARCHLISTCTRL,nb->GetPage(nb->GetSelection()));
			//theApp.xmuledlg->searchwnd->searchlistctrl->RemoveResult( todel );
				ctrl->RemoveResult(todel);
				list.RemoveAt(pos);
				delete todel;
				return;
			}
		}
	}
#endif

void CSearchList::NewSearch(CString resTypes, uint16 nSearchID){
	resultType=resTypes;
	m_nCurrentSearch = nSearchID;
	myHashList="";
	
	foundFilesCount.SetAt(nSearchID,0);
}

uint16 CSearchList::ProcessSearchanswer(char* in_packet, uint32 size, CUpDownClient* Sender){
	CSafeMemFile* packet = new CSafeMemFile((BYTE*)in_packet,size,0);

	if(Sender) {
	  theApp.xmuledlg->searchwnd->CreateNewTab(Sender->GetUserName(),(uint32)Sender);
	}

	try
	{
		uint32 results;
		if ( 4 != packet->Read(&results,4) )
			throw CInvalidPacket("short packet reading search result count");
		uint32 mySearchID=( (Sender != NULL)? (uint32)Sender : m_nCurrentSearch);
		foundFilesCount.SetAt(mySearchID,0);

		try
		{
			for (uint32 i = 0; i != results; i++){
				CSearchFile* toadd = new CSearchFile(packet, mySearchID);
				AddToList(toadd, (Sender != NULL) );
			}
		}
		catch ( CStrangePacket )
		{ }
	}
	catch ( CInvalidPacket e )
	{
#ifdef __DEBUG__
		printf("Invalid search result packet: %s\n", e.what());
		HexDump(in_packet, size);
#endif
	}

	packet->Close();
	delete packet;
	return GetResultCount();
}

uint16 CSearchList::ProcessUDPSearchanswer(char* in_packet, uint32 size){
	CSafeMemFile* packet = new CSafeMemFile((BYTE*)in_packet,size,0);
	try
	{
		CSearchFile* toadd = new CSearchFile(packet, m_nCurrentSearch);
		AddToList(toadd);
	}
	catch ( CStrangePacket )
	{ }
	packet->Close();
	delete packet;
	return GetResultCount();
}

bool CSearchList::AddToList(CSearchFile* toadd, bool bClientResponse){
	
	// If filesize is 0, drop it (why would we want to download a 0-byte file anyway?)
	if (!toadd->GetIntTagValue(FT_FILESIZE)) {
		return false;
	}
	
	// If the result was not the type user wanted, drop it.
	if (!bClientResponse && !(resultType == GetResString(IDS_SEARCH_ANY) || GetFiletypeByName(toadd->GetFileName())==resultType)){
		delete toadd;
		return false;
	}

	CSearchListCtrl* outputwnd = GetSearchListControl(toadd->GetSearchID());
	for (POSITION pos = list.GetHeadPosition(); pos != NULL; list.GetNext(pos)){
		CSearchFile* cur_file = list.GetAt(pos);
		if ( (!memcmp(toadd->GetFileHash(),cur_file->GetFileHash(),16)) && cur_file->GetSearchID() ==  toadd->GetSearchID()){
			cur_file->AddSources(toadd->GetIntTagValue(FT_SOURCES));
			if (outputwnd) {
				outputwnd->UpdateSources(cur_file);
			}
			delete toadd;
			UngetSearchListControl(outputwnd);
			return true;
		}
	}
	if (list.AddTail(toadd)) {	
		uint16 tempValue;
		foundFilesCount.Lookup(toadd->GetSearchID(),tempValue);
		foundFilesCount.SetAt(toadd->GetSearchID(),tempValue+1);
	}
	if (outputwnd) {
		outputwnd->AddResult(toadd);
	}
	UngetSearchListControl(outputwnd);
	return true;
}

uint16 CSearchList::GetResultCount(uint32 nSearchID) {
	uint16 hits = 0;
	for (POSITION pos = list.GetHeadPosition(); pos != NULL; list.GetNext(pos)){
		if( list.GetAt(pos)->GetSearchID() == nSearchID ) {
			hits += list.GetAt(pos)->GetSourceCount();
		}
	}
	return hits;
}


uint16 CSearchList::GetResultCount(){
	return GetResultCount(m_nCurrentSearch);
}

uint16 CSearchList::GetFoundFiles(uint32 searchID) {
	uint16 returnVal;
	foundFilesCount.Lookup(searchID,returnVal);
	return returnVal;
}
