//this file is part of xMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.xmule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifdef PRECOMP
#	include "xmule-headers.h"
#else
#	include "ChatWnd.h"
#	include "config.h"
#	include "ClientList.h"
#	include "ClientUDPSocket.h"
#	include "DownloadQueue.h"
#	include "FriendList.h"
#	include "IPFilter.h"
#	include "muuli_wdr.h"
#	include "opcodes.h"
#	include "PreferencesDlg.h"
#	include "SearchList.h"
#	include "ServerWnd.h"
#	include "SharedFilesWnd.h"
#	include "StatisticsDlg.h"
#	include "TransferWnd.h"
#	include "UploadQueue.h"
#	include "xmule.h"
#	include "xmuleDlg.h"
#	include "WebServer.h"
#endif

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#include <wx/ipc.h>
#include <wx/config.h>
#include <wx/clipbrd.h>
#include <wx/socket.h>
#include <wx/splash.h>

#include <wx/filesys.h>
#include <wx/fs_zip.h>
#include <wx/utils.h>
#include "wx/xrc/xmlres.h"

#include <sys/socket.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <gdk/gdk.h>
#include <gtk/gtk.h>

IMPLEMENT_APP(CxmuleApp)

// CxmuleApp

//BEGIN_MESSAGE_MAP(CxmuleApp, CWinApp)
//  ON_COMMAND(ID_HELP, CWinApp::OnHelp)
//END_MESSAGE_MAP()

void InitSplashXRC();

#ifdef HAVE_SYS_RESOURCE_H
#include <sys/resource.h>
#endif

#ifdef __GLIBC__
# define RLIMIT_RESOURCE __rlimit_resource
#else
# define RLIMIT_RESOURCE int
#endif

static void UnlimitResource(RLIMIT_RESOURCE resType)
{
#if defined(HAVE_GETRLIMIT) && defined(HAVE_SETRLIMIT)
	struct rlimit rl;
	getrlimit(resType, &rl);
	rl.rlim_cur = rl.rlim_max;
	setrlimit(resType, &rl);
#endif
}

static void SetResourceLimits()
{
#ifdef HAVE_SYS_RESOURCE_H
	UnlimitResource(RLIMIT_DATA);
	UnlimitResource(RLIMIT_FSIZE);
	UnlimitResource(RLIMIT_NOFILE);
	UnlimitResource(RLIMIT_RSS);
#endif
}


CxmuleApp::CxmuleApp()
{

}

CxmuleApp::~CxmuleApp()
{
	delete listensocket;
}

int CxmuleApp::OnExit()
{
	/*
	 * The following destruction sequence was moved to the
	 * destructor of the dialog since some of them call
	 * functions accessing controls of the dialog.
	 */
#if 0
	/* Clear up the Online Signature file. */
	OnlineSig(true);

	theApp.listensocket->Destroy();
	theApp.clientudp->Destroy();
	delete theApp.sharedfiles;
	delete theApp.serverconnect;
	delete theApp.serverlist;
	delete theApp.knownfiles;
	delete theApp.searchlist;
	delete theApp.clientcredits;
	delete theApp.downloadqueue;
	delete theApp.uploadqueue;
	delete theApp.clientlist;
	delete theApp.friendlist;
	delete theApp.glob_prefs;
#endif

#if 0
	delete searchlist;
	delete friendlist;
	delete knownfiles;
	delete serverlist;
	delete serverconnect;
	delete sharedfiles;
	delete listensocket;
	delete clientudp;
	delete clientcredits;
	delete downloadqueue;
	delete uploadqueue;
	delete clientlist;
#endif

	printf("xMule shutdown completed.\n");

	return wxApp::OnExit();
}



//CxmuleApp theApp;

// IPC classes

class MuleConnection:public wxConnection 
{
  public:
	MuleConnection(void):wxConnection() 
  	{
	};
	~MuleConnection(void) 
	{
	};
	bool OnAdvise(const wxString & topic, const wxString & item, char *data, int size, wxIPCFormat format) 
	{
		return TRUE;
	}
	virtual char *OnRequest(const wxString & topic, const wxString & item, int *size, wxIPCFormat format) 
	{
		if (item == "STATS") {
			int filecount = theApp.downloadqueue->GetFileCount();
			// get the source count
			int stats[2];
			theApp.downloadqueue->GetDownloadStats(stats);
			static char buffer[1024];
			sprintf(buffer, "Statistics: \n Downloading files: %d\n Found sources: %d\n Active downloads: %d\n Active Uploads: %d\n Users on upload queue: %d", filecount, stats[0], stats[1], theApp.uploadqueue->GetUploadQueueLength(), theApp.uploadqueue->GetWaitingUserCount());
			return buffer;
		}
		return "";
	}
	bool OnExecute(const wxString & topic, /*const wxString& item, */ char *data, int size, wxIPCFormat format) 
	{
		wxString item = "ED2KLINK";
		if (item == "ED2KLINK") {
			// add it to queue
			try {
				wxString edlink = data;
				if (edlink.Right(1) != "/")
					edlink += "/";
				edlink.Replace("%7c", "|");
				edlink.Replace("%7C", "|");
				wxString newlink;
				URLDecode(newlink, edlink.GetData());
				printf("Link is %s\n", newlink.GetData());
				CED2KLink *pLink = CED2KLink::CreateLinkFromUrl(newlink);
				switch (pLink->GetKind()) {
					case CED2KLink::kFile:
						{
							CED2KFileLink *pFileLink = pLink->GetFileLink();
							theApp.downloadqueue->AddFileLinkToDownload(pFileLink);
						}
						break;
					case CED2KLink::kServerList:
						{
							CED2KServerListLink *pListLink = pLink->GetServerListLink();
							CString strAddress = pListLink->GetAddress();
							if (strAddress.GetLength() != 0)
								theApp.xmuledlg->serverwnd->UpdateServerMetFromURL(strAddress);
						}
						break;
					case CED2KLink::kServer:
						{
							CString defName;
							CED2KServerLink *pSrvLink = pLink->GetServerLink();
							in_addr host;
							host.s_addr = pSrvLink->GetIP();
							CServer *pSrv = new CServer(pSrvLink->GetPort(), inet_ntoa(host));
							pSrvLink->GetDefaultName(defName);
							pSrv->SetListName((char *)(defName.GetData()));

							// Barry - Default all new servers to high priority
							pSrv->SetPreference(PR_HIGH);

							if (!theApp.xmuledlg->serverwnd->serverlistctrl->AddServer(pSrv, true))
								delete pSrv;
							else
								theApp.xmuledlg->AddLogLine(true, GetResString(IDS_SERVERADDED)+"%s", pSrv->GetListName());
						}
						break;
					default:
						break;
				}
				delete pLink;
			}
			catch(...) {
				theApp.xmuledlg->AddLogLine(true, GetResString(IDS_LINKNOTADDED));
			}
		}
	}
};

class MuleClient:public wxClient 
	{
  public:
	MuleClient(void) 
	{
	};
	wxConnectionBase *OnMakeConnection(void) 
	{
		return new MuleConnection;
	}
};

class MuleServer:public wxServer {
  public:
	MuleServer(void) 
	{
	};
	wxConnectionBase *OnAcceptConnection(const wxString & topic) 
	{
		return new MuleConnection;
	}
};

// CxmuleApp Initialisierung

extern void InitXmlResource();

bool CxmuleApp::OnInit()
{
	clientlist = NULL;
	searchlist = NULL;
	friendlist = NULL;
	knownfiles = NULL;
	serverlist = NULL;
	serverconnect = NULL;
	sharedfiles = NULL;
	listensocket = NULL;
	clientudp = NULL;
	clientcredits = NULL;
	downloadqueue = NULL;
	uploadqueue = NULL;
	ipfilter = NULL;

	// catch fatal exceptions
	wxHandleFatalExceptions(true);

	//putenv("LANG=en_US");

	SetResourceLimits();

	// for resources
	wxFileSystem::AddHandler(new wxZipFSHandler);
	wxXmlResource::Get()->InitAllHandlers();
	InitXmlResource();

	for (int i = 1; i < argc; i++) {
		if (strncmp(argv[i], "--version", 7) == 0) {
			printf("%s version %s\n", PACKAGE_NAME, PACKAGE_VERSION);
			sleep(1);
			exit(0);
		}
	}

	printf("Initialising xMule\n");

	close(0);

	//if(ProcessCommandLine())
	//  return FALSE;

	//SetTopWindow(dlg);

	SetVendorName("TikuWarez");

	// Do NOT change this string to xMule nor anything else, it WILL fuck you up.
	SetAppName("eMule");

	/* Madcat - This code part is no longer neccesery, because external ED2K links are
		handled by the 'ed2k' program, and for statistics, it is easier (and faster)
		to use the online signature. Besides, disabling this code part will lower
		memory usage and speed up startup times.
	*/
	#if 0
	// see if there is another instance running
	wxString server = getenv("HOME") + wxString("/.xMule/muleconn");
	wxString hostName = "localhost";
	MuleClient *client = new MuleClient;
	MuleConnection *conn = (MuleConnection *) client->MakeConnection(hostName, server, "xMule IPC");
	if (!conn) {
		// no connection => spawn server instead.
		MuleServer *ipcserver = new MuleServer;
		ipcserver->Create(server);
		// arguments should be checked here too..
		// (actually, later when app is ready)
	} else {
		// check command line arguments ed2k://
		for (int i = 1; i < argc; i++) {
			if (strlen(argv[i]) > 7) {
				// could be ed2k link
				if (strncmp(argv[i], "ed2k://", 7) == 0) {
					// it most likely is. send it to active instance
					conn->Execute(argv[i]);
				} else if (strncmp(argv[i], "statistics", 10) == 0) {
					printf("%s\n", conn->Request("STATS", NULL));
				}
			}
		}
		printf("xMule already running: exiting\n");
		conn->Disconnect();
		delete conn;
		delete client;
		// don't allow another instance.
		sleep(1);	// this will prevent xmule to hang itself     
		exit(0);	// is this clean.. perhaps not
	}

	delete conn;
	#endif
	m_locale.Init(wxLANGUAGE_DEFAULT);
	m_locale.AddCatalogLookupPathPrefix(LOCALEDIR);
	m_locale.AddCatalog(PACKAGE);

	CxmuleDlg *dlg = new CxmuleDlg(NULL, wxString::Format(wxT("%s v%s"), wxT(PACKAGE_NAME), wxT(PACKAGE_VERSION)));
	xmuledlg = dlg;
	dlg->Show(TRUE);

	// Madcat - Check if prefs can be found at ~/.lmule and rename as neccesery.

	wxString OldPrefDir = getenv("HOME") + wxString("/.lmule");
	wxString NewPrefDir = getenv("HOME") + wxString("/.xMule");
	if (wxDirExists(OldPrefDir) && !wxDirExists(NewPrefDir)) {
		printf("Found old settings, moving to new dir.\n");
		wxRenameFile(OldPrefDir, NewPrefDir);
	}
	 if (!wxDirExists(NewPrefDir)) {
		 mkdir(NewPrefDir,0777);
	}
	wxString filename = NewPrefDir + wxString("/server.met");
	if (!wxFileExists(filename)) {
		wxFile metfile(filename, wxFile::write_excl);
		if (metfile.IsOpened()) {
			metfile.Close();
		}
	}

	// Delete old log file.
	wxRemoveFile(wxString::Format("%s/.xMule/logfile", getenv("HOME")));

	glob_prefs = new CPreferences();
	xmuledlg->preferenceswnd->SetPrefs(glob_prefs);

	xmuledlg->createSystray(wxString::Format(wxT("%s v%s"),	wxT(PACKAGE_NAME), wxT(PACKAGE_VERSION)));

	// splashscreen
	if (theApp.glob_prefs->UseSplashScreen() && !theApp.glob_prefs->GetStartMinimized()) {
		InitSplashXRC();
		wxImage::AddHandler(new wxJPEGHandler);
		
		wxSplashScreen* splsh=new wxSplashScreen(wxXmlResource::Get()->LoadBitmap("About"),wxSPLASH_CENTRE_ON_SCREEN|wxSPLASH_TIMEOUT,
							 5000,NULL,-1,wxDefaultPosition,wxDefaultSize,
							 wxSIMPLE_BORDER|wxSTAY_ON_TOP);
	}

	wxIPV4address myaddr;
	myaddr.AnyAddress();
	myaddr.Service(glob_prefs->GetPort());
	printf("*** TCP socket at %d\n", glob_prefs->GetPort());

	clientlist = new CClientList();
	searchlist = new CSearchList();
	friendlist = new CFriendList();
	knownfiles = new CKnownFileList(glob_prefs->GetAppDir());
	serverlist = new CServerList(glob_prefs);
	serverconnect = new CServerConnect(serverlist, theApp.glob_prefs);
	sharedfiles = new CSharedFileList(glob_prefs, serverconnect, knownfiles);
	myaddr.Service(glob_prefs->GetUDPPort());
	clientudp = new CClientUDPSocket(myaddr);
	clientcredits = new CClientCreditsList(glob_prefs);
	downloadqueue = new CDownloadQueue(glob_prefs, sharedfiles);	// bugfix - do this before creating the uploadqueue
	uploadqueue = new CUploadQueue(glob_prefs);
	ipfilter = new CIPFilter();
	webserver = new CWebServer();
	//INT_PTR nResponse = dlg.DoModal();

	// init statistics stuff, better do it asap
	xmuledlg->statisticswnd->Init();
	xmuledlg->statisticswnd->ShowInterval();

	// must do initialisations here.. 
	xmuledlg->serverwnd->serverlistctrl->Init(serverlist);
	serverlist->Init();

	// ini. downloadqueue
	theApp.downloadqueue->Init();
	xmuledlg->AddLogLine(true, PACKAGE_STRING);

	// 
	theApp.sharedfiles->SetOutputCtrl((CSharedFilesCtrl *) xmuledlg->sharedfileswnd->FindWindowByName("sharedFilesCt"));

	// then init firend list
	theApp.friendlist->SetWindow((CFriendListCtrl *) theApp.xmuledlg->chatwnd->FindWindowById(ID_FRIENDLIST));
	theApp.friendlist->ShowFriends();

	SetTopWindow(dlg);

	// reset statistic values
	theApp.stat_sessionReceivedBytes = 0;
	theApp.stat_sessionSentBytes = 0;
	theApp.stat_reconnects = 0;
	theApp.stat_transferStarttime = 0;
	theApp.stat_serverConnectTime = 0;
	theApp.Start_time = GetTickCount();

	// Initialize and sort all lists.
	// FIX: Remove from here and put these back to the OnInitDialog()s
	// and call the OnInitDialog()s here!
	theApp.xmuledlg->transferwnd->downloadlistctrl->LoadSettings(CPreferences::tableDownload);
	theApp.xmuledlg->transferwnd->downloadlistctrl->InitSort();
	theApp.xmuledlg->transferwnd->uploadlistctrl->LoadSettings(CPreferences::tableUpload);
	theApp.xmuledlg->transferwnd->uploadlistctrl->InitSort();
	theApp.xmuledlg->transferwnd->queuelistctrl->LoadSettings(CPreferences::tableQueue);
	theApp.xmuledlg->transferwnd->queuelistctrl->InitSort();
	theApp.xmuledlg->serverwnd->serverlistctrl->LoadSettings(CPreferences::tableServer);
	theApp.xmuledlg->serverwnd->serverlistctrl->InitSort();
	theApp.xmuledlg->sharedfileswnd->sharedfilesctrl->LoadSettings(CPreferences::tableShared);
	theApp.xmuledlg->sharedfileswnd->sharedfilesctrl->InitSort();

	// call the initializers
	theApp.xmuledlg->transferwnd->OnInitDialog();

	xmuledlg->m_app_state = APP_STATE_RUNNING;
	
	/* Madcat - This code part is no longer neccesery, because external ED2K links are
		handled by the 'ed2k' program, and for statistics, it is easier (and faster)
		to use the online signature. Besides, disabling this code part will lower
		memory usage and speed up startup times.
	*/
	#if 0
	// parse possible arguments
	// easy way: just create a client connection and stuff them there :)
	// note: not actually SENDING anything, just passing stuff directly
	conn = new MuleConnection;
	if (conn) {
		// check command line arguments ed2k://
		for (int i = 1; i < argc; i++) {
			if (strlen(argv[i]) > 7) {
				// could be ed2k link
				if (strncmp(argv[i], "ed2k://", 7) == 0) {
					// it most likely is. send it to active instance
					conn->OnPoke("IPC", "ED2KLINK", argv[i], strlen(argv[i]), wxIPC_TEXT);
				}
			}
		}
		// we'll leave it lying around.. 
		// (can't delete it :)
	}
	#endif
	
	// reload shared files
	theApp.sharedfiles->Reload(true, true);

	if (glob_prefs->GetWSIsEnabled()) {
		webserver->ReloadTemplates();
		webserver->StartServer();
	}

	myaddr.Service(glob_prefs->GetPort());
	listensocket = new CListenSocket(glob_prefs, myaddr);

	if (!listensocket->Ok()) {
		xmuledlg->AddLogLine(false, (_("Port %d is not available. You will be LOWID")), glob_prefs->GetPort());
		CString str;
		str.Format(_("Port %d is not available !!\n\nThis will mean that you will be LOWID.\n\nUse netstat to determine when port becomes available\nand try starting xmule again."), glob_prefs->GetPort());
		wxMessageBox(str, _("Error"), wxCENTRE | wxOK | wxICON_ERROR);
	}

	// pretty much ready now. start autoconnect if 
	if (theApp.glob_prefs->DoAutoConnect()) {
		wxCommandEvent nullEvt;
		theApp.xmuledlg->OnBnConnect(nullEvt);
	}
#if 0
	// set the checkpoint
	wxDebugContext::SetCheckpoint();
#endif
	return TRUE;
}

#if 0
BOOL CxmuleApp::InitInstance()
{
#ifdef _DUMP
	MiniDumper dumper(CURRENT_VERSION_LONG);
#endif

	pendinglink = 0;
	if (ProcessCommandline()) {
		return false;
	}
	// InitCommonControls() ist fr Windows XP erforderlich, wenn ein Anwendungsmanifest
	// die Verwendung von ComCtl32.dll Version 6 oder hher zum Aktivieren
	// von visuellen Stilen angibt. Ansonsten treten beim Erstellen von Fenstern Fehler auf.
	InitCommonControls();

	CWinApp::InitInstance();

	if (!AfxSocketInit()) {
		AfxMessageBox(IDP_SOCKETS_INIT_FAILED);
		return FALSE;
	}

	AfxEnableControlContainer();
	AfxSocketInit();
	CxmuleDlg dlg;
	xmuledlg = &dlg;
	m_pMainWnd = &dlg;

	// create & initalize all the important stuff 
	glob_prefs = new CPreferences();

	//setup languag 
	clientlist = new CClientList();
	searchlist = new CSearchList();
	knownfiles = new CKnownFileList(glob_prefs->GetAppDir());
	serverlist = new CServerList(glob_prefs);
	serverconnect = new CServerConnect(serverlist, theApp.glob_prefs);
	sharedfiles = new CSharedFileList(glob_prefs, serverconnect, knownfiles);
	listensocket = new CListenSocket(glob_prefs);
	clientcredits = new CClientCreditsList(glob_prefs);
	downloadqueue = new CDownloadQueue(glob_prefs, sharedfiles);	// bugfix - do this before creating the uploadqueue
	uploadqueue = new CUploadQueue(glob_prefs);
	INT_PTR nResponse = dlg.DoModal();


	// reset statistic values
	theApp.stat_sessionReceivedBytes = 0;
	theApp.stat_sessionSentBytes = 0;
	theApp.stat_reconnects = 0;
	theApp.stat_transferStarttime = 0;
	theApp.stat_serverConnectTime = 0;

	return FALSE;
}
#endif

bool CxmuleApp::ProcessCommandline()
{
#if 0
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	char buffer[50];
	sprintf(buffer, "xMule V%s", CURRENT_VERSION_LONG);
	HWND maininst = FindWindow(0, buffer);
	if (cmdInfo.m_nShellCommand == CCommandLineInfo::FileOpen) {
		CString command = cmdInfo.m_strFileName;

		//if (maininst){ moved down by Cax2 28/10/02 
		//tagCOPYDATASTRUCT sendstruct; removed by Cax2 28/10/02 
		sendstruct.cbData = command.GetLength() + 1;
		sendstruct.dwData = OP_ED2KLINK;
		sendstruct.lpData = command.GetBuffer();
		if (maininst) {	//Cax2 28/10/02 
			SendMessage(maininst, WM_COPYDATA, (WPARAM) 0, (LPARAM) (PCOPYDATASTRUCT) & sendstruct);
			return true;
		} else {
			pendinglink = new CString(command);
		}
	}

	return maininst;
#endif
}

void CxmuleApp::UpdateReceivedBytes(int32 bytesToAdd)
{
	SetTimeOnTransfer();
	stat_sessionReceivedBytes += bytesToAdd;
}

void CxmuleApp::UpdateSentBytes(int32 bytesToAdd)
{
	SetTimeOnTransfer();
	stat_sessionSentBytes += bytesToAdd;
}

void CxmuleApp::SetTimeOnTransfer()
{
	if (stat_transferStarttime > 0)
		return;

	stat_transferStarttime = GetTickCount();
}

typedef char *LPTSTR;

wxString CxmuleApp::StripInvalidFilenameChars(wxString strText, bool bKeepSpaces)
{
	LPTSTR pszBuffer = (char *)strText.GetData();
	LPTSTR pszSource = pszBuffer;
	LPTSTR pszDest = pszBuffer;

	while (*pszSource != '\0') {
		if (!((*pszSource <= 31 && *pszSource >= 0) ||	// lots of invalid chars for filenames in windows :=)
			  *pszSource == '\"' || *pszSource == '*' || *pszSource == '<' || *pszSource == '>' || *pszSource == '?' || *pszSource == '|' || *pszSource == '\\' || *pszSource == '/' || *pszSource == ':')) {
			if (!bKeepSpaces && *pszSource == ' ') {
				*pszDest = '_';
			}
			else {
				*pszDest = *pszSource;
			}
			pszDest++;
		}
		pszSource++;
	}
	*pszDest = '\0';

	return strText;
}

wxString CxmuleApp::CreateED2kLink(CAbstractFile * f)
{
	wxString strLink;

	strLink = strLink.Format("ed2k://|file|%s|%d|%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x|/", StripInvalidFilenameChars(f->GetFileName(), true).GetData(),	// spaces to dots
							 f->GetFileSize(), f->GetFileHash()[0], f->GetFileHash()[1], f->GetFileHash()[2], f->GetFileHash()[3], f->GetFileHash()[4], f->GetFileHash()[5], f->GetFileHash()[6], f->GetFileHash()[7], f->GetFileHash()[8], f->GetFileHash()[9], f->GetFileHash()[10], f->GetFileHash()[11], f->GetFileHash()[12], f->GetFileHash()[13], f->GetFileHash()[14], f->GetFileHash()[15]);
	return strLink.GetData();
}

wxString CxmuleApp::CreateED2kSourceLink(CAbstractFile * f)
{
	if (!serverconnect->IsConnected() || serverconnect->IsLowID()) {
		xmuledlg->AddLogLine(true, GetResString(IDS_SOURCELINKFAILED));
		return CString("");
	}
	uint32 dwID = serverconnect->GetClientID();

	wxString strLink;
	strLink.Printf("ed2k://|file|%s|%u|%s|/|sources,%i.%i.%i.%i:%i|/", StripInvalidFilenameChars(f->GetFileName(), false).GetData(),	// spaces to dots
				   f->GetFileSize(), EncodeBase16(f->GetFileHash(), 16).GetData(), (uint8) dwID, (uint8) (dwID >> 8), (uint8) (dwID >> 16), (uint8) (dwID >> 24), glob_prefs->GetPort());
	return strLink;
}

wxString CxmuleApp::CreateHTMLED2kLink(CAbstractFile * f)
{
	wxString strCode = "<a href=\"" + CreateED2kLink(f) + "\">" + StripInvalidFilenameChars(f->GetFileName(), true) + "</a>";
	return strCode;
}

bool CxmuleApp::CopyTextToClipboard(wxString strText)
{
	if (wxTheClipboard->Open()) {
		wxTheClipboard->UsePrimarySelection(FALSE);
		wxTheClipboard->SetData(new wxTextDataObject(strText));
		wxTheClipboard->Close();
	}
}


/* Original implementation by Bouc7 of the eMule Project.
   xMule Signature idea was designed by BigBob and implemented
   by Un-Thesis, with design inputs and suggestions from bothie.
*/
void CxmuleApp::OnlineSig(bool zero /* reset stats (used on shutdown) */) 
{
	// Do not do anything if online signature is disabled in Preferences
	if (!theApp.glob_prefs->IsOnlineSignatureEnabled()) {
		return;
	}

	// Build the filenames for the two files
	char* emulesig_path = new char[strlen(glob_prefs->GetAppDir())+14];
	char* xmulesig_path = new char[strlen(glob_prefs->GetAppDir())+13];
	sprintf(emulesig_path,"%sonlinesig.dat",glob_prefs->GetAppDir());
	sprintf(xmulesig_path,"%sxmulesig.dat",glob_prefs->GetAppDir());

	// Open both files for writing
	CFile xmulesig_out, emulesig_out;
	if (!emulesig_out.Open(emulesig_path, CFile::write)) {
		theApp.xmuledlg->AddLogLine(true,GetResString(IDS_ERROR_SAVEFILE)+wxString(" OnlineSig File"));
	}
	if (!xmulesig_out.Open(xmulesig_path, CFile::write)) {
		theApp.xmuledlg->AddLogLine(true,GetResString(IDS_ERROR_SAVEFILE)+wxString(" xMule OnlineSig File"));
	}

	char buffer[256];

	if (zero) {
		emulesig_out.Write("0\n0.0|0.0|0\n", 12);
		xmulesig_out.Write("0\n0\n0\n0\n0\n0.0\n0.0\n0\n0\n", 22);
	} else {
		if (serverconnect->IsConnected()) {
			// We are online
			emulesig_out.Write("1",1);
			emulesig_out.Write("|",1);
			// Name of server (Do not use GetRealName()!)
			emulesig_out.Write(serverconnect->GetCurrentServer()->GetListName(),strlen(serverconnect->GetCurrentServer()->GetListName()));
			emulesig_out.Write("|",1);
			// IP and port of the server
			emulesig_out.Write(serverconnect->GetCurrentServer()->GetFullIP(),strlen(serverconnect->GetCurrentServer()->GetFullIP()));
			emulesig_out.Write("|",1);
			sprintf(buffer,"%d",serverconnect->GetCurrentServer()->GetPort());
			emulesig_out.Write(buffer,strlen(buffer));

			// Now for xmule sig
			xmulesig_out.Write("1",1);
			xmulesig_out.Write("\n",1);
			xmulesig_out.Write(serverconnect->GetCurrentServer()->GetListName(),strlen(serverconnect->GetCurrentServer()->GetListName()));
			xmulesig_out.Write("\n",1);
			xmulesig_out.Write(serverconnect->GetCurrentServer()->GetFullIP(),strlen(serverconnect->GetCurrentServer()->GetFullIP()));
			xmulesig_out.Write("\n",1);
			xmulesig_out.Write(buffer,strlen(buffer));
			xmulesig_out.Write("\n",1);

			// Low- or High-ID (only in xmule sig)
			if (theApp.serverconnect->IsLowID()) {
				xmulesig_out.Write("L\n",2);
			} else {
				xmulesig_out.Write("H\n",2);
			}
		} else {	// Not connected to a server
			emulesig_out.Write("0",1);
			xmulesig_out.Write("0\n0\n0\n0\n0\n",10);
		}
		emulesig_out.Write("\n",1);

		// Datarate for downloads
		sprintf(buffer,"%.1f",(float)downloadqueue->GetDatarate()/1024);
		emulesig_out.Write(buffer,strlen(buffer));
		emulesig_out.Write("|",1);
		xmulesig_out.Write(buffer,strlen(buffer));
		xmulesig_out.Write("\n",1);

		// Datarate for uploads
		sprintf(buffer,"%.1f",(float)uploadqueue->GetDatarate()/1024);
		emulesig_out.Write(buffer,strlen(buffer));
		emulesig_out.Write("|",1);
		xmulesig_out.Write(buffer,strlen(buffer));
		xmulesig_out.Write("\n",1);

		// Number of users waiting for upload
		sprintf(buffer,"%d",uploadqueue->GetWaitingUserCount());
		emulesig_out.Write(buffer,strlen(buffer));
		xmulesig_out.Write(buffer,strlen(buffer));
		xmulesig_out.Write("\n",1);

		// Number of shared files
		sprintf(buffer,"%d", theApp.sharedfiles->GetCount());
		xmulesig_out.Write(buffer, strlen(buffer));
		xmulesig_out.Write("\n",1);
	}	/* if (!zero) */

	// Nick on the network
	sprintf(buffer, "%s", theApp.glob_prefs->GetUserNick());
	xmulesig_out.Write(buffer, strlen(buffer));
	xmulesig_out.Write("\n",1);

	// Total received in GB
	sprintf(buffer, "%.2f", (float)(theApp.stat_sessionReceivedBytes+theApp.glob_prefs->GetTotalDownloaded()) / 1073741824);
	xmulesig_out.Write(buffer, strlen(buffer));
	xmulesig_out.Write("\n",1);

	// Total sent in GB
	sprintf(buffer, "%.2f", (float)(theApp.stat_sessionSentBytes+theApp.glob_prefs->GetTotalUploaded()) / 1073741824);
	xmulesig_out.Write(buffer, strlen(buffer));
	xmulesig_out.Write("\n",1);

	// xmule version 
	sprintf(buffer,"%s", PACKAGE_VERSION);
	xmulesig_out.Write(buffer, strlen(buffer));
	xmulesig_out.Write("\n",1);

	// Close the files
	emulesig_out.Close();
	xmulesig_out.Close();
	delete[] emulesig_path;
	delete[] xmulesig_path;
} //End Added By Bouc7
#if defined(__linux__)
#include <execinfo.h>
#endif

void CxmuleApp::OnFatalException()
{
	// Close sockets first.
	if ( theApp.listensocket )
		theApp.listensocket->Destroy();
	if ( theApp.clientudp )
		theApp.clientudp->Destroy();

	// (stkn) create backtrace
#if defined(__linux__)
	void *bt_array[100];	// 100 should be enough ?!?
	char **bt_strings;
	int num_entries;

	if ((num_entries = backtrace(bt_array, 100)) < 0) {
		fprintf(stderr, "* Could not generate backtrace\n");
		return;
	}

	if ((bt_strings = backtrace_symbols(bt_array, num_entries)) == NULL) {
		fprintf(stderr, "* Could not get symbol names for backtrace\n");
		return;
	}

	fprintf(stderr, "\nOOPS! - Seems like xMule crashed\n--== BACKTRACE FOLLOWS: ==--\n\n");
	for (int i = 0; i < num_entries; i++) {
		fprintf(stderr, "[%d] %s\n", i, bt_strings[i]);
	}
	free(bt_strings);
#endif
}

#define wxGTK_WINDOW 1
#define SHIFT (8*(sizeof(short int)-sizeof(char)))

static bool GetColourWidget(int &red, int &green, int &blue, int type)
{
	GtkWidget *widget;
	switch (type) {
		case wxGTK_WINDOW:
			widget = gtk_window_new(GTK_WINDOW_TOPLEVEL);
			break;
		default:
			return FALSE;
	}
	GtkStyle *def = gtk_rc_get_style(widget);
	bool ok = false;
	if (!def) {
		def = gtk_widget_get_default_style();
	}
	if (def) {
		GdkColor *col;
		col = def->bg;
		red = col[GTK_STATE_NORMAL].red;
		green = col[GTK_STATE_NORMAL].green;
		blue = col[GTK_STATE_NORMAL].blue;
		ok = true;
	}
	gtk_widget_destroy(widget);
	return ok;
}

// external helper function
wxColour GetColour(wxSystemColour what)
{
	static wxColour *_systemWindowColour = NULL;

	switch (what) {
		case wxSYS_COLOUR_WINDOW:
			if (!_systemWindowColour) {
				int red, green, blue;
				if (!GetColourWidget(red, green, blue, wxGTK_WINDOW)) {
					red = green = blue = 0x9c40;
				}
				_systemWindowColour = new wxColour(red >> SHIFT, green >> SHIFT, blue >> SHIFT);
			}
			return *_systemWindowColour;
	}
}
