// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (donate@xmule.org / http://www.xmule.org/)
// RSA-1024 Fingerprint: 4145 9DFD 5338 4FCC 1636  86E5 2E5A 42D8 BA13 460B
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// CommentDialog.cpp : implementation file
//

#ifdef PRECOMP
#	include "xmule-headers.h"
#else
#	include "CommentDialog.h"
#	include "KnownFile.h"
#	include "mfc.h"
#	include "muuli_wdr.h"
#	include "otherfunctions.h"
#	include "wintypes.h"
#	include "xmule.h"
#endif

#include <wx/settings.h>
// CommentDialog dialog

#include "wx/xrc/xmlres.h"
#include "wx/xrc/xh_all.h"

#define GetDlgItem(x,clas) XRCCTRL(*this,#x,clas)
#define IsDlgButtonChecked(x) XRCCTRL(*this,#x,wxCheckBox)->GetValue()
#define CheckDlgButton(x,y) XRCCTRL(*this,#x,wxCheckBox)->SetValue(y)

//IMPLEMENT_DYNAMIC(CCommentDialog, CDialog)
CCommentDialog::CCommentDialog(wxWindow* parent,CKnownFile* file)
//: CDialog(CCommentDialog::IDD, 0)
: wxDialog(parent,CCommentDialog::IDD,_("File Comments"),
wxDefaultPosition,wxDefaultSize,wxDEFAULT_DIALOG_STYLE|wxSYSTEM_MENU) {
	m_file = file;
	//wxSizer* content=commentDlg(this,TRUE);
	//content->Show(this,TRUE);
	wxPanel* content=wxXmlResource::Get()->LoadPanel(this,"DLG_COMMENT");
	SetSize(content->GetSize());
	content->SetBackgroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_WINDOWFRAME));
	Center();
	ratebox=XRCCTRL(*this,"IDC_RATELIST",wxComboBox);
	OnInitDialog();
}

CCommentDialog::~CCommentDialog() {
}

BEGIN_EVENT_TABLE(CCommentDialog,wxDialog)
EVT_BUTTON(XRCID("IDCOK"),CCommentDialog::OnBnClickedApply)
EVT_BUTTON(XRCID("IDCCANCEL"),CCommentDialog::OnBnClickedCancel)
END_EVENT_TABLE()

#if 0
void CCommentDialog::DoDataExchange(CDataExchange* pDX) {
	CDialog::DoDataExchange(pDX);
	//for rate:
	DDX_Control(pDX, IDC_RATELIST, ratebox);
}

BEGIN_MESSAGE_MAP(CCommentDialog, CDialog)
ON_BN_CLICKED(IDCOK, OnBnClickedApply)
ON_BN_CLICKED(IDCCANCEL, OnBnClickedCancel)
END_MESSAGE_MAP()
#endif


void CCommentDialog::OnBnClickedApply(wxEvent& evt) {
	wxString SValue;
	//(SValue);:
	SValue=GetDlgItem(IDC_CMT_TEXT,wxTextCtrl)->GetValue();
	m_file->SetFileComment(CString(SValue));
	//for Rate//:
	m_file->SetFileRate((int8) ratebox->GetSelection());
	//CDialog::OnOK();
	EndModal(0);
}

void CCommentDialog::OnBnClickedCancel(wxEvent& evt) {
	//CDialog::OnCancel();
	EndModal(0);
}

BOOL CCommentDialog::OnInitDialog() {
	//CDialog::OnInitDialog();
	Localize();
	GetDlgItem(IDC_CMT_TEXT,wxTextCtrl)->SetValue(m_file->GetFileComment());
	//((CEdit*)GetDlgItem(IDC_CMT_TEXT))->SetLimitText(50);
	GetDlgItem(IDC_CMT_TEXT,wxTextCtrl)->SetMaxLength(50);
	return TRUE;
}

void CCommentDialog::Localize(void) {
	GetDlgItem(IDCOK,wxControl)->SetLabel(GetResString(IDS_PW_APPLY));
	GetDlgItem(IDCCANCEL,wxControl)->SetLabel(GetResString(IDS_CANCEL));
	GetDlgItem(IDC_CMT_LQUEST,wxControl)->SetLabel(GetResString(IDS_CMT_QUEST));
	GetDlgItem(IDC_CMT_LAIDE,wxControl)->SetLabel(GetResString(IDS_CMT_AIDE));
	//for rate//
	GetDlgItem(IDC_RATEQUEST,wxControl)->SetLabel(GetResString(IDS_CMT_RATEQUEST));
	GetDlgItem(IDC_RATEHELP,wxControl)->SetLabel(GetResString(IDS_CMT_RATEHELP));
	while (ratebox->GetCount() >0) ratebox->Delete(0);
	ratebox->Append(GetResString(IDS_CMT_NOTRATED));
	ratebox->Append(GetResString(IDS_CMT_FAKE));
	ratebox->Append(GetResString(IDS_CMT_POOR));
	ratebox->Append(GetResString(IDS_CMT_GOOD));
	ratebox->Append(GetResString(IDS_CMT_FAIR));
	ratebox->Append(GetResString(IDS_CMT_EXCELLENT));
	//==CB_ERR)ratebox.SetCurSel(0) ;:
	ratebox->SetSelection(m_file->GetFileRate());
	//--end rate--//
	wxString strTitle;
	strTitle.Printf(GetResString(IDS_CMT_TITLE),m_file->GetFileName());
	//AfxFormatString1(title,IDS_CMT_TITLE,m_file->GetFileName());
	//SetWindowText(strTitle);
	SetTitle(strTitle);
}


