// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (donate@xmule.org / http://www.xmule.org/)
// RSA-1024 Fingerprint: 4145 9DFD 5338 4FCC 1636  86E5 2E5A 42D8 BA13 460B
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.xmule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef EMULE_H
#define EMULE_H

//#ifndef __AFXWIN_H__
//	#error include 'stdafx.h' before including this file for PCH
//#endif

#include <wx/app.h>
#include <wx/intl.h>
#include <wx/settings.h>
#include <wx/thread.h>

#include "types.h"
#include "wintypes.h"

class CAbstractFile;
class CClientCreditsList;
class CClientList;
class CClientUDPSocket;
class CDownloadQueue;
class CFriendList;
class CIPFilter;
class CKnownFileList;
class CListenSocket;
class CPreferences;
class CServerConnect;
class CServerList;	
class CSharedFileList;
class CUploadQueue;
class CWebServer;
class CxmuleDlg;


//#include <afxmt.h>

//extern CxmuleApp theApp;
#define theApp (*((CxmuleApp*)wxTheApp))
#define G_BLEND(a,b) ( ((int)a*b)/100>255?255:((int)a*b)/100 ) 


class CxmuleApp : public wxApp {
public:
				CxmuleApp();
	virtual		~CxmuleApp();
	int			OnExit();
	void			OnFatalException();
	CxmuleDlg *xmuledlg;
	CClientList *clientlist;
	CKnownFileList *knownfiles;
	CPreferences *glob_prefs;
	CServerConnect *serverconnect;
	CServerList *serverlist;	
	CSharedFileList *sharedfiles;
	CListenSocket *listensocket;
	CUploadQueue *uploadqueue;
	CDownloadQueue *downloadqueue;
	CClientCreditsList *clientcredits;
	CClientUDPSocket *clientudp;
	CFriendList *friendlist;
	CWebServer *webserver;
	//virtual BOOL		InitInstance();
	virtual bool 		OnInit();
	wxString*		pendinglink;
	//tagCOPYDATASTRUCT  sendstruct; //added by Cax2 28/10/02 
	CIPFilter*		ipfilter;

	uint64			stat_sessionReceivedBytes;
	uint64			stat_sessionSentBytes;
	uint16			stat_reconnects;
	DWORD			stat_transferStarttime;
	DWORD			stat_serverConnectTime;
	uint16			stat_filteredclients;
	DWORD			Start_time;

	// Implementierung
	// ed2k link functions
	wxString		StripInvalidFilenameChars(wxString strText, bool bKeepSpaces = true);
	wxString		CreateED2kLink( CAbstractFile* f );
	wxString		CreateHTMLED2kLink( CAbstractFile* f );
	wxString		CreateED2kSourceLink( CAbstractFile* f );
	bool			CopyTextToClipboard( wxString strText );
	void			OnlineSig(bool zero = false); 
	void			UpdateReceivedBytes(int32 bytesToAdd);
	void			UpdateSentBytes(int32 bytesToAdd);

	//DECLARE_MESSAGE_MAP()
protected:
	
	bool 			ProcessCommandline();
	void 			SetTimeOnTransfer();

	wxLocale		m_locale;

};

// helper
wxColour GetColour(wxSystemColour what);


#endif
