// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (donate@xmule.org / http://www.xmule.org/)
// RSA-1024 Fingerprint: 4145 9DFD 5338 4FCC 1636  86E5 2E5A 42D8 BA13 460B
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef _TABCTRL_H
#define _TABCTRL_H

#pragma interface "tabctrl.h" 

#include <wx/wx.h>
#include <gtk/gtk.h>

class wxTabItem;
WX_DECLARE_LIST(wxTabItem,TabList);

const int wxEVT_TABCTRL_FIRST = 10000+6341;

BEGIN_DECLARE_EVENT_TYPES()
     DECLARE_EVENT_TYPE(wxEVT_TAB_CHANGED,wxEVT_TABCTRL_FIRST+1)
END_DECLARE_EVENT_TYPES()

class wxTabCtrl : public wxControl
{
  DECLARE_DYNAMIC_CLASS(wxTabCtrl)
public:
  wxTabCtrl() {};
  wxTabCtrl(wxWindow* parent, const wxWindowID id=-1,
	    const wxPoint& pos = wxDefaultPosition,
	    const wxSize& size=wxDefaultSize,
	    const long int style=0)
    { Create(parent,id,pos,size,style); }

  bool Create(wxWindow* parent,const wxWindowID id,const wxPoint& pos,
	      const wxSize& size,const long int style);

  long InsertItem(int nMask,int nItem,wxString title,int nImage,long lpar);

  void OnPaint(GtkWidget* widget,GdkEventExpose* evt);
 private:
  void OnLeftDown(wxMouseEvent& evt);
  void OnMotion(wxMouseEvent& evt);

  int calcTabWidth();
  int tabsVisible();
  DECLARE_EVENT_TABLE()

  TabList m_tabs;
  int currentTab;
  int firstTab;
  bool prelightRight;
  bool prelightLeft;
};

#endif
