// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (donate@xmule.org / http://www.xmule.org/)
// RSA-1024 Fingerprint: 4145 9DFD 5338 4FCC 1636  86E5 2E5A 42D8 BA13 460B
//
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.xmule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifdef PRECOMP
#	include "xmule-headers.h"
#else
#	include "CatDialog.h"
#	include "CMuleNotebookBase.h"
#	include "DownloadQueue.h"
#	include "muuli_wdr.h"
#	include "otherfunctions.h"
#	include "TransferWnd.h"
#	include "UploadQueue.h"
#	include "wintypes.h"
#	include "xmule.h"
#	include "xmuleDlg.h"
#endif

#include <wx/settings.h>
#include <wx/splitter.h>

// CTransferWnd dialog

IMPLEMENT_DYNAMIC_CLASS(CTransferWnd,wxPanel)

BEGIN_EVENT_TABLE(CTransferWnd,wxPanel)
EVT_MULENOTEBOOK_PAGE_CHANGED(ID_CATEGORIES,CTransferWnd::OnSelchangeDltab)
EVT_RIGHT_DOWN(CTransferWnd::OnNMRclickDLtab)
EVT_SPLITTER_SASH_POS_CHANGED(ID_SPLATTER, CTransferWnd::OnSashPositionChanged)
END_EVENT_TABLE()

// handled in controls ProcessEvents()
//  EVT_MENU(MP_SWITCHCTRL,CTransferWnd::SwitchUploadList)

//IMPLEMENT_DYNAMIC(CTransferWnd, CDialog)
    CTransferWnd::CTransferWnd(wxWindow* pParent /*=NULL*/

)
: wxPanel(pParent,CTransferWnd::IDD) {
	SetBackgroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_WINDOWFRAME));
	wxSizer* content=transferDlg(this,TRUE);
	content->Show(this,TRUE);
	wxSplitterWindow* split=(wxSplitterWindow*) FindWindow("splitterWnd");
	wxPanel* subContent1=new wxPanel(split,-1);
	subContent1->SetBackgroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_WINDOWFRAME));
	wxSizer* subC1=transferTopPane(subContent1,TRUE);
	wxPanel* subContent2=new wxPanel(split,-1);
	subContent2->SetBackgroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_WINDOWFRAME));
	wxSizer* subC2=transferBottomPane(subContent2,FALSE);
	split->SplitHorizontally(subContent1,subContent2);
	uploadlistctrl=(CUploadListCtrl*) FindWindowByName("uploadList");
	downloadlistctrl=(CDownloadListCtrl*) FindWindowByName("downloadList");
	queuelistctrl=(CQueueListCtrl*) FindWindowByName("uploadQueue");
	// let's hide the queue
	queueSizer->Remove(queuelistctrl);
	subC2->SetDimension(0,0,100,50);
	queueSizer->Layout();
	//subC2->Layout();
	queuelistctrl->Show(FALSE);
	// allow notebook to dispatch right mouse clicks to us
	CMuleNotebook* nb=(CMuleNotebook*) FindWindowById(ID_CATEGORIES);
	nb->SetMouseListener(GetEventHandler());
	windowtransferstate=false;
	CatMenu=false;
}

CTransferWnd::~CTransferWnd() {
}

#if 0
BEGIN_MESSAGE_MAP(CTransferWnd, CResizableDialog)
ON_NOTIFY_EX_RANGE(TTN_NEEDTEXT,0,0xFFFF,OnToolTipNotify)
END_MESSAGE_MAP()
#endif

BOOL CTransferWnd::OnInitDialog() {
	m_dlTab=(CMuleNotebook*) FindWindowById(ID_CATEGORIES);
	// show & cat-tabs
	sprintf(theApp.glob_prefs->GetCategory(0)->title, "%s",GetCatTitle(theApp.glob_prefs->GetAllcatType()) .GetBuffer());
	sprintf(theApp.glob_prefs->GetCategory(0)->incomingpath,"%s",theApp.glob_prefs->GetIncomingDir());
	for (int ix=0;ix<theApp.glob_prefs->GetCatCount();ix++) {
		wxPanel* nullPanel=new wxPanel(m_dlTab);
		wxString tmpstrstr(theApp.glob_prefs->GetCategory(ix)->title);
		// just temporary string.:
		m_dlTab->AddPage(nullPanel,"-");
		// for some odd reason, wxwin2.5 and gtk2 will not allow non utf strings for AddPage()
		// but they will be accepted in SetPageText().. so let's use this as a countermeasure
		m_dlTab->SetPageText(ix,tmpstrstr);
	}
#if 0
	CResizableDialog::OnInitDialog();
	Localize();
	windowtransferstate = false;
	uploadlistctrl.Init();
	downloadlistctrl.Init();
	queuelistctrl.Init();
	((CStatic*) GetDlgItem(IDC_DOWNLOAD_ICO))->SetIcon((HICON) ::LoadImage(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_DIRECTDOWNLOAD), IMAGE_ICON, 16, 16, 0));
	((CStatic*) GetDlgItem(IDC_UPLOAD_ICO))->SetIcon((HICON) ::LoadImage(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_UPLOAD), IMAGE_ICON, 16, 16, 0));
	AddAnchor(IDC_DOWNLOADLIST,TOP_LEFT,CSize(100, theApp.glob_prefs->GetSplitterbarPosition()));
	AddAnchor(IDC_UPLOADLIST,CSize(0,theApp.glob_prefs->GetSplitterbarPosition()),BOTTOM_RIGHT);
	AddAnchor(IDC_QUEUELIST,CSize(0,theApp.glob_prefs->GetSplitterbarPosition()),BOTTOM_RIGHT);
	AddAnchor(IDC_UPLOAD_TEXT,CSize(0,theApp.glob_prefs->GetSplitterbarPosition()),BOTTOM_RIGHT);
	AddAnchor(IDC_UPLOAD_ICO,CSize(0,theApp.glob_prefs->GetSplitterbarPosition()),BOTTOM_RIGHT);
	AddAnchor(IDC_QUEUECOUNT,BOTTOM_LEFT);
	AddAnchor(IDC_TSTATIC1,BOTTOM_LEFT);
	// splitting functionality
	CRect rc,rcSpl,rcDown;
	GetWindowRect(rc);
	ScreenToClient(rc);
	rcSpl=rc; rcSpl.top=rc.bottom-100; rcSpl.bottom=rcSpl.top+5;rcSpl.left=55;
	m_wndSplitter.Create(WS_CHILD| WS_VISIBLE, rcSpl, this, IDC_SPLITTER);
	SetInitLayout();
	// create tooltip
	m_ttip.Create(this);
	m_ttip.SetDelayTime(TTDT_AUTOPOP, 20000);
	m_ttip.SetDelayTime(TTDT_INITIAL, theApp.glob_prefs->GetToolTipDelay() *1000);
	// recognize \n chars!:
	m_ttip.SendMessage(TTM_SETMAXTIPWIDTH, 0, SHRT_MAX);
	m_ttip.AddTool(&downloadlistctrl);
	m_ttip.AddTool(&uploadlistctrl);
	m_iOldToolTipItemDown =-1;
	m_iOldToolTipItemUp =-1;
	m_iOldToolTipItemQueue =-1;
#endif
	return true;
}


void CTransferWnd::ShowQueueCount(uint32 number) {
	char buffer[100];
	wxString fmtstr="%u (%u "+ GetResString(IDS_BANNED) .MakeLower()+")";
	sprintf(buffer,fmtstr.GetData(),number,theApp.uploadqueue->GetBanCount());
	wxStaticCast(FindWindowByName("clientCount"),wxStaticText)->SetLabel(buffer);
	//this->GetDlgItem(IDC_QUEUECOUNT)->SetWindowText(buffer);
}

#if 0
void CTransferWnd::DoDataExchange(CDataExchange* pDX) {
	CResizableDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_UPLOADLIST, uploadlistctrl);
	DDX_Control(pDX, IDC_DOWNLOADLIST, downloadlistctrl);
	DDX_Control(pDX, IDC_QUEUELIST, queuelistctrl);
}

#endif

void CTransferWnd::SetInitLayout() {
#if 0
	CRect rcDown,rcSpl,rcW;
	CWnd* pWnd;
	GetWindowRect(rcW);
	ScreenToClient(rcW);
	LONG splitpos=(theApp.glob_prefs->GetSplitterbarPosition() *rcW.Height()) /100;
	pWnd = GetDlgItem(IDC_DOWNLOADLIST);
	pWnd->GetWindowRect(rcDown);
	ScreenToClient(rcDown);
	rcDown.right=rcW.right-7;
	rcDown.bottom=splitpos-5;
	downloadlistctrl.MoveWindow(rcDown);
	pWnd = GetDlgItem(IDC_UPLOADLIST);
	pWnd->GetWindowRect(rcDown);
	ScreenToClient(rcDown);
	rcDown.right=rcW.right-7;
	rcDown.bottom=rcW.bottom-20;
	rcDown.top=splitpos+20;
	uploadlistctrl.MoveWindow(rcDown);
	pWnd = GetDlgItem(IDC_QUEUELIST);
	pWnd->GetWindowRect(rcDown);
	ScreenToClient(rcDown);
	rcDown.right=rcW.right-7;
	rcDown.bottom=rcW.bottom-20;
	rcDown.top=splitpos+20;
	queuelistctrl.MoveWindow(rcDown);
	rcSpl=rcDown;
	rcSpl.top=rcDown.bottom+4;rcSpl.bottom=rcSpl.top+5;rcSpl.left=95;
	m_wndSplitter.MoveWindow(rcSpl,true);
	DoResize(0);
#endif
}

void CTransferWnd::DoResize(int delta) {
#if 0
	CSplitterControl::ChangeHeight(&downloadlistctrl, delta);
	CSplitterControl::ChangeHeight(&uploadlistctrl,-delta, CW_BOTTOMALIGN);
	CSplitterControl::ChangeHeight(&queuelistctrl,-delta, CW_BOTTOMALIGN);
	UpdateSplitterRange();
	Invalidate();
	UpdateWindow();
#endif
}

// setting splitter range limits
void CTransferWnd::UpdateSplitterRange() {
#if 0
	CRect rcDown,rcUp,rcW,rcSpl;
	CWnd* pWnd;
	GetWindowRect(rcW);
	ScreenToClient(rcW);
	pWnd = GetDlgItem(IDC_DOWNLOADLIST);
	pWnd->GetWindowRect(rcDown);
	ScreenToClient(rcDown);
	pWnd = GetDlgItem(IDC_UPLOADLIST);
	pWnd->GetWindowRect(rcUp);
	ScreenToClient(rcUp);
	pWnd = GetDlgItem(IDC_QUEUELIST);
	pWnd->GetWindowRect(rcUp);
	ScreenToClient(rcUp);
	theApp.glob_prefs->SetSplitterbarPosition((rcDown.bottom*100) /rcW.Height());
	RemoveAnchor(IDC_DOWNLOADLIST);RemoveAnchor(IDC_UPLOADLIST);RemoveAnchor(IDC_QUEUELIST);
	AddAnchor(IDC_DOWNLOADLIST,TOP_LEFT,CSize(100,theApp.glob_prefs->GetSplitterbarPosition()));
	AddAnchor(IDC_UPLOADLIST,CSize(0,theApp.glob_prefs->GetSplitterbarPosition()),BOTTOM_RIGHT);
	AddAnchor(IDC_QUEUELIST,CSize(0,theApp.glob_prefs->GetSplitterbarPosition()),BOTTOM_RIGHT);
	m_wndSplitter.SetRange(rcDown.top+50, rcUp.bottom-40);
#endif
}


#if 0
LRESULT CTransferWnd::DefWindowProc(UINT message, WPARAM wParam, LPARAM lParam) {
	switch (message) {
		// arrange transferwindow layout
	case WM_PAINT:
		if (m_wndSplitter) {
			CRect rcDown,rcSpl,rcW;
			CWnd* pWnd;
			GetWindowRect(rcW);
			ScreenToClient(rcW);
			pWnd = GetDlgItem(IDC_DOWNLOADLIST);
			pWnd->GetWindowRect(rcDown);
			ScreenToClient(rcDown);
			if (rcW.Height() >0) {
				// splitter paint update
				rcSpl=rcDown;
				rcSpl.top=rcDown.bottom+8;rcSpl.bottom=rcSpl.top+5;rcSpl.left=95;
				GetDlgItem(IDC_UPLOAD_TEXT)->MoveWindow(30,rcSpl.top-5,90,16);
				GetDlgItem(IDC_UPLOAD_ICO)->MoveWindow(10,rcSpl.top-5,16,16);
				m_wndSplitter.MoveWindow(rcSpl,true);
				UpdateSplitterRange();
			}
		}
		break;
	case WM_NOTIFY:
		if (wParam == IDC_SPLITTER) {
			SPC_NMHDR* pHdr = (SPC_NMHDR*) lParam;
			DoResize(pHdr->delta);
		}
		break;
	case WM_WINDOWPOSCHANGED : {
		CRect rcW;
			GetWindowRect(rcW);
			ScreenToClient(rcW);
			if (m_wndSplitter&& rcW.Height() >0) Invalidate();
			break;
		}
	case WM_SIZE:
		if (m_wndSplitter) {
			CRect rcDown,rcSpl,rcW;
			CWnd* pWnd;
			GetWindowRect(rcW);
			ScreenToClient(rcW);
			if (rcW.Height() >0) {
				pWnd = GetDlgItem(IDC_DOWNLOADLIST);
				pWnd->GetWindowRect(rcDown);
				ScreenToClient(rcDown);
				long splitpos=(theApp.glob_prefs->GetSplitterbarPosition() *rcW.Height()) /100;
				rcSpl.right=rcDown.right;rcSpl.top=splitpos+10;rcSpl.bottom=rcSpl.top+5;rcSpl.left=95;
				m_wndSplitter.MoveWindow(rcSpl,true);
			}
		}
		break;
	}
	return CDialog::DefWindowProc(message, wParam, lParam);
}

#endif

#if 0
// CTransferWnd message handlers
BOOL CTransferWnd::PreTranslateMessage(MSG* pMsg) {
	// handle tooltip updating, when mouse is moved from one item to another
	if (pMsg->message== WM_MOUSEMOVE)
	UpdateToolTips();
	// relay mouse events to tooltip control
	if (pMsg->message== WM_LBUTTONDOWN|| pMsg->message== WM_LBUTTONUP|| pMsg->message== WM_MOUSEMOVE)
	m_ttip.RelayEvent(pMsg);
	return CResizableDialog::PreTranslateMessage(pMsg);
}

#endif

void CTransferWnd::UpdateToolTips(void) {
#if 0
	int sel = GetItemUnderMouse(&downloadlistctrl);
	if (sel !=-1) {
		if (sel != m_iOldToolTipItemDown) {
			if (m_ttip.IsWindowVisible())
			m_ttip.Update();
			m_iOldToolTipItemDown = sel;
			return;
		}
	}
	int sel2 = GetItemUnderMouse(&uploadlistctrl);
	if (sel2 !=-1) {
		if (sel2 != m_iOldToolTipItemUp) {
			if (m_ttip.IsWindowVisible())
			m_ttip.Update();
			m_iOldToolTipItemUp = sel2;
			return;
		}
	}
 /* no tooltips needed ATM
 int sel3 = GetItemUnderMouse(&queuelistctrl);
 if (sel3 != -1)
 {
 if (sel3 != m_iOldToolTipItemQueue)
 {
 if (m_ttip.IsWindowVisible())
 m_ttip.Update();
 m_iOldToolTipItemQueue = sel3;
 }
 }
    */
    if (sel ==-1&& sel2 ==-1 /*&& sel3 != -1*/
	)
	m_ttip.Pop();
#endif
}

int CTransferWnd::GetItemUnderMouse(wxListCtrl* ctrl) {
#if 0
	CPoint pt;
	::GetCursorPos(&pt);
	ctrl->ScreenToClient(&pt);
	LVHITTESTINFO hit, subhit;
	hit.pt = pt;
	subhit.pt = pt;
	ctrl->SubItemHitTest(&subhit);
	int sel = ctrl->HitTest(&hit);
	if (sel != LB_ERR&& (hit.flags& LVHT_ONITEM)) {
		if (subhit.iSubItem == 0)
		return sel;
	}
	return LB_ERR;
#endif
}

#if 0
BOOL CTransferWnd::OnToolTipNotify(UINT id, NMHDR *pNMH, LRESULT *pResult) {
	TOOLTIPTEXT *pText = (TOOLTIPTEXT *) pNMH;
	int control_id = ::GetDlgCtrlID((HWND) pNMH->idFrom);
	if (!control_id)
	return FALSE;
	CString info;
	if (control_id == IDC_DOWNLOADLIST) {
		if (downloadlistctrl.GetItemCount() < 1)
		return FALSE;
		int sel = GetItemUnderMouse(&downloadlistctrl);
		if (sel < 0|| sel == 65535)
		return FALSE;
		// build info text and display it
		CtrlItem_Struct* content = (CtrlItem_Struct*) downloadlistctrl.GetItemData(sel);
		// for downloading files:
		if (content->type == 1) {
			CPartFile* partfile = (CPartFile*) content->value;
			CString strHash;
			strHash.Format("%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X",
			partfile->GetFileHash() [0],partfile->GetFileHash() [1],partfile->GetFileHash() [2],partfile->GetFileHash() [3],partfile->GetFileHash() [4],partfile->GetFileHash() [5],partfile->GetFileHash() [6],partfile->GetFileHash() [7],
			partfile->GetFileHash() [8],partfile->GetFileHash() [9],partfile->GetFileHash() [10],partfile->GetFileHash() [11],partfile->GetFileHash() [12],partfile->GetFileHash() [13],partfile->GetFileHash() [14],partfile->GetFileHash() [15]);
			CTime t(partfile->GetFileDate());
			char lsc[50]; char compl[50]; char buffer[20];
			CastItoXBytes(partfile->GetCompletedSize(),lsc);
			CastItoXBytes(partfile->GetFileSize(),buffer);
			sprintf(compl,"%s/%s",lsc,buffer);
			if (partfile->lastseencomplete==NULL) sprintf(lsc,GetResString(IDS_UNKNOWN) .MakeLower()); else
				sprintf(lsc,partfile->lastseencomplete.Format("%A, %x, %X"));
			float availability = 0;
			if(partfile->GetPartCount() != 0) {
				availability = partfile->GetAvailablePartCount() * 100 / partfile->GetPartCount();
			}
			info.Format(GetResString(IDS_DL_FILENAME)+": %s (%d %s)\n"
			+GetResString(IDS_DATE)+": %s - "+ GetResString(IDS_FD_HASH)+" %s\n"
			+GetResString(IDS_PARTINFOS)+
			GetResString(IDS_PARTINFOS2)+"\n%s",
			partfile->GetFileName(), partfile->GetFileSize(),GetResString(IDS_BYTES),
			t.Format("%A, %B %d, %Y"), strHash,
			partfile->GetPartMetFileName(), partfile->GetPartCount(),GetResString(IDS_AVAIL),partfile->GetAvailablePartCount(),availability,
			(int) partfile->GetPercentCompleted(), compl, partfile->GetTransferingSrcCount(),
			GetResString(IDS_LASTSEENCOMPL)+" "+CString(lsc));
			// for sources:
		} else if (content->type == 3|| content->type == 2) {
				CUpDownClient* client = (CUpDownClient*) content->value;
			in_addr server;
			server.S_un.S_addr = client->GetServerIP();
			info.Format(GetResString(IDS_NICKNAME)+" %s ("+GetResString(IDS_USERID)+": %u)\n"
			+GetResString(IDS_CLIENT)+" %s:%d\n"
			+GetResString(IDS_SERVER)+" %s:%d\n"
			+GetResString(IDS_SOURCEINFO),
			client->GetUserName(), client->GetUserID(),
			client->GetFullIP(), client->GetUserPort(),
			inet_ntoa(server), client->GetServerPort(),
    /*client->GetAskedCount()*/
			0, client->GetAvailablePartCount());
			if (content->type == 2) {
				// normal client
				info+= GetResString(IDS_CLIENTSOURCENAME)+ CString(client->GetClientFilename());
			} else {
				// client asked twice
				info+= GetResString(IDS_ASKEDFAF);
			}
		}
	} else if (control_id == IDC_UPLOADLIST) {
		if (uploadlistctrl.GetItemCount() < 1)
		return FALSE;
		int sel = GetItemUnderMouse(&uploadlistctrl);
		if (sel < 0|| sel == 65535)
		return FALSE;
		CUpDownClient* client = (CUpDownClient*) uploadlistctrl.GetItemData(sel);
		CKnownFile* file = theApp.sharedfiles->GetFileByID(client->reqfileid);
		// build info text and display it
		info.Format(GetResString(IDS_USERINFO), client->GetUserName(), client->GetUserID());
		if (file) {
			info+= GetResString(IDS_SF_REQUESTED)+ CString(file->GetFileName())+ "\n";
			CString stat;
			stat.Format(GetResString(IDS_FILESTATS_SESSION)+GetResString(IDS_FILESTATS_TOTAL),
			file->statistic.GetAccepts(), file->statistic.GetRequests(), file->statistic.GetTransfered(),
			file->statistic.GetAllTimeAccepts(), file->statistic.GetAllTimeRequests(), file->statistic.GetAllTimeTransfered());
			info+= stat;
		} else {
			info+= GetResString(IDS_REQ_UNKNOWNFILE);
		}
	}
 /*	no tooltips needed ATM
 else if (control_id == IDC_QUEUELIST)
 {
 if (queuelistctrl.GetItemCount() < 1)
 return FALSE;
 int sel = GetItemUnderMouse(&queuelistctrl);
 if (sel < 0 || sel == 65535)
 return FALSE;
 // build info text and display it
 CUpDownClient* client = (CUpDownClient*)uploadlistctrl.GetItemData(sel);
 in_addr server;
 server.S_un.S_addr = client->GetServerIP();
 info.Format("Nickname: %s (UserID: %u)\n"
 "Client %s:%d\n"
 "Server %s:%d\n"
 "AskedCount: %d - AvailablePartCount: %d",
 client->GetUserName(), client->GetUserID(),
 client->GetFullIP(), client->GetUserPort(),
 inet_ntoa(server), client->GetServerPort(),
 client->GetAskedCount(), client->GetAvailablePartCount());
 }
    */
	// release old used buffer:
	m_strToolTip.ReleaseBuffer();
	m_strToolTip = info;
	pText->lpszText = m_strToolTip.GetBuffer(1);
	// we are not using a resource:
	pText->hinst = NULL;
	PostMessage(WM_ACTIVATE);
	return TRUE;
}

#endif

void CTransferWnd::SwitchUploadList(wxCommandEvent& evt) {
	if(windowtransferstate == false) {
#if 0
		uploadlistctrl.Hide();
		queuelistctrl.Visable();
		windowtransferstate = 0;
		GetDlgItem(IDC_UPLOAD_TEXT)->SetWindowText(GetResString(IDS_ONQUEUE));
#endif
		windowtransferstate=true;
		// hide the upload list
		queueSizer->Remove(uploadlistctrl);
		uploadlistctrl->Show(FALSE);
		queueSizer->Add(queuelistctrl,1,wxGROW|wxALIGN_CENTER_VERTICAL|wxALL,5);
		queuelistctrl->Show();
		queueSizer->Layout();
		wxStaticCast(FindWindowByName("uploadTitle"),wxStaticText)->SetLabel(GetResString(IDS_ONQUEUE));
	} else {
#if 0
		queuelistctrl.Hide();
		uploadlistctrl.Visable();
		windowtransferstate = 1;
		GetDlgItem(IDC_UPLOAD_TEXT)->SetWindowText(GetResString(IDS_TW_UPLOADS));
#endif
		windowtransferstate=false;
		// hide the queuelist
		queueSizer->Remove(queuelistctrl);
		queuelistctrl->Show(FALSE);
		queueSizer->Add(uploadlistctrl,1,wxGROW|wxALIGN_CENTER_VERTICAL|wxALL,5);
		uploadlistctrl->Show();
		queueSizer->Layout();
		wxStaticCast(FindWindowByName("uploadTitle"),wxStaticText)->SetLabel(GetResString(IDS_TW_UPLOADS));
	}
}

void CTransferWnd::Localize() {
#if 0
	GetDlgItem(IDC_DOWNLOAD_TEXT)->SetWindowText(GetResString(IDS_TW_DOWNLOADS));
	GetDlgItem(IDC_UPLOAD_TEXT)->SetWindowText(GetResString(IDS_TW_UPLOADS));
	GetDlgItem(IDC_TSTATIC1)->SetWindowText(GetResString(IDS_TW_QUEUE));
	downloadlistctrl.CreateMenues();
	downloadlistctrl.Localize();
	uploadlistctrl.Localize();
	queuelistctrl.Localize();
#endif
}


void CTransferWnd::OnSelchangeDltab(wxNotebookEvent& evt) {
	downloadlistctrl->ChangeCategory(evt.GetSelection());
	downloadlistctrl->InitSort();
}

void CTransferWnd::OnNMRclickDLtab(wxMouseEvent& evt) {
	CMuleNotebook* nb=(CMuleNotebook*) FindWindowById(ID_CATEGORIES);
	if(nb->GetSelection() ==-1) {
		return;
	}
	// Avoid opening another menu when it's already open
	if (CatMenu==false) {
		CatMenu=true;
		wxMenu* menu=new wxMenu(GetResString(IDS_CAT));
		if(nb->GetSelection() ==0) {
			wxMenu* m_CatMenu=new wxMenu();
			m_CatMenu->Append(MP_CAT_SET0,GetResString(IDS_ALL));
			m_CatMenu->Append(MP_CAT_SET0+1,GetResString(IDS_ALLOTHERS));
			m_CatMenu->AppendSeparator();
			m_CatMenu->Append(MP_CAT_SET0+2,GetResString(IDS_STATUS_NOTCOMPLETED));
			m_CatMenu->Append(MP_CAT_SET0+3,GetResString(IDS_DL_TRANSFCOMPL));
			m_CatMenu->Append(MP_CAT_SET0+4,GetResString(IDS_WAITING));
			m_CatMenu->Append(MP_CAT_SET0+5,GetResString(IDS_DOWNLOADING));
			m_CatMenu->Append(MP_CAT_SET0+6,GetResString(IDS_ERRORLIKE));
			m_CatMenu->Append(MP_CAT_SET0+7,GetResString(IDS_PAUSED));
			m_CatMenu->Append(MP_CAT_SET0+8,GetResString(IDS_STOPPED));
			m_CatMenu->AppendSeparator();
			m_CatMenu->Append(MP_CAT_SET0+9,GetResString(IDS_VIDEO));
			m_CatMenu->Append(MP_CAT_SET0+10,GetResString(IDS_AUDIO));
			m_CatMenu->Append(MP_CAT_SET0+11,GetResString(IDS_SEARCH_ARC));
			m_CatMenu->Append(MP_CAT_SET0+12,GetResString(IDS_SEARCH_CDIMG));
			m_CatMenu->Append(MP_CAT_SET0+13,GetResString(IDS_SEARCH_PICS));
			m_CatMenu->Append(MP_CAT_SET0+14,GetResString(IDS_TEXT));
			//m_CatMenu.CheckMenuItem( MP_CAT_SET0+theApp.glob_prefs->GetAllcatType() ,MF_CHECKED | MF_BYCOMMAND);
			menu->Append(47321,GetResString(IDS_CHANGECATVIEW),m_CatMenu);
		}
		menu->Append(MP_CAT_ADD,GetResString(IDS_CAT_ADD));
		menu->Append(MP_CAT_EDIT,GetResString(IDS_CAT_EDIT));
		menu->Append(MP_CAT_REMOVE, GetResString(IDS_CAT_REMOVE));
		menu->AppendSeparator();
		//menu->Append(472834,GetResString(IDS_PRIORITY),m_PrioMenu);
		menu->Append(MP_CANCEL,GetResString(IDS_MAIN_BTN_CANCEL));
		menu->Append(MP_STOP, GetResString(IDS_DL_STOP));
		menu->Append(MP_PAUSE, GetResString(IDS_DL_PAUSE));
		menu->Append(MP_RESUME, GetResString(IDS_DL_RESUME));
		//menu->Append(MP_RESUMENEXT, GetResString(IDS_DL_RESUMENEXT));
		// the point coming from mulenotebook control isn't in screen coordinates
		// (unlike std mouse event, which always returns screen coordinates)
		// so we must do the conversion here
		wxPoint pt=evt.GetPosition();
		wxPoint newpt=nb->ClientToScreen(pt);
		newpt=ScreenToClient(newpt);
		//evt.Skip();
		PopupMenu(menu,newpt);
		delete menu;
		CatMenu=false;
	}
}

bool CTransferWnd::ProcessEvent(wxEvent& evt) {
	if(evt.GetEventType() !=wxEVT_COMMAND_MENU_SELECTED) {
		return wxPanel::ProcessEvent(evt);
	}
 /*
 if(evt.GetEventObject()!=this)
 return wxPanel::ProcessEvent(evt);
    */
	wxCommandEvent& event=(wxCommandEvent&) evt;
	switch(event.GetId()) {
	case MP_CAT_SET0:
	case MP_CAT_SET0+1:
	case MP_CAT_SET0+2:
	case MP_CAT_SET0+3:
	case MP_CAT_SET0+4:
	case MP_CAT_SET0+5:
	case MP_CAT_SET0+6:
	case MP_CAT_SET0+7:
	case MP_CAT_SET0+8:
	case MP_CAT_SET0+9:
	case MP_CAT_SET0+10:
	case MP_CAT_SET0+11:
	case MP_CAT_SET0+12:
	case MP_CAT_SET0+13:
	case MP_CAT_SET0+14: {
		theApp.glob_prefs->SetAllcatType(event.GetId()-MP_CAT_SET0);
			sprintf(theApp.glob_prefs->GetCategory(0)->title, "%s", GetCatTitle(theApp.glob_prefs->GetAllcatType()) .GetBuffer());
			CString csName;
			csName.Format("%s", theApp.glob_prefs->GetCategory(0)->title);
			EditCatTabLabel(0,csName);
			downloadlistctrl->ChangeCategory(0);
			downloadlistctrl->InitSort();
			break;
		}
	case MP_CAT_ADD: {
		int m_nLastCatTT=-1;
			int newindex=AddCategorie("?",theApp.glob_prefs->GetIncomingDir(),"",false);
			//m_dlTab.InsertItem(newindex,theApp.glob_prefs->GetCatego
			//	       ry(newindex)->title);
			wxPanel* nullPanel=new wxPanel(m_dlTab,-1);
			m_dlTab->AddPage(nullPanel,theApp.glob_prefs->GetCategory(newindex)->title);
			CCatDialog dialog(this,newindex);
			dialog.OnInitDialog();
			//dialog.DoModal();
			dialog.ShowModal();
			//arning TODO: fix this
			//theApp.emuledlg->searchwnd->UpdateCatTabs();
			EditCatTabLabel(newindex,theApp.glob_prefs->GetCategory(newindex)->title);
			theApp.glob_prefs->SaveCats();
			break;
		}
	case MP_CAT_EDIT: {
		int m_nLastCatTT=-1;
			CCatDialog dialog(this,m_dlTab->GetSelection());
			dialog.OnInitDialog();
			dialog.ShowModal();
			CString csName;
			csName.Format("%s", theApp.glob_prefs->GetCategory(m_dlTab->GetSelection())->title);
			EditCatTabLabel(m_dlTab->GetSelection(),csName);
			//arning TODO: fix this
			//theApp.emuledlg->searchwnd.UpdateCatTabs();
			theApp.glob_prefs->SaveCats();
			break;
		}
	case MP_CAT_REMOVE: {
		int m_nLastCatTT=-1;
			theApp.downloadqueue->ResetCatParts(m_dlTab->GetSelection());
			theApp.glob_prefs->RemoveCat(m_dlTab->GetSelection());
			m_dlTab->RemovePage(m_dlTab->GetSelection());
			m_dlTab->SetSelection(0);
			downloadlistctrl->ChangeCategory(0);
			theApp.glob_prefs->SaveCats();
			if (theApp.glob_prefs->GetCatCount() ==1) theApp.glob_prefs->SetAllcatType(0);
			//arning TODO: fix this
			//theApp.emuledlg->searchwnd.UpdateCatTabs();
			break;
		}
	case MP_PRIOLOW: {
		theApp.downloadqueue->SetCatPrio(m_dlTab->GetSelection(),PR_LOW);
			break;
		}
	case MP_PRIONORMAL: {
		theApp.downloadqueue->SetCatPrio(m_dlTab->GetSelection(),PR_NORMAL);
			break;
		}
	case MP_PRIOHIGH: {
		theApp.downloadqueue->SetCatPrio(m_dlTab->GetSelection(),PR_HIGH);
			break;
		}
	case MP_PRIOAUTO: {
		theApp.downloadqueue->SetCatPrio(m_dlTab->GetSelection(),PR_AUTO);
			break;
		}
	case MP_PAUSE: {
		theApp.downloadqueue->SetCatStatus(m_dlTab->GetSelection(),MP_PAUSE);
			break;
		}
	case MP_STOP : {
		theApp.downloadqueue->SetCatStatus(m_dlTab->GetSelection(),MP_STOP);
			break;
		}
	case MP_CANCEL:
		if (wxMessageBox(GetResString(IDS_CATEGORY_DELETE),GetResString(IDS_CONFIRMATION),
		wxYES_NO|wxCENTRE|wxICON_EXCLAMATION) == wxYES) {
			theApp.downloadqueue->SetCatStatus(m_dlTab->GetSelection(),MP_CANCEL);
		}
		break;
	case MP_RESUME: {
		theApp.downloadqueue->SetCatStatus(m_dlTab->GetSelection(),MP_RESUME);
			break;
		}
#if 0
	case MP_RESUMENEXT:
		theApp.downloadqueue->StartNextFile(m_dlTab->GetSelection());
		break;
#endif
	case IDC_UPLOAD_ICO: {
		wxCommandEvent nullEvt;
			SwitchUploadList(nullEvt);
			break;
		}
	case IDC_QUEUE_REFRESH_BUTTON: {
		//arning TODO: fix this
			//OnBnClickedQueueRefreshButton();
			break;
		}
	default: {
		return wxPanel::ProcessEvent(evt);
		}
	}
	return false;
}

int CTransferWnd::AddCategorie(CString newtitle,CString newincoming,CString newcomment,bool addTab) {
	Category_Struct* newcat=new Category_Struct;
	sprintf(newcat->title,"%s",newtitle.GetBuffer());
	newcat->prio=0;
	sprintf(newcat->incomingpath,"%s",newincoming.GetBuffer());
	sprintf(newcat->comment,"%s",newcomment.GetBuffer());
	int index=theApp.glob_prefs->AddCat(newcat);
	if (addTab) {
		//m_dlTab.InsertItem(index,newtitle);
		wxPanel* nullPanel=new wxPanel(m_dlTab,-1);
		m_dlTab->AddPage(nullPanel,newtitle);
	}
	return index;
}

void CTransferWnd::EditCatTabLabel(int index,CString newlabel) {
	//TCITEM tabitem;
	//tabitem.mask = TCIF_PARAM;
	//m_dlTab.GetItem(index,&tabitem);
	//tabitem.mask = TCIF_TEXT;
	if (theApp.glob_prefs->ShowCatTabInfos()) {
		CPartFile* cur_file;
		uint16 count,dwl;
		count=dwl=0;
		for (int i=0;i<theApp.downloadqueue->GetFileCount();i++) {
			cur_file=theApp.downloadqueue->GetFileByIndex(i);
			if (cur_file==0) continue;
			if (CheckShowItemInGivenCat(cur_file,index)) {
				count++;
				if (cur_file->GetTransferingSrcCount() >0) dwl++;
				//                              speed+=cur_file->GetDatarate()/1024.0f;
				//                              size+=cur_file->GetFileSize();
				//                              trsize+=cur_file->GetCompletedSize();
			}
		}
		CString title=newlabel;
		newlabel.Format("%s (%i/%i)",title.GetData(),dwl,count);
	}
	//tabitem.pszText = newlabel.LockBuffer();
	//m_dlTab.SetItem(index,&tabitem);
	//newlabel.UnlockBuffer();
	m_dlTab->SetPageText(index,newlabel);
}

void CTransferWnd::OnSashPositionChanged() {
	theApp.xmuledlg->split_pos = ((wxSplitterWindow*) FindWindow("splitterWnd"))->GetSashPosition();
}


