// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (donate@xmule.org / http://xmule.hopto.org/)
// RSA-1024 Fingerprint: 4145 9DFD 5338 4FCC 1636  86E5 2E5A 42D8 BA13 460B
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.xmule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include <wx/wx.h>
#include <wx/sckaddr.h>

#include <netdb.h>
#include <pthread.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "xmule.h"

#include "ClientCredits.h"
#include "NewFunctions.h"
#include "otherfunctions.h"

uint32 MapData(MAP *pos)
{
    return pos -> Data;
}

unsigned char *MapDataKey(MAP *pos)
{
    return pos -> Key;
}

void MapData_Init(MAP *&base)
{
    base = (MAP *) malloc(sizeof(MAP));
    base -> Key = NULL;
    base -> Data = 0;
    base -> next = base;
    base -> prev = base;
}

uint32 MapData_GetCount(MAP *base)
{
    return base -> Data;
}

void *MapData_GetIt(MAP *pos)
{
    if (pos)
    {
        return(void *) pos -> Data;
    }
    else
    {
        return(void *) NULL;
    }
}

MAP *MapData_Find(MAP *base, void *tofind, int length)
{
    MAP *found;
    found = base;
    while (length)
    {
        found = MapData_GetNext(found);
        if (found)
        {
            if (found -> Key)
            {
                if (!memcmp(found -> Key, tofind, length))
                {
                    length = 0;
                }
            }
            else
            {
                found = 0;
                length = 0;
            }
        }
        else
        {
            length = 0;
        }
    }
    return found;
}

MAP *MapData_GetNext(MAP *next)
{
    if (next)
    {
        next = next -> next;
        if (next -> Key == NULL)
        {
            next = NULL;
        }
    }
    else
    {
        next = NULL;
    }
    return next;
}

void MapData_Insert(MAP *base, void *data, unsigned char *key, int length)
{
    MAP *toinsert;
    toinsert = (MAP *) malloc(sizeof(MAP));
    toinsert -> Key = (unsigned char *) malloc(length);
    toinsert -> Data = (uint32) data;
    toinsert -> prev = base;
    toinsert -> next = base -> next;
    memcpy(toinsert -> Key, key, length);
    base -> next -> prev = toinsert;
    base -> next = toinsert;
    base -> Data++;
    //return toinsert;
}

MAP *MapData_Remove(MAP *base, MAP *todelete)
{
    MAP *next = NULL;
    if (base -> Data)
    {
        next = todelete -> next;
        free(todelete -> Key);
        todelete -> Key = NULL;
        todelete -> Data = 0;
        todelete -> prev -> next = next;
        next -> prev = todelete -> prev;
        todelete -> next = NULL;
        todelete -> prev = NULL;
        base -> Data--;
    }
    return next;
}

void MapData_RemoveAll(MAP *base)
{
    MAP *pos;
    pos = base;
    do
    {
        pos = MapData_GetNext(pos);
        if (pos)
        {
            if (pos -> Data)
            {
                pos = MapData_Remove(base, pos);
            }
        }
    }
    while (pos);
}

void Menu_AppendSubmenu(wxMenu *&wxmenu, wxMenu *submenu, const char *submenutitle)
{
    wxmenu -> Append(0, submenutitle, submenu, "");
}

void Menu_CreateCheckItem(void *wxscw, wxMenu *&wxmenu, int entry_id, const char *entry_name, wxObjectEventFunction jumpto)
{
    switch (entry_id)
    {
    case 0:
        wxmenu = new wxMenu(entry_name);
    case - 1:
        wxmenu -> AppendSeparator();
        break;
    case - 2:
        wxmenu -> Break();
        break;
    default:
        wxMenuItem *item;
        wxmenu -> AppendCheckItem(entry_id, entry_name, "");
        //item=FindItem
        if (wxscw != NULL)
        {
            ((wxScrolledWindow *) wxscw) -> Connect(entry_id, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) jumpto);
        }
        break;
    }
}

int Menu_Create(void *wxscw, wxMenu *&wxmenu, int base_id, wxString *infos, const char *resourcefilename, wxObjectEventFunction jumpto)
{
    unsigned char byte[2] =
    {
        0x00, 0x00
        };
    wxMenu *submenu;
    int enablesubmenu = 0;
    wxString line, part1, part2;
    long value;
    int entrycounter = 0;
    for (int i = 0 ; i < 256 ; i++)
    {
        infos[i] = "";
    }
    FILE *filepointer;
printf("try to open: %s ",resourcefilename);
    filepointer = fopen(resourcefilename, "r");
    if(filepointer==NULL) {
	printf("... not found\n");
      wxString fname01=getenv("HOME")+wxString("/.xMule/")+wxString(resourcefilename);
printf("try to open: %s ",(const char *)fname01);
      filepointer = fopen((const char *)fname01, "r");
	if(filepointer==NULL) {
	  printf("... not found -> copy 'resource'-directory from xmule/src to $HOME/.xMule/\n");
	} else {
	  printf("... ok\n");
	}
    } else {
        printf("... ok\n");
    }
    if (filepointer)
    {
        line = "";
        submenu = wxmenu;
        while (!feof(filepointer))
        {
            (void) fread( &byte, 1, 1, filepointer);
            switch (byte[0])
            {
            case 0: break;
            case '\r': break;
            case '\n':
                value = line.Find(",");
                if (value >= 0)
                {
                    if (value)
                    {
                        part1 = line.Mid(0, value);
                        part2 = line.Mid(value + 1);
                    }
                    else
                    {
                        part1 = "";
                        part2 = line.Mid(value + 1);
                    }
                    (void) part1.ToLong( &value);
                    switch (value)
                    {
                    case 0:
                        Menu_CreateCheckItem(NULL, submenu, 0, part2, NULL);
                        break;
                    case - 1:
                        Menu_CreateCheckItem(NULL, submenu, - 1, part2, NULL);
                        break;
                    case - 8:
                        wxmenu = submenu;
                        submenu = new wxMenu(part2);
                        Menu_AppendSubmenu(wxmenu, submenu, part2);
                        if (!enablesubmenu)
                        {
                            enablesubmenu++;
                        }
                        break;
                    case - 9:
                        if (enablesubmenu)
                        {
                            enablesubmenu = 0;
                        }
                        submenu = wxmenu;
                        break;
                    default:
                        if (value < 256)
                        {
                            entrycounter++;
                            if (part1.Len() > 1)
                            {
                                infos[value] = part1.Right(2) + wxString:: Format("%3d%s", base_id + entrycounter - 20000, (const char *) part2);
                            }
                            else
                            {
                                infos[value] = wxString:: Format("%5d%s", base_id + entrycounter, (const char *) part2);
                            }
                            Menu_CreateCheckItem(wxscw, submenu, base_id + entrycounter, part2, jumpto);
                            submenu -> Check(base_id + entrycounter, false);
                        }
                        else
                        {
                            Menu_CreateCheckItem(wxscw, submenu, value, part2, jumpto);
                            submenu -> Check(value, false);
                        }
                        break;
                    }
                }
                line = "";
                break;
            default:
                line += (wxChar) byte[0];
                break;
            }
        }
        (void) fclose(filepointer);
    }
    wxmenu = submenu;
    return entrycounter;
}

