// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (donate@xmule.org / http://xmule.hopto.org/)
// RSA-1024 Fingerprint: 4145 9DFD 5338 4FCC 1636  86E5 2E5A 42D8 BA13 460B
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.xmule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef _NEWFUNCTIONS
#define _NEWFUNCTIONS

#define		MAPCLIENTS_MAX		30000

typedef struct _MAP
{
	_MAP*	next;
	_MAP* 	prev;
	uint32 Data;
	unsigned char *Key;
}

MAP;

    uint32 MapData(MAP* pos);
    unsigned char *MapDataKey(MAP* pos);
    void MapData_Init(MAP *&base);
    MAP* MapData_Find(MAP* base,void *tofind, int length);
    uint32 MapData_GetCount(MAP *base);
    void *MapData_GetIt(MAP* pos);
    MAP* MapData_GetNext(MAP* next);
    void MapData_Insert(MAP *base,void *data, unsigned char *key, int length);
    MAP* MapData_Remove(MAP *base,uint32 todelete);
    void MapData_RemoveAll(MAP* base);
    void Menu_CreateCheckItem(void *wxscw, wxMenu *&wxmenu, int entry_id, const char *entry_name, wxObjectEventFunction jumpto);
    int Menu_Create(void *wxscw, wxMenu *&wxmenu, int base_id, wxString *infos, const char *resourcefilename, wxObjectEventFunction jumpto);

#endif
