// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (donate@xmule.org / http://xmule.hopto.org/)
// RSA-1024 Fingerprint: 4145 9DFD 5338 4FCC 1636  86E5 2E5A 42D8 BA13 460B
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.xmule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include <wx/wx.h>
#include <wx/sckaddr.h>

#include <netdb.h>
#include <pthread.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "xmule.h"
#include "UploadQueue.h"
#include "NewSockets.h"
#include "ClientUDPSocket.h"

int new_socketcount = 0;

wxUint32 new_ip[10000];

wxUint16 new_port[10000];

CClientUDPSocket *clientudp;

Packet *newsocket_packet;

CMemFile *newsocket_data;

extern int newprefs03_opt[];

extern wxString newprefs03info[];

extern int newprefs04_opt[];

extern wxString newprefs04info[];

void NewSocket_Start(wxUint8 type, wxUint32 ip, wxUint16 port)
{
    switch (type)
    {
    case 1:
        wxIPV4address addr;
        if (!ip)
        {
            addr.AnyAddress();
            addr.Service(port);
        }
        else
        {
            addr.AnyAddress();
            addr.Service(port);
        }
        clientudp = new CClientUDPSocket(addr);
        break;
    }
}

void NewSocket_Stop(wxUint8 type)
{
    switch (type)
    {
    case 1:
        clientudp -> Destroy();
        break;
    }
}

void NewSocket_SendPacketOP(wxUint8 type, wxUint8 opcode, Packet *packet, wxUint32 ip, wxUint32 port)
{
    packet -> opcode = opcode;
    NewSocket_SendPacket(type, packet, ip, port);
}

void NewSocket_SendPacketOPdata(wxUint8 type, wxUint8 opcode, CMemFile *data, wxUint32 ip, wxUint32 port)
{
    if (data == NULL)
    {
        newsocket_packet = new Packet(opcode, 0);
    }
    else
    {
        newsocket_packet = new Packet(data);
    }
    newsocket_packet -> opcode = opcode;
    NewSocket_SendPacket(type, newsocket_packet, ip, port);
}

void NewSocket_SendPacket(wxUint8 type, Packet *packet, wxUint32 ip, wxUint32 port)
{
    if (type)
    {
        long value;
        if (newprefs03info[packet -> opcode].Len() > 4)
        {
            newprefs03info[packet -> opcode].Mid(2, 3) .ToLong( &value);
            if ((value > 300) && (value < 400))
            {
                value -= 300;
            }
            else
            {
                value = 0;
            }
        }
        else
        {
            value = 0;
        }
        if (value)
        {
            if (newprefs03_opt[value])
            {
                switch (type)
                {
                case 0:
                    printf("_Send TCPcliBLOCK --> ");
                    break;
                case 1:
                    printf("_Send UDPcli      --> ");
                    break;
                case 2:
                    printf("_Send TCPcli      --> ");
                    break;
                case 4:
                    printf("_Send TCPcliSAVE  --> ");
                    break;
                default:
                    printf("_Send %02x          --> ", type);
                    break;
                }
                printf("OP_%s = %02x size=%d  ip:port=%08x:%d\n",
                (const char *)(newprefs03info[packet -> opcode].Mid(17)), packet -> opcode, packet -> size, port, ip);
            }
        }
        else
        {
            printf("NewSocket_SendPacket %02x --> OP_unknown = %02x size=%d  ip:port=%08x:%d\n",
            type, packet -> opcode, packet -> size, port, ip);
        }
    }
    else
    {
        //blockdata sended from uploadclient
    }
    switch (type)
    {
    case 0:
        switch (port)
        {
        case 0:
            theApp.uploadqueue -> AddUpDataOverheadOther(packet -> size);
            break;
        default:
            theApp.UpdateSentBytes(port);
            break;
        }
        (void)((CUpDownClient *) ip) -> socket -> SendPacket(packet, true, false);
        break;
    case 1:
        switch (packet -> opcode)
        {
        case OP_FILENOTFOUND:
        case OP_QUEUEFULL:
        case OP_REASKACK:
        case OP_REASKFILEPING:
            theApp.uploadqueue -> AddUpDataOverheadFileRequest(packet -> size);
            break;
        }
        clientudp -> SendPacket(packet, ip, port &0xffff);
        break;
    case 2:
        switch (packet -> opcode)
        {
        case OP_ACCEPTUPLOADREQ:
        case OP_CANCELTRANSFER:
        case OP_FILEREQUEST:
        case OP_HASHSETANSWER:
        case OP_HASHSETREQUEST:
        case OP_REQUESTPARTS:
        case OP_SETREQFILEID:
        case OP_STARTUPLOADREQ:
            theApp.uploadqueue -> AddUpDataOverheadFileRequest(packet -> size);
            break;
        case OP_REQUESTSOURCES:
            theApp.uploadqueue -> AddUpDataOverheadSourceExchange(packet -> size);
            break;
        case OP_ASKSHAREDDIRS:
        case OP_ASKSHAREDFILES:
            //case OP_EMULEINFO:==OP_HELLO
        case OP_EMULEINFOANSWER:
        case OP_HELLO:
        case OP_HELLOANSWER:
        case OP_PUBLICKEY:
        case OP_SECIDENTSTATE:
        case OP_SIGNATURE:
        default:
            theApp.uploadqueue -> AddUpDataOverheadOther(packet -> size);
            break;
        }
        (void)((CUpDownClient *) ip) -> socket -> SendPacket(packet, true, true);
        break;
    case 3:
        switch (port &0xff)
        {
        case OP_FILEREQUEST:
        case OP_SETREQFILEID:
            theApp.uploadqueue -> AddUpDataOverheadFileRequest(packet -> size);
            break;
        case OP_REQUESTSOURCES:
            theApp.uploadqueue -> AddUpDataOverheadSourceExchange(packet -> size);
            break;
        default:
            theApp.uploadqueue -> AddUpDataOverheadOther(packet -> size);
            break;
        }
        (void)((CEMSocket *) ip) -> SendPacket(packet, true, true);
        break;
    }
}

void NewSocket_DebugPP(void *client, uint8 opcode, long size, unsigned char *packet)
{
    long value;
    if (newprefs04info[opcode].Len() > 5)
    {
        newprefs04info[opcode].Mid(2, 3) .ToLong( &value);
        if ((value > 400) && (value < 500))
        {
            value -= 400;
            if (newprefs04_opt[value])
            {
                printf("NewSocket_ProcessPacket -> OP_%s = %02x size=%d  client=%u\n",
                (const char *)(newprefs04info[opcode].Mid(17)), opcode, size, (uint32) client);
            }
        }
        else
        {
            value = 0;
        }
    }
    else
    {
        value = 0;
    }
}

