// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (donate@xmule.org / http://xmule.hopto.org/)
// RSA-1024 Fingerprint: 4145 9DFD 5338 4FCC 1636  86E5 2E5A 42D8 BA13 460B
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.xmule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// ClientUDPSocket.cpp : implementation file
//

#ifdef PRECOMP
#	include "xmule-headers.h"
#else
#	include "ClientUDPSocket.h"
#	include "DownloadQueue.h"
#	include "opcodes.h"
#	include "Preferences.h"
#	include "SharedFileList.h"
#	include "UploadQueue.h"
#	include "xmule.h"
#	include "xmuleDlg.h"
#endif

#include <wx/socket.h>

#include <errno.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

// CClientUDPSocket
#define ID_SOKETTI 7772

IMPLEMENT_DYNAMIC_CLASS(CClientUDPSocket, wxDatagramSocket)
CClientUDPSocket:: CClientUDPSocket(wxIPV4address address)
: wxDatagramSocket(address, wxSOCKET_NOWAIT)
{
    m_bWouldBlock = false;
    SetEventHandler( *theApp.xmuledlg, ID_SOKETTI);
    SetNotify(wxSOCKET_INPUT_FLAG |wxSOCKET_OUTPUT_FLAG);
    Notify(TRUE);
}

CClientUDPSocket:: ~CClientUDPSocket()
{
    SetNotify(0);
    Notify(FALSE);
}

void CClientUDPSocket:: OnReceive(int nErrorCode)
{
    unsigned char buffer[5000];
    wxIPV4address addr;
    RecvFrom(addr, buffer, 5000);
    int32 length = LastCount();
    wxUint32 fromIP = GAddress_INET_GetHostAddress(addr.GetAddress());
    if ((buffer[0] == OP_EMULEPROT) && (length != ( - 1)))
    ProcessPacket(buffer + 2, length - 2, buffer[1], fromIP, addr.Service());
}

bool CClientUDPSocket:: ProcessPacket(unsigned char *packet, int16 size, wxUint8 opcode, wxUint32 hostip, uint16 port)
{
printf("====> CClientUDPSocket::ProcessPacket opcode=0x%02x size=%u\n",opcode,size);
    switch (opcode)
    {
    case OP_REASKFILEPING:
        {
            theApp.downloadqueue -> AddDownDataOverheadFileRequest(size);
            if (size != 16)
            {
                break;
            }
            CKnownFile *reqfile = theApp.sharedfiles -> GetFileByID((uchar *) packet);
            if (!reqfile)
            {
                Packet *response = new Packet(OP_FILENOTFOUND, 0, OP_EMULEPROT);
                NewSocket_SendPacketOP(1, OP_FILENOTFOUND, response, hostip, port);
                break;
            }
            CUpDownClient *sender = theApp.uploadqueue -> GetWaitingClientByIP(hostip);
            if (sender)
            {
                sender -> AddAskedCount();
                sender -> SetUDPPort(port);
                sender -> UDPFileReasked();
                break;
            }
            else
            {
                if (((uint32) theApp.uploadqueue -> GetWaitingUserCount() + 50) > theApp.glob_prefs -> GetQueueSize())
                {
                    Packet *response = new Packet(OP_QUEUEFULL, 0, OP_EMULEPROT);
                    NewSocket_SendPacketOP(1, OP_QUEUEFULL, response, hostip, port);
                }
            }
            break;
        }
    case OP_QUEUEFULL:
        {
            theApp.downloadqueue -> AddDownDataOverheadOther(size);
            CUpDownClient *sender = theApp.downloadqueue -> GetDownloadClientByIP(hostip);
            if (sender)
            {
                sender -> SetRemoteQueueFull(true);
                sender -> UDPReaskACK(0);
            }
            break;
        }
    case OP_REASKACK:
        {
            theApp.downloadqueue -> AddDownDataOverheadFileRequest(size);
            CUpDownClient *sender = theApp.downloadqueue -> GetDownloadClientByIP(hostip);
            if (sender)
            {
                if (size != 2)
                {
                    break;
                }
                uint16 nRank;
                memcpy( &nRank, packet, 2);
                sender -> SetRemoteQueueFull(false);
                sender -> UDPReaskACK(nRank);
                sender -> AddAskedCountDown();
            }
            break;
        }
    case OP_FILENOTFOUND:
        {
            theApp.downloadqueue -> AddDownDataOverheadFileRequest(size);
            CUpDownClient *sender = theApp.downloadqueue -> GetDownloadClientByIP(hostip);
            if (sender)
            {
                sender -> UDPReaskFNF();
            }
            break;
        }
    default:
        return false;
    }
    return true;
}

void CClientUDPSocket:: OnSend(int nErrorCode)
{
    if (nErrorCode)
    {
        return;
    }
    m_bWouldBlock = false;
    CTypedPtrList < CPtrList, UDPPack *> failed_packets;
    while (controlpacket_queue.GetHeadPosition() != 0 && !IsBusy())
    {
        UDPPack *cur_packet = controlpacket_queue.RemoveHead();
        char *sendbuffer = new char[cur_packet -> packet -> size + 2];
        memcpy(sendbuffer, cur_packet -> packet -> GetUDPHeader(), 2);
        memcpy(sendbuffer + 2, cur_packet -> packet -> pBuffer, cur_packet -> packet -> size);
        if (SendTo(sendbuffer, cur_packet -> packet -> size + 2, cur_packet -> dwIP, cur_packet -> nPort))
        {
            delete cur_packet -> packet;
            delete cur_packet;
        }
        else if(++cur_packet -> trial < 3)
        {
            failed_packets.AddTail(cur_packet);
        }
        else
        {
            delete cur_packet -> packet;
            delete cur_packet;
        }
        delete[] sendbuffer;
    }
    for (POSITION pos = failed_packets.GetHeadPosition() ; pos ;)
    {
        UDPPack *packet = failed_packets.GetNext(pos);
        controlpacket_queue.AddTail(packet);
    }
    failed_packets.RemoveAll();
}

bool CClientUDPSocket:: SendTo(char *lpBuf, int nBufLen, uint32 dwIP, uint16 nPort)
{
    if (Ok())
    {
        wxIPV4address *addr = new wxIPV4address();
        (void) GAddress_INET_SetPort(addr -> GetAddress(), nPort);
        (void) GAddress_INET_SetHostAddress(addr -> GetAddress(), dwIP);
#if defined(__DEBUG__)
        //printf("CClientUDPSocket::SendTo %s:%d\n", (const char *) addr -> IPAddress(), addr -> Service());
#endif
        wxDatagramSocket:: SendTo( *addr, lpBuf, nBufLen);
        delete addr;
    }
    else
    {
        return false;
    }
    if (Error())
    {
        uint32 error = LastError();
        if (error == wxSOCKET_WOULDBLOCK)
        {
            m_bWouldBlock = true;
            return false;
        }
        else
        {
            return false;
        }
    }
    return true;
}

bool CClientUDPSocket:: SendPacket(Packet *packet, uint32 dwIP, uint16 nPort)
{
//printf("CClientUDPSocket::SendPacket opcode=0x%02x size=%u\n",packet->opcode,packet->size);
    UDPPack *newpending = new UDPPack;
    newpending -> dwIP = dwIP;
    newpending -> nPort = nPort;
    newpending -> packet = packet;
    newpending -> trial = 0;
    if (IsBusy())
    {
        controlpacket_queue.AddTail(newpending);
    }
    else
    {
        char *sendbuffer = new char[packet -> size + 2];
        memcpy(sendbuffer, packet -> GetUDPHeader(), 2);
        memcpy(sendbuffer + 2, packet -> pBuffer, packet -> size);
        if (!SendTo(sendbuffer, packet -> size + 2, dwIP, nPort))
        {
            controlpacket_queue.AddTail(newpending);
        }
        else
        {
            delete newpending -> packet;
            delete newpending;
        }
        delete[] sendbuffer;
    }
    return true;
}

bool CClientUDPSocket:: Create()
{
    // constructor does dirty work
    return true;
    //if (theApp.glob_prefs->GetUDPPort())
    //	return CAsyncSocket::Create(theApp.glob_prefs->GetUDPPort(),SOCK_DGRAM,FD_READ);
    //else
    //	return true;
}

