// This file is a part of the xMule Project.
//
// Coded by uploaod & plaenky
//
// Copyright (c) 2004 Theodore R. Smith (donate@xmule.org / http://xmule.hopto.org/)
// RSA-1024 Fingerprint: 4145 9DFD 5338 4FCC 1636  86E5 2E5A 42D8 BA13 460B
//
// This file was a part of eMule
// Copyright (c) 2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifdef PRECOMP
#include "xmule-headers.h"
#endif

#include <wx/frame.h>
#include <wx/filedlg.h>           // Needed for wxFileDialog
#include <wx/msgdlg.h>            // Needed for wxMessageDialog
#include <wx/sizer.h>             // Needed for wxSizer
#include <wx/statbox.h>           // Needed for wxStaticBox
#include <wx/stattext.h>          // Needed for wxStaticText
#include "wx/xrc/xmlres.h"        // Needed for XRCID
#include <wx/textdlg.h>                     // Needed for wxTextEntryDialog
#include <wx/dirdlg.h>            // Needed for wxDirDialog
#include <wx/dialog.h>            // Needed for wxDialog

#include "xmule.h"
#include "FlowChart.h"            // Interface declarations.
#include "NewFunctions.h"
#include "xmuleDlg.h"             // Needed for CxmuleDlg
#include "DownloadQueue.h"        // Needed for CDownloadQueue
#include "otherfunctions.h"       // Needed for URLEncode
#include "packets.h"              // Needed for Packet
#include "server.h"               // Needed for CServer
#include "ServerList.h"           // Needed for CServerList
#include "sockets.h"              // Needed for CServerConnect
#include "Preferences.h"

#define	SDMOUSEEVT	(wxObjectEventFunction) (wxEventFunction) (wxMouseEventFunction) &CFlowChart
#define	SDPAINTEVT	(wxObjectEventFunction) (wxEventFunction) (wxPaintEventFunction) &CFlowChart
#define	SDTIMEREVT	(wxObjectEventFunction) (wxEventFunction) (wxTimerEventFunction) &CFlowChart

#define OLDPREF_STATCOL_MASKSTART     21104
#define OLDPREF_SHAREDDIRS_MASKSTART  21010
#define OLDPREF_SHAREDDIRS_LISTSIZE   10

wxUint16 infonumber = 0;

wxString info[256];

wxUint16 info_type[256];

wxUint16 info_x[256];

wxUint16 info_y[256];

wxUint16 info_width[256];

wxUint16 info_height[256];

wxUint32 info_ip[256];

wxUint16 info_port[256];

wxPen *info_pen[256];

wxBrush *info_brush[256];

wxColour *info_txtbgcolour[256];

wxColour *info_txtfgcolour[256];

wxMenu *pop_newprefs01;

wxMenu *pop_newprefs02;

wxMenu *pop_newprefs03;

wxMenu *pop_newprefs04;

wxMenu *pop_oldprefs01;

wxMenu *pop_oldprefs02;

wxMenu *pop_oldprefs03;

wxMenu *pop_oldprefs04;

wxMenu *pop_oldprefs05;

wxMenu *pop_oldprefs06;

wxMenu *pop_oldprefs07;

wxMenu *pop_oldprefs08;

wxMenu *pop_oldprefs09;

int newprefs01_opt[101];

wxString newprefs01info[256];

int newprefs02_opt[101];

int newprefs03_opt[101];

wxString newprefs03info[256];

int newprefs04_opt[101];

wxString newprefs04info[256];

int oldprefs01_opt[4];

int oldprefs02_opt[15];

int oldprefs03_opt[14];

int oldprefs04_opt[13];

int oldprefs05_opt[11];

int oldprefs06_opt[6];

int oldprefs07_opt[21];

int oldprefs08_opt[9];

int oldprefs09_opt[1];

wxColour *LIGHT_RED = new wxColour(0xe0, 0x90, 0x90);

wxColour *DARK_WHITE;

void SetPenBrushText(wxUint16 index, wxClientDC *dc, wxColour *pencolour, wxColour *brushcolour, wxColour *textbgcolour,
wxColour *textfgcolour, int style)
{
    if (info_pen[index] != NULL)
    {
        delete info_pen[index];
    }
    info_pen[index] = new wxPen( *pencolour, 1, style);
    if (info_brush[index] != NULL)
    {
        delete info_brush[index];
    }
    info_brush[index] = new wxBrush( *brushcolour, style);
    if (info_txtbgcolour[index] != NULL)
    {
        delete info_txtbgcolour[index];
    }
    info_txtbgcolour[index] = new wxColour( *textbgcolour);
    if (info_txtfgcolour[index] != NULL)
    {
        delete info_txtfgcolour[index];
    }
    info_txtfgcolour[index] = new wxColour( *textfgcolour);
}

void Load_NewPrefs01()
{
    for (int i = 0 ; i < 7 ; i++)
    {
	switch(i) {
	case 3:
	case 4:
        	newprefs01_opt[i] = 0;
		break;
	default:	
        	newprefs01_opt[i] = 1;
		break;
	}
    }
    unsigned char byte[2] =
    {
        0x00, 0x00
        };
    wxString newprefs01_filename = wxString:: Format("%s/.xMule/", getenv("HOME")) + wxT("newprefs01.dat");
    wxString line;
    FILE *newprefs01_fd;
    newprefs01_fd = fopen(newprefs01_filename, "r");
    if (newprefs01_fd == NULL)
    {
        newprefs01_fd = fopen(newprefs01_filename, "w");
        (void) fclose(newprefs01_fd);
        newprefs01_fd = fopen(newprefs01_filename, "r");
    }
    line = "";
    while (!feof(newprefs01_fd))
    {
        (void) fread( &byte, 1, 1, newprefs01_fd);
        line += (wxChar) byte[0];
    }
    for (int i = 0 ; i < 7 ; i++)
    {
        if (i *4 <= line.Len())
        {
            memcpy( &newprefs01_opt[i], ((const char *) line) + i *4, 4);
        }
    }
    (void) fclose(newprefs01_fd);
}

void Save_NewPrefs01()
{
    FILE *newprefs01_fd;
    wxString line;
    wxString newprefs01_filename = wxString:: Format("%s/.xMule/", getenv("HOME")) + wxT("newprefs01.dat");
    newprefs01_fd = fopen(newprefs01_filename, "w");
    if (newprefs01_fd != NULL)
    {
        line = "";
        for (int i = 0 ; i < 7 ; i++)
        {
            line += "    ";
            memcpy((void *)(((const char *) line) + i *4), &newprefs01_opt[i], 4);
        }
        (void) fwrite(((const char *) line), 1, line.Len(), newprefs01_fd);
        (void) fclose(newprefs01_fd);
    }
}

CFlowChart:: CFlowChart(wxWindow *pParent): wxScrolledWindow(pParent, IDD, wxDefaultPosition, wxDefaultSize,
wxHSCROLL |wxVSCROLL |wxNO_FULL_REPAINT_ON_RESIZE)
{
    Init();
}

void CFlowChart::Init()
{
#define WXOBEF	(wxObjectEventFunction)&CFlowChart
    for (int i = 1 ; i <= 100 ; i++)
    {
        newprefs01_opt[i] = 0;
        newprefs03_opt[i] = 0;
        newprefs04_opt[i] = 0;
    }
    //Save_NewPrefs01();
    DARK_WHITE = new wxColour(0xef, 0xef, 0xef);
    Load_NewPrefs01();
    ReadOldPrefs();
    newprefs01_opt[0] = Menu_Create(this, pop_newprefs01, 20100, newprefs01info, "resource/newprefs01.pm", WXOBEF:: np01_CommandEvent);
    pop_newprefs02 = new wxMenu("Debugmodes | To test");
    pop_newprefs02 -> AppendSeparator();
    pop_newprefs02 -> AppendCheckItem(20201, "OP_FILEREQUEST for extended Versions (If checked, eMule 0.42+ will leech from you!)", "");
    newprefs03_opt[0] = Menu_Create(this, pop_newprefs03, 20300, newprefs03info, "resource/newprefs03.pm", WXOBEF:: np03_CommandEvent);
    //newprefs03_opt[0]+= Menu_Create(this, pop_newprefs03b, 20330, newprefs03info, "resource/newprefs03.pm", WXOBEF:: np03_CommandEvent);
    newprefs04_opt[0] = Menu_Create(this, pop_newprefs04, 20400, newprefs04info, "resource/newprefs04.pm", WXOBEF:: np04_CommandEvent);
    //newprefs04_opt[0]+= Menu_Create(this, pop_newprefs04b, 20430, newprefs04info, "resource/newprefs04.pm", WXOBEF:: np04_CommandEvent);
    //Old Prefs
    pop_oldprefs01 = new wxMenu("Old Preferences");
    pop_oldprefs01 -> AppendCheckItem(20501, "Use Preferences", "");
    pop_oldprefs01 -> AppendCheckItem(20502, "User Mode", "");
    oldprefs01_opt[2] = 1;
    pop_oldprefs01 -> Check(20502, true);
    pop_oldprefs01 -> Append(20503, "Save Preferences", "");
    pop_oldprefs02 = new wxMenu("General");
    pop_oldprefs02 -> AppendCheckItem(20601, "Beep on Errors", "");
    pop_oldprefs02 -> AppendCheckItem(20602, "Bring to front on Link click", "");
    pop_oldprefs02 -> AppendCheckItem(20603, "Downloadlist doubleclick to expand", "");
    pop_oldprefs02 -> AppendCheckItem(20604, "Minimize to trayicon", "");
    pop_oldprefs02 -> AppendCheckItem(20605, "Enable OnlineSig", "");
    pop_oldprefs02 -> AppendCheckItem(20606, "Confirm Exit", "");
    pop_oldprefs02 -> AppendCheckItem(20607, "Start -> Check Version", "");
    pop_oldprefs02 -> AppendCheckItem(20608, "Start -> Show Splash Screen", "");
    pop_oldprefs02 -> AppendCheckItem(20609, "Start -> Minimized", "");
    pop_oldprefs02 -> AppendSeparator();
    pop_oldprefs02 -> Append(20610, "Nick:", "");
    pop_oldprefs02 -> Append(20611, "Tooltip Delay Time:", "");
    pop_oldprefs02 -> Append(20612, "Days between Update-Check:", "");
    pop_oldprefs02 -> Append(20613, "Progress Bar Style:", "");
    pop_oldprefs03 = new wxMenu("Connection");
    pop_oldprefs03 -> AppendCheckItem(20701, "Autoconnect on Startup", "");
    pop_oldprefs03 -> AppendCheckItem(20702, "Reconnect on loss", "");
    pop_oldprefs03 -> AppendCheckItem(20703, "Show Overhead Bandwidth", "");
    pop_oldprefs03 -> AppendCheckItem(20704, "Disable UDP Port", "");
    pop_oldprefs03 -> AppendSeparator();
    pop_oldprefs03 -> Append(20705, "Download Capacitie:", "");
    pop_oldprefs03 -> Append(20706, "Upload Capacitie:", "");
    pop_oldprefs03 -> Append(20707, "Download Limit:", "");
    pop_oldprefs03 -> Append(20708, "Upload Limit:", "");
    pop_oldprefs03 -> Append(20709, "Client-Port:", "");
    pop_oldprefs03 -> Append(20710, "UDP-Port:", "");
    pop_oldprefs03 -> Append(20711, "Hard Limit:", "");
    pop_oldprefs03 -> Append(20712, "Maximum Connections:", "");
    pop_oldprefs04 = new wxMenu("Server");
    pop_oldprefs04 -> AppendCheckItem(20801, "Remove Dead Server", "");
    pop_oldprefs04 -> AppendCheckItem(20802, "Always filter bad Server IPs", "");
    pop_oldprefs04 -> AppendCheckItem(20803, "Auto-Update Serverlist at startup", "");
    pop_oldprefs04 -> AppendCheckItem(20804, "Update Serverlist from Servers", "");
    pop_oldprefs04 -> AppendCheckItem(20805, "Update Serverlist from clients", "");
    pop_oldprefs04 -> AppendCheckItem(20806, "Use Priority System", "");
    pop_oldprefs04 -> AppendCheckItem(20807, "Use Smart LowID Check on connect", "");
    pop_oldprefs04 -> AppendCheckItem(20808, "Safe Connect", "");
    pop_oldprefs04 -> AppendCheckItem(20809, "Autoconnect Static-List Server only", "");
    pop_oldprefs04 -> AppendCheckItem(20810, "Set mannualy added Server to high priority", "");
    pop_oldprefs04 -> AppendSeparator();
    pop_oldprefs04 -> Append(20811, "Retrys before Dead Server Remove:", "");
    pop_oldprefs05 = new wxMenu("Files");
    pop_oldprefs05 -> AppendRadioItem(20901, "Everybody - See my Share", "");
    pop_oldprefs05 -> AppendRadioItem(20902, "Friends - See my Share", "");
    pop_oldprefs05 -> AppendRadioItem(20903, "No One - See my Share", "");
    pop_oldprefs05 -> AppendSeparator();
    pop_oldprefs05 -> AppendCheckItem(20904, "Intelligent Coruption Handling Enabled", "");
    pop_oldprefs05 -> AppendCheckItem(20905, "Add files to download in paused mode", "");
    pop_oldprefs05 -> AppendCheckItem(20906, "Try to download first and last Chunks first", "");
    pop_oldprefs05 -> AppendCheckItem(20907, "Add new shared Files with auto priority", "");
    pop_oldprefs05 -> AppendCheckItem(20908, "Try to transfer full chunks to all uploads", "");
    pop_oldprefs05 -> AppendCheckItem(20909, "Start next paused File, when a file completes", "");
    pop_oldprefs06 = new wxMenu("Directories");
    pop_oldprefs06 -> AppendCheckItem(21001, "Create Backup for Video Preview", "");
    pop_oldprefs06 -> AppendSeparator();
    pop_oldprefs06 -> Append(21002, "Video Player (empty=standard) :", "");
    pop_oldprefs06 -> Append(21003, "Incoming Dir:", "");
    pop_oldprefs06 -> Append(21004, "Temp Dir:", "");
    pop_oldprefs06 -> AppendSeparator();
    pop_oldprefs06 -> Append(21005, "Share Folder", "");
    pop_oldprefs07 = new wxMenu("Statistics");
    pop_oldprefs07 -> Append(21101, "Graph's update delay:", "");
    pop_oldprefs07 -> Append(21102, "Time for average Graph:", "");
    pop_oldprefs07 -> Append(21103, "Statistic Tree Update Delay:", "");
    pop_oldprefs07 -> AppendSeparator();
    for (int i = OLDPREF_STATCOL_MASKSTART ; i < OLDPREF_STATCOL_MASKSTART + 16 ;++i)
    {
        pop_oldprefs07 -> Append(i, "...", "");
    }
    pop_oldprefs08 = new wxMenu("Tweaks");
    pop_oldprefs08 -> AppendCheckItem(21201, "Verbose (Aditional Program Feedback)", "");
    pop_oldprefs08 -> AppendCheckItem(21202, "Autotake ED2K Links only during runtime", "");
    pop_oldprefs08 -> AppendCheckItem(21203, "Don't update Queuelist in realtime", "");
    pop_oldprefs08 -> AppendCheckItem(21204, "Show transfer Rates on titel", "");
    pop_oldprefs08 -> AppendSeparator();
    pop_oldprefs08 -> Append(21205, "Max. Connections per 5 sec:", "");
    pop_oldprefs08 -> Append(21206, "File Buffer Size:", "");
    pop_oldprefs08 -> Append(21207, "Upload-Queue Size:", "");
    pop_oldprefs09 = new wxMenu("Sources Dropping");
    for (int i = 1 ; i < 7 ; i++)
    {
        if (newprefs01_opt[i])
        {
            pop_newprefs01 -> Check(20100 + i, true);
        }
        else
        {
            pop_newprefs01 -> Check(20100 + i, false);
        }
    }
    for (int i = 1 ; i < 2 ; i++)
    {
        if (newprefs02_opt[i])
        {
            pop_newprefs02 -> Check(20200 + i, true);
        }
        else
        {
            pop_newprefs02 -> Check(20200 + i, false);
        }
    }
    SetScrollbars(4, 4, 400, 300);
    wxBoxSizer *root = new wxBoxSizer(wxVERTICAL);
    this -> SetAutoLayout(TRUE);
    this -> SetSizer(root);
    root -> Fit(this);
    root -> SetSizeHints(this);
    root -> Show(this, TRUE);
    Connect( - 1, wxEVT_MOTION, SDMOUSEEVT:: OnMouseMove);
    Connect( - 1, wxEVT_PAINT, SDPAINTEVT:: OnPaint);
    Connect(10001, wxEVT_TIMER, SDTIMEREVT:: OnTimer);
    Connect(20201, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: np02_OPfilerequest);
    Connect(20501, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op01_Use_eMule_file_Switch);
    Connect(20502, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op01_User_Mode);
    Connect(20503, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op01_Write_eMule_file);
    Connect(20601, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op02_Beep_on_Errors);
    Connect(20602, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op02_Bring_on_Front);
    Connect(20603, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op02_Downl_Doubleclick);
    Connect(20604, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op02_Minimize_Trayicon);
    Connect(20605, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op02_Enable_OnlineSig);
    Connect(20606, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op02_Confirm_Exit);
    Connect(20607, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op02_Start_CheckVersion);
    Connect(20608, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op02_Start_Splashscreen);
    Connect(20609, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op02_Start_Minimized);
    Connect(20610, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op02_Nick);
    Connect(20611, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op02_ToolTipDelay);
    Connect(20612, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op02_Update_Days);
    Connect(20613, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op02_Progress_Bar_Style);
    Connect(20701, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op03_Autoconnect);
    Connect(20702, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op03_Reconnect);
    Connect(20703, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op03_Show_Overhead);
    Connect(20704, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op03_Disable_UDP);
    Connect(20705, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op03_Download_Capacitie);
    Connect(20706, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op03_Upload_Capacitie);
    Connect(20707, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op03_Download_Limit);
    Connect(20708, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op03_Upload_Limit);
    Connect(20709, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op03_Client_Port);
    Connect(20710, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op03_UDP_Port);
    Connect(20711, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op03_Hard_Limit);
    Connect(20712, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op03_Max_Connection);
    Connect(20801, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op04_Remove_Dead_Server);
    Connect(20802, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op04_Filter_Server_IP);
    Connect(20803, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op04_Serverlist_Startup);
    Connect(20804, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op04_Serverlist_Server);
    Connect(20805, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op04_Serverlist_Clients);
    Connect(20806, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op04_Use_Priority_System);
    Connect(20807, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op04_Use_Smart_LowID_Check);
    Connect(20808, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op04_Safe_Connect);
    Connect(20809, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op04_Connect_Static_List_only);
    Connect(20810, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op04_Manually_Server_High_prio);
    Connect(20811, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op04_Dead_Server_Retrys);
    Connect(20901, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op05_See_Share_Everybody);
    Connect(20902, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op05_See_Share_Friends);
    Connect(20903, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op05_See_Share_Noone);
    Connect(20904, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op05_ICH_Enabled);
    Connect(20905, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op05_Add_Files_Paused);
    Connect(20906, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op05_Preview_Prio);
    Connect(20907, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op05_Add_With_Auto_Priority);
    Connect(20908, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op05_Transfer_Full_Chunks);
    Connect(20909, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op05_Start_Next_File);
    Connect(21001, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op06_Backup_Video_Preview);
    Connect(21002, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op06_Video_Player);
    Connect(21003, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op06_Incomming_Dir);
    Connect(21004, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op06_Temp_Dir);
    Connect(21005, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op06_Share_Folder);
    Connect(21101, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op07_Graph_Update_Delay);
    Connect(21102, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op07_Time_Average_Graph);
    Connect(21103, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op07_Statistic_Update_Delay);
    Connect(OLDPREF_STATCOL_MASKSTART, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op07_Color_00);
    Connect(OLDPREF_STATCOL_MASKSTART + 1, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op07_Color_01);
    Connect(OLDPREF_STATCOL_MASKSTART + 2, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op07_Color_02);
    Connect(OLDPREF_STATCOL_MASKSTART + 3, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op07_Color_03);
    Connect(OLDPREF_STATCOL_MASKSTART + 4, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op07_Color_04);
    Connect(OLDPREF_STATCOL_MASKSTART + 5, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op07_Color_05);
    Connect(OLDPREF_STATCOL_MASKSTART + 6, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op07_Color_06);
    Connect(OLDPREF_STATCOL_MASKSTART + 7, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op07_Color_07);
    Connect(OLDPREF_STATCOL_MASKSTART + 8, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op07_Color_08);
    Connect(OLDPREF_STATCOL_MASKSTART + 9, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op07_Color_09);
    Connect(OLDPREF_STATCOL_MASKSTART + 10, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op07_Color_10);
    Connect(OLDPREF_STATCOL_MASKSTART + 11, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op07_Color_11);
    Connect(OLDPREF_STATCOL_MASKSTART + 12, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op07_Color_12);
    Connect(OLDPREF_STATCOL_MASKSTART + 13, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op07_Color_13);
    Connect(OLDPREF_STATCOL_MASKSTART + 14, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op07_Color_14);
    Connect(OLDPREF_STATCOL_MASKSTART + 15, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op07_Color_15);
    Connect(21201, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op08_Verbose);
    Connect(21202, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op08_ED2K_Only_Runtime);
    Connect(21203, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op08_Queuelist_Realtime);
    Connect(21204, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op08_Show_Transfer_Titel);
    Connect(21205, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op08_Max_Con_5Sec);
    Connect(21206, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op08_File_Buffer_Size);
    Connect(21207, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op08_Queue_Size);
    Connect(wxID_ANY, wxEVT_RIGHT_DOWN, SDMOUSEEVT:: Popup_NewPrefs);
    lastindex = 0;
    lastsocketnumber = 0;
    for (int i = 0 ; i < 256 ; i++)
    {
        info[i] = "";
        info_type[i] = 0;
        info_pen[i] = NULL;
        info_brush[i] = NULL;
        info_txtbgcolour[i] = NULL;
        info_txtfgcolour[i] = NULL;
    }
    infonumber = 0;
    Sync(0, 129, 0, 0, NULL);
    Sync(0, 130, 0, 0, NULL);
    Sync(0, 131, 0, 0, NULL);
    Sync(0, 132, 0, 0, NULL);
    Sync(0, 192, 0, 0, NULL);
    Sync(0, 193, 0, 0, NULL);
    Sync(0, 194, 0, 0, NULL);
    Sync(0, 195, 0, 0, NULL);
    Sync(0, 196, 0, 0, NULL);
    Sync(0, 197, 0, 0, NULL);
    Sync(0, 198, 0, 0, NULL);
    Sync(0, 199, 0, 0, NULL);
#if 0 //TODO Sourec Droping Button
    Sync(0, 200, 0, 0, NULL);
#endif
}

CFlowChart:: ~CFlowChart()
{
}

void CFlowChart:: Popup_NewPrefs(wxMouseEvent &event)
{
    wxPoint position = event.GetPosition();
    wxString output;
    long x, y;
    wxClientDC dc(this);
    PrepareDC(dc);
    x = dc.DeviceToLogicalX(position.x);
    y = dc.DeviceToLogicalY(position.y);
    if (y > 8 &&y < 34)
    {
        if (x > 25 &&x < 120)
        {
            PopupMenu(pop_oldprefs01, event.GetPosition());
        }
        else if(x > 132 &&x < 186 &&oldprefs01_opt[1])
        {
            PopupMenu(pop_oldprefs02, event.GetPosition());
        }
        else if(x > 198 &&x < 273 &&oldprefs01_opt[1])
        {
            PopupMenu(pop_oldprefs03, event.GetPosition());
        }
        else if(x > 284 &&x < 330 &&oldprefs01_opt[1])
        {
            PopupMenu(pop_oldprefs04, event.GetPosition());
        }
        else if(x > 342 &&x < 378 &&oldprefs01_opt[1])
        {
            PopupMenu(pop_oldprefs05, event.GetPosition());
        }
        else if(x > 390 &&x < 460 &&oldprefs01_opt[1])
        {
            PopupMenu(pop_oldprefs06, event.GetPosition());
        }
        else if(x > 472 &&x < 530 &&oldprefs01_opt[1])
        {
            PopupMenu(pop_oldprefs07, event.GetPosition());
        }
        else if(x > 542 &&x < 594 &&oldprefs01_opt[1])
        {
            PopupMenu(pop_oldprefs08, event.GetPosition());
        }
#if 0 //TODO Source Dropping Button
        else if(x > 606 &&x < 718 &&oldprefs01_opt[1])
        {
            PopupMenu(pop_oldprefs09, event.GetPosition());
        }
#endif
    }
    if (y > 40 &&y < 66)
    {
        if (x > 25 &&x < 130)
        {
            PopupMenu(pop_newprefs01, event.GetPosition());
        }
        else if(x > 141 &&x < 236)
        {
            PopupMenu(pop_newprefs02, event.GetPosition());
        }
        else if(x > 249 &&x < 392)
        {
            PopupMenu(pop_newprefs03, event.GetPosition());
        }
        else if(x > 405 &&x < 543)
        {
            PopupMenu(pop_newprefs04, event.GetPosition());
        }
    }
}

void CFlowChart:: np01_CommandEvent(wxCommandEvent &event)
{
    int eventid = event.GetId();
    if((eventid > 20100) && (eventid < 20110))
    {
        bool value = pop_newprefs01->IsChecked(eventid);
        if (wxMessageBox("This should only be set if you know what you are doing.\nIs it true that you don't know what you are doing?", "Warning", wxICON_WARNING | wxYES_NO) == wxYES)
        {
            pop_newprefs01->Check(eventid, !value);
            return;
        }
        if (value)
        {
            newprefs01_opt[eventid - 20100] = 1;
        }
    }
//printf(" newprefs01 %d: => %u\n",eventid,newprefs01_opt[eventid-20100]);
    Save_NewPrefs01();
}

void CFlowChart:: np02_OPfilerequest(wxCommandEvent &event)
{
    if (pop_newprefs02 -> IsChecked(20201))
    {
        newprefs02_opt[1] = 1;
    }
    else
    {
        newprefs02_opt[1] = 0;
    }
}

void CFlowChart:: np03_CommandEvent(wxCommandEvent &event)
{
    int evtid = event.GetId();
    switch (evtid)
    {
    case 20398:
        for (int i = 1 ; i <= newprefs03_opt[0] ; i++)
        {
            newprefs03_opt[i] = 1;
            pop_newprefs03 -> Check(20300 + i, true);
        }
        newprefs03_opt[98] = 1;
        newprefs03_opt[99] = 0;
        pop_newprefs03 -> Check(20399, false);
        break;
    case 20399:
        for (int i = 1 ; i <= newprefs03_opt[0] ; i++)
        {
            newprefs03_opt[i] = 0;
            pop_newprefs03 -> Check(20300 + i, false);
        }
        newprefs03_opt[98] = 0;
        newprefs03_opt[99] = 1;
        pop_newprefs03 -> Check(20398, false);
        break;
    default:
        if ((evtid > 20300) && (evtid <= newprefs03_opt[0]))
        {
            if (pop_newprefs03 -> IsChecked(evtid))
            {
                newprefs03_opt[evtid - 20300] = 1;
            }
            else
            {
                newprefs03_opt[evtid - 20300] = 0;
            }
        }
        break;
    }
//printf(" newprefs03 %d: => %u\n",evtid,newprefs03_opt[evtid-20300]);
}

void CFlowChart:: np04_CommandEvent(wxCommandEvent &event)
{
    int evtid = event.GetId();
    switch (evtid)
    {
    case 20498:
        for (int i = 1 ; i <= newprefs04_opt[0] ; i++)
        {
            newprefs04_opt[i] = 1;
            pop_newprefs04 -> Check(20400 + i, true);
        }
        newprefs04_opt[98] = 1;
        newprefs04_opt[99] = 0;
        pop_newprefs04 -> Check(20499, false);
        break;
    case 20499:
        for (int i = 1 ; i <= newprefs04_opt[0] ; i++)
        {
            newprefs04_opt[i] = 0;
            pop_newprefs04 -> Check(20400 + i, false);
        }
        newprefs04_opt[98] = 0;
        newprefs04_opt[99] = 1;
        pop_newprefs04 -> Check(20498, false);
        break;
    default:
        if ((evtid > 20400) && (evtid <= newprefs04_opt[0]))
        {
            if (pop_newprefs04 -> IsChecked(evtid))
            {
                newprefs04_opt[evtid - 20400] = 1;
            }
            else
            {
                newprefs04_opt[evtid - 20400] = 0;
            }
        }
        break;
    }
//printf(" newprefs04 %d: => %u\n",evtid,newprefs04_opt[evtid-20400]);
}

void CFlowChart:: op01_Use_eMule_file_Switch(wxCommandEvent &evt)
{
    wxClientDC dc(this);
    if (pop_oldprefs01 -> IsChecked(20501))
    {
        oldprefs01_opt[1] = 1;
        // Set Old Prefs Buttons to Black Color
        for (int i = 193 ; i < 201 ;++i)
        {
            SetPenBrushText(i, &dc, wxBLACK, wxLIGHT_GREY, wxLIGHT_GREY, wxBLACK, wxSOLID);
        }
        // Draw Old Prefs Buttons
        for (int i = 193 ; i < 201 ;++i)
        {
            ShowEntry(i, &dc);
        }
        ReadOldPrefs();
    }
    else
    {
        // Set Old Prefs Buttons to Red Color
        for (int i = 193 ; i < 201 ;++i)
        {
            SetPenBrushText(i, &dc, wxRED, LIGHT_RED, LIGHT_RED, wxRED, wxSOLID);
        }
        // Draw Old Prefs Buttons
        for (int i = 193 ; i < 201 ;++i)
        {
            ShowEntry(i, &dc);
        }
        // Save Old Prefs to make it UserSafe :)
        WriteOldPrefs();
        oldprefs01_opt[1] = 0;
    }
    Save_NewPrefs01();
}

void CFlowChart:: op01_User_Mode(wxCommandEvent &evt)
{
    if (pop_oldprefs01 -> IsChecked(20502))
    {
        oldprefs01_opt[2] = 1;
    }
    else
    {
        oldprefs01_opt[2] = 0;
        wxMessageDialog dialog(this, _T("It's not recommed to switch off the User-Mode"), _T("Warning"), wxOK |wxICON_INFORMATION);
        switch (dialog.ShowModal())
        {
        default: break;
        }
    }
}

void CFlowChart:: op01_Write_eMule_file(wxCommandEvent &evt)
{
    if (oldprefs01_opt[1])
    {
        WriteOldPrefs();
    }
}

void CFlowChart:: op02_Beep_on_Errors(wxCommandEvent &evt)
{
    if (pop_oldprefs02 -> IsChecked(20601))
    {
        oldprefs02_opt[1] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetErrorBeepEnabled(1);
        }
    }
    else
    {
        oldprefs02_opt[1] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetErrorBeepEnabled(0);
        }
    }
}

void CFlowChart:: op02_Bring_on_Front(wxCommandEvent &evt)
{
    if (pop_oldprefs02 -> IsChecked(20602))
    {
        oldprefs02_opt[2] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetBringToFront(1);
        }
    }
    else
    {
        oldprefs02_opt[2] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetBringToFront(0);
        }
    }
}

void CFlowChart:: op02_Downl_Doubleclick(wxCommandEvent &evt)
{
    if (pop_oldprefs02 -> IsChecked(20603))
    {
        oldprefs02_opt[3] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetDoubleClickEnabled(1);
        }
    }
    else
    {
        oldprefs02_opt[3] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetDoubleClickEnabled(0);
        }
    }
}

void CFlowChart:: op02_Minimize_Trayicon(wxCommandEvent &evt)
{
    if (pop_oldprefs02 -> IsChecked(20604))
    {
        oldprefs02_opt[4] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetMinToTray(1);
        }
    }
    else
    {
        oldprefs02_opt[4] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetMinToTray(0);
        }
    }
}

void CFlowChart:: op02_Enable_OnlineSig(wxCommandEvent &evt)
{
    if (pop_oldprefs02 -> IsChecked(20605))
    {
        oldprefs02_opt[5] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetOnlineSignatureEnabled(1);
        }
    }
    else
    {
        oldprefs02_opt[5] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetOnlineSignatureEnabled(0);
        }
    }
}

void CFlowChart:: op02_Confirm_Exit(wxCommandEvent &evt)
{
    if (pop_oldprefs02 -> IsChecked(20606))
    {
        oldprefs02_opt[6] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetConfirmExitEnabled(1);
        }
    }
    else
    {
        oldprefs02_opt[6] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetConfirmExitEnabled(0);
        }
    }
}

void CFlowChart:: op02_Start_CheckVersion(wxCommandEvent &evt)
{
    if (pop_oldprefs02 -> IsChecked(20607))
    {
        oldprefs02_opt[7] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetUpdateNotify(1);
        }
    }
    else
    {
        oldprefs02_opt[7] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetUpdateNotify(0);
        }
    }
}

void CFlowChart:: op02_Start_Splashscreen(wxCommandEvent &evt)
{
    if (pop_oldprefs02 -> IsChecked(20608))
    {
        oldprefs02_opt[8] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetSplashScreen(1);
        }
    }
    else
    {
        oldprefs02_opt[8] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetSplashScreen(0);
        }
    }
}

void CFlowChart:: op02_Start_Minimized(wxCommandEvent &evt)
{
    if (pop_oldprefs02 -> IsChecked(20609))
    {
        oldprefs02_opt[9] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetStartMinimized(1);
        }
    }
    else
    {
        oldprefs02_opt[9] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetStartMinimized(0);
        }
    }
}

void CFlowChart:: op02_Nick(wxCommandEvent &evt)
{
    CString nick;
    wxString old_value;
    old_value.Printf("%s", theApp.glob_prefs -> GetUserNick());
    wxTextEntryDialog textbox((wxWindow *) this, _T("Nick for the client"), _T("Nick"), old_value, wxOK | wxCANCEL);
    if (textbox.ShowModal() == wxID_OK)
    {
        if (textbox.GetValue() .Len())
        {
            nick = textbox.GetValue();
        }
        else
        {
            nick = "xMule";
        }
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetUserNick(nick);
            op02_SetOldPrefs();
        }
    }
}

void CFlowChart:: op02_ToolTipDelay(wxCommandEvent &evt)
{
    long int delay;
    wxString old_value;
    old_value.Printf("%d", theApp.glob_prefs -> GetToolTipDelay());
    wxTextEntryDialog textbox((wxWindow *) this, _T("Tool Tip Delay (Seconds).[1-32]"), _T("Tool Tip Delay"), old_value, wxOK | wxCANCEL);
    if (textbox.ShowModal() == wxID_OK)
    {
        if (textbox.GetValue() .Len())
        {
            wxString result = textbox.GetValue();
            result.ToLong( &delay);
        }
        else
        {
            delay = 1;
        }
        if (delay < 0)
        {
            delay = 0;
        }
        else if(delay > 32)
        {
            delay = 32;
        }
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetToolTipDelay((uint8) delay);
            op02_SetOldPrefs();
        }
    }
}

void CFlowChart:: op02_Update_Days(wxCommandEvent &evt)
{
    long int days;
    wxString old_value;
    old_value.Printf("%d", theApp.glob_prefs -> GetUpdateDays());
    wxTextEntryDialog textbox((wxWindow *) this, _T("Days between update check.[2-7]"), _T("Update Days"), old_value, wxOK | wxCANCEL);
    if (textbox.ShowModal() == wxID_OK)
    {
        if (textbox.GetValue() .Len())
        {
            wxString result = textbox.GetValue();
            result.ToLong( &days);
        }
        else
        {
            days = 7;
        }
        if (days < 2)
        {
            days = 2;
        }
        else if(days > 7)
        {
            days = 7;
        }
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetUpdateDays((uint8) days);
            op02_SetOldPrefs();
        }
    }
}

void CFlowChart:: op02_Progress_Bar_Style(wxCommandEvent &evt)
{
    long int style;
    wxString old_value;
    old_value.Printf("%d", theApp.glob_prefs -> GetFlatBarStyle());
    wxTextEntryDialog textbox((wxWindow *) this, _T("Style of the Progress Bar:[0=Flat - 5=3D]"), _T("Progress Bar Style"), old_value, wxOK | wxCANCEL);
    if (textbox.ShowModal() == wxID_OK)
    {
        if (textbox.GetValue() .Len())
        {
            wxString result = textbox.GetValue();
            result.ToLong( &style);
        }
        else
        {
            style = 5;
        }
        if (style < 0)
        {
            style = 0;
        }
        else if(style > 5)
        {
            style = 5;
        }
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetFlatBarStyle((uint8) style);
            op02_SetOldPrefs();
        }
    }
}

void CFlowChart:: op02_SetOldPrefs(void)
{
    wxString str_buffer;
    // Beep on Errors
    oldprefs02_opt[1] = theApp.glob_prefs -> IsErrorBeepEnabled();
    if (oldprefs02_opt[1] == 1)
    {
        pop_oldprefs02 -> Check(20601, true);
    }
    else
    {
        pop_oldprefs02 -> Check(20601, false);
    }
    // On Front when Link click
    oldprefs02_opt[2] = theApp.glob_prefs -> IsBringToFront();
    if (oldprefs02_opt[2] == 1)
    {
        pop_oldprefs02 -> Check(20602, true);
    }
    else
    {
        pop_oldprefs02 -> Check(20602, false);
    }
    // DownloadList Doubleclick
    oldprefs02_opt[3] = theApp.glob_prefs -> IsDoubleClickEnabled();
    if (oldprefs02_opt[3] == 1)
    {
        pop_oldprefs02 -> Check(20603, true);
    }
    else
    {
        pop_oldprefs02 -> Check(20603, false);
    }
    // Minimize to trayicon
    oldprefs02_opt[4] = theApp.glob_prefs -> DoMinToTray();
    if (oldprefs02_opt[4] == 1)
    {
        pop_oldprefs02 -> Check(20604, true);
    }
    else
    {
        pop_oldprefs02 -> Check(20604, false);
    }
    // Enable OnlineSig
    oldprefs02_opt[5] = theApp.glob_prefs -> IsOnlineSignatureEnabled();
    if (oldprefs02_opt[5] == 1)
    {
        pop_oldprefs02 -> Check(20605, true);
    }
    else
    {
        pop_oldprefs02 -> Check(20605, false);
    }
    // Confirm Exit
    oldprefs02_opt[6] = theApp.glob_prefs -> IsConfirmExitEnabled();
    if (oldprefs02_opt[6] == 1)
    {
        pop_oldprefs02 -> Check(20606, true);
    }
    else
    {
        pop_oldprefs02 -> Check(20606, false);
    }
    // Start -> Check Version
    oldprefs02_opt[7] = theApp.glob_prefs -> UpdateNotify();
    if (oldprefs02_opt[7] == 1)
    {
        pop_oldprefs02 -> Check(20607, true);
    }
    else
    {
        pop_oldprefs02 -> Check(20607, false);
    }
    // Start -> Show Splash Screen
    oldprefs02_opt[8] = theApp.glob_prefs -> UseSplashScreen();
    if (oldprefs02_opt[8] == 1)
    {
        pop_oldprefs02 -> Check(20608, true);
    }
    else
    {
        pop_oldprefs02 -> Check(20608, false);
    }
    // Start -> Startup Minimized
    oldprefs02_opt[9] = theApp.glob_prefs -> GetStartMinimized();
    if (oldprefs02_opt[9] == 1)
    {
        pop_oldprefs02 -> Check(20609, true);
    }
    else
    {
        pop_oldprefs02 -> Check(20609, false);
    }
    //User Nick
    str_buffer.Printf("Nick: %s", theApp.glob_prefs -> GetUserNick());
    pop_oldprefs02 -> SetLabel(20610, str_buffer);
    //Tool Tip Delay
    oldprefs02_opt[11] = theApp.glob_prefs -> GetToolTipDelay();
    str_buffer.Printf("Tooltip Delay Time: %d", oldprefs02_opt[11]);
    pop_oldprefs02 -> SetLabel(20611, str_buffer);
    //Days between Version Check
    oldprefs02_opt[12] = theApp.glob_prefs -> GetUpdateDays();
    str_buffer.Printf("Days between Update-Check: %d", oldprefs02_opt[12]);
    pop_oldprefs02 -> SetLabel(20612, str_buffer);
    //Progressbar Style
    oldprefs02_opt[13] = theApp.glob_prefs -> GetFlatBarStyle();
    str_buffer.Printf("Progress Bar Style: %d", oldprefs02_opt[13]);
    pop_oldprefs02 -> SetLabel(20613, str_buffer);
}

void CFlowChart:: op03_Autoconnect(wxCommandEvent &evt)
{
    if (pop_oldprefs03 -> IsChecked(20701))
    {
        oldprefs03_opt[1] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetAutoConnect(1);
        }
    }
    else
    {
        oldprefs03_opt[1] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetAutoConnect(0);
        }
    }
}

void CFlowChart:: op03_Reconnect(wxCommandEvent &evt)
{
    if (pop_oldprefs03 -> IsChecked(20702))
    {
        oldprefs03_opt[2] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetReconnect(1);
        }
    }
    else
    {
        oldprefs03_opt[2] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetReconnect(0);
        }
    }
}

void CFlowChart:: op03_Show_Overhead(wxCommandEvent &evt)
{
    if (pop_oldprefs03 -> IsChecked(20703))
    {
        oldprefs03_opt[3] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetShowOverhead(1);
        }
    }
    else
    {
        oldprefs03_opt[3] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetShowOverhead(0);
        }
    }
}

void CFlowChart:: op03_Disable_UDP(wxCommandEvent &evt)
{
    long int port;
    if (pop_oldprefs03 -> IsChecked(20704))
    {
        oldprefs03_opt[3] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetUDPPort(0);
            SetOldPrefs();
        }
    }
    else
    {
        oldprefs03_opt[3] = 0;
        if (oldprefs01_opt[1])
        {
            wxTextEntryDialog textbox((wxWindow *) this, _T("We need the number of the UDP Port:"), _T("Enable UDP"), _T("4672"), wxOK | wxCANCEL);
            if (textbox.ShowModal() == wxID_OK)
            {
                if (textbox.GetValue() .Len())
                {
                    wxString result = textbox.GetValue();
                    result.ToLong( &port);
                }
                else
                {
                    port = 4672;
                }
                if (port < 1)
                {
                    port = 1;
                }
                else if(port > 65535)
                {
                    port = 65535;
                }
            }
            else
            {
                port = 0;
            }
            theApp.glob_prefs -> SetUDPPort((uint16) port);
            op03_SetOldPrefs();
        }
    }
}

void CFlowChart:: op03_Download_Capacitie(wxCommandEvent &evt)
{
    long int capacitie;
    wxString old_value;
    old_value.Printf("%d", theApp.glob_prefs -> GetMaxGraphDownloadRate());
    wxTextEntryDialog textbox((wxWindow *) this, _T("Download Capacitie:"), _T("Download Capacitie"), old_value, wxOK | wxCANCEL);
    if (textbox.ShowModal() == wxID_OK)
    {
        if (textbox.GetValue() .Len())
        {
            wxString result = textbox.GetValue();
            result.ToLong( &capacitie);
        }
        else
        {
            capacitie = 128;
        }
        if (capacitie < 0)
        {
            capacitie = 0;
        }
        else if(capacitie > 65535)
        {
            capacitie = 65535;
        }
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetMaxGraphDownloadRate((int) capacitie);
            op03_SetOldPrefs();
        }
    }
}

void CFlowChart:: op03_Upload_Capacitie(wxCommandEvent &evt)
{
    long int capacitie;
    wxString old_value;
    old_value.Printf("%d", theApp.glob_prefs -> GetMaxGraphUploadRate());
    wxTextEntryDialog textbox((wxWindow *) this, _T("Upload Capacitie:"), _T("Upload Capacitie"), old_value, wxOK | wxCANCEL);
    if (textbox.ShowModal() == wxID_OK)
    {
        if (textbox.GetValue() .Len())
        {
            wxString result = textbox.GetValue();
            result.ToLong( &capacitie);
        }
        else
        {
            capacitie = 16;
        }
        if (capacitie < 0)
        {
            capacitie = 0;
        }
        else if(capacitie > 65535)
        {
            capacitie = 65535;
        }
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetMaxGraphUploadRate((int) capacitie);
            op03_SetOldPrefs();
        }
    }
}

void CFlowChart:: op03_Download_Limit(wxCommandEvent &evt)
{
    long int limit;
    wxString old_value;
    old_value.Printf("%d", theApp.glob_prefs -> GetMaxDownload());
    wxTextEntryDialog textbox((wxWindow *) this, _T("Download Limit: [65535 is unlimited]"), _T("Download Limit"), old_value, wxOK | wxCANCEL);
    if (textbox.ShowModal() == wxID_OK)
    {
        if (textbox.GetValue() .Len())
        {
            wxString result = textbox.GetValue();
            result.ToLong( &limit);
        }
        else
        {
            limit = 65535;
        }
        if (limit < 1)
        {
            limit = 65535;
        }
        else if(limit > 65535)
        {
            limit = 65535;
        }
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetDownloadlimit((uint16) limit);
            op03_SetOldPrefs();
        }
    }
}

void CFlowChart:: op03_Upload_Limit(wxCommandEvent &evt)
{
    long int limit;
    wxString old_value;
    old_value.Printf("%d", theApp.glob_prefs -> GetMaxUpload());
    wxTextEntryDialog textbox((wxWindow *) this, _T("Upload Limit: [65535 is unlimited]"), _T("Upload Limit"), old_value, wxOK | wxCANCEL);
    if (textbox.ShowModal() == wxID_OK)
    {
        if (textbox.GetValue() .Len())
        {
            wxString result = textbox.GetValue();
            result.ToLong( &limit);
        }
        else
        {
            limit = 16;
        }
        if (limit < 1)
        {
            limit = 65535;
        }
        else if(limit > 65535)
        {
            limit = 65535;
        }
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetUploadlimit((uint16) limit);
            op03_SetOldPrefs();
        }
    }
}

void CFlowChart:: op03_Client_Port(wxCommandEvent &evt)
{
    long int port;
    wxString old_value;
    old_value.Printf("%d", theApp.glob_prefs -> GetPort());
    wxTextEntryDialog textbox((wxWindow *) this, _T("Client-Port:[1-65635]"), _T("Client Port"), old_value, wxOK | wxCANCEL);
    if (textbox.ShowModal() == wxID_OK)
    {
        if (textbox.GetValue() .Len())
        {
            wxString result = textbox.GetValue();
            result.ToLong( &port);
        }
        else
        {
            port = 4662;
        }
        if (port < 1)
        {
            port = 1;
        }
        else if(port > 65535)
        {
            port = 65535;
        }
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetPort((uint16) port);
            op03_SetOldPrefs();
        }
    }
}

void CFlowChart:: op03_UDP_Port(wxCommandEvent &evt)
{
    long int port;
    wxString old_value;
    old_value.Printf("%d", theApp.glob_prefs -> GetUDPPort());
    wxTextEntryDialog textbox((wxWindow *) this, _T("UDP-Port:[1-65635]"), _T("UDP Port"), old_value, wxOK | wxCANCEL);
    if (textbox.ShowModal() == wxID_OK)
    {
        if (textbox.GetValue() .Len())
        {
            wxString result = textbox.GetValue();
            result.ToLong( &port);
        }
        else
        {
            port = 4672;
        }
        if (port < 1)
        {
            port = 1;
        }
        else if(port > 65535)
        {
            port = 65535;
        }
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetUDPPort((uint16) port);
            op03_SetOldPrefs();
        }
    }
}

void CFlowChart:: op03_Hard_Limit(wxCommandEvent &evt)
{
    long int limit;
    wxString old_value;
    old_value.Printf("%d", theApp.glob_prefs -> GetMaxSourcePerFile());
    wxTextEntryDialog textbox((wxWindow *) this, _T("Hard Limit. Maximum Sources per File"), _T("Hard Limit"), old_value, wxOK | wxCANCEL);
    if (textbox.ShowModal() == wxID_OK)
    {
        if (textbox.GetValue() .Len())
        {
            wxString result = textbox.GetValue();
            result.ToLong( &limit);
        }
        else
        {
            limit = 500;
        }
        if (limit < 1)
        {
            limit = 1;
        }
        else if(limit > 65535)
        {
            limit = 65535;
        }
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetMaxSourcesPerFile((uint16) limit);
            op03_SetOldPrefs();
        }
    }
}

void CFlowChart:: op03_Max_Connection(wxCommandEvent &evt)
{
    long int limit;
    wxString old_value;
    old_value.Printf("%d", theApp.glob_prefs -> GetMaxConnections());
    wxTextEntryDialog textbox((wxWindow *) this, _T("Maximum Connections"), _T("Maximum Connections"), old_value, wxOK | wxCANCEL);
    if (textbox.ShowModal() == wxID_OK)
    {
        if (textbox.GetValue() .Len())
        {
            wxString result = textbox.GetValue();
            result.ToLong( &limit);
        }
        else
        {
            limit = 1000;
        }
        if (limit < 1)
        {
            limit = 1;
        }
        else if(limit > 65535)
        {
            limit = 65535;
        }
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetMaxConnections((uint16) limit);
            op03_SetOldPrefs();
        }
    }
}

void CFlowChart:: op03_SetOldPrefs(void)
{
    wxString str_buffer;
    //Autoconnect On Startup
    oldprefs03_opt[1] = theApp.glob_prefs -> DoAutoConnect();
    if (oldprefs03_opt[1] == 1)
    {
        pop_oldprefs03 -> Check(20701, true);
    }
    else
    {
        pop_oldprefs03 -> Check(20701, false);
    }
    //Reconnect on loss
    oldprefs03_opt[2] = theApp.glob_prefs -> Reconnect();
    if (oldprefs03_opt[2] == 1)
    {
        pop_oldprefs03 -> Check(20702, true);
    }
    else
    {
        pop_oldprefs03 -> Check(20702, false);
    }
    //Show Overhead Bandwitdh
    oldprefs03_opt[3] = theApp.glob_prefs -> ShowOverhead();
    if (oldprefs03_opt[3] == 1)
    {
        pop_oldprefs03 -> Check(20703, true);
    }
    else
    {
        pop_oldprefs03 -> Check(20703, false);
    }
    //Disable UDP
    oldprefs03_opt[4] = theApp.glob_prefs -> GetUDPPort();
    if (oldprefs03_opt[4] == 0)
    {
        pop_oldprefs03 -> Check(20704, true);
    }
    else
    {
        pop_oldprefs03 -> Check(20704, false);
    }
    //Download Capacitie
    oldprefs03_opt[6] = theApp.glob_prefs -> GetMaxGraphDownloadRate();
    str_buffer.Printf("Download Capacitie: %d", oldprefs03_opt[6]);
    pop_oldprefs03 -> SetLabel(20705, str_buffer);
    //Upload Capacitie
    oldprefs03_opt[7] = theApp.glob_prefs -> GetMaxGraphUploadRate();
    str_buffer.Printf("Upload Capacitie: %d", oldprefs03_opt[7]);
    pop_oldprefs03 -> SetLabel(20706, str_buffer);
    //Download Limit
    oldprefs03_opt[8] = theApp.glob_prefs -> GetMaxDownload();
    str_buffer.Printf("Download Limit: %d", oldprefs03_opt[8]);
    pop_oldprefs03 -> SetLabel(20707, str_buffer);
    //Upload Limit
    oldprefs03_opt[9] = theApp.glob_prefs -> GetMaxUpload();
    str_buffer.Printf("Upload Limit: %d", oldprefs03_opt[9]);
    pop_oldprefs03 -> SetLabel(20708, str_buffer);
    //Client Port
    oldprefs03_opt[10] = theApp.glob_prefs -> GetPort();
    str_buffer.Printf("Client-Port: %d", oldprefs03_opt[10]);
    pop_oldprefs03 -> SetLabel(20709, str_buffer);
    //UDP Port
    oldprefs03_opt[11] = theApp.glob_prefs -> GetUDPPort();
    str_buffer.Printf("UDP-Port: %d", oldprefs03_opt[11]);
    pop_oldprefs03 -> SetLabel(20710, str_buffer);
    //Hard Limit
    oldprefs03_opt[12] = theApp.glob_prefs -> GetMaxSourcePerFile();
    str_buffer.Printf("Hard Limit: %d", oldprefs03_opt[12]);
    pop_oldprefs03 -> SetLabel(20711, str_buffer);
    //Max. Connections
    oldprefs03_opt[13] = theApp.glob_prefs -> GetMaxConnections();
    str_buffer.Printf("Maximum Connections: %d", oldprefs03_opt[13]);
    pop_oldprefs03 -> SetLabel(20712, str_buffer);
}

void CFlowChart:: op04_Remove_Dead_Server(wxCommandEvent &evt)
{
    if (pop_oldprefs04 -> IsChecked(20801))
    {
        oldprefs04_opt[1] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetDeadServer(1);
        }
    }
    else
    {
        oldprefs04_opt[1] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetDeadServer(0);
        }
    }
}

void CFlowChart:: op04_Filter_Server_IP(wxCommandEvent &evt)
{
    if (pop_oldprefs04 -> IsChecked(20802))
    {
        oldprefs04_opt[2] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetFilterBadIPs(1);
        }
    }
    else
    {
        oldprefs04_opt[2] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetFilterBadIPs(0);
        }
    }
}

void CFlowChart:: op04_Serverlist_Startup(wxCommandEvent &evt)
{
    if (pop_oldprefs04 -> IsChecked(20803))
    {
        oldprefs04_opt[3] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetAutoServerlist(1);
        }
    }
    else
    {
        oldprefs04_opt[3] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetAutoServerlist(0);
        }
    }
}

void CFlowChart:: op04_Serverlist_Server(wxCommandEvent &evt)
{
    if (pop_oldprefs04 -> IsChecked(20804))
    {
        oldprefs04_opt[4] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetAddServersFromServer(1);
        }
    }
    else
    {
        oldprefs04_opt[4] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetAddServersFromServer(0);
        }
    }
}

void CFlowChart:: op04_Serverlist_Clients(wxCommandEvent &evt)
{
    if (pop_oldprefs04 -> IsChecked(20805))
    {
        oldprefs04_opt[5] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetAddServersFromClient(1);
        }
    }
    else
    {
        oldprefs04_opt[5] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetAddServersFromClient(0);
        }
    }
}

void CFlowChart:: op04_Use_Priority_System(wxCommandEvent &evt)
{
    if (pop_oldprefs04 -> IsChecked(20806))
    {
        oldprefs04_opt[6] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetScore(1);
        }
    }
    else
    {
        oldprefs04_opt[6] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetScore(0);
        }
    }
}

void CFlowChart:: op04_Use_Smart_LowID_Check(wxCommandEvent &evt)
{
    if (pop_oldprefs04 -> IsChecked(20807))
    {
        oldprefs04_opt[7] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetSmartIdCheck(1);
        }
    }
    else
    {
        oldprefs04_opt[7] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetSmartIdCheck(0);
        }
    }
}

void CFlowChart:: op04_Safe_Connect(wxCommandEvent &evt)
{
    if (pop_oldprefs04 -> IsChecked(20808))
    {
        oldprefs04_opt[8] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetSafeServerConnectEnabled(1);
        }
    }
    else
    {
        oldprefs04_opt[8] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetSafeServerConnectEnabled(0);
        }
    }
}

void CFlowChart:: op04_Connect_Static_List_only(wxCommandEvent &evt)
{
    if (pop_oldprefs04 -> IsChecked(20809))
    {
        oldprefs04_opt[9] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetAutoConnectStaticOnly(1);
        }
    }
    else
    {
        oldprefs04_opt[9] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetAutoConnectStaticOnly(0);
        }
    }
}

void CFlowChart:: op04_Manually_Server_High_prio(wxCommandEvent &evt)
{
    if (pop_oldprefs04 -> IsChecked(20810))
    {
        oldprefs04_opt[10] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetManualHighPrio(1);
        }
    }
    else
    {
        oldprefs04_opt[10] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetManualHighPrio(0);
        }
    }
}

void CFlowChart:: op04_Dead_Server_Retrys(wxCommandEvent &evt)
{
    long int retrys;
    wxString old_value;
    old_value.Printf("%d", theApp.glob_prefs -> GetDeadserverRetries());
    wxTextEntryDialog textbox((wxWindow *) this, _T("Connection retrys before the dead Server will be removed from the List."), _T("Dead Server Retrys"), old_value, wxOK | wxCANCEL);
    if (textbox.ShowModal() == wxID_OK)
    {
        if (textbox.GetValue() .Len())
        {
            wxString result = textbox.GetValue();
            result.ToLong( &retrys);
        }
        else
        {
            retrys = 5;
        }
        if (retrys < 1)
        {
            retrys = 1;
        }
        else if(retrys > 65535)
        {
            retrys = 65535;
        }
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetDeadserverRetries(retrys);
            op04_SetOldPrefs();
        }
    }
}

void CFlowChart:: op04_SetOldPrefs(void)
{
    wxString str_buffer;
    //Remove Dead Server
    oldprefs04_opt[1] = theApp.glob_prefs -> DeadServer();
    if (oldprefs04_opt[1] == 1)
    {
        pop_oldprefs04 -> Check(20801, true);
    }
    else
    {
        pop_oldprefs04 -> Check(20801, false);
    }
    //Filter Bad Server IP
    oldprefs04_opt[2] = theApp.glob_prefs -> FilterBadIPs();
    if (oldprefs04_opt[2] == 1)
    {
        pop_oldprefs04 -> Check(20802, true);
    }
    else
    {
        pop_oldprefs04 -> Check(20802, false);
    }
    //Auto update Serverlist at startup
    oldprefs04_opt[3] = theApp.glob_prefs -> AutoServerlist();
    if (oldprefs04_opt[3] == 1)
    {
        pop_oldprefs04 -> Check(20803, true);
    }
    else
    {
        pop_oldprefs04 -> Check(20803, false);
    }
    //Serverlist from Server
    oldprefs04_opt[4] = theApp.glob_prefs -> AddServersFromServer();
    if (oldprefs04_opt[4] == 1)
    {
        pop_oldprefs04 -> Check(20804, true);
    }
    else
    {
        pop_oldprefs04 -> Check(20804, false);
    }
    //Serverlist from Clients
    oldprefs04_opt[5] = theApp.glob_prefs -> AddServersFromClient();
    if (oldprefs04_opt[5] == 1)
    {
        pop_oldprefs04 -> Check(20805, true);
    }
    else
    {
        pop_oldprefs04 -> Check(20805, false);
    }
    //Use Priority System
    oldprefs04_opt[6] = theApp.glob_prefs -> Score();
    if (oldprefs04_opt[6] == 1)
    {
        pop_oldprefs04 -> Check(20806, true);
    }
    else
    {
        pop_oldprefs04 -> Check(20806, false);
    }
    //Use Smart LowID Check
    oldprefs04_opt[7] = theApp.glob_prefs -> GetSmartIdCheck();
    if (oldprefs04_opt[7] == 1)
    {
        pop_oldprefs04 -> Check(20807, true);
    }
    else
    {
        pop_oldprefs04 -> Check(20807, false);
    }
    //Use Safe Server connect
    oldprefs04_opt[8] = theApp.glob_prefs -> IsSafeServerConnectEnabled();
    if (oldprefs04_opt[8] == 1)
    {
        pop_oldprefs04 -> Check(20808, true);
    }
    else
    {
        pop_oldprefs04 -> Check(20808, false);
    }
    //Connect Static List Servers Only
    oldprefs04_opt[9] = theApp.glob_prefs -> AutoConnectStaticOnly();
    if (oldprefs04_opt[9] == 1)
    {
        pop_oldprefs04 -> Check(20809, true);
    }
    else
    {
        pop_oldprefs04 -> Check(20809, false);
    }
    //Manually Servers High Priority
    oldprefs04_opt[10] = theApp.glob_prefs -> GetManualHighPrio();
    if (oldprefs04_opt[10] == 1)
    {
        pop_oldprefs04 -> Check(20810, true);
    }
    else
    {
        pop_oldprefs04 -> Check(20810, false);
    }
    //Retrys before Dead Server Remove
    oldprefs04_opt[11] = theApp.glob_prefs -> GetDeadserverRetries();
    str_buffer.Printf("Retrys before Dead Server Remove: %d", oldprefs04_opt[11]);
    pop_oldprefs04 -> SetLabel(20811, str_buffer);
}

void CFlowChart:: op05_See_Share_Everybody(wxCommandEvent &evt)
{
    oldprefs05_opt[1] = 0;
    if (oldprefs01_opt[1])
    {
        theApp.glob_prefs -> SetSeeShares(0);
    }
}

void CFlowChart:: op05_See_Share_Friends(wxCommandEvent &evt)
{
    oldprefs05_opt[1] = 1;
    if (oldprefs01_opt[1])
    {
        theApp.glob_prefs -> SetSeeShares(1);
    }
}

void CFlowChart:: op05_See_Share_Noone(wxCommandEvent &evt)
{
    oldprefs05_opt[1] = 2;
    if (oldprefs01_opt[1])
    {
        theApp.glob_prefs -> SetSeeShares(2);
    }
}

void CFlowChart:: op05_ICH_Enabled(wxCommandEvent &evt)
{
    if (pop_oldprefs05 -> IsChecked(20904))
    {
        oldprefs05_opt[2] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetICHEnabled(1);
        }
    }
    else
    {
        oldprefs05_opt[2] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetICHEnabled(0);
        }
    }
}

void CFlowChart:: op05_Add_Files_Paused(wxCommandEvent &evt)
{
    if (pop_oldprefs05 -> IsChecked(20905))
    {
        oldprefs05_opt[3] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetAddNewFilesPaused(1);
        }
    }
    else
    {
        oldprefs05_opt[3] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetAddNewFilesPaused(0);
        }
    }
}

void CFlowChart:: op05_Preview_Prio(wxCommandEvent &evt)
{
    if (pop_oldprefs05 -> IsChecked(20906))
    {
        oldprefs05_opt[4] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetPreviewPrio(1);
        }
    }
    else
    {
        oldprefs05_opt[4] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetPreviewPrio(0);
        }
    }
}

void CFlowChart:: op05_Add_With_Auto_Priority(wxCommandEvent &evt)
{
    if (pop_oldprefs05 -> IsChecked(20907))
    {
        oldprefs05_opt[5] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetNewAutoUp(1);
        }
    }
    else
    {
        oldprefs05_opt[5] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetNewAutoUp(0);
        }
    }
}

void CFlowChart:: op05_Transfer_Full_Chunks(wxCommandEvent &evt)
{
    if (pop_oldprefs05 -> IsChecked(20908))
    {
        oldprefs05_opt[6] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetTransferFullChunks(1);
        }
    }
    else
    {
        oldprefs05_opt[6] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetTransferFullChunks(0);
        }
    }
}

void CFlowChart:: op05_Start_Next_File(wxCommandEvent &evt)
{
    if (pop_oldprefs05 -> IsChecked(20909))
    {
        oldprefs05_opt[7] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetStartNextFile(1);
        }
    }
    else
    {
        oldprefs05_opt[7] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetStartNextFile(0);
        }
    }
}

void CFlowChart:: op05_SetOldPrefs(void)
{
    // Can See Share
    oldprefs05_opt[1] = theApp.glob_prefs -> CanSeeShares();
    switch (oldprefs05_opt[1])
    {
    case 0: pop_oldprefs05 -> Check(20901, true);
        break;
    case 1: pop_oldprefs05 -> Check(20902, true);
        break;
    case 2: pop_oldprefs05 -> Check(20903, true);
        break;
    }
    //ICH Enabled
    oldprefs05_opt[2] = theApp.glob_prefs -> IsICHEnabled();
    if (oldprefs05_opt[2] == 1)
    {
        pop_oldprefs05 -> Check(20904, true);
    }
    else
    {
        pop_oldprefs05 -> Check(20904, false);
    }
    //Add new downloads in paused mode
    oldprefs05_opt[3] = theApp.glob_prefs -> AddNewFilesPaused();
    if (oldprefs05_opt[3] == 1)
    {
        pop_oldprefs05 -> Check(20905, true);
    }
    else
    {
        pop_oldprefs05 -> Check(20905, false);
    }
    //Try to download first and last chunks first
    oldprefs05_opt[4] = theApp.glob_prefs -> GetPreviewPrio();
    if (oldprefs05_opt[4] == 1)
    {
        pop_oldprefs05 -> Check(20906, true);
    }
    else
    {
        pop_oldprefs05 -> Check(20906, false);
    }
    //Add new shared Files with Auto Priority
    oldprefs05_opt[5] = theApp.glob_prefs -> GetNewAutoUp();
    if (oldprefs05_opt[5] == 1)
    {
        pop_oldprefs05 -> Check(20907, true);
    }
    else
    {
        pop_oldprefs05 -> Check(20907, false);
    }
    //Transfer full chunks
    oldprefs05_opt[6] = theApp.glob_prefs -> TransferFullChunks();
    if (oldprefs05_opt[6] == 1)
    {
        pop_oldprefs05 -> Check(20908, true);
    }
    else
    {
        pop_oldprefs05 -> Check(20908, false);
    }
    //Start next Paused File
    oldprefs05_opt[7] = theApp.glob_prefs -> StartNextFile();
    if (oldprefs05_opt[7] == 1)
    {
        pop_oldprefs05 -> Check(20909, true);
    }
    else
    {
        pop_oldprefs05 -> Check(20909, false);
    }
}

void CFlowChart:: op06_Backup_Video_Preview(wxCommandEvent &evt)
{
    if (pop_oldprefs06 -> IsChecked(21001))
    {
        oldprefs06_opt[1] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetMoviePreviewBackup(1);
        }
    }
    else
    {
        oldprefs06_opt[1] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetMoviePreviewBackup(0);
        }
    }
}

void CFlowChart:: op06_Video_Player(wxCommandEvent &evt)
{
    wxString player, old_player;
    old_player.Printf("%s", theApp.glob_prefs -> GetVideoPlayer());
    wxTextEntryDialog textbox((wxWindow *) this, _T("Type the command Line for your favorite \nVideo Player. (empty = Standard Player)"), _T("Video Player"), old_player, wxOK | wxCANCEL);
    if (textbox.ShowModal() == wxID_OK)
    {
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetVideoPlayer(textbox.GetValue() .c_str());
        }
        op06_SetOldPrefs();
    }
}

void CFlowChart:: op06_Incomming_Dir(wxCommandEvent &evt)
{
    wxString indir;
    wxDirDialog dirbox(this, "Chose incoming Folder", theApp.glob_prefs -> GetIncomingDir());
    if (dirbox.ShowModal() == wxID_OK)
    {
        indir = dirbox.GetPath();
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetIncomingDir(indir.c_str());
        }
        op06_SetOldPrefs();
    }
}

void CFlowChart:: op06_Temp_Dir(wxCommandEvent &evt)
{
    wxString tempdir;
    wxDirDialog dirbox(this, "Choose Folder for temp files", theApp.glob_prefs -> GetTempDir());
    if (dirbox.ShowModal() == wxID_OK)
    {
        tempdir = dirbox.GetPath();
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetTempDir(tempdir.c_str());
        }
        op06_SetOldPrefs();
    }
}

void CFlowChart:: op06_Share_Folder(wxCommandEvent &evt)
{
    bool is_already_shared = false;
    wxString sharedir, buffer;
    wxDirDialog dirbox(this, "Choose a Folder that you wan't to share.", "~");
    if (dirbox.ShowModal() == wxID_OK)
    {
        sharedir = "/" + dirbox.GetPath() + "/";
        for (int i = 0 ; i < theApp.glob_prefs -> shareddir_list.GetCount() ;++i)
        {
            if (!sharedir.Cmp(theApp.glob_prefs -> shareddir_list[i].GetData()))
            {
                is_already_shared = true;
            }
        }
        if (is_already_shared)
        {
            buffer.Printf("%s\nThis Folder is already shared.", sharedir.c_str());
            wxMessageDialog dialog(this, _T(buffer), _T("Can't share the Directory twice"), wxOK |wxICON_INFORMATION);
            switch (dialog.ShowModal())
            {
            default:
                break;
            }
        }
        else
        {
            if (oldprefs01_opt[1])
            {
                theApp.glob_prefs -> shareddir_list.Add(sharedir);
            }
            op06_SetOldPrefs();
        }
    }
}

void CFlowChart:: op06_Unshare_Folder(wxCommandEvent &evt)
{
    wxString dir, buffer;
    int button_shift;
    switch (oldprefs06_opt[3])
    {
    case 0: button_shift = 0;
        break;
    default: button_shift = 1;
    }
    int item = evt.GetId() - (OLDPREF_SHAREDDIRS_MASKSTART + button_shift);
    dir = theApp.glob_prefs -> shareddir_list[item + oldprefs06_opt[3]].GetData();
    buffer.Printf("%s\n\nDo you really wan't remove the Folder from the\nShared Directorys List ?", dir.c_str());
    wxMessageDialog dialog(this, _T(buffer), _T("Unshare Directory"), wxYES_DEFAULT |wxYES_NO |wxICON_INFORMATION);
    switch (dialog.ShowModal())
    {
    case wxID_YES:
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> shareddir_list.Remove(item + oldprefs06_opt[3], 1);
        }
        //Check if Last Entry was Removed
        if (oldprefs06_opt[3] > theApp.glob_prefs -> shareddir_list.GetCount() - OLDPREF_SHAREDDIRS_LISTSIZE)
        {
            oldprefs06_opt[3] = theApp.glob_prefs -> shareddir_list.GetCount() - OLDPREF_SHAREDDIRS_LISTSIZE;
        }
        op06_SetOldPrefs();
        break;
    case wxID_NO:
        break;
    }
}

void CFlowChart:: op06_ScrollDown(wxCommandEvent &evt)
{
    ++oldprefs06_opt[3];
    op06_SetOldPrefs();
}

void CFlowChart:: op06_ScrollUp(wxCommandEvent &evt)
{
    if (oldprefs06_opt[3])
    {
        --oldprefs06_opt[3];
        op06_SetOldPrefs();
    }
}

void CFlowChart:: op06_SetOldPrefs(void)
{
    wxString str_buffer;
    // Backup File for Video Preview
    oldprefs06_opt[1] = theApp.glob_prefs -> IsMoviePreviewBackup();
    if (oldprefs06_opt[1] == 1)
    {
        pop_oldprefs06 -> Check(21001, true);
    }
    else
    {
        pop_oldprefs06 -> Check(21001, false);
    }
    // Video Applikation  oldprefs06_opt[2]
    str_buffer.Printf("Video Player (empty=standard): %s", theApp.glob_prefs -> GetVideoPlayer());
    pop_oldprefs06 -> SetLabel(21002, str_buffer);
    // Incoming Directory
    str_buffer.Printf("Incoming Dir: %s", theApp.glob_prefs -> GetIncomingDir());
    pop_oldprefs06 -> SetLabel(21003, str_buffer);
    // Temp Directory
    str_buffer.Printf("Temp Dir: %s", theApp.glob_prefs -> GetTempDir());
    pop_oldprefs06 -> SetLabel(21004, str_buffer);
    //Shared Folder Button
    // Shared Folder List
    for (int i = OLDPREF_SHAREDDIRS_LISTSIZE + 2 ; i >= 0 ;--i)
    {
        pop_oldprefs06 -> Delete(OLDPREF_SHAREDDIRS_MASKSTART + i);
    }
    // Check if we have more then the maximum showable Listentrys
    if (OLDPREF_SHAREDDIRS_MASKSTART + theApp.glob_prefs -> shareddir_list.GetCount() > OLDPREF_SHAREDDIRS_MASKSTART + OLDPREF_SHAREDDIRS_LISTSIZE)
    {
        // Check if we are not at ScrolPosition 1 == (oldprefs06_opt[3] == 0)
        if (oldprefs06_opt[3])
        {
            pop_oldprefs06 -> Append(OLDPREF_SHAREDDIRS_MASKSTART, "  <<< Up >>>", "");
            Connect(OLDPREF_SHAREDDIRS_MASKSTART, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op06_ScrollUp);
            for (int i = 0 ; i < OLDPREF_SHAREDDIRS_LISTSIZE ; i++)
            {
                str_buffer.Printf("%s", theApp.glob_prefs -> shareddir_list[i + oldprefs06_opt[3]].GetData());
                pop_oldprefs06 -> Append(OLDPREF_SHAREDDIRS_MASKSTART + i + 1, str_buffer, "");
                Connect(OLDPREF_SHAREDDIRS_MASKSTART + i + 1, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op06_Unshare_Folder);
            }
            // Do only Append Down Button if haven't reached last List Position
            if (oldprefs06_opt[3] < theApp.glob_prefs -> shareddir_list.GetCount() - OLDPREF_SHAREDDIRS_LISTSIZE)
            {
                pop_oldprefs06 -> Append(OLDPREF_SHAREDDIRS_MASKSTART + OLDPREF_SHAREDDIRS_LISTSIZE + 2, "  <<<Down>>>", "");
                Connect(OLDPREF_SHAREDDIRS_MASKSTART + OLDPREF_SHAREDDIRS_LISTSIZE + 2, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op06_ScrollDown);
            }
        }
        // So we don't need an up button:
        else
        {
            for (int i = 0 ; i < OLDPREF_SHAREDDIRS_LISTSIZE ; i++)
            {
                str_buffer.Printf("%s", theApp.glob_prefs -> shareddir_list[i + oldprefs06_opt[3]].GetData());
                pop_oldprefs06 -> Append(OLDPREF_SHAREDDIRS_MASKSTART + i, str_buffer, "");
                Connect(OLDPREF_SHAREDDIRS_MASKSTART + i, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op06_Unshare_Folder);
            }
            pop_oldprefs06 -> Append(OLDPREF_SHAREDDIRS_MASKSTART + OLDPREF_SHAREDDIRS_LISTSIZE + 1, "  <<<Down>>>", "");
            Connect(OLDPREF_SHAREDDIRS_MASKSTART + OLDPREF_SHAREDDIRS_LISTSIZE + 1, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op06_ScrollDown);
        }
    }
    // No ? We can make it simple:
    else
    {
        for (int i = 0 ; i < theApp.glob_prefs -> shareddir_list.GetCount() ; i++)
        {
            str_buffer.Printf("%s", theApp.glob_prefs -> shareddir_list[i].GetData());
            pop_oldprefs06 -> Append(OLDPREF_SHAREDDIRS_MASKSTART + i, str_buffer, "");
            Connect(OLDPREF_SHAREDDIRS_MASKSTART + i, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) &CFlowChart:: op06_Unshare_Folder);
        }
    }
}

void CFlowChart:: op07_Graph_Update_Delay(wxCommandEvent &evt)
{
    long int update_delay;
    wxString old_value;
    old_value.Printf("%d", theApp.glob_prefs -> GetTrafficOMeterInterval());
    wxTextEntryDialog textbox((wxWindow *) this, _T("This setting scales the mesure Time:\n[0=disable - 100]"), _T("Update delay for the graphs"), old_value, wxOK | wxCANCEL);
    if (textbox.ShowModal() == wxID_OK)
    {
        if (textbox.GetValue() .Len())
        {
            wxString result = textbox.GetValue();
            result.ToLong( &update_delay);
        }
        else
        {
            update_delay = 5;
        }
        if (update_delay < - 1)
        {
            update_delay = 0;
        }
        else if(update_delay > 100)
        {
            update_delay = 100;
        }
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetTrafficOMeterInterval((uint16) update_delay);
            SetOldPrefs();
        }
    }
}

void CFlowChart:: op07_Time_Average_Graph(wxCommandEvent &evt)
{
    long int time_average;
    wxString old_value;
    old_value.Printf("%d", theApp.glob_prefs -> GetStatsAverageMinutes());
    wxTextEntryDialog textbox((wxWindow *) this, _T("Set the time (in minutes) for the calculation \nof the Average-Graph:[1-101] "), _T("Average Graph Time"), old_value, wxOK | wxCANCEL);
    if (textbox.ShowModal() == wxID_OK)
    {
        if (textbox.GetValue() .Len())
        {
            wxString result = textbox.GetValue();
            result.ToLong( &time_average);
        }
        else
        {
            time_average = 5;
        }
        if (time_average < 1)
        {
            time_average = 1;
        }
        else if(time_average > 101)
        {
            time_average = 101;
        }
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetStatsAverageMinutes((uint8) time_average);
            SetOldPrefs();
        }
    }
}

void CFlowChart:: op07_Statistic_Update_Delay(wxCommandEvent &evt)
{
    long int update_delay;
    wxString old_value;
    old_value.Printf("%d", theApp.glob_prefs -> GetStatsInterval());
    wxTextEntryDialog textbox((wxWindow *) this, _T("Set the time (in seconds) for updating the statistic Tree:\n[0=disable - 104] "), _T("Statistic Tree Update Delay"), old_value, wxOK | wxCANCEL);
    if (textbox.ShowModal() == wxID_OK)
    {
        if (textbox.GetValue() .Len())
        {
            wxString result = textbox.GetValue();
            result.ToLong( &update_delay);
        }
        else
        {
            update_delay = 5;
        }
        if (update_delay < 0)
        {
            update_delay = 0;
        }
        else if(update_delay > 104)
        {
            update_delay = 104;
        }
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetStatsInterval((uint16) update_delay);
            op07_SetOldPrefs();
        }
    }
}

void CFlowChart:: op07_Color_00(wxCommandEvent &evt)
{
    op_Color_Selection(0);
}

void CFlowChart:: op07_Color_01(wxCommandEvent &evt)
{
    op_Color_Selection(1);
}

void CFlowChart:: op07_Color_02(wxCommandEvent &evt)
{
    op_Color_Selection(2);
}

void CFlowChart:: op07_Color_03(wxCommandEvent &evt)
{
    op_Color_Selection(3);
}

void CFlowChart:: op07_Color_04(wxCommandEvent &evt)
{
    op_Color_Selection(4);
}

void CFlowChart:: op07_Color_05(wxCommandEvent &evt)
{
    op_Color_Selection(5);
}

void CFlowChart:: op07_Color_06(wxCommandEvent &evt)
{
    op_Color_Selection(6);
}

void CFlowChart:: op07_Color_07(wxCommandEvent &evt)
{
    op_Color_Selection(7);
}

void CFlowChart:: op07_Color_08(wxCommandEvent &evt)
{
    op_Color_Selection(8);
}

void CFlowChart:: op07_Color_09(wxCommandEvent &evt)
{
    op_Color_Selection(9);
}

void CFlowChart:: op07_Color_10(wxCommandEvent &evt)
{
    op_Color_Selection(10);
}

void CFlowChart:: op07_Color_11(wxCommandEvent &evt)
{
    op_Color_Selection(11);
}

void CFlowChart:: op07_Color_12(wxCommandEvent &evt)
{
    if (!oldprefs01_opt[2])
    {
        op_Color_Selection(12);
    }
}

void CFlowChart:: op07_Color_13(wxCommandEvent &evt)
{
    if (!oldprefs01_opt[2])
    {
        op_Color_Selection(13);
    }
}

void CFlowChart:: op07_Color_14(wxCommandEvent &evt)
{
    if (!oldprefs01_opt[2])
    {
        op_Color_Selection(14);
    }
}

void CFlowChart:: op07_Color_15(wxCommandEvent &evt)
{
    if (!oldprefs01_opt[2])
    {
        op_Color_Selection(15);
    }
}

void CFlowChart:: op07_SetOldPrefs(void)
{
    wxString str_buffer;
    wxColour col_buffer;
    // Graph Update Delay
    oldprefs07_opt[1] = theApp.glob_prefs -> GetTrafficOMeterInterval();
    str_buffer.Printf("Graph's update delay: %d", oldprefs07_opt[1]);
    pop_oldprefs07 -> SetLabel(21101, str_buffer);
    // Average time Graph
    oldprefs07_opt[2] = theApp.glob_prefs -> GetStatsAverageMinutes();
    str_buffer.Printf("Time for average Graph: %d min.", oldprefs07_opt[2]);
    pop_oldprefs07 -> SetLabel(21102, str_buffer);
    // Statistic Tree Update Delay
    oldprefs07_opt[3] = theApp.glob_prefs -> GetStatsInterval();
    str_buffer.Printf("Statistic Tree Update Delay: %d sec.", oldprefs07_opt[3]);
    pop_oldprefs07 -> SetLabel(21103, str_buffer);
    // Background
    pop_oldprefs07 -> SetLabel(OLDPREF_STATCOL_MASKSTART, "Background");
    // Grid
    pop_oldprefs07 -> SetLabel(OLDPREF_STATCOL_MASKSTART + 1, "Grid");
    // Download Current
    pop_oldprefs07 -> SetLabel(OLDPREF_STATCOL_MASKSTART + 2, "Download Current");
    // Download time-average
    pop_oldprefs07 -> SetLabel(OLDPREF_STATCOL_MASKSTART + 3, "Download time-average");
    // Download session-average
    pop_oldprefs07 -> SetLabel(OLDPREF_STATCOL_MASKSTART + 4, "Download session-average");
    // Upload Current
    pop_oldprefs07 -> SetLabel(OLDPREF_STATCOL_MASKSTART + 5, "Upload Current");
    // Upload time-average
    pop_oldprefs07 -> SetLabel(OLDPREF_STATCOL_MASKSTART + 6, "Upload time-average");
    // Upload session-average
    pop_oldprefs07 -> SetLabel(OLDPREF_STATCOL_MASKSTART + 7, "Upload session-average");
    // Active Connections
    pop_oldprefs07 -> SetLabel(OLDPREF_STATCOL_MASKSTART + 8, "Active Connections");
    // Active Downloads
    pop_oldprefs07 -> SetLabel(OLDPREF_STATCOL_MASKSTART + 9, "Active Downloads");
    // Active Uploads
    pop_oldprefs07 -> SetLabel(OLDPREF_STATCOL_MASKSTART + 10, "Active Uploads");
    // Systrayicon Speedbar
    pop_oldprefs07 -> SetLabel(OLDPREF_STATCOL_MASKSTART + 11, "Systrayicon Speedbar");
    pop_oldprefs07 -> SetLabel(OLDPREF_STATCOL_MASKSTART + 12, "Not in Use");
    pop_oldprefs07 -> SetLabel(OLDPREF_STATCOL_MASKSTART + 13, "Not in Use");
    pop_oldprefs07 -> SetLabel(OLDPREF_STATCOL_MASKSTART + 14, "Not in Use");
    pop_oldprefs07 -> SetLabel(OLDPREF_STATCOL_MASKSTART + 15, "Not in Use");
}

void CFlowChart:: op08_Verbose(wxCommandEvent &evt)
{
    if (pop_oldprefs08 -> IsChecked(21201))
    {
        oldprefs08_opt[1] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetVerbose(1);
        }
    }
    else
    {
        oldprefs08_opt[1] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetVerbose(0);
        }
    }
}

void CFlowChart:: op08_ED2K_Only_Runtime(wxCommandEvent &evt)
{
    if (pop_oldprefs08 -> IsChecked(21202))
    {
        oldprefs08_opt[2] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetAutoTakeED2KLinks(1);
        }
    }
    else
    {
        oldprefs08_opt[2] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetAutoTakeED2KLinks(0);
        }
    }
}

void CFlowChart:: op08_Queuelist_Realtime(wxCommandEvent &evt)
{
    if (pop_oldprefs08 -> IsChecked(21203))
    {
        oldprefs08_opt[3] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetUpdateQueueList(1);
        }
    }
    else
    {
        oldprefs08_opt[3] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetUpdateQueueList(0);
        }
    }
}

void CFlowChart:: op08_Show_Transfer_Titel(wxCommandEvent &evt)
{
    if (pop_oldprefs08 -> IsChecked(21204))
    {
        oldprefs08_opt[4] = 1;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetShowRatesOnTitle(1);
        }
    }
    else
    {
        oldprefs08_opt[4] = 0;
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetShowRatesOnTitle(0);
        }
    }
}

void CFlowChart:: op08_Max_Con_5Sec(wxCommandEvent &evt)
{
    long int maxcon;
    wxString old_value;
    old_value.Printf("%d", theApp.glob_prefs -> GetMaxConperFive());
    wxTextEntryDialog textbox((wxWindow *) this, _T("Maximum Connections per 5.Seconds"), _T("Max. Connection 5sec."), old_value, wxOK | wxCANCEL);
    if (textbox.ShowModal() == wxID_OK)
    {
        if (textbox.GetValue() .Len())
        {
            wxString result = textbox.GetValue();
            result.ToLong( &maxcon);
        }
        else
        {
            maxcon = 50;
        }
        if (maxcon < 1)
        {
            maxcon = 1;
        }
        else if(maxcon > 1000)
        {
            maxcon = 1000;
        }
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetMaxConsPerFive(maxcon);
            op08_SetOldPrefs();
        }
    }
}

void CFlowChart:: op08_File_Buffer_Size(wxCommandEvent &evt)
{
    long int buf_size;
    wxString old_value;
    old_value.Printf("%d", theApp.glob_prefs -> GetFileBufferSize());
    wxTextEntryDialog textbox((wxWindow *) this, _T("Maximum Filebuffer Size: [1-100 | 15000 - 150000]"), _T("Maximum Filebuffer Size."), old_value, wxOK | wxCANCEL);
    if (textbox.ShowModal() == wxID_OK)
    {
        if (textbox.GetValue() .Len())
        {
            wxString result = textbox.GetValue();
            result.ToLong( &buf_size);
        }
        else
        {
            buf_size = 15000;
        }
        if (buf_size < 15000)
        {
            if (buf_size <= 100)
            {
                if (buf_size == 0) buf_size = 1;
                buf_size = buf_size *15000;
            }
            else
            {
                buf_size = 15000;
            }
        }
        else if(buf_size > 150000)
        {
            buf_size = 150000;
        }
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetFileBufferSize(buf_size);
            op08_SetOldPrefs();
        }
    }
}

void CFlowChart:: op08_Queue_Size(wxCommandEvent &evt)
{
    long int queue_size;
    wxString old_value;
    old_value.Printf("%d", theApp.glob_prefs -> GetQueueSize());
    wxTextEntryDialog textbox((wxWindow *) this, _T("Queue Size: [20 - 100 | 2000 - 10000]"), _T("Upload Queue Size."), old_value, wxOK | wxCANCEL);
    if (textbox.ShowModal() == wxID_OK)
    {
        if (textbox.GetValue() .Len())
        {
            wxString result = textbox.GetValue();
            result.ToLong( &queue_size);
        }
        else
        {
            queue_size = 4000;
        }
        if (queue_size < 2000)
        {
            if (queue_size <= 100)
            {
                if (queue_size < 20) queue_size = 1;
                queue_size = queue_size *100;
            }
            else
            {
                queue_size = 2000;
            }
        }
        else if(queue_size > 10000)
        {
            queue_size = 10000;
        }
        if (oldprefs01_opt[1])
        {
            theApp.glob_prefs -> SetQueueSize(queue_size);
            op08_SetOldPrefs();
        }
    }
}

void CFlowChart:: op08_SetOldPrefs(void)
{
    wxString str_buffer;
    // Verbose
    oldprefs08_opt[1] = theApp.glob_prefs -> GetVerbose();
    if (oldprefs08_opt[1] == 1)
    {
        pop_oldprefs08 -> Check(21201, true);
    }
    else
    {
        pop_oldprefs08 -> Check(21201, false);
    }
    // Autotake ed2k links only during runtime
    oldprefs08_opt[2] = theApp.glob_prefs -> AutoTakeED2KLinks();
    if (oldprefs08_opt[2] == 1)
    {
        pop_oldprefs08 -> Check(21202, true);
    }
    else
    {
        pop_oldprefs08 -> Check(21202, false);
    }
    // Update Queuelist in Realtime
    oldprefs08_opt[3] = theApp.glob_prefs -> GetUpdateQueueList();
    if (oldprefs08_opt[3] == 1)
    {
        pop_oldprefs08 -> Check(21203, true);
    }
    else
    {
        pop_oldprefs08 -> Check(21203, false);
    }
    // Show Rates on Titel
    oldprefs08_opt[4] = theApp.glob_prefs -> ShowRatesOnTitle();
    if (oldprefs08_opt[4] == 1)
    {
        pop_oldprefs08 -> Check(21204, true);
    }
    else
    {
        pop_oldprefs08 -> Check(21204, false);
    }
    // Max Connection per 5 Sec
    oldprefs08_opt[5] = theApp.glob_prefs -> GetMaxConperFive();
    str_buffer.Printf("Max. Connections per 5 sec: %d", oldprefs08_opt[5]);
    pop_oldprefs08 -> SetLabel(21205, str_buffer);
    // File Buffer Size
    oldprefs08_opt[6] = theApp.glob_prefs -> GetFileBufferSize();
    str_buffer.Printf("File Buffer Size: %d", oldprefs08_opt[6]);
    pop_oldprefs08 -> SetLabel(21206, str_buffer);
    // Upload-Queue Size
    oldprefs08_opt[7] = theApp.glob_prefs -> GetQueueSize();
    str_buffer.Printf("Upload-Queue Size: %d", oldprefs08_opt[7]);
    pop_oldprefs08 -> SetLabel(21207, str_buffer);
}

void CFlowChart:: op_Color_Selection(int index)
{
    wxString buffer;
    wxColour in_color, out_color;
    if (index >= 0 &&index < 16)
    {
        in_color.Set((unsigned char)((theApp.glob_prefs -> GetStatsColor(index) >> 16) &0xff),
        (unsigned char)((theApp.glob_prefs -> GetStatsColor(index) >> 8) &0xff),
        (unsigned char)(theApp.glob_prefs -> GetStatsColor(index) &0xff));
        out_color = wxGetColourFromUser(this, in_color);
        if (out_color.Ok())
        {
            if (oldprefs01_opt[1])
            {
                theApp.glob_prefs -> SetStatsColor(index, ((out_color.Red() &0xff) << 16) | ((out_color.Green() &0xff) << 8) | (out_color.Blue() &0xff));
                if (oldprefs01_opt[2])
                {
                    buffer.Printf("Set Color %d to R<%d>G<%d>B<%d>\n Changes will be visible after next xMule start", index,
                    out_color.Red(), out_color.Green(), out_color.Blue());
                    wxMessageDialog dialog(this, _T(buffer), _T("Color Value Set"), wxOK |wxICON_INFORMATION);
                    switch (dialog.ShowModal())
                    {
                    default: break;
                    }
                }
            }
        }
    }
}

void CFlowChart:: SetOldPrefs(void)
{
    wxString str_buffer;
    // Generall Button
    op02_SetOldPrefs();
    // * Connection *
    op03_SetOldPrefs();
    // * Server *
    op04_SetOldPrefs();
    // * Files *
    op05_SetOldPrefs();
    // * Directorys *
    op06_SetOldPrefs();
    // * Statistics *
    op07_SetOldPrefs();
    // * Tweaks *
    op08_SetOldPrefs();
}

void CFlowChart:: WriteOldPrefs(void)
{
    long int save_selection = 5;
    wxString standard_value;
    if (oldprefs01_opt[1])
    {
        if (!oldprefs01_opt[2])
        {
            standard_value.Printf("%d", save_selection);
            wxTextEntryDialog textbox((wxWindow *) this, _T("Enter a Save_Selection Mask[0-15]"), _T("Save Preferences"), standard_value, wxOK | wxCANCEL);
            if (textbox.ShowModal() == wxID_OK)
            {
                if (textbox.GetValue() .Len())
                {
                    wxString result = textbox.GetValue();
                    result.ToLong( &save_selection);
                }
                else
                {
                    save_selection = 5;
                }
                if (save_selection < 0)
                {
                    save_selection = 0;
                }
                else if(save_selection > 15)
                {
                    save_selection = 15;
                }
            }
        }
        if (theApp.glob_prefs -> Save((unsigned char) save_selection))
        {
            wxMessageDialog dialog(this, _T("Can't write Preferences"), _T("Error"), wxOK |wxICON_INFORMATION);
            switch (dialog.ShowModal())
            {
            default: break;
            }
        }
        else
        {
            if (oldprefs01_opt[2])
            {
                wxMessageDialog dialog(this, _T("Preferences saved"), _T("Save"), wxOK |wxICON_INFORMATION);
                switch (dialog.ShowModal())
                {
                default: break;
                }
            }
        }
    }
}

void CFlowChart:: ReadOldPrefs(void)
{
    if (oldprefs01_opt[1])
    {
        if (theApp.glob_prefs -> Load(false))
        {
            wxMessageDialog dialog(this, _T("Can't load Preferences"), _T("Error"), wxOK |wxICON_INFORMATION);
            switch (dialog.ShowModal())
            {
            default: break;
            }
        }
        else
        {
            SetOldPrefs();
            if (oldprefs01_opt[2])
            {
                wxMessageDialog dialog(this, _T("Preferences loaded"), _T("Load"), wxOK |wxICON_INFORMATION);
                switch (dialog.ShowModal())
                {
                default: break;
                }
            }
        }
    }
}

void CFlowChart:: OnPaint(wxPaintEvent &event)
{
    wxPaintDC dc(this);
    PrepareDC(dc);
    dc.Clear();
    dc.SetTextForeground( *wxWHITE);
    dc.SetTextBackground( *wxBLACK);
    dc.SetPen(wxPen( *wxWHITE, 1, wxSOLID));
    dc.SetBrush(wxBrush( *DARK_WHITE, wxSOLID));
    dc.DrawRectangle(0, 0, 1600, 1200);
    //dc.DrawRectangle(16, 16, 783, 583);
    for (int index = 0 ; index < 256 ; index++)
    {
        switch (info_type[index])
        {
        case 1:
            ShowEntry(index, &dc);
            break;
        }
    }
}

void CFlowChart:: OnMouseMove(wxMouseEvent &event)
{
    wxPoint position = event.GetPosition();
    wxString output;
    long x, y;
    wxClientDC dc(this);
    PrepareDC(dc);
    x = dc.DeviceToLogicalX(position.x);
    y = dc.DeviceToLogicalY(position.y);
    //output.Printf(wxT("Current Position: %d,%d"), (int) x, (int) y);
    //dc.DrawText(output, 500,4);
}

void CFlowChart:: OnTimer(wxTimerEvent &event)
{
    //printf("OnTimer\n");
}

void CFlowChart:: CreateEntry(wxUint16 index, wxUint16 type, wxUint16 x, wxUint16 y, wxUint16 width,
wxUint16 height, wxUint32 ip, wxUint16 port, wxString textinfo, wxClientDC *dc)
{
    if (type != info_type[index])
    {
        info[index] = textinfo;
        info_type[index] = type;
        info_x[index] = x;
        info_y[index] = y;
        info_width[index] = width;
        info_height[index] = height;
        info_ip[index] = ip;
        info_port[index] = port;
    }
}

void CFlowChart:: ShowEntry(wxUint16 index, wxClientDC *dc)
{
    if (info_type[index])
    {
        wxUint16 x, y, width, height;
        x = info_x[index];
        y = info_y[index];
        width = info_width[index];
        height = info_height[index];
        if (info_txtbgcolour[index] == NULL)
        {
            dc -> SetTextBackground( *wxLIGHT_GREY);
        }
        else
        {
            dc -> SetTextBackground( *info_txtbgcolour[index]);
        }
        if (info_txtfgcolour[index] == NULL)
        {
            dc -> SetTextForeground( *wxBLACK);
        }
        else
        {
            dc -> SetTextForeground( *info_txtfgcolour[index]);
        }
        if (info_pen[index] == NULL)
        {
            dc -> SetPen(wxPen( *wxLIGHT_GREY, 1, wxSOLID));
        }
        else
        {
            dc -> SetPen( *info_pen[index]);
        }
        if (info_brush[index] == NULL)
        {
            dc -> SetBrush(wxBrush( *wxLIGHT_GREY, wxSOLID));
        }
        else
        {
            dc -> SetBrush( *info_brush[index]);
        }
        dc -> DrawRectangle(x, y, width, height);
        if (info_ip[index])
        {
            dc -> DrawText(info[index], x + 4, y + height - 28);
            unsigned char ip[4];
            memcpy(ip, &info_ip[index], 4);
            dc -> DrawText(wxString:: Format("%d.%d.%d.%d:%d", ip[0], ip[1], ip[2], ip[3], info_port[index]),
            x + 4, y + height - 14);
        }
        else
        {
            dc -> DrawText(info[index], x + 4, y + height - 20);
        }
    }
}

void CFlowChart:: Sync(wxUint32 socketnumber, wxUint16 index, wxUint32 ip, wxUint16 port,
unsigned char *buffer)
{
    wxClientDC dc(this);
    PrepareDC(dc);
    dc.SetTextForeground( *wxWHITE);
    switch (index)
    {
    case 1:
        SetPenBrushText(1, &dc, wxBLUE, wxLIGHT_GREY, wxLIGHT_GREY, wxBLACK, wxSOLID);
        CreateEntry(index, 1, 40, 80, 128, 32, ip, port, wxT("ClientSocket UDP"), &dc);
        ShowEntry(index, &dc);
        break;
    case 129:
        SetPenBrushText(129, &dc, wxBLACK, wxLIGHT_GREY, wxLIGHT_GREY, wxBLACK, wxSOLID);
        CreateEntry(129, 1, 24, 40, 104, 26, ip, port, wxT("New Preferences"), &dc);
        ShowEntry(129, &dc);
        break;
    case 130:
        SetPenBrushText(130, &dc, wxBLACK, wxLIGHT_GREY, wxLIGHT_GREY, wxBLACK, wxSOLID);
        CreateEntry(130, 1, 140, 40, 96, 26, ip, port, wxT("Debug-Settings"), &dc);
        ShowEntry(130, &dc);
        break;
    case 131:
        SetPenBrushText(131, &dc, wxBLACK, wxLIGHT_GREY, wxLIGHT_GREY, wxBLACK, wxSOLID);
        CreateEntry(131, 1, 248, 40, 144, 26, ip, port, wxT("Show Outgo. OPcodes?"), &dc);
        ShowEntry(131, &dc);
        break;
    case 132:
        SetPenBrushText(132, &dc, wxBLACK, wxLIGHT_GREY, wxLIGHT_GREY, wxBLACK, wxSOLID);
        CreateEntry(132, 1, 404, 40, 144, 26, ip, port, wxT("Show Incom. OPcodes?"), &dc);
        ShowEntry(132, &dc);
        break;
    case 192:
        SetPenBrushText(192, &dc, wxBLACK, wxLIGHT_GREY, wxLIGHT_GREY, wxBLACK, wxSOLID);
        CreateEntry(192, 1, 24, 8, 96, 26, ip, port, wxT("Old Prefereces"), &dc);
        ShowEntry(192, &dc);
        break;
    case 193:
        if (oldprefs01_opt[1])
        {
            SetPenBrushText(193, &dc, wxBLACK, wxLIGHT_GREY, wxLIGHT_GREY, wxBLACK, wxSOLID);
        }
        else
        {
            SetPenBrushText(193, &dc, wxRED, LIGHT_RED, LIGHT_RED, wxRED, wxSOLID);
        }
        CreateEntry(193, 1, 132, 8, 54, 26, ip, port, wxT("General"), &dc);
        ShowEntry(193, &dc);
        break;
    case 194:
        if (oldprefs01_opt[1])
        {
            SetPenBrushText(194, &dc, wxBLACK, wxLIGHT_GREY, wxLIGHT_GREY, wxBLACK, wxSOLID);
        }
        else
        {
            SetPenBrushText(194, &dc, wxRED, LIGHT_RED, LIGHT_RED, wxRED, wxSOLID);
        }
        CreateEntry(194, 1, 198, 8, 74, 26, ip, port, wxT("Connection"), &dc);
        ShowEntry(194, &dc);
        break;
    case 195:
        if (oldprefs01_opt[1])
        {
            SetPenBrushText(195, &dc, wxBLACK, wxLIGHT_GREY, wxLIGHT_GREY, wxBLACK, wxSOLID);
        }
        else
        {
            SetPenBrushText(195, &dc, wxRED, LIGHT_RED, LIGHT_RED, wxRED, wxSOLID);
        }
        CreateEntry(195, 1, 284, 8, 46, 26, ip, port, wxT("Server"), &dc);
        ShowEntry(195, &dc);
        break;
    case 196:
        if (oldprefs01_opt[1])
        {
            SetPenBrushText(196, &dc, wxBLACK, wxLIGHT_GREY, wxLIGHT_GREY, wxBLACK, wxSOLID);
        }
        else
        {
            SetPenBrushText(196, &dc, wxRED, LIGHT_RED, LIGHT_RED, wxRED, wxSOLID);
        }
        CreateEntry(196, 1, 342, 8, 36, 26, ip, port, wxT("Files"), &dc);
        ShowEntry(196, &dc);
        break;
    case 197:
        if (oldprefs01_opt[1])
        {
            SetPenBrushText(197, &dc, wxBLACK, wxLIGHT_GREY, wxLIGHT_GREY, wxBLACK, wxSOLID);
        }
        else
        {
            SetPenBrushText(197, &dc, wxRED, LIGHT_RED, LIGHT_RED, wxRED, wxSOLID);
        }
        CreateEntry(197, 1, 390, 8, 70, 26, ip, port, wxT("Directories"), &dc);
        ShowEntry(197, &dc);
        break;
    case 198:
        if (oldprefs01_opt[1])
        {
            SetPenBrushText(198, &dc, wxBLACK, wxLIGHT_GREY, wxLIGHT_GREY, wxBLACK, wxSOLID);
        }
        else
        {
            SetPenBrushText(198, &dc, wxRED, LIGHT_RED, LIGHT_RED, wxRED, wxSOLID);
        }
        CreateEntry(198, 1, 472, 8, 58, 26, ip, port, wxT("Statistics"), &dc);
        ShowEntry(198, &dc);
        break;
    case 199:
        if (oldprefs01_opt[1])
        {
            SetPenBrushText(199, &dc, wxBLACK, wxLIGHT_GREY, wxLIGHT_GREY, wxBLACK, wxSOLID);
        }
        else
        {
            SetPenBrushText(199, &dc, wxRED, LIGHT_RED, LIGHT_RED, wxRED, wxSOLID);
        }
        CreateEntry(199, 1, 542, 8, 52, 26, ip, port, wxT("Tweaks"), &dc);
        ShowEntry(199, &dc);
        break;
#if 0 // TODO: Source Dropping Button PLK
    case 200:
        if (oldprefs01_opt[1])
        {
            SetPenBrushText(200, &dc, wxBLACK, wxLIGHT_GREY, wxLIGHT_GREY, wxBLACK, wxSOLID);
        }
        else
        {
            SetPenBrushText(200, &dc, wxRED, LIGHT_RED, LIGHT_RED, wxRED, wxSOLID);
        }
        CreateEntry(200, 1, 606, 8, 112, 26, ip, port, wxT("Sources Dropping"), &dc);
        ShowEntry(200, &dc);
        break;
#endif
    }
    if (lastindex)
    {
        switch (lastindex)
        {
        case 1:
            break;
        }
    }
    lastsocketnumber = socketnumber;
    lastindex = index;
}

