// This file is a part of the xMule Project.
//
// This file was a part of eMule
// Copyright (c) 2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef FLOWCHART_H
#define FLOWCHART_H

#include <wx/defs.h>		// Needed before any other wx/*.h
#include <wx/panel.h>		// Needed for wxPanel
#include <wx/combobox.h>	// Needed for wxComboBox
#include <wx/imaglist.h>	// Needed for wxImageList
#include <wx/timer.h>		// Needed for wxTimer and wxTimerEvent
#include <wx/statbmp.h>		// Needed for wxStaticBitmap
#include <wx/listbase.h>	// Needed for wxListEvent
#include <wx/gauge.h>		// Needed for wxGauge
#include <wx/notebook.h>	// Needed for wxNotebookEvent
#include <wx/scrolwin.h>	// Needed for wxScrollWindow
#include <wx/colordlg.h>        

#include "resource.h"		// Needed for IDD_FLOWCHART

class CFlowChart : public wxScrolledWindow 
{
    public:
    CFlowChart(wxWindow* pParent);
    ~CFlowChart();
	void OnMouseMove(wxMouseEvent &event);
	void OnPaint(wxPaintEvent &event);
	void OnTimer(wxTimerEvent &event);
	void CreateEntry(wxUint16 type,wxUint16 index,wxUint16 x,wxUint16 y,wxUint16 width,
			wxUint16 height,wxUint32 ip,wxUint16 port,wxString info,wxClientDC *dc);
	void ShowEntry(wxUint16 type,wxClientDC *dc);
	void Sync(wxUint32 socketnumber,wxUint16 index,
		wxUint32 ip,wxUint16 port,unsigned char *buffer);

    enum {
        IDD = IDD_FLOWCHART
    };

    private:
	void		Popup_NewPrefs(wxMouseEvent& evt);
	void		np01_CommandEvent(wxCommandEvent& evt);
	void		np02_OPfilerequest(wxCommandEvent& evt);
        void		np03_CommandEvent(wxCommandEvent& evt);
        void		np04_CommandEvent(wxCommandEvent& evt);
        void            op01_Use_eMule_file_Switch(wxCommandEvent& evt);
        void            op01_Write_eMule_file(wxCommandEvent& evt);
        void            op01_User_Mode(wxCommandEvent& evt);
        void            op02_Beep_on_Errors(wxCommandEvent& evt);
        void            op02_Bring_on_Front(wxCommandEvent& evt);
        void            op02_Downl_Doubleclick(wxCommandEvent& evt);
        void            op02_Minimize_Trayicon(wxCommandEvent& evt);
        void            op02_Enable_OnlineSig(wxCommandEvent& evt);
        void            op02_Confirm_Exit(wxCommandEvent& evt);
        void            op02_Start_CheckVersion(wxCommandEvent& evt);
        void            op02_Start_Splashscreen(wxCommandEvent& evt);
        void            op02_Start_Minimized(wxCommandEvent& evt);
        void            op02_Nick(wxCommandEvent& evt);
        void            op02_ToolTipDelay(wxCommandEvent& evt);
        void            op02_Update_Days(wxCommandEvent& evt);
        void            op02_Progress_Bar_Style(wxCommandEvent& evt);
        void            op02_SetOldPrefs(void);
        void            op03_Autoconnect(wxCommandEvent& evt);
        void            op03_Reconnect(wxCommandEvent& evt);
        void            op03_Show_Overhead(wxCommandEvent& evt);
        void            op03_Disable_UDP(wxCommandEvent& evt);
        void            op03_Download_Capacitie(wxCommandEvent& evt);
        void            op03_Upload_Capacitie(wxCommandEvent& evt);
        void            op03_Download_Limit(wxCommandEvent& evt);
        void            op03_Upload_Limit(wxCommandEvent& evt);
        void            op03_Client_Port(wxCommandEvent& evt);
        void            op03_UDP_Port(wxCommandEvent& evt);
        void            op03_Hard_Limit(wxCommandEvent& evt);
        void            op03_Max_Connection(wxCommandEvent& evt);
        void            op03_SetOldPrefs(void);
        void            op04_Remove_Dead_Server(wxCommandEvent& evt);
        void            op04_Filter_Server_IP(wxCommandEvent& evt);
        void            op04_Serverlist_Startup(wxCommandEvent& evt);
        void            op04_Serverlist_Server(wxCommandEvent& evt);
        void            op04_Serverlist_Clients(wxCommandEvent& evt);
        void            op04_Use_Priority_System(wxCommandEvent& evt);
        void            op04_Use_Smart_LowID_Check(wxCommandEvent& evt);
 	void            op04_Safe_Connect(wxCommandEvent& evt);
        void            op04_Connect_Static_List_only(wxCommandEvent& evt);
        void            op04_Manually_Server_High_prio(wxCommandEvent& evt);
        void            op04_Dead_Server_Retrys(wxCommandEvent& evt);
	void            op04_SetOldPrefs(void);
        void            op05_See_Share_Everybody(wxCommandEvent& evt);
        void            op05_See_Share_Friends(wxCommandEvent& evt);
        void            op05_See_Share_Noone(wxCommandEvent& evt);
        void            op05_ICH_Enabled(wxCommandEvent& evt);
        void            op05_Add_Files_Paused(wxCommandEvent& evt);
        void            op05_Preview_Prio(wxCommandEvent& evt);
        void            op05_Add_With_Auto_Priority(wxCommandEvent& evt);
        void            op05_Transfer_Full_Chunks(wxCommandEvent& evt);
        void            op05_Start_Next_File(wxCommandEvent& evt);
 	void            op05_SetOldPrefs(void);
        void            op06_Backup_Video_Preview(wxCommandEvent& evt);
        void            op06_Video_Player(wxCommandEvent& evt);
        void            op06_Incomming_Dir(wxCommandEvent &evt);
        void            op06_Temp_Dir(wxCommandEvent &evt);
        void            op06_Share_Folder(wxCommandEvent &evt);  
        void            op06_Unshare_Folder(wxCommandEvent &evt);
        void            op06_ScrollDown(wxCommandEvent &evt);
        void            op06_ScrollUp(wxCommandEvent &evt);
 	void            op06_SetOldPrefs(void);
        void            op07_Graph_Update_Delay(wxCommandEvent &evt);
        void            op07_Time_Average_Graph(wxCommandEvent &evt);
        void            op07_Statistic_Update_Delay(wxCommandEvent &evt);
        void            op07_Color_00(wxCommandEvent &evt);
        void            op07_Color_01(wxCommandEvent &evt);
        void            op07_Color_02(wxCommandEvent &evt);
        void            op07_Color_03(wxCommandEvent &evt);
        void            op07_Color_04(wxCommandEvent &evt);
        void            op07_Color_05(wxCommandEvent &evt);
        void            op07_Color_06(wxCommandEvent &evt);
        void            op07_Color_07(wxCommandEvent &evt);
        void            op07_Color_08(wxCommandEvent &evt);
        void            op07_Color_09(wxCommandEvent &evt);
        void            op07_Color_10(wxCommandEvent &evt);
        void            op07_Color_11(wxCommandEvent &evt);
        void            op07_Color_12(wxCommandEvent &evt);
        void            op07_Color_13(wxCommandEvent &evt);
        void            op07_Color_14(wxCommandEvent &evt);
        void            op07_Color_15(wxCommandEvent &evt);
        void            op07_SetOldPrefs(void);
        void            op08_Verbose(wxCommandEvent& evt);
        void            op08_ED2K_Only_Runtime(wxCommandEvent& evt);
        void            op08_Queuelist_Realtime(wxCommandEvent& evt);
        void            op08_Show_Transfer_Titel(wxCommandEvent& evt);
        void            op08_Max_Con_5Sec(wxCommandEvent& evt);
        void            op08_File_Buffer_Size(wxCommandEvent& evt);
        void            op08_Queue_Size(wxCommandEvent& evt);
        void            op08_SetOldPrefs(void);
        void            op_Color_Selection(int index);
        void            SetOldPrefs( void);
        void            WriteOldPrefs(void);
        void            ReadOldPrefs( void);

        wxWindow*	my_owner;
	wxUint32	lastindex; 
	wxUint32	lastsocketnumber;
private:
    void Init();
	
};

#endif // FLOWCHART_H

