// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (donate@xmule.org / http://xmule.hopto.org/)
// RSA-1024 Fingerprint: 4145 9DFD 5338 4FCC 1636  86E5 2E5A 42D8 BA13 460B
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.xmule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#ifndef SEARCHLIST_H
#define SEARCHLIST_H

#include "opcodes.h"
#include "xmule.h"
#include "types.h"
#include "Preferences.h"
#include "KnownFile.h"
#include "packets.h"
#include "otherfunctions.h"
#include "SafeFile.h"

class CSearchFile : public CAbstractFile {
	friend class CPartFile;
public:
	//CSearchFile() {};
	CSearchFile(char* data, wxUint32 nSearchID);
	CSearchFile(CFile* in_data, wxUint32 nSearchID, wxUint32 nServerIP=0, uint16 nServerPort=0, LPCTSTR pszDirectory = NULL);
	CSearchFile(wxUint32 nSearchID, const uchar* pucFileHash, wxUint32 uFileSize, char *pszFileName, int iFileType, int iAvailability);

	~CSearchFile();
	wxUint32	GetIntTagValue(uint8 tagname);
	char*	GetStrTagValue(uint8 tagname);
	wxUint32	AddSources(wxUint32 count);
	wxUint32	GetSourceCount();
	wxUint32	GetSearchID() {return m_nSearchID;}

	wxUint32	GetClientID() const	{ return m_nClientID; }
	void		SetClientID(wxUint32 nClientID)	{ m_nClientID = nClientID; }
	uint16	GetClientPort() const			{ return m_nClientPort; }
	void		SetClientPort(uint16 nPort)		{ m_nClientPort = nPort; }
	wxUint32	GetClientServerIP() const		{ return m_nClientServerIP; }
	void		SetClientServerIP(wxUint32 uIP)   	{ m_nClientServerIP = uIP; }
	uint16	GetClientServerPort() const		{ return m_nClientServerPort; }
	void		SetClientServerPort(uint16 nPort) { m_nClientServerPort = nPort; }
	int		GetClientsCount() const		{ return ((GetClientID() && GetClientPort()) ? 1 : 0) + m_aClients.GetSize(); }

	CSearchFile* GetListParent() const		{ return m_list_parent; }
	struct SClient {
		SClient() {
			m_nIP = m_nPort = m_nServerIP = m_nServerPort = 0;
		}
		SClient(wxUint32 nIP, unsigned int nPort, wxUint32 nServerIP, unsigned int nServerPort) {
			m_nIP = nIP;
			m_nPort = nPort;
			m_nServerIP = nServerIP;
			m_nServerPort = nServerPort;
		}
		wxUint32 m_nIP;
		wxUint32 m_nServerIP;
		uint16 m_nPort;
		uint16 m_nServerPort;
	};
	void AddClient(SClient* client) { m_aClients.Add(client); }
	const CArray<SClient*,SClient*>& GetClients() { return m_aClients; }

	struct SServer {
		SServer() {
			m_nIP = m_nPort = 0;
			m_uAvail = 0;
		}
		SServer(wxUint32 nIP, unsigned int nPort) {
			m_nIP = nIP;
			m_nPort = nPort;
			m_uAvail = 0;
		}
		wxUint32 m_nIP;
		uint16 m_nPort;
		unsigned int m_uAvail;
	};
	void AddServer(SServer* server) { m_aServers.Add(server); }
	const CArray<SServer*,SServer*>& GetServers() const { return m_aServers; }
	SServer* GetServer(int iServer) { return m_aServers[iServer]; }

private:
	uint8	clientip[4];
	uint16	clientport;
	wxUint32	m_nSearchID;
	CArray<CTag*,CTag*> taglist;

	wxUint32	m_nClientID;
	uint16	m_nClientPort;
	wxUint32	m_nClientServerIP;
	uint16	m_nClientServerPort;
	CArray<SClient*,SClient*> m_aClients;
	CArray<SServer*,SServer*> m_aServers;
	bool		 m_list_bExpanded;
	uint16	 m_list_childcount;
	CSearchFile* m_list_parent;
	bool		 m_bPreviewPossible;
	//CArray<CxImage*,CxImage*> m_listImages;
	char *m_pszDirectory;
};
#endif
