// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (donate@xmule.org / http://xmule.hopto.org/)
// RSA-1024 Fingerprint: 4145 9DFD 5338 4FCC 1636 86E5 2E5A 42D8 BA13 460B
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.xmule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifdef PRECOMP
#	include "xmule-headers.h"
#else
#	include "ClientList.h"
#	include "DownloadQueue.h"
#	include "KnownFile.h"
#	include "ListenSocket.h"
#	include "opcodes.h"
#	include "SearchDlg.h"
#	include "SearchList.h"
#	include "ServerSocket.h"
#	include "ServerWnd.h"
#	include "SharedFileList.h"
#	include "updownclient.h"
#	include "UploadQueue.h"
#	include "wintypes.h"
#	include "xmule.h"
#	include "xmuleDlg.h"
#endif

#include <time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
 /*
 BEGIN_EVENT_TABLE(CServerSocket,wxSocketClient);
 END_EVENT_TABLE()
 */

IMPLEMENT_DYNAMIC_CLASS(CServerSocket, CEMSocket)
CServerSocket:: CServerSocket(CServerConnect *in_serverconnect) { serverconnect = in_serverconnect; connectionstate = 0;
 cur_server = 0; info = ""; m_bIsDeleting = false; SetEventHandler( *theApp.xmuledlg, ID_SOKETTI); SetNotify(
wxSOCKET_CONNECTION_FLAG |wxSOCKET_INPUT_FLAG |wxSOCKET_OUTPUT_FLAG |wxSOCKET_LOST_FLAG); Notify(TRUE); }
CServerSocket:: ~CServerSocket() { SetNotify(0); Notify(FALSE); if (cur_server) delete cur_server; cur_server = NULL; }
#include <errno.h>
void CServerSocket:: OnConnect(int nErrorCode) { switch (errno) { case EINPROGRESS: { while (!WaitOnConnect(1, 0));
break; } case 0: { if (cur_server -> HasDynIP()) { struct sockaddr_in sockAddr; memset( &sockAddr, 0, 
sizeof(sockAddr)); uint32 nSockAddrLen = sizeof(sockAddr); wxIPV4address tmpaddr; GetPeer(tmpaddr); sockAddr.sin_addr
.s_addr = GAddress_INET_GetHostAddress(tmpaddr.GetAddress()); cur_server -> SetID(sockAddr.sin_addr.s_addr); theApp.
serverlist -> GetServerByAddress(cur_server -> GetAddress(), cur_server -> GetPort()) -> SetID(sockAddr.sin_addr.
s_addr); } SetConnectionState(CS_WAITFORLOGIN); break; } case E2BIG: { m_bIsDeleting = true; SetConnectionState(
CS_SERVERDEAD); serverconnect -> DestroySocket(this); break; } default: { m_bIsDeleting = true; SetConnectionState(
CS_FATALERROR); serverconnect -> DestroySocket(this); break; } } return; }
void CServerSocket:: OnInput(int nErrorCode) { if (connectionstate != CS_CONNECTED && !this -> serverconnect -> 
IsConnecting()) { serverconnect -> DestroySocket(this); } else { CEMSocket:: OnReceive(nErrorCode); } }
wxIPV4address ppaddr;
bool CServerSocket:: ProcessPacket(char *packet, int32 size, int8 opcode) { CServer *update; switch (opcode) { case 
OP_SERVERMESSAGE: { wxString strMessages =""; if (size >= 2) { wxUint16 uLen = * (wxUint16 *) packet; if (uLen > 
size - 2) { uLen = size - 2; } char * buffer = new char[uLen + 1]; memcpy(buffer, packet + 2, uLen); buffer[uLen] 
= 0; strMessages = wxString(buffer); int p = 0, iPos = 0; wxString message; do { iPos = strMessages.Find("\r\n"); 
 if (iPos >= 0) { message = strMessages.Left(iPos); strMessages = strMessages.Mid(iPos + 2); } else { message =
 strMessages; strMessages =""; } bool bOutputMessage = true; p = message.Find("server version"); if (p >= 0) { 
wxString strVer = message.Mid(p + 14); strVer.Trim(FALSE); strVer = strVer.Left(64); CServer * eserver = 
theApp.serverlist -> GetServerByAddress(cur_server -> GetAddress(), cur_server -> GetPort()); if (eserver) { 
theApp.xmuledlg -> serverwnd -> serverlistctrl -> RefreshServer(eserver); } } p = message.Find("ERROR"); if (p >= 0)
 { CServer * pServer = theApp.serverlist -> GetServerByAddress(cur_server -> GetAddress(), cur_server -> GetPort()); 
 theApp.xmuledlg -> AddLogLine(true, "%s %s (%s:%u) - %s", GetResString(IDS_ERROR) .GetData(), pServer ? pServer ->
 GetListName(): GetResString(IDS_PW_SERVER) .GetData(), cur_server -> GetAddress(), cur_server -> GetPort(), 
message.Mid(5) .Trim() .GetData()); bOutputMessage = false; } p = message.Find("WARNING"); if (p >= 0) { 
 CServer * pServer = theApp.serverlist -> GetServerByAddress(cur_server -> GetAddress(), cur_server -> GetPort()); 
theApp.xmuledlg -> AddLogLine(true, "%s %s (%s:%u) - %s", GetResString(IDS_WARNING) .GetData(), pServer ? pServer -> 
GetListName(): GetResString(IDS_PW_SERVER) .GetData(), cur_server -> GetAddress(), cur_server -> GetPort(), 
message.Mid(7) .Trim() .GetData()); bOutputMessage = false; } 
if (message.Find("[emDynIP: ") != ( - 1) && message.Find("]") != ( - 1) && message.Find("[emDynIP: ") < 
message.Find("]")) { wxString dynip = message.Mid(message.Find("[emDynIP: ") + 10, message.Find("]") - 
(message.Find("[emDynIP: ") + 10)); dynip.Trim(" "); if (dynip.Len() && dynip.Len() < 51) { CServer * eserver = 
theApp.serverlist -> GetServerByAddress(cur_server -> GetAddress(), cur_server -> GetPort()); if (eserver) { 
eserver -> SetDynIP((char *) dynip.GetData()); cur_server -> SetDynIP((char *) dynip.GetData()); theApp.xmuledlg -> 
serverwnd -> serverlistctrl -> RefreshServer(eserver); } } } if (bOutputMessage) { (void) GetPeer(ppaddr); theApp.xmuledlg -> AddServerMessageLine("%s:%d: %s", (const char *) ppaddr.IPAddress(), ppaddr.Service(), message.GetData()); } } while (iPos >= 0); delete buffer; } break; } case OP_IDCHANGE: { if (size >= sizeof(LoginAnswer_Struct)) { if (cur_server) { if (size >= 8) { cur_server->SetTCPFlags(*((uint32*)(packet + 4))); } else { cur_server->SetTCPFlags(0); } } LoginAnswer_Struct *la = (LoginAnswer_Struct *) packet; if (la -> clientid == 0) { uint8 state = theApp.glob_prefs -> GetSmartIdState(); if (state > 0) { state++; if (state > 3) theApp.glob_prefs -> SetSmartIdState(0); else theApp.glob_prefs -> SetSmartIdState(state); } break; } if (theApp.glob_prefs -> GetSmartIdCheck()) { if (la -> clientid >= 16777216) theApp.glob_prefs -> SetSmartIdState(1); else { uint8 state = theApp.glob_prefs -> GetSmartIdState(); if (state > 0) { state++; if (state > 3) theApp.glob_prefs -> SetSmartIdState(0); else theApp.glob_prefs -> SetSmartIdState(state); break; } } } if ((la -> clientid < 16777216) && (serverconnect -> GetLowIDTries() < 3)) { serverconnect -> IncrementLowIDTries(); SetConnectionState(CS_DISCONNECTED); theApp.xmuledlg -> ShowConnectionState(false); break; } serverconnect -> ResetLowIDTries(); serverconnect -> clientid = la -> clientid; if (connectionstate != CS_CONNECTED) { SetConnectionState(CS_CONNECTED); theApp.OnlineSig(); } serverconnect -> SetClientID(la -> clientid); theApp.xmuledlg -> AddLogLine(false, GetResString(IDS_NEWCLIENTID), la -> clientid); for (POSITION pos = theApp.downloadqueue -> filelist.GetHeadPosition() ; pos != NULL ; theApp.downloadqueue -> filelist.GetNext(pos)) { CPartFile *cur_file = theApp.downloadqueue -> filelist.GetAt(pos); if (cur_file -> GetStatus() == PS_READY) { cur_file -> ResumeFile(); } } theApp.downloadqueue -> filelist.GetCount(); } break; } case OP_SEARCHRESULT: { theApp.xmuledlg -> searchwnd -> SearchEnd((char *) packet, size, 0, 0); theApp.downloadqueue -> AddDownDataOverheadServer(size); break; } case OP_FOUNDSOURCES: { CMemFile *sources = new CMemFile((BYTE *) packet, size); uchar fileid[16]; sources -> Read(fileid, 16); if (CPartFile *file = theApp.downloadqueue -> GetFileByID(fileid)) file -> AddSources(sources, cur_server -> GetIP(), cur_server -> GetPort()); delete sources; break; } case OP_SERVERSTATUS: { if (size > 7) { uint32 cur_user; memcpy( &cur_user, packet, 4); uint32 cur_files; memcpy( &cur_files, packet + 4, 4); update = theApp.serverlist -> GetServerByAddress(cur_server -> GetAddress(), cur_server -> GetPort()); if (update) { update -> SetUserCount(cur_user); update -> SetFileCount(cur_files); theApp.xmuledlg -> ShowUserCount(cur_user, cur_files); theApp.xmuledlg -> serverwnd -> serverlistctrl -> RefreshServer(update); } } break; } case OP_SERVERIDENT: { unsigned char n_ServerHash[16]; wxUint32 n_ServerIP, nTags; wxUint16 n_ServerPort; CMemFile * data = new CMemFile((BYTE *) packet, size); if (size > 25) { int i = 0; data -> Read(n_ServerHash, 16); data -> Read( & n_ServerIP, 4); data -> Read( & n_ServerPort, 2); data -> Read( & nTags, 4); CServer * updateServer = theApp.serverlist -> GetServerByAddress(cur_server -> GetAddress(), cur_server -> GetPort()); if (updateServer) { while (i < nTags) { CTag * temptag = new CTag(data); if (temptag -> tag) { switch (temptag -> tag -> specialtag) { case ST_SERVERNAME: updateServer -> SetListName(temptag -> tag -> stringvalue); break; case ST_DESCRIPTION: updateServer -> SetDescription(temptag -> tag -> stringvalue); break; default: printf("ServerSocket_Process(0x41): unknown specialtag: %02x(%u)\n", temptag -> tag -> specialtag, temptag -> tag -> specialtag); break; } i++; } else { i = nTags; } delete temptag; } } theApp.xmuledlg -> ShowConnectionState(true, updateServer -> GetListName()); theApp.xmuledlg -> serverwnd -> serverlistctrl -> RefreshServer(updateServer); } delete data; break; } case OP_SERVERLIST: { { CSafeMemFile *servers = new CSafeMemFile((BYTE *) packet, size); unsigned char count; if ((1 != servers -> Read( &count, 1)) || ((int32)(count *6 + 1) > size)) count = 0; int addcount = 0; while (count) { uint32 ip; unsigned short port; if (4 != servers -> Read( &ip, 4)) break; if (2 != servers -> Read( &port, 2)) break; in_addr host; host.s_addr = ip; CServer *srv = new CServer(port, inet_ntoa(host)); srv -> SetListName(srv -> GetFullIP()); if (!theApp.xmuledlg -> serverwnd -> serverlistctrl -> AddServer(srv, true)) delete srv; else addcount++; count--; } delete servers; if (addcount) theApp.xmuledlg -> AddLogLine(false, GetResString(IDS_NEWSERVERS), addcount); } theApp.serverlist -> SaveServermetToFile(); break; } case OP_CALLBACKREQUESTED: { if (size == 6) { uint32 dwIP; memcpy( &dwIP, packet, 4); uint16 nPort; memcpy( &nPort, packet + 4, 2); CUpDownClient *client = theApp.clientlist -> FindClientByIP(dwIP, nPort); if (client) { (void) client -> TryToConnect(); } else { client = new CUpDownClient(nPort, dwIP, 0, 0, 0); theApp.clientlist -> AddClient(client); (void) client -> TryToConnect(); } } break; } default: { break; } } return true; }
void CServerSocket:: ConnectToServer(CServer *server) { cur_server = new CServer(server); theApp.xmuledlg -> 
AddLogLine(false, GetResString(IDS_CONNECTINGTO), cur_server -> GetListName(), cur_server -> GetFullIP(), cur_server -> 
GetPort()); SetConnectionState(CS_CONNECTING); wxIPV4address addr; addr.Hostname(server -> GetAddress()); 
addr.Service(server -> GetPort()); if (!this -> Connect(addr, FALSE)) { int error = errno; if (error != EINPROGRESS) {
 theApp.xmuledlg -> AddLogLine(false, GetResString(IDS_ERR_CONNECTIONERROR), cur_server -> GetListName(), cur_server ->
 GetFullIP(), cur_server -> GetPort(), error); SetConnectionState(CS_FATALERROR); return; } } info = server -> 
GetListName(); SetConnectionState(CS_CONNECTING); }
void CServerSocket:: OnLost(int nErrorCode) { SetConnectionState(CS_DISCONNECTED); }
void CServerSocket:: PacketReceived(Packet *packet) { if (packet -> prot == OP_PACKEDPROT) { uint32 uComprSize = packet
 -> size; if (!packet -> UnPackPacket(260000)) { theApp.downloadqueue -> AddDownDataOverheadServer(packet -> size); 
return; } packet -> prot = OP_EDONKEYPROT; ProcessPacket(packet -> pBuffer, packet -> size, packet -> opcode); } else 
if(packet -> prot == OP_EDONKEYPROT) { ProcessPacket(packet -> pBuffer, packet -> size, packet -> opcode); } else { 
theApp.downloadqueue -> AddDownDataOverheadServer(packet -> size); } }
void CServerSocket:: OnClose(int nErrorCode) { CEMSocket:: OnClose(0); if (connectionstate == CS_CONNECTING) { 
SetConnectionState(CS_SERVERFULL); } else if(connectionstate == CS_CONNECTED) { SetConnectionState(CS_DISCONNECTED); }
 else { SetConnectionState(CS_NOTCONNECTED); } serverconnect -> DestroySocket(this); }
void CServerSocket:: SetConnectionState(sint8 newstate) { connectionstate = newstate; if (newstate < 1) { serverconnect
-> ConnectionFailed(this); } else if(newstate == CS_CONNECTED || newstate == CS_WAITFORLOGIN) { if (serverconnect) { 
serverconnect -> ConnectionEstablished(this); } } }

