// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef CMEMFILE_H
#define CMEMFILE_H 1

// something that looks like the MFC CMemFile

#include "wintypes.h"                   // Needed for BYTE
#include "CFile.h"                      // Needed for CFile

class CMemFile : public CFile {
public:  
	CMemFile(unsigned int growBytes=1024);
	CMemFile(BYTE* buffer,unsigned int bufferSize,unsigned int growBytes=0);
	void Attach(BYTE* buffer,unsigned int buffserSize,unsigned int growBytes=0);
	BYTE* Detach();
	virtual ~CMemFile();
	virtual unsigned long GetPosition() {return fPosition;};
	virtual bool GetStatus(unsigned long none) const {return 1;};
	off_t Seek(off_t offset,wxSeekMode from=wxFromStart);
	virtual void SetLength(unsigned long newLen);
	unsigned long GetLength() { return fFileSize; };
	off_t Read(void* buf,off_t length);
	size_t Write(const void* buf,size_t length);
//	virtual void Abort();
//	virtual void Flush();
	virtual bool Close();

private:
	void enlargeBuffer(unsigned long size);
	
	unsigned long fLength;
	unsigned int fGrowBytes;
	unsigned long fPosition;
	unsigned long fBufferSize;
	unsigned long fFileSize;
	int deleteBuffer;
	BYTE* fBuffer;
};

#endif
