// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//this file was part of eMule created by Ornis

#ifdef PRECOMP
    #include "xmule-headers.h"
#endif

#include "CatDialog.h"                      // Needed for this Interface's Prototype

#include "otherfunctions.h"                 // Needed for GetResString
#include "SharedFileList.h"                 // Needed for CSharedFileList
#include "TransferWnd.h"                    // Needed for CTransferWnd
#include "xmule.h"                          // Needed for theApp
#include "xmuleDlg.h"                       // Needed for CxmuleDlg

#include <wx/colordlg.h>                    // Needed for wxGetColourFromUser
#include <wx/dcmemory.h>                    // Needed for wxMemoryDC
#include <wx/dirdlg.h>                      // Needed for wxDirSelector
#include <wx/textctrl.h>                    // Needed for wxTextCtrl
#include "wx/xrc/xmlres.h"                  // Needed for wxXmlResource

#define GetDlgItem(x,clas) XRCCTRL(*this,#x,clas)
#define IsDlgButtonChecked(x) XRCCTRL(*this,#x,wxCheckBox)->GetValue()
#define CheckDlgButton(x,y) XRCCTRL(*this,#x,wxCheckBox)->SetValue(y)

// these should be in some global .h file
#define GetRValue(rgb) (((rgb)>>16)&0xff)
#define GetGValue(rgb) (((rgb)>>8)&0xff)
#define GetBValue(rgb) ((rgb)&0xff)

#define RGB(a,b,c) ((a&0xff)<<16|(b&0xff)<<8|(c&0xff))

// CCatDialog dialog

IMPLEMENT_DYNAMIC_CLASS(CCatDialog, wxDialog)

CCatDialog::CCatDialog(wxWindow *parent, int index)
: wxDialog(parent, CCatDialog::IDD, _("Category"),
wxDefaultPosition, wxDefaultSize,
wxDEFAULT_DIALOG_STYLE |wxSYSTEM_MENU)
{
    wxPanel *content = wxXmlResource::Get()->LoadPanel(this, "DLG_CAT");
    SetSize(content->GetSize());
    //    content->SetBackgroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_WINDOW));
    Center();
    m_myCat = theApp.glob_prefs->GetCategory(index);
    // bwah?:
    if (m_myCat == NULL) return;
}

BOOL CCatDialog::OnInitDialog()
{
    //CDialog::OnInitDialog();
    m_prio = XRCCTRL( *this, "IDC_PRIOCOMBO", wxComboBox);
    // replace the catcolor button with bitmapbutton
    wxButton *btn = GetDlgItem(IDC_CATCOLOR, wxButton);
    wxPoint pos = btn->GetPosition();
    wxSize siz = btn->GetSize();
    btn->Destroy();
    m_bitmap = new wxBitmap(16, 16);
    // create own
    mkBitmap( *m_bitmap);
    //wxBitmapButton* newbtn=new wxBitmapButton((wxWindow*)this,XRCID("IDC_CATCOLOR"),
    //					    bmp,pos,siz,wxBU_AUTODRAW);
    mmMultiButton *newbtn = new mmMultiButton(this, XRCID("IDC_CATCOLOR"),
    wxEmptyString, *m_bitmap,
    pos, siz,
    mmMB_AUTODRAW);
    m_ctlColor = newbtn;
    Localize();
    UpdateData();
    return true;
}

void CCatDialog::UpdateData()
{
    CString buffer;
    buffer.Format("%s", m_myCat->title);
    GetDlgItem(IDC_TITLE, wxTextCtrl)->SetValue(buffer);
    buffer.Format("%s", m_myCat->incomingpath);
    GetDlgItem(IDC_INCOMING, wxTextCtrl)->SetValue(buffer);
    buffer.Format("%s", m_myCat->comment);
    GetDlgItem(IDC_COMMENT, wxTextCtrl)->SetValue(buffer);
    //COLORREF selcolor=m_myCat->color;
    newcolor = m_myCat->color;
    mkBitmap( *m_bitmap);
    m_ctlColor->SetDefaultBitmap((wxBitmap &) *m_bitmap);
    //m_ctlColor.SetColor(selcolor);
    m_prio->SetSelection(m_myCat->prio);
}

CCatDialog::~CCatDialog()
{
}

#if 0
void CCatDialog::DoDataExchange(CDataExchange *pDX)
{
    CDialog::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_CATCOLOR, m_ctlColor);
    DDX_Control(pDX, IDC_PRIOCOMBO, m_prio);
}

BEGIN_MESSAGE_MAP(CCatDialog, CDialog)
ON_BN_CLICKED(IDC_BROWSE, OnBnClickedBrowse)
ON_BN_CLICKED(IDOK, OnBnClickedOk)
//CPN_SELCHANGE:
ON_MESSAGE(CPN_SELENDOK, OnSelChange)
END_MESSAGE_MAP()
#endif

BEGIN_EVENT_TABLE(CCatDialog, wxDialog)
EVT_BUTTON(wxID_OK, CCatDialog::OnBnClickedOk)
EVT_BUTTON(XRCID("IDC_CATCOLOR"), CCatDialog::OnBnClickColor)
EVT_BUTTON(XRCID("IDC_BROWSE"), CCatDialog::OnBnClickedBrowse)
END_EVENT_TABLE()

// CCatDialog message handlers

void CCatDialog::Localize()
{
    GetDlgItem(IDC_STATIC_TITLE, wxControl)->SetLabel(GetResString(IDS_TITLE));
    GetDlgItem(IDC_STATIC_INCOMING, wxControl)->SetLabel(GetResString(IDS_PW_INCOMING));
    GetDlgItem(IDC_STATIC_COMMENT, wxControl)->SetLabel(GetResString(IDS_COMMENT));
    // for some reason, this wont be found
    //GetDlgItem(ID_CANCEL,wxControl)->SetLabel(GetResString(IDS_CANCEL));
    GetDlgItem(IDC_STATIC_COLOR, wxControl)->SetLabel(GetResString(IDS_COLOR));
    GetDlgItem(IDC_STATIC_PRIO, wxControl)->SetLabel(GetResString(IDS_STARTPRIO));
    //m_ctlColor.CustomText = _T(GetResString(IDS_COL_MORECOLORS));
    //m_ctlColor.DefaultText = _T(GetResString(IDS_DEFAULT));
    //m_ctlColor.SetDefaultColor(NULL);
    //SetWindowText(GetResString(IDS_EDITCAT));
    SetTitle(GetResString(IDS_EDITCAT));
    while (m_prio->GetCount() > 0) m_prio->Delete(0);
    m_prio->Append(GetResString(IDS_DONTCHANGE));
    m_prio->Append(GetResString(IDS_PRIOLOW));
    m_prio->Append(GetResString(IDS_PRIONORMAL));
    m_prio->Append(GetResString(IDS_PRIOHIGH));
    m_prio->Append(GetResString(IDS_PRIOAUTO));
    m_prio->SetSelection(m_myCat->prio);
}

void CCatDialog::OnBnClickedBrowse(wxCommandEvent &evt)
{
#if 0
    char buffer[MAX_PATH];
    if (SelectDir(GetSafeHwnd(), buffer, GetResString(IDS_SELECT_INCOMINGDIR)))
    GetDlgItem(IDC_INCOMING)->SetWindowText(buffer);
#endif
    wxString dir = wxDirSelector(GetResString(IDS_SELECT_INCOMINGDIR),
    GetDlgItem(IDC_INCOMING, wxTextCtrl)->GetValue());
    if (!dir.IsEmpty())
    {
        GetDlgItem(IDC_INCOMING, wxTextCtrl)->SetValue(dir);
    }
}

void CCatDialog::OnBnClickedOk(wxCommandEvent &evt)
{
    CString oldpath = CString(m_myCat->incomingpath);
    if (GetDlgItem(IDC_TITLE, wxTextCtrl)->GetValue() .Length() > 0)
    strncpy(m_myCat->title, GetDlgItem(IDC_TITLE, wxTextCtrl)->GetValue(), 64);
    if (GetDlgItem(IDC_INCOMING, wxTextCtrl)->GetValue() .Length() > 1)
    strncpy(m_myCat->incomingpath, GetDlgItem(IDC_INCOMING, wxTextCtrl)->GetValue(), MAX_PATH);
    //GetDlgItem(IDC_COMMENT)->GetWindowText(m_myCat->comment,255);
    strncpy(m_myCat->comment, GetDlgItem(IDC_COMMENT, wxTextCtrl)->GetValue(), 255);
    MakeFoldername(m_myCat->incomingpath);
    if (!::wxDirExists(m_myCat->incomingpath)) wxMkdir(m_myCat->incomingpath, 0777);
    if (CString(m_myCat->incomingpath) .CmpNoCase(oldpath) != 0)
    {
        theApp.sharedfiles->AddFilesFromDirectory(m_myCat->incomingpath);
        theApp.sharedfiles->Reload();
    }
    m_myCat->color = newcolor;
    m_myCat->prio = m_prio->GetSelection();
    theApp.xmuledlg->transferwnd->downloadlistctrl->Refresh();
    EndModal(0);
    //OnOK();
}

#if 0
LONG CCatDialog::OnSelChange(UINT lParam, LONG wParam)
{
    if (lParam == CLR_DEFAULT)
    newcolor = 0;
    else
    newcolor = m_ctlColor.GetColor();
    return TRUE;
}

#endif

void CCatDialog::mkBitmap(wxBitmap &bmp)
{
    wxMemoryDC dc;
    dc.SelectObject(bmp);
    wxBrush *suti = wxTheBrushList->FindOrCreateBrush(wxColor(GetBValue(newcolor), GetGValue(newcolor), GetRValue(newcolor)), wxSOLID);
    dc.SetBrush( *suti);
    dc.DrawRectangle(0, 0, 16, 16);
    dc.SetBrush(wxNullBrush);
    dc.SelectObject(wxNullBitmap);
}

void CCatDialog::OnBnClickColor(wxCommandEvent &evt)
{
    wxColour newcol = wxGetColourFromUser(this, wxColour(GetBValue(newcolor), GetGValue(newcolor), GetRValue(newcolor)));
    if (newcol.Ok())
    {
        newcolor = RGB(newcol.Blue(), newcol.Green(), newcol.Red());
        mkBitmap( *m_bitmap);
        m_ctlColor->SetDefaultBitmap( *m_bitmap);
    }
}

