// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef CLIENTCRED_H
#define CLIENTCRED_H

#include "Preferences.h"                // Needed for CPreferences

#if USE_CRYPTO 
#   include <cryptopp/cryptlib.h>
#   include <cryptopp/rsa.h>
#   define CryptoXMpp CryptoPP
#else
#   include "CryptoXMpp.h"              // Needed for CrytoXMpp
#endif

/* winemaker: #pragma pack(1) */
#define		MAXPUBKEYSIZE		80

#define		CRYPT_CIP_REMOTECLIENT	10
#define		CRYPT_CIP_LOCALCLIENT	20
#define		CRYPT_CIP_NONECLIENT	30

#pragma pack(1)
struct CreditStruct_29a{
	uchar		abyKey[16];
	uint32		nUploadedLo;	// uploaded TO him
	uint32		nDownloadedLo;	// downloaded from him
	uint32		nLastSeen;
	uint32		nUploadedHi;	// upload high 32
	uint32		nDownloadedHi;	// download high 32
	uint16		nReserved3;
};
struct CreditStruct{
	uchar		abyKey[16];
	uint32		nUploadedLo;	// uploaded TO him
	uint32		nDownloadedLo;	// downloaded from him
	uint32		nLastSeen;
	uint32		nUploadedHi;	// upload high 32
	uint32		nDownloadedHi;	// download high 32
	uint16		nReserved3;
	uint8		nKeySize;
	uchar		abySecureIdent[MAXPUBKEYSIZE];
};
#pragma pack()

enum EIdentState {
	IS_NOTAVAILABLE,
	IS_IDNEEDED,
	IS_IDENTIFIED,
	IS_IDFAILED,
	IS_IDBADGUY,
};

class CClientCredits
{
	friend class CClientCreditsList;
public:
	CClientCredits(CreditStruct* in_credits);
	CClientCredits(uchar* key);
	~CClientCredits();

	uchar*	GetKey()						{return m_pCredits->abyKey;}
	uchar*  GetSecureIdent()			{return m_abyPublicKey;}
	uint8	GetSecIDKeyLen()			{return m_nPublicKeyLen;}
	CreditStruct* GetDataStruct()			{return m_pCredits;}
	void	ClearWaitStartTime();
	void	AddDownloaded(uint32 bytes, uint32 dwForIP);
	void	AddUploaded(uint32 bytes, uint32 dwForIP);
	uint64	GetUploadedTotal();
	uint64	GetDownloadedTotal();
	float	GetScoreRatio(uint32 dwForIP);
	float	GetMyScoreRatio(uint32 dwForIP); //added by sivka [VQB: -ownCredits-]
	void	SetLastSeen()				{m_pCredits->nLastSeen = time(NULL);}
	bool	SetSecureIdent(uchar* pachIdent,uint8 nIdentLen);
	void	ShowCHandPK(uint32 challenge,unsigned char *publickey,int length);

	uint32	m_dwCryptRndChallengeFor;
	uint32	m_dwCryptRndChallengeFrom;
	EIdentState	GetCurrentIdentState(wxUint32 dwForIP);

	uint32		GetSecureWaitStartTime(uint32 dwForIP);
	void		SetSecWaitStartTime(uint32 dwForIP);
protected:
	void		Verified(uint32 dwForIP);
	EIdentState	IdentState;
private:
	void 		InitalizeIdent();
	CreditStruct*	m_pCredits;
	BYTE		m_abyPublicKey[80];
	uint8		m_nPublicKeyLen;
	uint32		m_dwIdentIP;
	uint32		m_dwWaitTime;
	uint32		m_dwSecureWaitTime;
	uint32		m_dwUnSecureWaitTime;
	uint32		m_dwWaitTimeIP;
};

class CClientCreditsList
{
public:
	CClientCreditsList(CPreferences* in_prefs);
	~CClientCreditsList();
	
	// return signature size, 0 = Failed | use sigkey param for debug only
	uint8 CreateSignature(CClientCredits* pTarget, uchar* pachOutput, uint8 nMaxSize, uint32 ChallengeIP, uint8 byChaIPKind);
					//CryptoXMpp::RSASSA_PKCS1v15_SHA_Signer* sigkey = NULL);
	bool VerifyIdent(CClientCredits* pTarget, uchar* pachSignature, uint8 nInputSize, uint32 dwForIP, uint8 byChaIPKind);	
	CClientCredits* GetCredit(uchar* key);

	void Process();
	uint8 GetPubKeyLen()					{ return m_nMyPublicKeyLen; }
	BYTE* GetPublicKey()					{ return m_abyMyPublicKey; }
	bool CryptoAvailable();
protected:
	void LoadList();
	void SaveList();
	void InitalizeCrypting();
	void CreateKeyPair();
private:
	CPreferences*	m_pAppPrefs;
	uint32			m_nLastSaved;
	CryptoXMpp::RSASSA_PKCS1v15_SHA_Signer*		m_pSignkey;
	BYTE			m_abyMyPublicKey[80];
	uint8			m_nMyPublicKeyLen;
};

#endif
