// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

//#include "stdafx.h"

#ifdef PRECOMP
    #include "xmule-headers.h"
#endif

#include "ClientList.h"                     // Needed for this Interface's Prototype

#include "DownloadQueue.h"                  // Needed for CDownloadQueue
#include "ListenSocket.h"                   // Needed for CClientReqSocket
#include "UploadQueue.h"                    // Needed for CUploadQueue
#include "xmule.h"                          // Needed for theApp

MAP * listof_UpDownClients = NULL;

CClientList::CClientList()
{
}

CClientList::~ CClientList()
{
}

// xrmb : statsclientstatus
void CClientList::GetStatistics(uint32 & totalclient, int stats[], CMap <uint8, uint8, uint32, uint32 > * clientStatus, CMap <uint16, uint16, uint32, uint32 > * clientVersionEDonkey, CMap <uint16, uint16, uint32, uint32 > * clientVersionEDonkeyHybrid, CMap <uint8, uint8, uint32, uint32 > * clientVersionEMule)
{
    //if(clientStatus)		clientStatus->RemoveAll();
    totalclient = listof_UpDownClients->Data;
    if (clientVersionEDonkey)
    {
        clientVersionEDonkey->RemoveAll();
    }
    if (clientVersionEMule)
    {
        clientVersionEMule->RemoveAll();
    }
    for (int i = 0 ; i < 8 ; i++)
    {
        stats[i] = 0;
    }
    CUpDownClient * cur_client;
    MAP * pos;
    pos = listof_UpDownClients->next;
    while (pos->Key)
    {
        cur_client = (CUpDownClient *) pos->Data;
        switch (cur_client->GetClientSoft())
        {
        case SO_UNKNOWN: stats[0]++;
            break;
        case SO_EDONKEY:
            stats[1]++;
            if (clientVersionEDonkey)
            ( * clientVersionEDonkey) [cur_client->GetVersion() ]++;
            break;
        case SO_EDONKEYHYBRID:
            stats[4]++;
            if (clientVersionEDonkeyHybrid)
            ( * clientVersionEDonkeyHybrid) [cur_client->GetVersion() ]++;
            break;
        case SO_EMULE:
        case SO_OLDEMULE:
            stats[2]++;
            if (clientVersionEMule)
            {
                uint8 version = cur_client->GetMuleVersion();
                ( * clientVersionEMule) [version]++;
            }
            break;
            //Didn't get much time to test this "xMule Compatable" feature.:
        case SO_CDONKEY:
            stats[5]++;
            break;
        case SO_AMULE:
        case SO_SHAREAZA:
        case SO_XMULE:
            stats[6]++;
            break;
        case SO_MLDONKEY:
            stats[3]++;
            break;
        case SO_NEW_MLDONKEY:
            stats[7]++;
            break;
        }
        pos = pos->next;
    }
}

void CClientList::AddClient(CUpDownClient * toadd, bool bSkipDupTest)
{
    bool found = false;
    if (!bSkipDupTest)
    {
        MAP * pos;
        pos = listof_UpDownClients->next;
        while (pos->Key && (!found))
        {
            if (toadd == (CUpDownClient *) pos->Data)
            {
                found = true;
            }
            else
            {
                pos = pos->next;
            }
        }
    }
    if (!found)
    {
        //faz:printf("CClientList::AddClient(%u): %u\n", listof_UpDownClients->Data, (uint32) toadd);
        MapData_Insert(listof_UpDownClients, toadd, toadd, 4);
    }
}

void CClientList::RemoveClient(CUpDownClient * toremove)
{
    bool found = false;
    MAP * pos;
    pos = listof_UpDownClients->next;
    while (pos->Key && (!found))
    {
        if (toremove == (CUpDownClient *) pos->Data)
        {
            found = true;
            theApp.uploadqueue->RemoveFromUploadQueue(toremove);
            theApp.uploadqueue->RemoveFromWaitingQueue(toremove);
            theApp.downloadqueue->RemoveSource(toremove);
            //printf("CClientList::RemoveClient(%u): %u\n", listof_UpDownClients->Data, (wxUint32) toremove);
            pos = MapData_Remove(listof_UpDownClients, pos);
        }
        else
        {
            pos = pos->next;
        }
    }
}

void CClientList::DeleteAll()
{
    CUpDownClient * cur_client = NULL;
    theApp.uploadqueue->DeleteAll();
    theApp.downloadqueue->DeleteAll();
    MAP * pos;
    pos = listof_UpDownClients->next;
    while (pos->Key)
    {
        cur_client = (CUpDownClient*)pos->Data;
        pos = MapData_Remove(listof_UpDownClients, pos);
        (void) cur_client->Disconnected();
    }
}

bool CClientList::AttachToAlreadyKnown(CUpDownClient ** client, CClientReqSocket * sender)
{
    bool found = false;
    //faz:printf("CClientList::AttachToAlreadyKnown_start(%u): ", * ((uint32 *) client));
    CUpDownClient * tocheck = ( * client);
    CUpDownClient * cur_client = NULL;
    MAP * pos;
    pos = listof_UpDownClients->next;
    while (pos->Key && (!found))
    {
        cur_client = (CUpDownClient*)pos->Data;
        if (tocheck == cur_client)
        {
            found = true;
        }
        else if(tocheck->Compare(cur_client))
        {
            if (sender)
            {
                if (cur_client->socket)
                {
                    cur_client->socket->deletethis = true;
                }
                delete tocheck;
                tocheck = NULL;
                cur_client->socket = sender;
                * client = cur_client;
                found = true;
            }
        }
        pos = pos->next;
    }
    if (found)
    {
        return true;
    }
    else
    {
        return false;
    }
}

CUpDownClient * CClientList::FindClientByIP(uint32 clientip, uint16 port)
{
    CUpDownClient * cur_client = NULL;
    MAP * pos;
    pos = listof_UpDownClients->next;
    while (pos->Key)
    {
        cur_client = (CUpDownClient*)pos->Data;
        if (cur_client->GetIP() == clientip)
        {
            if (cur_client->GetUserPort() == port)
            {
                return cur_client;
            }
        }
        pos = pos->next;
    }
    return NULL;
}

CUpDownClient * CClientList::FindClientByUserHash(uchar * clienthash)
{
    CUpDownClient * cur_client = NULL;
    MAP * pos;
    pos = listof_UpDownClients->next;
    while (pos->Key)
    {
        cur_client = (CUpDownClient*)pos->Data;
        if (md4cmp(cur_client->GetUserHash(), clienthash))
        {
            return cur_client;
        }
        pos = pos->next;
    }
    return NULL;
}

