// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifdef PRECOMP
    #include "xmule-headers.h"
#endif

#include "CommentDialog.h"                  // Needed for this Interface's Prototype

#include "KnownFile.h"                      // Needed for CKnownFile
#include "otherfunctions.h"                 // Needed for GetResString
#include "xmule.h"                          // Needed for GetColor

#include <wx/combobox.h>                    // Needed for wxComboBox
#include <wx/panel.h>                       // Needed for wxPanel
#include <wx/textctrl.h>                    // Needed for wxTextCtrl
#include <wx/xrc/xmlres.h>                  // Needed for wxXmlResource

#define GetDlgItem(x,clas) XRCCTRL(*this,#x,clas)
#define IsDlgButtonChecked(x) XRCCTRL(*this,#x,wxCheckBox)->GetValue()
#define CheckDlgButton(x,y) XRCCTRL(*this,#x,wxCheckBox)->SetValue(y)

CCommentDialog::CCommentDialog(wxWindow *parent, CKnownFile *file):
    wxDialog(parent, CCommentDialog::IDD, _("File Comments"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE |wxSYSTEM_MENU)
{
    m_file = file;
    wxPanel *content = wxXmlResource::Get()->LoadPanel(this, "DLG_COMMENT");
    SetSize(content->GetSize());
    content->SetBackgroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_WINDOWFRAME));
    Center();
    ratebox = XRCCTRL( *this, "IDC_RATELIST", wxComboBox);
    OnInitDialog();
}

CCommentDialog::~CCommentDialog()
{
}

BEGIN_EVENT_TABLE(CCommentDialog, wxDialog)
EVT_BUTTON(XRCID("IDCOK"), CCommentDialog::OnBnClickedApply)
EVT_BUTTON(XRCID("IDCCANCEL"), CCommentDialog::OnBnClickedCancel)
END_EVENT_TABLE()

void CCommentDialog::OnBnClickedApply(wxEvent &evt)
{
    wxString SValue;
    SValue = GetDlgItem(IDC_CMT_TEXT, wxTextCtrl)->GetValue();
    m_file->SetFileComment(CString(SValue));
    m_file->SetFileRate((int8) ratebox->GetSelection());
    EndModal(0);
}

void CCommentDialog::OnBnClickedCancel(wxEvent &evt)
{
    EndModal(0);
}

BOOL CCommentDialog::OnInitDialog()
{
    Localize();
    GetDlgItem(IDC_CMT_TEXT, wxTextCtrl)->SetValue(m_file->GetFileComment());
    GetDlgItem(IDC_CMT_TEXT, wxTextCtrl)->SetMaxLength(50);
    return TRUE;
}

void CCommentDialog::Localize(void)
{
    GetDlgItem(IDCOK, wxControl)->SetLabel(GetResString(IDS_PW_APPLY));
    GetDlgItem(IDCCANCEL, wxControl)->SetLabel(GetResString(IDS_CANCEL));
    GetDlgItem(IDC_CMT_LQUEST, wxControl)->SetLabel(GetResString(IDS_CMT_QUEST));
    GetDlgItem(IDC_CMT_LAIDE, wxControl)->SetLabel(GetResString(IDS_CMT_AIDE));
    //for rate//
    GetDlgItem(IDC_RATEQUEST, wxControl)->SetLabel(GetResString(IDS_CMT_RATEQUEST));
    GetDlgItem(IDC_RATEHELP, wxControl)->SetLabel(GetResString(IDS_CMT_RATEHELP));
    while (ratebox->GetCount() > 0)
    {
        ratebox->Delete(0);
    }
    ratebox->Append(GetResString(IDS_CMT_NOTRATED));
    ratebox->Append(GetResString(IDS_CMT_FAKE));
    ratebox->Append(GetResString(IDS_CMT_POOR));
    ratebox->Append(GetResString(IDS_CMT_GOOD));
    ratebox->Append(GetResString(IDS_CMT_FAIR));
    ratebox->Append(GetResString(IDS_CMT_EXCELLENT));
    ratebox->SetSelection(m_file->GetFileRate());
    //--end rate--//
    wxString strTitle;
    strTitle.Printf(GetResString(IDS_CMT_TITLE), m_file->GetFileName());
    SetTitle(strTitle);
}

