// This file is part of xmule.
//
// Copyright (C) 2004 Carlo Wood
//
// Carlo Wood, Run on IRC <carlo@alinoe.com>
// RSA-1024 0x624ACAD5 1997-01-26                    Sign & Encrypt
// Fingerprint16 = 32 EC A7 B6 AC DB 65 A6  F6 F6 55 DD 1C DC FF 61
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef CXMULEAPPBASE_H
#define CXMULEAPPBASE_H

#if defined(__WXMSW__)
#include <wx/msw/winundef.h>      // THIS IS NEEDED OR ERRORS RESULT!!
#endif

#include <wx/defs.h>              // Needed for wxWidgets types
#include <wx/app.h>               // Needed for wxApp
#include <wx/string.h>            // Needed for wxString

class CxmuleDlg;
class CPreferences;
class CDownloadQueue;
class CUploadQueue;
class CServerConnect;
class CSharedFileList;
class CServerList;
class CListenSocket;
class CClientList;
class CKnownFileList;
class CSearchList;
class CClientCreditsList;
class CClientUDPSocket;
class CFriendList;
class CIPFilter;

#ifndef theApp
#define theApp (*((CxmuleAppBase*)wxTheApp))
#endif

// These elements are accessed directly through "theApp.xmuledlg" etc.
// If you need other theApp members then #include "xmule.h".
class CxmuleAppBase : public wxApp
{
public:
    wxString const& GetAppPath() const { return m_AppPath; }
    wxString const& GetConfigPath() const { return m_ConfigPath; }

    void SetAppPath(wxString const& NewPath) { m_AppPath = NewPath; }
    void SetConfigPath(wxString const& NewPath) { m_ConfigPath = NewPath; }

    CxmuleDlg*          xmuledlg;
    CPreferences*       glob_prefs;
    CDownloadQueue*     downloadqueue;
    CUploadQueue*       uploadqueue;
    CServerConnect*     serverconnect;
    CSharedFileList*    sharedfiles;
    CServerList*        serverlist;
    CListenSocket*      listensocket;
    CClientList*        clientlist;
    CKnownFileList*     knownfiles;
    CSearchList*        searchlist;
    CClientCreditsList* clientcredits;
    CClientUDPSocket*   clientudp;
    CFriendList*        friendlist;
    CIPFilter*          ipfilter;

private:
    wxString m_AppPath;
    wxString m_ConfigPath;
};

#endif // CXMULEAPPBASE_H
