// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifdef PRECOMP
#	include "xmule-headers.h"
#endif

#include <signal.h>                         // Needed for SIGPIPE

#include "EMSocket.h"                       // Needed for this Interface's Prototype

#ifndef MAX_SIZE
#	define MAX_SIZE 2000000
#endif

IMPLEMENT_DYNAMIC_CLASS(CEMSocket, wxSocketClient)

CEMSocket::CEMSocket(void): wxSocketClient(wxSOCKET_NOWAIT) /*wxSOCKET_BLOCK*/
{
    byConnected = ES_NOTCONNECTED;
    limitenabled = false;
    downloadlimit = 0;
    pendingOnReceive = false;
    // Download partial header
    // memset(pendingHeader, 0, sizeof(pendingHeader));
    pendingHeaderSize = 0;
    // Download partial packet
    pendingPacket = NULL;
    pendingPacketSize = 0;
    sendbuffer = 0;
    sendblen = 0;
    sent = 0;
    m_bLinkedPackets = false;
}

CEMSocket::~ CEMSocket()
{
    SetNotify(0);
    Notify(FALSE);
    ClearQueues();
    OnClose(0);
}

void CEMSocket::ClearQueues()
{
    for (POSITION pos = controlpacket_queue.GetHeadPosition() ; pos != 0 ; controlpacket_queue.GetNext(pos))
    delete controlpacket_queue.GetAt(pos);
    controlpacket_queue.RemoveAll();
    for (POSITION pos = standartpacket_queue.GetHeadPosition() ; pos != 0 ; standartpacket_queue.GetNext(pos))
    delete standartpacket_queue.GetAt(pos);
    standartpacket_queue.RemoveAll();
    limitenabled = false;
    downloadlimit = 0;
    pendingOnReceive = false;
    // Download partial header
    // memset(pendingHeader, 0, sizeof(pendingHeader));
    pendingHeaderSize = 0;
    // Download partial packet
    if (pendingPacket != NULL)
    {
        delete pendingPacket;
        pendingPacket = NULL;
        pendingPacketSize = 0;
    }
    if (sendbuffer != NULL)
    {
        delete[] sendbuffer;
        sendbuffer = NULL;
    }
    //sendbuffer = 0;
    sendblen = 0;
    sent = 0;
    m_bLinkedPackets = false;
}

void CEMSocket::OnClose(int nErrorCode)
{
    byConnected = ES_DISCONNECTED;
    ClearQueues();
}

    static unsigned char GlobalReadBuffer[MAX_SIZE];

void CEMSocket::OnReceive(int nErrorCode)
{
#if defined(__DEBUG__)
    //printf("CEMSocket::OnReceive(%u): nErrorCode=%u\n", (wxUint32) this, nErrorCode);
#endif
    if (nErrorCode)
    {
        OnError(nErrorCode);
        return;
    }
    if (byConnected == ES_DISCONNECTED)
    {
        return;
    }
    else
    {
        // ES_DISCONNECTED, ES_NOTCONNECTED, ES_CONNECTED:
        byConnected = ES_CONNECTED;
    }
    if ((limitenabled == true) && (downloadlimit == 0))
    {
        pendingOnReceive = true;
        return;
    }
    int readMax = sizeof(GlobalReadBuffer) - pendingHeaderSize;
    if ((limitenabled == true) && (readMax > downloadlimit))
    {
        readMax = downloadlimit;
    }
    Read(GlobalReadBuffer + pendingHeaderSize, readMax);
    int ret = LastCount();
    if (Error() || ret == 0)
    {
        return;
    }
    if (limitenabled == true)
    {
        downloadlimit -= ret;
    }
    pendingOnReceive = (ret == readMax) ? true: false;
    if (pendingHeaderSize > 0)
    {
        memcpy(GlobalReadBuffer, pendingHeader, pendingHeaderSize);
        ret += pendingHeaderSize;
        pendingHeaderSize = 0;
    }
    unsigned char * rptr = GlobalReadBuffer;
    int p = 1;
    while ((p > 0) && (p < ret))
    {
        if (!rptr[p - 1])
        {
            p++;
        }
        else
        {
            p = -p;
        }
    }
    if (p < -1)
    {
        p = - p;
        p--;
        if ((rptr[p] == 0xe3) || (rptr[p] == 0xc5))
        {
            rptr += p;
            ret -= p;
            p = 0;
        }
    }
    const unsigned char * rend = rptr + ret;
    while ((rend - rptr >= PACKET_HEADER_SIZE) ||
    ((pendingPacket != NULL) && (rend - rptr > 0)))
    {
        if (pendingPacket == NULL)
        {
            pendingPacket = new Packet(rptr);
            rptr += 6;
            switch (pendingPacket->prot)
            {
            case OP_EDONKEYPROT:
            case OP_PACKEDPROT:
            case OP_EMULEPROT:
                break;
            default:
                delete pendingPacket;
                pendingPacket = NULL;
                OnError(ERR_WRONGHEADER);
                return;
            }
            if (pendingPacket->size > sizeof(GlobalReadBuffer))
            {
                delete pendingPacket;
                pendingPacket = NULL;
                OnError(ERR_TOOBIG);
                return;
            }
            pendingPacket->pBuffer = new char[pendingPacket->size + 1];
            pendingPacketSize = 0;
        }
        uint32 toCopy = ((pendingPacket->size - pendingPacketSize) <= (uint32)(rend - rptr)) ?
        (pendingPacket->size - pendingPacketSize): (uint32)(rend - rptr);
        memcpy( & pendingPacket->pBuffer[pendingPacketSize], rptr, toCopy);
        pendingPacketSize += toCopy;
        rptr += toCopy;
	if(pendingPacket->size==pendingPacketSize+10) {
		pendingPacket->size-=10;
	}
        if (pendingPacket->size == pendingPacketSize)
        {
            PacketReceived(pendingPacket);
            delete pendingPacket;
            pendingPacket = NULL;
            pendingPacketSize = 0;
        }
    }
    if (rptr != rend)
    {
        pendingHeaderSize = rend - rptr;
        memcpy(pendingHeader, rptr, pendingHeaderSize);
    }
}

void CEMSocket::SetDownloadLimit(uint32 limit)
{
    limitenabled = true;
    downloadlimit = limit;
    // Avoiding CPU load
    if (limit > 0 && pendingOnReceive == true)
    {
        OnReceive(0);
    }
}

void CEMSocket::DisableDownloadLimit()
{
    limitenabled = false;
    if (pendingOnReceive == true)
    {
        OnReceive(0);
    }
}

bool CEMSocket::SendPacket(Packet * packet, bool delpacket, bool controlpacket)
{
    if (!delpacket)
    {
        Packet * copy = new Packet(packet->opcode, packet->size);
        memcpy(copy->pBuffer, packet->pBuffer, packet->size);
        packet = copy;
    }
#if defined(__DEBUG__)
    //printf("CEMSocket::SendPacket opcode=0x%02x size=%u \n",
    			//packet->opcode,packet->size);
#endif
    if ((m_bLinkedPackets && controlpacket) || ((!IsConnected()) || IsBusy()))
    {
        if (controlpacket)
        {
            controlpacket_queue.AddTail(packet);
            return true;
        }
        else
        {
            standartpacket_queue.AddTail(packet);
            return true;
        }
    }
    bool bCheckControlQueue = false;
    if (packet->IsLastSplitted())
    {
        m_bLinkedPackets = false;
        bCheckControlQueue = true;
    }
    else if(packet->IsSplitted())
    {
        m_bLinkedPackets = true;
    }
    Send(packet->DetachPacket(), packet->GetRealPacketSize());
    delete packet;
    if (!IsBusy() && bCheckControlQueue)
    {
        OnSend(0);
    }
    return true;
}

void CEMSocket::OnSend(int nErrorCode)
{
    if (nErrorCode)
    {
        // || Error()){
        OnError(nErrorCode);
        return;
    }
    if (byConnected == ES_DISCONNECTED)
    {
        return;
    }
    else
    {
        byConnected = ES_CONNECTED;
    }
    if (IsBusy())
    {
        Send(0, 0, 0);
    }
    // Still busy?
    if (IsBusy())
    {
        return;
    }
    while (controlpacket_queue.GetHeadPosition() != 0 && (!IsBusy()) && IsConnected() && !m_bLinkedPackets)
    {
        Packet * cur_packet = controlpacket_queue.GetHead();
        //		EMTrace("CEMSocket::OnSend sending control packet on %d, size=%u",(SOCKET)this, cur_packet->GetRealPacketSize());
        Send(cur_packet->DetachPacket(), cur_packet->GetRealPacketSize());
        controlpacket_queue.RemoveHead();
        delete cur_packet;
    }
    while (standartpacket_queue.GetHeadPosition() != 0 && (!IsBusy()) && IsConnected())
    {
        Packet * cur_packet = standartpacket_queue.GetHead();
        if (cur_packet->IsLastSplitted())
        {
            m_bLinkedPackets = false;
        }
        else if(cur_packet->IsSplitted())
        {
            m_bLinkedPackets = true;
        }
 /* This assert seem to make some troubles ... BigBob
 } else if (m_bLinkedPackets) {
 assert (false);
 }
    */
        //		EMTrace("CEMSocket::OnSend sending standart packet on %d, size=%u",(SOCKET)this, cur_packet->GetRealPacketSize());
        Send(cur_packet->DetachPacket(), cur_packet->GetRealPacketSize());
        standartpacket_queue.RemoveHead();
        delete cur_packet;
    }
    while (controlpacket_queue.GetHeadPosition() != 0 && (!IsBusy()) && IsConnected() && !m_bLinkedPackets)
    {
        Packet * cur_packet = controlpacket_queue.GetHead();
        //		EMTrace("CEMSocket::OnSend sending control packet on %d, size=%u",(SOCKET)this, cur_packet->GetRealPacketSize());
        Send(cur_packet->DetachPacket(), cur_packet->GetRealPacketSize());
        controlpacket_queue.RemoveHead();
        delete cur_packet;
    }
}

int CEMSocket::Send(char * lpBuf, int nBufLen, int nFlags)
{
    assert(sendbuffer == NULL || lpBuf == NULL);
    if (lpBuf)
    {
        sendbuffer = lpBuf;
        sendblen = nBufLen;
        sent = 0;
    }
    while (true)
    {
        uint32 tosend = sendblen - sent;
        if (tosend > MAXFRAGSIZE)
        {
            tosend = MAXFRAGSIZE;
        }
        assert(tosend != 0);
        signal(SIGPIPE, SIG_IGN);
        wxSocketBase::Write(sendbuffer + sent, tosend);
        uint32 result = LastCount();
        //if (result == (uint32)-1) {
        if (Error())
        {
            //GetLastError();:
            uint32 error = LastError();
            if (error == wxSOCKET_WOULDBLOCK)
            {
                break;
            }
            else
            {
                //OnError(error);
                return - 1;
            }
        }
        sent += result;
        assert(sent <= sendblen);
        if (sent == sendblen)
        {
            delete[] sendbuffer;
            sendbuffer = 0;
            sent = 0;
            sendblen = 0;
            break;
        }
    }
    return 0;
}

