// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Franz Schneider (sf -at- fsch -dot- net / http://www.xmule.ws/)
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#include <netdb.h>
#include <pthread.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "xmule.h"

#include "ClientCredits.h"
#include "NewFunctions.h"
#include "otherfunctions.h"

#include <wx/filesys.h>
#include <wx/msgdlg.h>
#include <wx/fs_zip.h>
#include <wx/zstream.h>
#include <wx/wfstream.h>
#include <wx/sckaddr.h>
#include <wx/scrolwin.h>

MAP * ToDelete_ClientReqSockets = NULL;
MAP * ToDelete_UpDownClients = NULL;

void MD4Transform(wxUint32 Hash[4], wxUint32 x[16])
{
    // constants for MD4Transform
#define S11 3
#define S12 7
#define S13 11
#define S14 19
#define S21 3
#define S22 5
#define S23 9
#define S24 13
#define S31 3
#define S32 9
#define S33 11
#define S34 15
    wxUint32 a = Hash[0];
    wxUint32 b = Hash[1];
    wxUint32 c = Hash[2];
    wxUint32 d = Hash[3];
    /* Round 1 */
    // 01:
    MD4_FF(a, b, c, d, x[0], S11);
    // 02:
    MD4_FF(d, a, b, c, x[1], S12);
    // 03:
    MD4_FF(c, d, a, b, x[2], S13);
    // 04:
    MD4_FF(b, c, d, a, x[3], S14);
    // 05:
    MD4_FF(a, b, c, d, x[4], S11);
    // 06:
    MD4_FF(d, a, b, c, x[5], S12);
    // 07:
    MD4_FF(c, d, a, b, x[6], S13);
    // 08:
    MD4_FF(b, c, d, a, x[7], S14);
    // 09:
    MD4_FF(a, b, c, d, x[8], S11);
    // 10:
    MD4_FF(d, a, b, c, x[9], S12);
    // 11:
    MD4_FF(c, d, a, b, x[10], S13);
    // 12:
    MD4_FF(b, c, d, a, x[11], S14);
    // 13:
    MD4_FF(a, b, c, d, x[12], S11);
    // 14:
    MD4_FF(d, a, b, c, x[13], S12);
    // 15:
    MD4_FF(c, d, a, b, x[14], S13);
    // 16:
    MD4_FF(b, c, d, a, x[15], S14);
    /* Round 2 */
    // 17:
    MD4_GG(a, b, c, d, x[0], S21);
    // 18:
    MD4_GG(d, a, b, c, x[4], S22);
    // 19:
    MD4_GG(c, d, a, b, x[8], S23);
    // 20:
    MD4_GG(b, c, d, a, x[12], S24);
    // 21:
    MD4_GG(a, b, c, d, x[1], S21);
    // 22:
    MD4_GG(d, a, b, c, x[5], S22);
    // 23:
    MD4_GG(c, d, a, b, x[9], S23);
    // 24:
    MD4_GG(b, c, d, a, x[13], S24);
    // 25:
    MD4_GG(a, b, c, d, x[2], S21);
    // 26:
    MD4_GG(d, a, b, c, x[6], S22);
    // 27:
    MD4_GG(c, d, a, b, x[10], S23);
    // 28:
    MD4_GG(b, c, d, a, x[14], S24);
    // 29:
    MD4_GG(a, b, c, d, x[3], S21);
    // 30:
    MD4_GG(d, a, b, c, x[7], S22);
    // 31:
    MD4_GG(c, d, a, b, x[11], S23);
    // 32:
    MD4_GG(b, c, d, a, x[15], S24);
    /* Round 3 */
    // 33:
    MD4_HH(a, b, c, d, x[0], S31);
    // 34:
    MD4_HH(d, a, b, c, x[8], S32);
    // 35:
    MD4_HH(c, d, a, b, x[4], S33);
    // 36:
    MD4_HH(b, c, d, a, x[12], S34);
    // 37:
    MD4_HH(a, b, c, d, x[2], S31);
    // 38:
    MD4_HH(d, a, b, c, x[10], S32);
    // 39:
    MD4_HH(c, d, a, b, x[6], S33);
    // 40:
    MD4_HH(b, c, d, a, x[14], S34);
    // 41:
    MD4_HH(a, b, c, d, x[1], S31);
    // 42:
    MD4_HH(d, a, b, c, x[9], S32);
    // 43:
    MD4_HH(c, d, a, b, x[5], S33);
    // 44:
    MD4_HH(b, c, d, a, x[13], S34);
    // 45:
    MD4_HH(a, b, c, d, x[3], S31);
    // 46:
    MD4_HH(d, a, b, c, x[11], S32);
    // 47:
    MD4_HH(c, d, a, b, x[7], S33);
    // 48:
    MD4_HH(b, c, d, a, x[15], S34);
    Hash[0] += a;
    Hash[1] += b;
    Hash[2] += c;
    Hash[3] += d;
}

wxUint32 globaldata2 = 0;

wxUint32 MapData(MAP * pos)
{
    return pos->Data;
}

void md4printf(const void * hash)
{
    printf("md4hash: ");
    for (int i = 0 ; i < 16 ; i++)
    {
        printf("%02x", ((unsigned char *) hash) [i]);
    }
    printf("\n");
}

unsigned char * pckprintf(char * info)
{
    int i, s, c;
    unsigned char * t, * c0;
    c0 = (unsigned char *) info;
    s = strlen(info);
    t = (unsigned char *) malloc(1 + (s >> 1));
    for (int i = 0 ; i < s ; i++)
    {
        c = c0 [i];
        if ((c >= 'a') && (c <= 'z'))
        {
            c = c - 'a' + 10;
        }
        else if((c >= '0') && (c <= '9'))
        {
            c = c - '0';
        }
        else
        {
            printf("fehler: %u(%u)\n", c, i);
        }
        if (i & 1)
        {
            t[i >> 1] += c & 15;
        }
        else
        {
            t[i >> 1] = (c & 15) <<4;
        }
    }
    return t;
}

void hexprintf(char * info, const void * buffer, int length)
{
    printf("%s:\n", info);
    for (int i = 0 ; i < length ; i++)
    {
        printf("%02x", ((unsigned char *) buffer) [i]);
    }
    printf("\n");
}

void ascprintf(char * info, const void * buffer, int length)
{
    unsigned char c;
    printf("%s:\n", info);
    for (int i = 0 ; i < length ; i++)
    {
        c = ((unsigned char *) buffer) [i];
        if ((c >= 'a') && (c <= 'z'))
        {
            printf("%c", c);
        }
        else if((c >= 'A') && (c <= 'Z'))
        {
            printf("%c", c);
        }
        else if((c >= '0') && (c <= '9'))
        {
            printf("%c", c);
        }
        else
        {
            printf(".");
        }
    }
    printf("\n");
}

unsigned char * MapDataKey(MAP * pos)
{
    return pos->Key;
}

void MapData_Init(MAP *& base)
{
    base = (MAP *) malloc(sizeof(MAP));
    base->Key = NULL;
    base->Data = 0;
    base->Data2 = 0;
    base->next = base;
    base->prev = base;
}

wxUint32 MapData_GetCount(MAP * base)
{
    return base->Data;
}

void * MapData_GetIt(MAP * pos)
{
    if (pos)
    {
        return(void *) pos->Data;
    }
    else
    {
        return(void *) NULL;
    }
}

MAP * MapData_Find(MAP * base, void * tofind, int length)
{
    MAP * found;
    found = base;
    while (length)
    {
        found = MapData_GetNext(found);
        if (found)
        {
            if (found->Key)
            {
                if (!memcmp(found->Key, tofind, length))
                {
                    length = 0;
                }
            }
            else
            {
                found = NULL;
                length = 0;
            }
        }
        else
        {
            length = 0;
        }
    }
    return found;
}

MAP * MapData_GetNext(MAP * next)
{
    if (next)
    {
        next = next->next;
        if (next->Key == NULL)
        {
            next = NULL;
        }
    }
    else
    {
        next = NULL;
    }
    return next;
}

void MapData_Insert(MAP * base, void * data, void * key, int length)
{
    MAP * toinsert;
    toinsert = (MAP *) malloc(sizeof(MAP));
    toinsert->Key = (unsigned char *) malloc(length);
    if (globaldata2)
    {
        toinsert->Data2 = globaldata2;
        if (!data)
        {
            toinsert->Data = globaldata2;
        }
        globaldata2 = 0;
    }
    else
    {
        toinsert->Data2 = 0;
    }
    if (!length)
    {
        key = data;
        length = 4;
    }
    toinsert->Data = (wxUint32) data;
    toinsert->prev = base;
    toinsert->next = base->next;
    memcpy(toinsert->Key, key, length);
    base->next->prev = toinsert;
    base->next = toinsert;
    base->Data++;
    //return toinsert;
}

MAP * MapData_Remove(MAP * base, MAP * todelete)
{
    MAP * next = NULL;
    if (base->Data)
    {
        free(todelete->Key);
        todelete->Key = NULL;
        todelete->Data = 0;
        next = todelete->next;
        next->prev = todelete->prev;
        next->prev->next = next;
        todelete->next = NULL;
        todelete->prev = NULL;
        free(todelete);
        base->Data--;
    }
    else
    {
        next = todelete;
    }
    return next;
}

void MapData_RemoveAll(MAP * base)
{
    MAP * pos;
    pos = base->next;
    while (pos->Key)
    {
        pos = MapData_Remove(base, pos);
    }
}

void Menu_AppendSubmenu(wxMenu *& wxmenu, wxMenu * submenu, const char * submenutitle)
{
    wxmenu->Append(0, submenutitle, submenu, "");
}

void Menu_CreateCheckItem(void * wxscw, wxMenu *& wxmenu, int entry_id, const char * entry_name, wxObjectEventFunction jumpto)
{
    switch (entry_id)
    {
    case 0:
        wxmenu = new wxMenu(entry_name);
    case - 1:
        wxmenu->AppendSeparator();
        break;
    case - 2:
        wxmenu->Break();
        break;
    default:
        wxMenuItem * item;
        wxmenu->AppendCheckItem(entry_id, entry_name, "");
        //item=FindItem
        if (wxscw != NULL)
        {
            ((wxScrolledWindow *) wxscw)->Connect(entry_id, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction) jumpto);
        }
        break;
    }
}

int Menu_Create(void * wxscw, wxMenu *& wxmenu, int base_id, wxString * infos, const char * resourcefilename, wxObjectEventFunction jumpto)
{
    unsigned char byte[2] =
    {
        0x00, 0x00
    };
    wxMenu * submenu;
    int enablesubmenu = 0;
    wxString line, part1, part2;
    long value;
    int entrycounter = 0;
    for (int i = 0 ; i < 256 ; i++)
    {
        infos[i] = "";
    }
    wxInputStream* filepointer;
    printf("Trying to open %s...", resourcefilename);

    if (wxFileExists(resourcefilename) == false)
    {
        printf(" not found\n");
        wxString fname01 = wxString(getenv("HOME"), *wxConvCurrent) + wxT("/.xMule/") + wxString(resourcefilename, *wxConvCurrent);
        printf("Trying to open %s...", fname01.mb_str());        

        if (wxFileExists(fname01) == false)
        {
            printf(" not found\n");
            fname01 = wxT("memory:") + wxString(resourcefilename, *wxConvCurrent);
            printf("Trying to open %s...", fname01.mb_str());

            wxFSFile* f;
            wxFileSystem fsys;

            wxFileSystem::AddHandler(new wxZipFSHandler);
            f = fsys.OpenFile(fname01);
            if (f == NULL)
            {
                printf(" not found\n\t* Try copying 'src/resource' directory to $HOME/.xMule/\n------------------\n");
                return 0;
            }

            filepointer = f->GetStream();
//            filepointer->Read(fname01, wxFile::read);

        }
        else
        {
            filepointer = new wxFileInputStream(fname01);
        }
    }
    else
    {        
        filepointer = new wxFileInputStream(resourcefilename);
    }
    printf(" ok\n------------------\n");

    line = "";
    submenu = wxmenu;
    while (filepointer->Eof() == false)
    {
        filepointer->Read(&byte, 1);
        switch (byte[0])
        {
        case 0: break;
        case '\r': break;
        case '\n':
            value = line.Find(",");
            if (value >= 0)
            {
                if (value)
                {
                    part1 = line.Mid(0, value);
                    part2 = line.Mid(value + 1);
                }
                else
                {
                    part1 = "";
                    part2 = line.Mid(value + 1);
                }
                (void) part1.ToLong( & value);
                //faz:printf("%s->%u\n", part1.GetData(), value);
                switch (value)
                {
                case 0:
                    Menu_CreateCheckItem(NULL, submenu, 0, part2, NULL);
                    break;
                case - 1:
                    Menu_CreateCheckItem(NULL, submenu, - 1, part2, NULL);
                    break;
                case - 8:
                    wxmenu = submenu;
                    submenu = new wxMenu(part2);
                    Menu_AppendSubmenu(wxmenu, submenu, part2);
                    if (!enablesubmenu)
                    {
                        enablesubmenu++;
                    }
                    break;
                case - 9:
                    if (enablesubmenu)
                    {
                        enablesubmenu = 0;
                    }
                    submenu = wxmenu;
                    break;
                default:
                    if (value < 256)
                    {
                        entrycounter++;
                        if (part1.Len() > 1)
                        {
                            infos[value] = part1.Right(2) + wxString::Format("%3d%s", base_id + entrycounter - 20000, (const char *) part2);
                        }
                        else
                        {
                            infos[value] = wxString::Format("%5d%s", base_id + entrycounter, (const char *) part2);
                        }
                        Menu_CreateCheckItem(wxscw, submenu, base_id + entrycounter, part2, jumpto);
                        submenu->Check(base_id + entrycounter, false);
                    }
                    else
                    {
                        Menu_CreateCheckItem(wxscw, submenu, value, part2, jumpto);
                        submenu->Check(value, false);
                    }
                    break;
                }
            }
            line = "";
            break;
        default:
            line += (wxChar) byte[0];
            break;
        }
    }

    wxmenu = submenu;
    return entrycounter;
}
