// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (c) 2004 Franz Schneider (sf -at- fsch -dot- net / http://www.xmule.ws/)
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef _NEWFUNCTIONS
#define _NEWFUNCTIONS

#include <wx/defs.h>                    // Needed for wxUint32
#include <wx/menu.h>                    // Needed for wxMenu

#define MAPCLIENTS_MAX 30000

// basic MD4 functions
#define MD4_F(x, y, z) (((x) & (y)) | ((~x) & (z)))
#define MD4_G(x, y, z) (((x) & (y)) | ((x) & (z)) | ((y) & (z)))
#define MD4_H(x, y, z) ((x) ^ (y) ^ (z))

// rotates x left n bits
#define MD4_ROTATE_LEFT(x, n) (((x) << (n)) | ((x) >> (32-(n))))

// partial transformations
#define MD4_FF(a, b, c, d, x, s) \
{ \
  (a) += MD4_F((b), (c), (d)) + (x); \
  (a) = MD4_ROTATE_LEFT((a), (s)); \
}

#define MD4_GG(a, b, c, d, x, s) \
{ \
  (a) += MD4_G((b), (c), (d)) + (x) + (wxUint32)0x5A827999; \
  (a) = MD4_ROTATE_LEFT((a), (s)); \
}

#define MD4_HH(a, b, c, d, x, s) \
{ \
  (a) += MD4_H((b), (c), (d)) + (x) + (wxUint32)0x6ED9EBA1; \
  (a) = MD4_ROTATE_LEFT((a), (s)); \
}
void MD4Transform(wxUint32 Hash[4],wxUint32 x[16]);
unsigned char *pckprintf(char *info);
void ascprintf(char *info,const void *buffer,int length);
void md4printf(const void *hash);
void hexprintf(char *info,const void *buffer,int length);

typedef struct _MAP
{
	_MAP*	next;
	_MAP* 	prev;
	wxUint32 Data;
	wxUint32 Data2;
	unsigned char *Key;
}

MAP;

extern wxUint32 globaldata2;

extern MAP* ToDelete_ClientReqSockets;
extern MAP* ToDelete_UpDownClients;

wxUint32 MapData(MAP* pos);
unsigned char *MapDataKey(MAP* pos);
void MapData_Init(MAP *&base);
MAP* MapData_Find(MAP* base,void *tofind, int length);
wxUint32 MapData_GetCount(MAP *base);
void *MapData_GetIt(MAP* pos);
MAP* MapData_GetNext(MAP* next);
void MapData_Insert(MAP *base,void *data, void *key=NULL, int length=0);
MAP* MapData_Remove(MAP *base,MAP *todelete);
void MapData_RemoveAll(MAP* base);
void Menu_CreateCheckItem(void *wxscw, wxMenu *&wxmenu, int entry_id, const char *entry_name, wxObjectEventFunction jumpto);
int Menu_Create(void *wxscw, wxMenu *&wxmenu, int base_id, wxString *infos, const char *resourcefilename, wxObjectEventFunction jumpto);

#endif
