// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifdef PRECOMP
#	include "xmule-headers.h"
#else
#include "opcodes.h"                    // Needed for UNLIMITED
#include "otherfunctions.h"             // Needed for GetResString
#	include "muuli_wdr.h"
#	include "PPgConnection.h"
#	include "Preferences.h"
#	include "StatisticsDlg.h"
#	include "wintypes.h"
#	include "Wizard.h"
#	include "xmule.h"
#	include "xmuleDlg.h"
#endif

#include <wx/checkbox.h>
#include <wx/msgdlg.h>
#include <wx/notebook.h>
#include <wx/slider.h>
#include <wx/textctrl.h>                // Needed for wxTextCtrl::SetValue
#include "wx/xrc/xmlres.h"
#include "wx/xrc/xh_all.h"

#define GetDlgItem(x,clas) XRCCTRL(*this,#x,clas)
#define IsDlgButtonChecked(x) XRCCTRL(*this,#x,wxCheckBox)->GetValue()
#define CheckDlgButton(x,y) XRCCTRL(*this,#x,wxCheckBox)->SetValue(y)

//IMPLEMENT_DYNAMIC(CPPgConnection, CPropertyPage)
IMPLEMENT_DYNAMIC_CLASS(CPPgConnection, wxPanel)

CPPgConnection::CPPgConnection(wxWindow *parent)
//: CPropertyPage(CPPgConnection::IDD):
: wxPanel(parent, CPPgConnection::IDD)
{
    wxNotebook *book = (wxNotebook *) parent;
    wxPanel *page1 = wxXmlResource::Get()->LoadPanel(this, "DLG_PPG_CONNECTION");
    book->AddPage(this, _("Connection"));
    SetSize(page1->GetSize() .GetWidth(), page1->GetSize() .GetHeight() + 48);
    page1->SetSize(GetSize());
}

CPPgConnection::~CPPgConnection()
{
}

BEGIN_EVENT_TABLE(CPPgConnection, wxPanel)
//EVT_BUTTON(XRCID("IDC_WIZARD"), CPPgConnection::OnBnClickedWizard)
EVT_CHECKBOX(XRCID("IDC_UDPDISABLE"), CPPgConnection::OnUDPDISABLEChecked)
END_EVENT_TABLE()

void CPPgConnection::LoadSettings(void)
{
    if (app_prefs->prefs->maxGraphDownloadRate < app_prefs->prefs->maxdownload) app_prefs->prefs->maxdownload = UNLIMITED;
    if (app_prefs->prefs->maxGraphUploadRate < app_prefs->prefs->maxupload) app_prefs->prefs->maxupload = UNLIMITED;
    if (app_prefs->prefs->maxupload != 0)
    {
        if (app_prefs->prefs->maxupload < 4 && (app_prefs->prefs->maxupload *3 < app_prefs->prefs->maxdownload))
        app_prefs->prefs->maxdownload = app_prefs->prefs->maxupload *3;
        if (app_prefs->prefs->maxupload < 10 && (app_prefs->prefs->maxupload *4 < app_prefs->prefs->maxdownload))
        app_prefs->prefs->maxdownload = app_prefs->prefs->maxupload *4;
    }
    CString strBuffer;
    strBuffer.Format("%d", app_prefs->prefs->udpport);
    GetDlgItem(IDC_UDPPORT, wxTextCtrl)->SetValue(strBuffer);
    CheckDlgButton(IDC_UDPDISABLE, (app_prefs->prefs->udpport == 0));
    GetDlgItem(IDC_UDPPORT, wxControl)->Enable(app_prefs->prefs->udpport > 0);
    strBuffer.Format("%d", app_prefs->prefs->maxGraphDownloadRate);
    GetDlgItem(IDC_DOWNLOAD_CAP, wxTextCtrl)->SetValue(strBuffer);
    strBuffer.Format("%d", app_prefs->prefs->maxGraphUploadRate);
    GetDlgItem(IDC_UPLOAD_CAP, wxTextCtrl)->SetValue(strBuffer);
    if (app_prefs->prefs->maxdownload == 0xFFFF)
    GetDlgItem(IDC_MAXDOWN, wxTextCtrl)->SetValue("0");
    else
    {
        strBuffer.Format("%d", app_prefs->prefs->maxdownload);
        GetDlgItem(IDC_MAXDOWN, wxTextCtrl)->SetValue(strBuffer);
    }
    if (app_prefs->prefs->maxupload == 0xFFFF)
    GetDlgItem(IDC_MAXUP, wxTextCtrl)->SetValue("0");
    else
    {
        strBuffer.Format("%d", app_prefs->prefs->maxupload);
        GetDlgItem(IDC_MAXUP, wxTextCtrl)->SetValue(strBuffer);
    }
    strBuffer.Format("%d", app_prefs->prefs->port);
    GetDlgItem(IDC_PORT, wxTextCtrl)->SetValue(strBuffer);
    strBuffer.Format("%d", app_prefs->prefs->maxconnections);
    GetDlgItem(IDC_MAXCON, wxTextCtrl)->SetValue(strBuffer);
    if (app_prefs->prefs->maxsourceperfile == 0xFFFF)
    GetDlgItem(IDC_MAXSOURCEPERFILE, wxTextCtrl)->SetValue("0");
    else
    {
        strBuffer.Format("%d", app_prefs->prefs->maxsourceperfile);
        GetDlgItem(IDC_MAXSOURCEPERFILE, wxTextCtrl)->SetValue(strBuffer);
    }
    if (app_prefs->prefs->reconnect)
    CheckDlgButton(IDC_RECONN, 1);
    else
    CheckDlgButton(IDC_RECONN, 0);
    if (app_prefs->prefs->m_bshowoverhead)
    CheckDlgButton(IDC_SHOWOVERHEAD, 1);
    else
    CheckDlgButton(IDC_SHOWOVERHEAD, 0);
    if (app_prefs->prefs->autoconnect)
    CheckDlgButton(IDC_AUTOCONNECT, 1);
    else
    CheckDlgButton(IDC_AUTOCONNECT, 0);
}

void CPPgConnection::OnApply()
{
    wxString buffer;
    int lastmaxgu = app_prefs->prefs->maxGraphUploadRate;
    int lastmaxgd = app_prefs->prefs->maxGraphDownloadRate;
 if (GetDlgItem(IDC_DOWNLOAD_CAP, wxTextCtrl)->GetValue() .Length())
 {
 buffer = GetDlgItem(IDC_DOWNLOAD_CAP, wxTextCtrl)->GetValue();
 app_prefs->prefs->maxGraphDownloadRate = (atoi(buffer)) ? atoi(buffer): 100;
 }
 if (GetDlgItem(IDC_UPLOAD_CAP, wxTextCtrl)->GetValue() .Length())
 {
 buffer = GetDlgItem(IDC_UPLOAD_CAP, wxTextCtrl)->GetValue();
 app_prefs->prefs->maxGraphUploadRate = (atoi(buffer)) ? atoi(buffer): 25;
 }
 if (GetDlgItem(IDC_MAXUP, wxTextCtrl)->GetValue() .Length())
 {
 buffer = GetDlgItem(IDC_MAXUP, wxTextCtrl)->GetValue();
 app_prefs->prefs->maxupload = (atoi(buffer)) ? atoi(buffer): 0xFFFF;
 }
 if (GetDlgItem(IDC_MAXDOWN, wxTextCtrl)->GetValue() .Length())
 {
 buffer = GetDlgItem(IDC_MAXDOWN, wxTextCtrl)->GetValue();
 app_prefs->prefs->maxdownload = (atoi(buffer)) ? atoi(buffer): 0xFFFF;
 }
 if (GetDlgItem(IDC_PORT, wxTextCtrl)->GetValue() .Length())
 {
 buffer = GetDlgItem(IDC_PORT, wxTextCtrl)->GetValue();
 app_prefs->prefs->port = (atoi(buffer)) ? atoi(buffer): 4662;
 }
 if (GetDlgItem(IDC_MAXSOURCEPERFILE, wxTextCtrl)->GetValue() .Length())
 {
 buffer = GetDlgItem(IDC_MAXSOURCEPERFILE, wxTextCtrl)->GetValue();
 app_prefs->prefs->maxsourceperfile = (atoi(buffer)) ? atoi(buffer): 1;
 }
 if (GetDlgItem(IDC_UDPPORT, wxTextCtrl)->GetValue() .Length())
 {
 buffer = GetDlgItem(IDC_UDPPORT, wxTextCtrl)->GetValue();
 app_prefs->prefs->udpport = (atoi(buffer) && !IsDlgButtonChecked(IDC_UDPDISABLE)) ? atoi(buffer): 0;
 }
 if (IsDlgButtonChecked(IDC_SHOWOVERHEAD))
 app_prefs->prefs->m_bshowoverhead = true;
 else
 app_prefs->prefs->m_bshowoverhead = false;
 //	if(IsDlgButtonChecked(IDC_UDPDISABLE)) app_prefs->prefs->udpport=0;
 GetDlgItem(IDC_UDPPORT, wxControl)->Enable(!IsDlgButtonChecked(IDC_UDPDISABLE));
 app_prefs->prefs->autoconnect = (int8) IsDlgButtonChecked(IDC_AUTOCONNECT);
 app_prefs->prefs->reconnect = (int8) IsDlgButtonChecked(IDC_RECONN);
 if (lastmaxgu != app_prefs->prefs->maxGraphUploadRate)
 theApp.xmuledlg->statisticswnd->SetARange(false, app_prefs->prefs->maxGraphUploadRate);
 if (lastmaxgd != app_prefs->prefs->maxGraphDownloadRate)
 theApp.xmuledlg->statisticswnd->SetARange(true, app_prefs->prefs->maxGraphDownloadRate);
 uint16 tempcon = app_prefs->prefs->maxconnections;
 if (GetDlgItem(IDC_MAXCON, wxTextCtrl)->GetValue() .Length())
 {
 buffer = GetDlgItem(IDC_MAXCON, wxTextCtrl)->GetValue();
 tempcon = (atoi(buffer)) ? atoi(buffer): CPreferences::GetRecommendedMaxConnections();
 }
 if (tempcon > (unsigned)::GetMaxConnections())
 {
 CString strMessage;
 strMessage.Format(GetResString(IDS_PW_WARNING), GetResString(IDS_PW_MAXC) .GetData(),::GetMaxConnections());
 int iResult = wxMessageBox(strMessage, GetResString(IDS_PW_MAXC), wxICON_WARNING | wxYES_NO);
 if (iResult != wxYES)
 {
 //TODO: set focus to max connection?
 strMessage.Format("%d", app_prefs->prefs->maxconnections);
 GetDlgItem(IDC_MAXCON, wxTextCtrl)->SetValue(strMessage);
 tempcon =::GetMaxConnections();
 }
 }
 app_prefs->prefs->maxconnections = tempcon;
 //SetModified(FALSE);
 //	app_prefs->Save();
 //LoadSettings();
 //	theApp.xmuledlg->preferenceswnd.m_wndTweaks.LoadSettings();
 //return CPropertyPage::OnApply();
}

void CPPgConnection::Localize(void)
{
    if (1)
    {
        GetDlgItem(IDC_CAPACITIES_FRM, wxControl)->SetLabel(GetResString(IDS_PW_CON_CAPFRM));
        GetDlgItem(IDC_DCAP_LBL, wxControl)->SetLabel(GetResString(IDS_PW_CON_DOWNLBL));
        GetDlgItem(IDC_UCAP_LBL, wxControl)->SetLabel(GetResString(IDS_PW_CON_UPLBL));
        GetDlgItem(IDC_LIMITS_FRM, wxControl)->SetLabel(GetResString(IDS_PW_CON_LIMITFRM));
        GetDlgItem(IDC_DLIMIT_LBL, wxControl)->SetLabel(GetResString(IDS_PW_CON_DOWNLBL));
        GetDlgItem(IDC_ULIMIT_LBL, wxControl)->SetLabel(GetResString(IDS_PW_CON_UPLBL));
        GetDlgItem(IDC_KBS1, wxControl)->SetLabel(GetResString(IDS_KBYTESEC));
        GetDlgItem(IDC_KBS2, wxControl)->SetLabel(GetResString(IDS_KBYTESEC));
        GetDlgItem(IDC_KBS3, wxControl)->SetLabel(GetResString(IDS_KBYTESEC));
        GetDlgItem(IDC_KBS4, wxControl)->SetLabel(GetResString(IDS_KBYTESEC));
        GetDlgItem(IDC_MAXCONN_FRM, wxControl)->SetLabel(GetResString(IDS_PW_CONLIMITS));
        GetDlgItem(IDC_MAXCONLABEL, wxControl)->SetLabel(GetResString(IDS_PW_MAXC));
        GetDlgItem(IDC_SHOWOVERHEAD, wxControl)->SetLabel(GetResString(IDS_SHOWOVERHEAD));
        GetDlgItem(IDC_CLIENTPORT_FRM, wxControl)->SetLabel(GetResString(IDS_PW_CLIENTPORT));
        GetDlgItem(IDC_MAXSRC_FRM, wxControl)->SetLabel(GetResString(IDS_PW_MAXSOURCES));
        GetDlgItem(IDC_AUTOCONNECT, wxControl)->SetLabel(GetResString(IDS_PW_AUTOCON));
        GetDlgItem(IDC_RECONN, wxControl)->SetLabel(GetResString(IDS_PW_RECON));
        GetDlgItem(IDC_MAXSRCHARD_LBL, wxControl)->SetLabel(GetResString(IDS_HARDLIMIT));
        //GetDlgItem(IDC_WIZARD, wxControl)->SetLabel(GetResString(IDS_WIZARD));
        // okok, these seems to have vanished.. needs to be fixed at some point
        //GetDlgItem(IDC_UDPPORTLABEL,wxControl)->SetLabel(GetResString(IDS_UDPPORT));
        GetDlgItem(IDC_UDPPORTLABEL, wxControl)->SetLabel("UDP Port");
        GetDlgItem(IDC_UDPDISABLE, wxControl)->SetLabel(GetResString(IDS_UDPDISABLED));
    }
}

void CPPgConnection::OnBnClickedWizard(wxEvent &evt)
{
 /*
 Wizard test(this);
 test.SetPrefs(app_prefs);
 test.OnInitDialog();
 test.ShowModal();
    */
}

void CPPgConnection::OnUDPDISABLEChecked(wxEvent &evt)
{
    GetDlgItem(IDC_UDPPORT, wxControl)->Enable(!IsDlgButtonChecked(IDC_UDPDISABLE));
}

