// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef PREFERENCES_H
#define PREFERENCES_H

#include "MD5Sum.h"                     // Needed for MD5Sum
#include "mfc.h"                        // Needed for CStringList
#include "types.h"                      // Needed for int8
#include "wintypes.h"                   // Needed for WINDOWPLACEMENT
#include "xmule.h"                      // Needed for theApp
#include <ctime>                        // Needed for time

extern int newprefs01_opt[];

#ifndef MAX_PATH
// *BSD compatibility
#	if (defined(BSD) && (BSD >= 199103))
#		define MAX_PATH MAXPATHLEN
#	else
#		define MAX_PATH 2048
#	endif
#endif

#define DEFAULT_COL_SIZE 65535

// DO NOT EDIT VALUES like making a uint16 to uint32, or insert any value. ONLY append new vars
#pragma pack(1)
struct Preferences_Ext_Struct
{
    int8 version;
    uchar userhash[16];
    WINDOWPLACEMENT EmuleWindowPlacement;
};

#pragma pack()

// deadlake PROXYSUPPORT
struct ProxySettings
{
    uint16 type;
    uint16 port;
    char name[50];
    char user[50];
    char password[50];
    bool EnablePassword;
    bool UseProxy;
};

#pragma pack(1)
struct Category_Struct
{
    char incomingpath[MAX_PATH];
    char title[64];
    char comment[255];
    uint32 color;
    uint8 prio;
};

#pragma pack(1)
struct Preferences_Struct
{
    char nick[255];
    uint16 maxupload;
    uint16 maxdownload;
    uint16 port;
    uint16 udpport;
    uint16 maxconnections;
    int8 reconnect;
    int8 deadserver;
    int8 scorsystem;
    char incomingdir[MAX_PATH];
    char tempdir[MAX_PATH];
    int8 ICH;
    int8 autoserverlist;
    int8 updatenotify;
    int8 mintotray;
    int8 autoconnect;
    int8 autoconnectstaticonly;
    // Barry
    int8 autotakeed2klinks;
    // Barry
    int8 addnewfilespaused;
    // Barry
    int8 depth3D;
    // Barry
    int8 addserversfromserver;
    int8 addserversfromclient;
    int16 maxsourceperfile;
    int16 trafficOMeterInterval;
    int16 statsInterval;
    uchar userhash[16];
    WINDOWPLACEMENT EmuleWindowPlacement;
    int maxGraphDownloadRate;
    int maxGraphUploadRate;
    uint8 beepOnError;
    uint8 confirmExit;
    int16 downloadColumnWidths[13];
    BOOL downloadColumnHidden[13];
    INT downloadColumnOrder[13];
    int16 uploadColumnWidths[8];
    BOOL uploadColumnHidden[8];
    INT uploadColumnOrder[8];
    int16 queueColumnWidths[10];
    BOOL queueColumnHidden[10];
    INT queueColumnOrder[10];
    int16 searchColumnWidths[5];
    BOOL searchColumnHidden[5];
    INT searchColumnOrder[5];
    int16 sharedColumnWidths[11];
    BOOL sharedColumnHidden[11];
    INT sharedColumnOrder[11];
    int16 serverColumnWidths[12];
    BOOL serverColumnHidden[12];
    INT serverColumnOrder[12];
    int16 clientListColumnWidths[8];
    BOOL clientListColumnHidden[8];
    INT clientListColumnOrder[8];
    uint32 statcolors[15];
    uint8 splashscreen;
    uint8 filterBadIP;
    uint8 onlineSig;
    uint64 totalDownloadedBytes;
    uint64 totalUploadedBytes;
    WORD languageID;
    int8 transferDoubleclick;
    int8 m_iSeeShares;
    // 0=everybody 1=friends only 2=noone
    int8 m_iToolDelayTime;
    // tooltip delay time in seconds
    int8 bringtoforeground;
    int8 splitterbarPosition;
    uint16 deadserverretries;
    uint8 statsMax;
    int8 statsAverageMinutes;
    int8 useDownloadNotifier;
    int8 useChatNotifier;
    int8 useLogNotifier;
    int8 useSoundInNotifier;
    int8 notifierPopsEveryChatMsg;
    int8 notifierImportantError;
    int8 notifierNewVersion;
    char notifierSoundFilePath[510];
    char m_sircserver[50];
    char m_sircnick[30];
    char m_sircchannamefilter[50];
    bool m_bircaddtimestamp;
    bool m_bircusechanfilter;
    uint16 m_iircchanneluserfilter;
    char m_sircperformstring[255];
    bool m_bircuseperform;
    bool m_birclistonconnect;
    bool m_bircacceptlinks;
    bool m_bircignoreinfomessage;
    bool m_bircignoreemuleprotoinfomessage;
    bool m_bpreviewprio;
    bool smartidcheck;
    uint8 smartidstate;
    bool safeServerConnect;
    bool startMinimized;
    uint16 MaxConperFive;
    bool m_bVerbose;
    bool m_bupdatequeuelist;
    bool m_bmanualhighprio;
    bool m_btransferfullchunks;
    bool m_bstartnextfile;
    bool m_bshowoverhead;
    bool m_bDAP;
    bool m_bUAP;
    bool m_bDisableKnownClientList;
    bool m_bDisableQueueList;
    int8 versioncheckdays;
    // Barry - Provide a mechanism for all tables to store/retrieve sort order
    int tableSortItemDownload;
    int tableSortItemUpload;
    int tableSortItemQueue;
    int tableSortItemSearch;
    int tableSortItemShared;
    int tableSortItemServer;
    int tableSortItemClientList;
    bool tableSortAscendingDownload;
    bool tableSortAscendingUpload;
    bool tableSortAscendingQueue;
    bool tableSortAscendingSearch;
    bool tableSortAscendingShared;
    bool tableSortAscendingServer;
    bool tableSortAscendingClientList;
    bool showRatesInTitle;
    char TxtEditor[256];
    char VideoPlayer[256];
    bool moviePreviewBackup;
    bool indicateratings;
    bool showAllNotCats;
    bool watchclipboard;
    bool filterserverbyip;
    bool m_bFirstStart;
    bool m_bCreditSystem;
    bool log2disk;
    bool debug2disk;
    int iMaxLogMessages;
    bool scheduler;
    bool dontcompressavi;
    bool msgonlyfriends;
    bool msgsecure;
    uint8 filterlevel;
    uint8 m_iFileBufferSize;
    uint8 m_iQueueSize;
    int m_iCommitFiles;
    uint16 maxmsgsessions;
    uint32 versioncheckLastAutomatic;
    char messageFilter[512];
    char commentFilter[512];
    char notifierConfiguration[510];
    char datetimeformat[32];
    char m_szLRUServermetURL[512];
    // Web Server [kuchin]
    char m_sWebPassword[256];
    char m_sWebLowPassword[256];
    uint16 m_nWebPort;
    bool m_bWebEnabled;
    bool m_bWebUseGzip;
    int m_nWebPageRefresh;
    bool m_bWebLowEnabled;
    char m_sWebResDir[MAX_PATH];
    char m_sTemplateFile[MAX_PATH];
    ProxySettings proxy;
    // deadlake PROXYSUPPORT
    bool m_bIsASCWOP;
    bool showCatTabInfos;
    bool resumeSameCat;
    bool dontRecreateGraphs;
    int allcatType;
    bool m_bUseSecureIdent;
    int desktopMode;
    // Madcat - Sources Dropping Tweaks
    bool DropNoNeededSources;
    bool SwapNoNeededSources;
    bool DropFullQueueSources;
    bool DropHighQueueRankingSources;
    int HighQueueRanking;
    int AutoDropTimer;
};

#pragma pack()

class CPreferences
{
    public:
    enum Table
    {
        tableDownload, tableUpload, tableQueue, tableSearch,
        tableShared, tableServer, tableClientList
        };
    wxArrayString shareddir_list;
    CStringList adresses_list;
    friend class CPreferencesWnd;
    friend class CPPgGeneral;
    friend class CPPgConnection;
    friend class CPPgServer;
    friend class CPPgDirectories;
    friend class CPPgFiles;
    friend class CPPgNotify;
    friend class CPPgIRC;
    friend class Wizard;
    friend class CPPgTweaks;
    friend class CPPgDisplay;
    friend class CPPgSecurity;
    friend class CPPgScheduler;
    friend class CPPgSourcesDropping;
    friend class CPPgGuiTweaks;
    CPreferences();
    ~CPreferences();
    // Sort Algorithmen
    int GetColumnWidth(Table t, int index) const;
    BOOL GetColumnHidden(Table t, int index) const;
    int GetColumnOrder(Table t, int index) const;
    void SetColumnWidth(Table t, int index, int width);
    void SetColumnHidden(Table t, int index, BOOL bHidden);
    void SetColumnOrder(Table t, INT *piOrder);
    int GetColumnSortItem(Table t) const;
    bool GetColumnSortAscending(Table t) const;
    void SetColumnSortItem(Table t, int sortItem);
    void SetColumnSortAscending(Table t, bool sortAscending);
    // .xMule/ path
    void SetAppDir(CString in_appdir)
    {
        sprintf(appdir, "%s", in_appdir.GetData());
    }
    char *GetAppDir()
    {
        return appdir;
    }
    // Load-Save
    bool Load(bool startup);
    bool Save(unsigned char selection_mask);
    // ~/.eMule Line 3:Nick
    void SetUserNick(CString in_nick)
    {
        sprintf(prefs->nick, "%s", in_nick.GetData());
    }
    char *GetUserNick()
    {
        return prefs->nick;
    }
    // ~/.eMule Line 4:IncomingDir
    void SetIncomingDir(CString in_incomingdir)
    {
        sprintf(prefs->incomingdir, "%s", in_incomingdir.GetData());
    }
    char *GetIncomingDir()
    {
        return prefs->incomingdir;
    }
    // ~/.eMule Line 5:TempDir
    void SetTempDir(CString in_tempdir)
    {
        sprintf(prefs->tempdir, "%s", in_tempdir.GetData());
    }
    char *GetTempDir()
    {
        return prefs->tempdir;
    }
    // ~/.eMule Line 6:MaxUpload
    void SetUploadlimit(uint16 in_maxupload)
    {
        prefs->maxupload = in_maxupload;
    }
    uint16 GetMaxUpload()
    {
        return prefs->maxupload;
    }
    // ~/.eMule Line 7:MaxDownload
    void SetDownloadlimit(uint16 in_maxdownload)
    {
        prefs->maxdownload = in_maxdownload;
    }
    uint16 GetMaxDownload()
    {
        return prefs->maxdownload;
    }
    // ~/.eMule Line 8:MaxConnections
    void SetMaxConnections(uint16 in_maxconnections)
    {
        prefs->maxconnections = in_maxconnections;
    }
    uint16 GetMaxConnections()
    {
        return prefs->maxconnections;
    }
    // ~/.eMule Line 9:RemoveDeadServer
    void SetDeadServer(bool in_deadserver)
    {
        prefs->deadserver = in_deadserver;
    }
    int8 DeadServer()
    {
        return prefs->deadserver;
    }
    // ~/.eMule Line10:Port
    void SetPort(uint16 in_port)
    {
        prefs->port = in_port;
    }
    uint16 GetPort()
    {
        return prefs->port;
    }
    // ~/.eMule Line11:UDPPort
    void SetUDPPort(uint16 in_udpport)
    {
        prefs->udpport = in_udpport;
    }
    uint16 GetUDPPort()
    {
        return prefs->udpport;
    }
    // ~/.eMule Line12:MaxSourcesPerFile
    void SetMaxSourcesPerFile(uint16 in_maxsourceperfile)
    {
        prefs->maxsourceperfile = in_maxsourceperfile;
    }
    uint16 GetMaxSourcePerFile()
    {
        return prefs->maxsourceperfile;
    }
    // ~/.eMule Line13:Language
    void SetLanguage();
    // ~/.eMule Line 14:SeeShare --- 0=everybody 1=friends only 2=noone
    void SetSeeShares(int8 in_m_iSeeShares)
    {
        prefs->m_iSeeShares = in_m_iSeeShares;
    }
    int8 CanSeeShares(void)
    {
        return prefs->m_iSeeShares;
    }
    // ~/.eMule Line 15:ToolTipDelay
    void SetToolTipDelay(int8 in_m_iToolDelayTime)
    {
        prefs->m_iToolDelayTime = in_m_iToolDelayTime;
    }
    int8 GetToolTipDelay(void)
    {
        return prefs->m_iToolDelayTime;
    }
    // ~/.eMule Line 16:StatGraphsInterval (0-100)
    void SetTrafficOMeterInterval(int16 in)
    {
        prefs->trafficOMeterInterval = in;
    }
    uint16 GetTrafficOMeterInterval()
    {
        return prefs->trafficOMeterInterval;
    }
    // ~/.eMule Line 18:DownloadCapacity
    void SetMaxGraphDownloadRate(int in)
    {
        prefs->maxGraphDownloadRate = in;
    }
    int GetMaxGraphDownloadRate()
    {
        return prefs->maxGraphDownloadRate;
    }
    // ~/.eMule Line 19:UploadCapacity
    void SetMaxGraphUploadRate(int in)
    {
        prefs->maxGraphUploadRate = in;
    }
    int GetMaxGraphUploadRate()
    {
        return prefs->maxGraphUploadRate;
    }
    // ~/.eMule Line 20:DeadServerRetry
    void SetDeadserverRetries(uint16 in_deadserverretries)
    {
        prefs->deadserverretries = in_deadserverretries;
    }
    uint16 GetDeadserverRetries()
    {
        return prefs->deadserverretries;
    }
    // ~/.eMule Line 21:StatsInterval (0-104)
    void SetStatsInterval(int16 in)
    {
        prefs->statsInterval = in;
    }
    uint16 GetStatsInterval()
    {
        return prefs->statsInterval;
    }
    // ~/.eMule Line 23:StatsAverageMinutes
    void SetStatsAverageMinutes(int8 in)
    {
        prefs->statsAverageMinutes = in;
    }
    int8 GetStatsAverageMinutes()
    {
        return prefs->statsAverageMinutes;
    }
    // ~/.eMule Line 24:MaxConnectionsPerFiveSeconds
    void SetMaxConsPerFive(int in_MaxConperFive)
    {
        prefs->MaxConperFive = in_MaxConperFive;
    }
    uint16 GetMaxConperFive()
    {
        return prefs->MaxConperFive;
    }
    uint16 GetDefaultMaxConperFive();
    // ~/.emule Line 25:Check4NewVersionDelay
    void SetUpdateDays(int8 in_versioncheckdays)
    {
        prefs->versioncheckdays = in_versioncheckdays;
    }
    int8 GetUpdateDays()
    {
        return prefs->versioncheckdays;
    }
    // ~/.eMule Line 26:Reconnect
    void SetReconnect(bool in_reconnect)
    {
        prefs->reconnect = in_reconnect;
    }
    bool Reconnect()
    {
        return prefs->reconnect;
    }
    // ~/.eMule Line 27:Scoresystem
    void SetScore(bool in_scorsystem)
    {
        prefs->scorsystem = in_scorsystem;
    }
    int8 Score()
    {
        return prefs->scorsystem;
    }
    // ~/.eMule Line 28:ICH
    void SetICHEnabled(bool in_ICHEnabled)
    {
        prefs->ICH = in_ICHEnabled;
    }
    bool IsICHEnabled()
    {
        return prefs->ICH;
    }
    // ~/.eMule Line 29:Serverlist
    void SetAutoServerlist(bool in_autoserverlist)
    {
        prefs->autoserverlist = in_autoserverlist;
    }
    bool AutoServerlist()
    {
        return prefs->autoserverlist;
    }
    // ~/.eMule Line31:UpdateNotify
    void SetUpdateNotify(bool in_updatenotify)
    {
        prefs->updatenotify = in_updatenotify;
    }
    bool UpdateNotify()
    {
        return prefs->updatenotify;
    }
    // ~/.eMule Line32:MinToTray
    void SetMinToTray(bool in_mintotray)
    {
        prefs->mintotray = in_mintotray;
    }
    bool DoMinToTray()
    {
        return prefs->mintotray;
    }
    int8 *GetMinTrayPTR()
    {
        return &prefs->mintotray;
    }
    // ~/.eMule Line 33:AddServersFromServer
    void SetAddServersFromServer(bool in_addserversfromserver)
    {
        prefs->addserversfromserver = in_addserversfromserver;
    }
    bool AddServersFromServer()
    {
        return prefs->addserversfromserver;
    }
    // ~/.eMule Line 34:AddServersFromClient
    void SetAddServersFromClient(bool in_addserversfromclient)
    {
        prefs->addserversfromclient = in_addserversfromclient;
    }
    bool AddServersFromClient()
    {
        return prefs->addserversfromclient;
    }
    // ~/.eMule Line 35:Splashscreen
    void SetSplashScreen(bool in_splashscreen)
    {
        prefs->splashscreen = in_splashscreen;
    }
    bool UseSplashScreen()
    {
        return prefs->splashscreen;
    }
    // ~/.eMule Line 36:BringToFront
    void SetBringToFront(bool in_bringtoforeground)
    {
        prefs->bringtoforeground = in_bringtoforeground;
    }
    int8 IsBringToFront()
    {
        return prefs->bringtoforeground;
    }
    // ~/.eMule Linee 37:TransferDoubleClick
    void SetDoubleClickEnabled(bool in_transferDoubleclick)
    {
        prefs->transferDoubleclick = in_transferDoubleclick;
    }
    int8 IsDoubleClickEnabled()
    {
        return prefs->transferDoubleclick;
    }
    // ~/.eMule Line 38:BeepOnError
    void SetErrorBeepEnabled(bool in_beepOnError)
    {
        prefs->beepOnError = in_beepOnError;
    }
    bool IsErrorBeepEnabled()
    {
        return prefs->beepOnError;
    }
    // ~/.eMule Line 39:ConfirmExit
    void SetConfirmExitEnabled(bool in_confirmExit)
    {
        prefs->confirmExit = in_confirmExit;
    }
    bool IsConfirmExitEnabled()
    {
        return prefs->confirmExit;
    }
    // ~/.eMule Line 40:FilterBadIPs
    void SetFilterBadIPs(bool in_filterBadIP)
    {
        prefs->filterBadIP = in_filterBadIP;
    }
    bool FilterBadIPs()
    {
        return prefs->filterBadIP;
    }
    // ~/.eMule Line 41:Autoconnect
    void SetAutoConnect(bool in_autoconnect)
    {
        prefs->autoconnect = in_autoconnect;
    }
    bool DoAutoConnect()
    {
        return prefs->autoconnect;
    }
    // ~/.eMule Line 42:OnlineSignature
    void SetOnlineSignatureEnabled(bool in_onlineSig)
    {
        prefs->onlineSig = in_onlineSig;
    }
    bool IsOnlineSignatureEnabled()
    {
        return prefs->onlineSig;
    }
    // ~/.eMule Line 43:StartupMinimized
    void SetStartMinimized(bool in_startMinimized)
    {
        prefs->startMinimized = in_startMinimized;
    }
    bool GetStartMinimized()
    {
        return prefs->startMinimized;
    }
    // ~/.eMule Line 44:SafeServerConnect
    void SetSafeServerConnectEnabled(bool in_safeServerConnect)
    {
        prefs->safeServerConnect = in_safeServerConnect;
    }
    bool IsSafeServerConnectEnabled()
    {
        return prefs->safeServerConnect;
    }
    // ~/.eMule Line 45:ShowRatesOnTitle
    void SetShowRatesOnTitle(bool in_showRatesInTitle)
    {
        prefs->showRatesInTitle = in_showRatesInTitle;
    }
    bool ShowRatesOnTitle()
    {
        return prefs->showRatesInTitle;
    }
    // ~/.eMule Line 48:AutoConnectStaticOnly
    void SetAutoConnectStaticOnly(bool in_autoconnectstaticonly)
    {
        prefs->autoconnectstaticonly = in_autoconnectstaticonly;
    }
    int8 AutoConnectStaticOnly()
    {
        return prefs->autoconnectstaticonly;
    }
    // ~/-eMule Line 49:AutoTakeED2KLinks
    void SetAutoTakeED2KLinks(bool in_autotakeed2klinks)
    {
        prefs->autotakeed2klinks = in_autotakeed2klinks;
    }
    bool AutoTakeED2KLinks()
    {
        return prefs->autotakeed2klinks;
    }
    // ~/.eMule Line 50:AddNewFilesPaused
    void SetAddNewFilesPaused(bool in_addnewfilespaused)
    {
        prefs->addnewfilespaused = in_addnewfilespaused;
    }
    bool AddNewFilesPaused()
    {
        return prefs->addnewfilespaused;
    }
    // ~/.eMule Line 51:3DDepth (values 0-5)
    void SetFlatBarStyle(int8 in_depth3D)
    {
        prefs->depth3D = in_depth3D;
    }
    int8 GetFlatBarStyle()
    {
        return prefs->depth3D;
    }
    int8 UseFlatBar()
    {
        return(prefs->depth3D == 0);
    }
    //PLK ==0 :huh: ?!?
    uint16 Get3DDepth()
    {
        return prefs->depth3D;
    }
    // ~/.eMule Line 61:VideoPlayer
    void SetVideoPlayer(CString in_VideoPlayer)
    {
        sprintf(prefs->VideoPlayer, "%s", in_VideoPlayer.GetData());
    }
    char *GetVideoPlayer()
    {
        if (strlen(prefs->VideoPlayer) == 0) return "";
        else return prefs->VideoPlayer;
    }
    // ~/.eMule Line 79:SmartIdCheck
    void SetSmartIdCheck(bool in_smartidcheck)
    {
        prefs->smartidcheck = in_smartidcheck;
    }
    bool GetSmartIdCheck()
    {
        return prefs->smartidcheck;
    }
    // Smart Id State
    void SetSmartIdState(uint8 in_smartidstate)
    {
        prefs->smartidstate = in_smartidstate;
    }
    uint8 GetSmartIdState()
    {
        return prefs->smartidstate;
    }
    // ~/.eMule Line 80:Verbose
    void SetVerbose(bool in_m_bVerbose)
    {
        prefs->m_bVerbose = in_m_bVerbose;
    }
    bool GetVerbose()
    {
        return prefs->m_bVerbose;
    }
    // ~/.eMule Line 81:PreviewPrio
    void SetPreviewPrio(bool in_m_bpreviewprio)
    {
        prefs->m_bpreviewprio = in_m_bpreviewprio;
    }
    bool GetPreviewPrio()
    {
        return prefs->m_bpreviewprio;
    }
    // ~/.eMule Line 82:UpdateQueueListPref
    void SetUpdateQueueList(bool in_m_bupdatequeuelist)
    {
        prefs->m_bupdatequeuelist = in_m_bupdatequeuelist;
    }
    bool GetUpdateQueueList()
    {
        return prefs->m_bupdatequeuelist;
    }
    bool IsQueueListDisabled()
    {
        return prefs->m_bDisableQueueList;
    }
    // <-- ?!? PLK
    // ~/.eMule Line 83:ManualHighPrio
    void SetManualHighPrio(bool in_m_bmanualhighprio)
    {
        prefs->m_bmanualhighprio = in_m_bmanualhighprio;
    }
    bool GetManualHighPrio()
    {
        return prefs->m_bmanualhighprio;
    }
    // ~/.eMule Line 84:FullChunkTransfers
    void SetTransferFullChunks(bool in_m_btransferfullchunks)
    {
        prefs->m_btransferfullchunks = in_m_btransferfullchunks;
    }
    bool TransferFullChunks()
    {
        return prefs->m_btransferfullchunks;
    }
    // ~/.eMule Line 85:StartNextFile
    void SetStartNextFile(bool in_m_bstartnextfile)
    {
        prefs->m_bstartnextfile = in_m_bstartnextfile;
    }
    bool StartNextFile()
    {
        return prefs->m_bstartnextfile;
    }
    // ~/.eMule Line 86:ShowOverhead
    void SetShowOverhead(bool in_showoverhead)
    {
        prefs->m_bshowoverhead = in_showoverhead;
    }
    bool ShowOverhead()
    {
        return prefs->m_bshowoverhead;
    }
    // ~/.eMule Line 87:VideoPreviewBackupped
    void SetMoviePreviewBackup(bool in_moviePreviewBackup)
    {
        prefs->moviePreviewBackup = in_moviePreviewBackup;
    }
    bool IsMoviePreviewBackup()
    {
        return prefs->moviePreviewBackup;
    }
    // ~/.eMule Line 88:FileBufferSizePref (1 - 100)
    void SetFileBufferSize(uint32 in_m_iFileBufferSize)
    {
        prefs->m_iFileBufferSize = (uint32) in_m_iFileBufferSize / 15000;
    }
    uint32 GetFileBufferSize()
    {
        return prefs->m_iFileBufferSize *15000;
    }
    // ~/.eMule Line 89:QueueSizePref (20 - 100)
    void SetQueueSize(uint32 in_m_iQueueSize)
    {
        prefs->m_iQueueSize = in_m_iQueueSize / 100;
    }
    uint32 GetQueueSize()
    {
        return prefs->m_iQueueSize *100;
    }
    // ~/.eMule Line 91:UAPPref
    void SetNewAutoUp(bool in_m_bUAP)
    {
        prefs->m_bUAP = in_m_bUAP;
    }
    bool GetNewAutoUp()
    {
        return prefs->m_bUAP;
    }
    // ~/.eMule Line 144-155:StatColor0-StatColor12
    void SetStatsColor(int index, uint32 value)
    {
        prefs->statcolors[index] = value;
    }
    uint32 GetStatsColor(int index)
    {
        return prefs->statcolors[index];
    }
    void ResetStatsColor(int index);
    // ~/.emule Line ??
    void SetFilterServerByIP(bool infilterserverbyip)
    {
        prefs->filterserverbyip = infilterserverbyip;
    }
    bool FilterServerByIP()
    {
        return prefs->filterserverbyip;
    }
    // New Prefs
    bool IsSecureIdentEnabled();
    // UNSORTED *****************************************************************************
    // Download Categories (Ornis)
    void RemoveCat(int index);
    int AddCat(Category_Struct *cat)
    {
        catMap.Add(cat);
        return catMap.GetCount() - 1;
    }
    int GetCatCount()
    {
        return catMap.GetCount();
    }
    Category_Struct *GetCategory(int index)
    {
        if (index >= 0 && index < catMap.GetCount()) return catMap.GetAt(index);
        else return NULL;
    }
    char *GetCatPath(uint8 index)
    {
        return catMap.GetAt(index)->incomingpath;
    }
    DWORD GetCatColor(int index)
    {
        if ((int) index >= 0 && (int) index < (int) catMap.GetCount()) return catMap.GetAt(index)->color;
        else return 0;
    }
    int GetAllcatType()
    {
        return prefs->allcatType;
    }
    void SetAllcatType(int in)
    {
        prefs->allcatType = in;
    }
    bool ShowAllNotCats()
    {
        return prefs->showAllNotCats;
    }
    bool ShowRatingIndicator()
    {
        return prefs->indicateratings;
    }
    bool WatchClipboard4ED2KLinks()
    {
        return prefs->watchclipboard;
    }
    void InvertShowAllNotCats()
    {
        prefs->showAllNotCats =!prefs->showAllNotCats;
    }
    bool Log2Disk()
    {
        return prefs->log2disk;
    }
    bool Debug2Disk()
    {
        return prefs->debug2disk;
    }
    int GetMaxLogMessages()
    {
        return prefs->iMaxLogMessages;
    }
    char *GetUserHash()
    {
        return userhash;
    }
    char *GetLRUServermetURL()
    {
        return prefs->m_szLRUServermetURL;
    }
    void SetLRUServermetURL(const char *pszURL)
    {
        snprintf(prefs->m_szLRUServermetURL, sizeof prefs->m_szLRUServermetURL, "%s", pszURL);
    }
    void Add2TotalDownloaded(uint64 in)
    {
        prefs->totalDownloadedBytes += in;
    }
    void Add2TotalUploaded(uint64 in)
    {
        prefs->totalUploadedBytes += in;
    }
    uint64 GetTotalDownloaded()
    {
        return prefs->totalDownloadedBytes;
    }
    uint64 GetTotalUploaded()
    {
        return prefs->totalUploadedBytes;
    }
    uint16 GetMaxSourcePerFileSoft()
    {
        uint16 temp = (uint16)(prefs->maxsourceperfile *0.9);
        if (temp > 1000)
        return 1000;
        return temp;
    }
    uint16 GetMaxSourcePerFileUDP()
    {
        uint16 temp = (uint16)(prefs->maxsourceperfile *0.75);
        if (temp > 100) return 100;
        return temp;
    }
    WORD GetLanguageID()
    {
        return prefs->languageID;
    }
    int8 GetSplitterbarPosition()
    {
        return prefs->splitterbarPosition;
    }
    void SetSplitterbarPosition(int8 pos)
    {
        prefs->splitterbarPosition = pos;
    }
    int8 GetStatsMax()
    {
        return prefs->statsMax;
    }
    bool GetUseDownloadNotifier()
    {
        return prefs->useDownloadNotifier;
    }
    bool GetUseChatNotifier()
    {
        return prefs->useChatNotifier;
    }
    bool GetUseLogNotifier()
    {
        return prefs->useLogNotifier;
    }
    bool GetUseSoundInNotifier()
    {
        return prefs->useSoundInNotifier;
    }
    bool GetNotifierPopsEveryChatMsg()
    {
        return prefs->notifierPopsEveryChatMsg;
    }
    bool GetNotifierPopOnImportantError()
    {
        return prefs->notifierImportantError;
    }
    bool GetNotifierPopOnNewVersion()
    {
        return prefs->notifierNewVersion;
    }
    char *GetNotifierWavSoundPath()
    {
        return prefs->notifierSoundFilePath;
    }
    CString GetIRCNick()
    {
        return(CString) prefs->m_sircnick;
    }
    void SetIRCNick(char in_nick[])
    {
        strcpy(prefs->m_sircnick, in_nick);
    }
    CString GetIRCServer()
    {
        return(CString) prefs->m_sircserver;
    }
    void SetIRCServer(char in_serv[])
    {
        strcpy(prefs->m_sircserver, in_serv);
    }
    bool GetIRCAddTimestamp()
    {
        return prefs->m_bircaddtimestamp;
    }
    void SetIRCAddTimestamp(bool flag)
    {
        prefs->m_bircaddtimestamp = flag;
    }
    CString GetIRCChanNameFilter()
    {
        return(CString) prefs->m_sircchannamefilter;
    }
    bool GetIRCUseChanFilter()
    {
        return prefs->m_bircusechanfilter;
    }
    uint16 GetIRCChannelUserFilter()
    {
        return prefs->m_iircchanneluserfilter;
    }
    void SetIRCChanNameFilter(char in_name[])
    {
        strcpy(prefs->m_sircchannamefilter, in_name);
    }
    void SetIRCUseChanFilter(bool flag)
    {
        prefs->m_bircusechanfilter = flag;
    }
    void SetIRCChanUserFilter(uint16 in_user)
    {
        prefs->m_iircchanneluserfilter = in_user;
    }
    CString GetIrcPerformString()
    {
        return(CString) prefs->m_sircperformstring;
    }
    bool GetIrcUsePerform()
    {
        return prefs->m_bircuseperform;
    }
    bool GetIRCListOnConnect()
    {
        return prefs->m_birclistonconnect;
    }
    void SetIRCListonConnect(bool flag)
    {
        prefs->m_birclistonconnect = flag;
    }
    void SetIRCPerformString(char in_perf[])
    {
        strcpy(prefs->m_sircperformstring, in_perf);
    }
    void SetIrcUsePerform(bool flag)
    {
        prefs->m_bircuseperform = flag;
    }
    bool GetIrcAcceptLinks()
    {
        return prefs->m_bircacceptlinks;
    }
    void SetIrcAcceptLInks(bool flag)
    {
        prefs->m_bircacceptlinks = flag;
    }
    bool GetIrcIgnoreInfoMessage()
    {
        return prefs->m_bircignoreinfomessage;
    }
    void SetIrcIgnoreInfoMessage(bool flag)
    {
        prefs->m_bircignoreinfomessage = flag;
    }
    bool GetIrcIgnoreEmuleProtoInfoMessage()
    {
        return prefs->m_bircignoreemuleprotoinfomessage;
    }
    void SetIrcIgnoreEmuleProtoInfoMessage(bool flag)
    {
        prefs->m_bircignoreemuleprotoinfomessage = flag;
    }
    WORD GetWindowsVersion();
    void SetNewAutoDown(bool m_bInDAP)
    {
        prefs->m_bDAP = m_bInDAP;
    }
    bool GetNewAutoDown()
    {
        return prefs->m_bDAP;
    }
    bool IsKnownClientListDisabled()
    {
        return prefs->m_bDisableKnownClientList;
    }
    bool IsFirstStart()
    {
        return prefs->m_bFirstStart;
    }
    bool UseCreditSystem()
    {
        return prefs->m_bCreditSystem;
    }
    void SetCreditSystem(bool m_bInCreditSystem)
    {
        prefs->m_bCreditSystem = m_bInCreditSystem;
    }
    char *GetTxtEditor()
    {
        return prefs->TxtEditor;
    }
    int GetCommitFiles()
    {
        return prefs->m_iCommitFiles;
    }
    // quick-speed changer [xrmb]
    void SetMaxUpload(uint16 in)
    {
        prefs->maxupload = in;
    }
    ;
    void SetMaxDownload(uint16 in)
    {
        prefs->maxdownload = in;
        };
    WINDOWPLACEMENT GetEmuleWindowPlacement()
    {
        return prefs->EmuleWindowPlacement;
    }
    void SetWindowLayout(WINDOWPLACEMENT in)
    {
        prefs->EmuleWindowPlacement = in;
    }
    uint32 GetLastVC()
    {
        return prefs->versioncheckLastAutomatic;
    }
    void UpdateLastVC()
    {
        prefs->versioncheckLastAutomatic = time(NULL);
    }
    int GetIPFilterLevel()
    {
        return prefs->filterlevel;
    }
    CString GetMessageFilter()
    {
        return CString(prefs->messageFilter);
    }
    CString GetCommentFilter()
    {
        return CString(prefs->commentFilter);
    }
    char *GetNotifierConfiguration()
    {
        return prefs->notifierConfiguration;
        };
    //<<-- enkeyDEV(kei-kun) -skinnable notifier-
    void SetNotifierConfiguration(CString configFullPath)
    {
        sprintf(prefs->notifierConfiguration, "%s", configFullPath.GetData());
    }
    //<<-- enkeyDEV(kei-kun) -skinnable notifier-
    CString GetDateTimeFormat()
    {
        return CString(prefs->datetimeformat);
    }
    // WebServer
    uint16 GetWSPort()
    {
        return prefs->m_nWebPort;
    }
    void SetWSPort(uint16 uPort)
    {
        prefs->m_nWebPort = uPort;
    }
    CString GetWSPass()
    {
        return CString(prefs->m_sWebPassword);
    }
    void SetWSPass(CString strNewPass)
    {
        sprintf(prefs->m_sWebPassword, "%s", MD5Sum(strNewPass) .GetHash() .GetData());
    }
    bool GetWSIsEnabled()
    {
        return prefs->m_bWebEnabled;
    }
    void SetWSIsEnabled(bool bEnable)
    {
        prefs->m_bWebEnabled = bEnable;
    }
    bool GetWebUseGzip()
    {
        return prefs->m_bWebUseGzip;
    }
    void SetWebUseGzip(bool bUse)
    {
        prefs->m_bWebUseGzip = bUse;
    }
    int GetWebPageRefresh()
    {
        return prefs->m_nWebPageRefresh;
    }
    void SetWebPageRefresh(int nRefresh)
    {
        prefs->m_nWebPageRefresh = nRefresh;
    }
    bool GetWSIsLowUserEnabled()
    {
        return prefs->m_bWebLowEnabled;
    }
    void SetWSIsLowUserEnabled(bool in)
    {
        prefs->m_bWebLowEnabled = in;
    }
    CString GetWSLowPass()
    {
        return CString(prefs->m_sWebLowPassword);
    }
    void SetWSLowPass(CString strNewPass)
    {
        sprintf(prefs->m_sWebLowPassword, "%s", MD5Sum(strNewPass) .GetHash() .GetData());
    }
    bool IsSchedulerEnabled()
    {
        return prefs->scheduler;
    }
    bool GetDontCompressAvi()
    {
        return prefs->dontcompressavi;
    }
    bool MsgOnlyFriends()
    {
        return prefs->msgonlyfriends;
    }
    bool MsgOnlySecure()
    {
        return prefs->msgsecure;
    }
    uint16 GetMsgSessionsMax()
    {
        return prefs->maxmsgsessions;
    }
    CString GetTemplate()
    {
        return CString(prefs->m_sTemplateFile);
    }
    void SetTemplate(CString in)
    {
        sprintf(prefs->m_sTemplateFile, "%s", in.GetData());
    }
    int GetDesktopMode()
    {
        return prefs->desktopMode;
    }
    void SetDesktopMode(int mode)
    {
        prefs->desktopMode = mode;
    }
    // deadlake PROXYSUPPORT
    ProxySettings GetProxy()
    {
        return prefs->proxy;
    }
    void SetProxySettings(ProxySettings proxysettings)
    {
        prefs->proxy = proxysettings;
    }
    uint16 GetListenPort()
    {
        if (m_UseProxyListenPort) return ListenPort;
        else return prefs->port;
    }
    void SetListenPort(uint16 uPort)
    {
        ListenPort = uPort;
        m_UseProxyListenPort = true;
    }
    void ResetListenPort()
    {
        ListenPort = 0;
        m_UseProxyListenPort = false;
    }
    void SetUseProxy(bool in)
    {
        prefs->proxy.UseProxy = in;
    }
    bool IsProxyASCWOP()
    {
        return prefs->m_bIsASCWOP;
    }
    void SetProxyASCWOP(bool in)
    {
        prefs->m_bIsASCWOP = in;
    }
    bool ShowCatTabInfos()
    {
        return prefs->showCatTabInfos;
    }
    void ShowCatTabInfos(bool in)
    {
        prefs->showCatTabInfos = in;
    }
    bool GetResumeSameCat()
    {
        return prefs->resumeSameCat;
    }
    bool IsGraphRecreateDisabled()
    {
        return prefs->dontRecreateGraphs;
    }
    // Madcat - Sources Dropping Tweaks
    bool DropNoNeededSources()
    {
        return prefs->DropNoNeededSources;
    }
    bool SwapNoNeededSources()
    {
        return prefs->SwapNoNeededSources;
    }
    bool DropFullQueueSources()
    {
        return prefs->DropFullQueueSources;
    }
    bool DropHighQueueRankingSources()
    {
        return prefs->DropHighQueueRankingSources;
    }
    int HighQueueRanking()
    {
        return prefs->HighQueueRanking;
    }
    int GetAutoDropTimer()
    {
        return prefs->AutoDropTimer;
    }
    protected:
    bool SaveCats(void);
    bool LoadCats(void);
    bool LoadPreferences(void);
    void SavePreferences(void);
    bool Load_Adresses(void);
    bool Save_Adresses(void);
    bool Load_Shared_Dirs(void);
    bool Save_Shared_Dirs(void);
    void CreateUserHash();
    void SetStandartValues();
    static int GetRecommendedMaxConnections();
    private:
    char appdir[MAX_PATH];    
    Preferences_Ext_Struct *prefsExt;
    char userhash[16];
    WORD m_wWinVer;
    CArray < Category_Struct *, Category_Struct *> catMap;
    // deadlake PROXYSUPPORT
    bool m_UseProxyListenPort;
    uint16 ListenPort;
public:
    Preferences_Struct *prefs;
};

#endif
