// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef PREFERDLG_H
#define PREFERDLG_H

#include <wx/dialog.h>                  // Needed for wxDialog
#include "PPgGeneral.h"                 // Needed for CPPgGeneral
#include "PPgConnection.h"              // Needed for CPPgConnection
#include "PPgServer.h"                  // Needed for CPPgServer
#include "PPgDirectories.h"             // Needed for CPPgDirectories
#include "PPgFiles.h"                   // Needed for CPPgFiles
#include "PPgStats.h"                   // Needed for CPPgStats
#include "PPgNotify.h"                  // Needed for CPPgNotify
#include "PPgTweaks.h"                  // Needed for CPPgTweaks
#include "PPgSourcesDropping.h"         // Needed for CPPgSourcesDropping
#include "PPgGuiTweaks.h"               // Needed for CPPgGuiTweaks

class CPreferencesDlg : public wxDialog
{
  //DECLARE_DYNAMIC(CPreferencesDlg)
  DECLARE_DYNAMIC_CLASS(CPreferencesDlg)

    CPreferencesDlg() {};

public:
	CPreferencesDlg(wxWindow* parent,CPreferences* prefs);
	virtual ~CPreferencesDlg();
	
protected:
	UINT m_nActiveWnd;
	//DECLARE_MESSAGE_MAP()
	DECLARE_EVENT_TABLE()
public:
	CPPgGeneral*		m_wndGeneral;
	CPPgConnection*	m_wndConnection;
	CPPgServer*		m_wndServer;
	CPPgDirectories*	m_wndDirectories;
	CPPgFiles*		m_wndFiles;
	CPPgStats*		m_wndStats;
	CPPgNotify*		m_wndNotify;
	CPPgTweaks*		m_wndTweaks;
	CPPgSourcesDropping*    m_wndSourcesDropping;  // Sources Dropping window
	CPPgGuiTweaks*          m_wndGuiTweaks; // GUI Tweaks window
	CPreferences	*app_prefs;

	virtual int ShowModal();

	void SetPrefs(CPreferences* in_prefs)
	{
		app_prefs = in_prefs;
		m_wndGeneral->SetPrefs(in_prefs);
		m_wndConnection->SetPrefs(in_prefs);
		m_wndServer->SetPrefs(in_prefs);
		m_wndDirectories->SetPrefs(in_prefs);
		m_wndFiles->SetPrefs(in_prefs);
		m_wndStats->SetPrefs(in_prefs);
		m_wndNotify->SetPrefs(in_prefs);
		//m_wndIRC->SetPrefs(in_prefs);
		m_wndTweaks->SetPrefs(in_prefs);
		m_wndSourcesDropping->SetPrefs(in_prefs);  // Setting preferences to Sources Dropping
		m_wndGuiTweaks->SetPrefs(in_prefs); // Setting preferences to GUI Tweaks
	}
	//afx_msg void OnDestroy();
	//virtual BOOL OnInitDialog();

	void OnBtnOk(wxEvent& evt);
	void OnBtnCancel(wxEvent& evt);
	void OnBtnWizard(wxEvent& evt);

	void Localize(void)
	{
#if 0
		// start changed by InterCeptor (localization) 11.11.02 
		TC_ITEM item; 
		item.mask = TCIF_TEXT; 

		CStringArray buffer; 
		buffer.Add(GetResString(IDS_PW_GENERAL)); 
		buffer.Add(GetResString(IDS_PW_CONNECTION)); 
		buffer.Add(GetResString(IDS_PW_SERVER)); 
		buffer.Add(GetResString(IDS_PW_DIR)); 
		buffer.Add(GetResString(IDS_PW_FILES)); 
		buffer.Add(GetResString(IDS_PW_EKDEV_OPTIONS)); 
		buffer.Add(GetResString(IDS_STATSSETUPINFO)); 
		buffer.Add("IRC"); 

		for (int i = 0; i <= GetTabControl()->GetItemCount()-1; i++) { 
		item.pszText = buffer[i].GetBuffer(); 
		GetTabControl()->SetItem (i, &item); 
		buffer[i].ReleaseBuffer(); 
		} 
		// end changed by InterCeptor (localization) 11.11.02 
#endif
		//SetWindowText(GetResString(IDS_PREFERENCES_CAPTION));
		m_wndGeneral->Localize();
		m_wndConnection->Localize();
		m_wndServer->Localize();
		m_wndDirectories->Localize();
		m_wndFiles->Localize();
		m_wndStats->Localize();
		m_wndNotify->Localize();
		//m_wndIRC->Localize();
		m_wndTweaks->Localize();
		m_wndSourcesDropping->Localize();  // Localize Source Dropping window
		m_wndGuiTweaks->Localize(); // Localize GUI Tweaks window
	}
};


#endif
