// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef SERVERLISTCTRL_H
#define SERVERLISTCTRL_H

#include "server.h"                     // Needed for CServer
#include "MuleListCtrl.h"               // Needed for CMuleListCtrl

class serverListItem : public wxListItem {
 public:
  serverListItem() {};
  ~serverListItem() {};

  CServer* data;
};

// CServerListCtrl
class CServerList; 
class CServerListCtrl : public CMuleListCtrl 
{
  //	DECLARE_DYNAMIC(CServerListCtrl)
public:
	CServerListCtrl();
	CServerListCtrl(wxWindow*& parent,int id,const wxPoint& pos,wxSize siz,int flags);

//	void	ShowServers();
	virtual ~CServerListCtrl();
	bool	Init(CServerList* in_list);
	void InitSort();
	bool	AddServer(CServer* toadd,bool bAddToList = true);
	void	RemoveServer(CServer* todel,bool bDelToList = true);
	bool	AddServermetToList(wxString strFile);
	void	RefreshServer(CServer* server);
	void	RemoveDeadServer();
	//void	Hide() {ShowWindow(SW_HIDE);}
	//void	Visable() {ShowWindow(SW_SHOW);}
	void	Localize();
	void	ShowFilesCount();

	void OnRclickServlist(wxListEvent& event);
	void OnLDclick(wxMouseEvent& event);
	void OnConnectTo(wxCommandEvent& event);
	void OnCopyLink(wxCommandEvent& event);

	DECLARE_EVENT_TABLE()

	  void OnRemove(wxEvent& evt);
	void OnLvnColumnclickServlist(wxListEvent& evt);
	static int SortProc(long item1,long item2,long sortData);
#if 0
	afx_msg void OnNMRclickServlist(NMHDR *pNMHDR, LRESULT *pResult);
protected:
	afx_msg	void	OnLvnColumnclickServlist(NMHDR *pNMHDR, LRESULT *pResult);
	static	int		CALLBACK SortProc(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort);
#endif
	bool	asc_sort[9]; 
	bool ProcessEvent(wxEvent& evt);

	// Barry - New methods
	bool StaticServerFileAppend(CServer *server);
	bool StaticServerFileRemove(CServer *server);

	//virtual BOOL OnCommand(WPARAM wParam,LPARAM lParam );
	//DECLARE_MESSAGE_MAP()
private:
	CServerList*	server_list;
	wxImageList		imagelist;
	wxMenu* m_ServerPrioMenu;
	wxMenu* m_ServerMenu;
	//afx_msg void OnNMLdblclk (NMHDR *pNMHDR, LRESULT *pResult); //<-- mod bb 27.09.02
};

#endif
