// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "config.h"

// Test if we have _GNU_SOURCE before the next step will mess up
// setting __USE_GNU that we need for string.h to define basename
// (only needed for gcc-2.95 compatibility, gcc 3.2 always defines it)
#include <wx/setup.h>

// Mario Sergio Fujikawa Ferreira <lioux@FreeBSD.org>
// to detect if this is a *BSD system
#if defined(HAVE_SYS_PARAM_H)
#include <sys/param.h>
#endif

#ifdef PRECOMP
#	include "xmule-headers.h"
#else
#include "SharedFileList.h"             // Needed for this Interface's Prototype
#include "xmule.h"                      // Needed for theApp
#include "KnownFileList.h"              // Needed for CKnownFile::FindKnownFile
#include "SharedFilesCtrl.h"            // Needed for CSharedFileList::ShowFile
#	include "AddFileThread.h"
#	include "DownloadQueue.h"
#	include "muuli_wdr.h"
#	include "UploadQueue.h"
#	include "xmuleDlg.h"
#endif

#include <wx/msgdlg.h>
#include <time.h>
#include <wx/filename.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

// *BSD compatibility
// required for basename(1) definition
#if (defined(BSD) && (BSD >= 199103))
#include <libgen.h>
#endif

// so we get basename(1) only if we have _GNU_SOURCE or BSD
// what about other constellations ? -- let's try this:
#ifndef __USE_GNU
#include <libgen.h>
#endif

CSharedFileList::CSharedFileList(CPreferences * in_prefs, CServerConnect * in_server, CKnownFileList * in_kfilelist)
{
    listof_SharedFiles = NULL;
    MapData_Init(listof_SharedFiles);
    app_prefs = in_prefs;
    server = in_server;
    kfilelist = in_kfilelist;
    output = 0;
    FindSharedFiles();
}

CSharedFileList::~ CSharedFileList()
{
    MapData_RemoveAll(listof_SharedFiles);
}

void CSharedFileList::FindSharedFiles()
{
    if (theApp.xmuledlg->IsRunning())
    {
        if (!listof_SharedFiles->Data)
        {
            list_mut.Lock();
            MapData_RemoveAll(listof_SharedFiles);
            list_mut.Unlock();
            //TODO: for dynamic partfiles:
            theApp.downloadqueue->AddPartFilesToShare();
        }
    /* Global incoming dir and all category incoming directories are automatically shared. */
        AddFilesFromDirectory(theApp.glob_prefs->GetIncomingDir());
        for (int i = 1 ; i < theApp.glob_prefs->GetCatCount() ; i++)
        {
            AddFilesFromDirectory(theApp.glob_prefs->GetCatPath(i));
        }
        //for (POSITION pos = app_prefs->shareddir_list.GetHeadPosition();pos != 0;app_prefs->shareddir_list.GetNext(pos))
        // remove bogus entries first
        for (int ij = 0 ; ij < app_prefs->shareddir_list.GetCount() ; ij++)
        {
            if (!wxFileName::DirExists(app_prefs->shareddir_list.Item(ij)))
            {
                app_prefs->shareddir_list.Remove(ij);
                --ij;
            }
        }
        for (int ii = 0 ; ii < app_prefs->shareddir_list.GetCount() ; ii++)
        {
            AddFilesFromDirectory((char *) app_prefs->shareddir_list.Item(ii) .GetData());
        }
        uint32 newFiles = CAddFileThread::GetCount();
        if (!newFiles)
        {
            theApp.xmuledlg->AddLogLine(false, GetResString(IDS_SHAREDFOUND), listof_SharedFiles->Data);
        }
        else
        {
            theApp.xmuledlg->AddLogLine(false, GetResString(IDS_SHAREDFOUNDHASHING), listof_SharedFiles->Data, newFiles);
        }
    }
}

void CSharedFileList::AddFilesFromDirectory(char * directory)
{
    char * searchpath = new char[strlen(directory) + 3];
    // Kry - Add slash only if it's not already in string to avoid double-slash
    if (directory[strlen(directory) - 1] != '/')
    {
        sprintf(searchpath, "%s/*", directory);
    }
    else
    {
        sprintf(searchpath, "%s*", directory);
    }
    wxString fname =::wxFindFirstFile(searchpath, wxFILE);
    delete[] searchpath;
    if (fname.IsEmpty())
    {
        return;
    }
    while (!fname.IsEmpty())
    {
        wxFileName fName(fname);
        wxDateTime accTime, modTime, crtTime;
        fName.GetTimes( & accTime, & modTime, & crtTime);
        uint32 fdate = modTime.GetTicks();
        int koko;
        struct stat sbf;
        stat(fname.GetData(), & sbf);
        koko = sbf.st_size;
        CKnownFile * toadd = kfilelist->FindKnownFile((char *) fName.GetFullName() .GetData(), fdate, koko);
        if (toadd)
        {
            if (MapData_Find(listof_SharedFiles, toadd->GetFileHash(), 16))
            {
                if (wxStrcmp(fName.GetFullName() .GetData(), toadd->GetFileName()))
                {
                    printf("Warning: File '%s' already shared as '%s'\n", fName.GetFullName() .GetData(), toadd->GetFileName());
                }
            }
            else
            {
                toadd->SetPath(directory);
                output->ShowFile(toadd);
                list_mut.Lock();
                MapData_Insert(listof_SharedFiles, toadd, toadd->GetFileHash(), 16);
                list_mut.Unlock();
            }
        }
        else
        {
            //not in knownfilelist - start adding thread to hash file
            CAddFileThread::AddFile(directory, fName.GetFullName() .GetData());
        }
        fname =::wxFindNextFile();
    }
}

void CSharedFileList::SafeAddKFile(wxUint8 type, CKnownFile * toadd, bool bOnlyAdd)
{
    // TODO: Check if the file is already known - only with another date
    //CSingleLock sLock(&list_mut,true);
    list_mut.Lock();
    if (MapData_Find(listof_SharedFiles, toadd->GetFileHash(), 16))
    {
        list_mut.Unlock();
        return;
    }
    MapData_Insert(listof_SharedFiles, toadd, toadd->GetFileHash(), 16);
    //sLock.Unlock();
    list_mut.Unlock();
    if (bOnlyAdd)
    {
        output->ShowFile(toadd);
        return;
    }
    if (output)
    {
        output->ShowFile(toadd);
    }
    // offer new file to server
    if (server->IsConnected())
    {
        CMemFile * files = new CMemFile(100);
        uint32 filecount = 1;
        files->Write( & filecount, 4);
        CreateOfferedFilePacket(toadd, files);
        Packet * packet = new Packet(files);
        packet->opcode = OP_OFFERFILES;

        CServer *cur_server=server->GetCurrentServer();
        if (cur_server)
        {
            if(cur_server->GetTCPFlags()&0x00000001)
            {
                packet->PackPacket();
            }
        }

        delete files;
        theApp.uploadqueue->AddUpDataOverheadServer(packet->size);
#if defined(__DEBUG__)
        printf("CSharedFileList::SAKF->OP_OFFERFILES size=%d\n", packet->size);
#endif
        server->SendPacket(packet, true);
    }
}

// removes first occurrence of 'toremove' in 'list'
void CSharedFileList::RemoveFile(CKnownFile * toremove)
{
    MAP * found;
    output->RemoveFile(toremove);
    found = MapData_Find(listof_SharedFiles, toremove->GetFileHash(), 16);
    if (found)
    {
        printf("CSharedFileLIst::RemoveFile: === found %u\n", (wxUint32) toremove);
        found = MapData_Remove(listof_SharedFiles, found);
    }
    else
    {
        printf("CSharedFileLIst::RemoveFile: not found %u\n", (wxUint32) toremove);
    }
}

#define GetDlgItem(X) (wxStaticCast(wxWindow::FindWindowById((X)),wxButton))
void CSharedFileList::Reload(bool sendtoserver, bool firstload)
{
    // Madcat - Disable reloading if reloading already in progress.
    // Kry - Fixed to let non-english language users use the 'Reload' button :P
    if (GetDlgItem(IDC_RELOADSHAREDFILES)->GetLabel() == GetResString(IDS_SF_RELOAD))
    {
        GetDlgItem(IDC_RELOADSHAREDFILES)->SetLabel(wxT("Loading..."));
        output->DeleteAllItems();
        this->FindSharedFiles();
        if ((output) && (firstload == false))
        {
            output->ShowFileList(this);
        }
        if (sendtoserver)
        {
            SendListToServer();
        }
        GetDlgItem(IDC_RELOADSHAREDFILES)->SetLabel(GetResString(IDS_SF_RELOAD));
    }
    output->InitSort();
}

void CSharedFileList::SetOutputCtrl(CSharedFilesCtrl * in_ctrl)
{
    output = in_ctrl;
    output->ShowFileList(this);
}

void CSharedFileList::SendListToServer()
{
    if (listof_SharedFiles->Data && server->IsConnected())
    {
        CMemFile * files = new CMemFile();
        wxUint32 filecount = listof_SharedFiles->Data;
        files->Write( & filecount, 4);
        MAP * pos;
        pos = listof_SharedFiles->next;
        while (pos->Key)
        {
            CreateOfferedFilePacket((CKnownFile *) pos->Data, files);
            pos = pos->next;
        }
        Packet * packet = new Packet(files);
        packet->opcode = OP_OFFERFILES;

        CServer *cur_server=server->GetCurrentServer();
        if (cur_server)
        {
            if(cur_server->GetTCPFlags()&0x00000001)
            {
                packet->PackPacket();
            }
        }

        delete files;
        theApp.uploadqueue->AddUpDataOverheadServer(packet->size);
#if defined(__DEBUG__)
        printf("CSharedFileList::SendListToServer--> OP_OFFERFILES", packet->pBuffer, packet->size);
#endif
        server->SendPacket(packet, true);
    }
}

CKnownFile * CSharedFileList::GetFileByIndex(int index)
{
    int count = 0;
    MAP * pos;
    pos = listof_SharedFiles->next;
    while (pos->Key)
    {
        if (index == count)
        {
            return(CKnownFile *) pos->Data;
        }
        else
        {
            count++;
        }
        pos = pos->next;
    }
    return NULL;
}

void CSharedFileList::CreateOfferedFilePacket(CKnownFile * cur_file, CMemFile * files)
{
    files->Write(cur_file->GetFileHash(), 16);
    char * buffer = new char[6];
    memset(buffer, 0, 6);
    files->Write(buffer, 6);
    delete[] buffer;
    files->Write(cur_file->GetFileTypePtr(), 4);
    CTag * nametag = new CTag(FT_FILENAME, cur_file->GetFileName());
    nametag->WriteTagToFile(files);
    delete nametag;
    CTag * sizetag = new CTag(FT_FILESIZE, cur_file->GetFileSize());
    sizetag->WriteTagToFile(files);
    delete sizetag;
    //TODO add tags for documents mp3 etc
}

uint64 CSharedFileList::GetDatasize()
{
    uint64 fsize;
    fsize = 0;
    MAP * pos;
    pos = listof_SharedFiles->next;
    while (pos->Key)
    {
        fsize += ((CKnownFile *) pos->Data)->GetFileSize();
        pos = pos->next;
    }
    return fsize;
}

CKnownFile * CSharedFileList::GetFileByID(uchar * filehash)
{
    MAP * found;
    found = MapData_Find(listof_SharedFiles, filehash, 16);
    if (found)
    {
        return(CKnownFile *) found->Data;
    }
    else
    {
        return NULL;
    }
}

short CSharedFileList::GetFilePriorityByID(uchar * filehash)
{
    CKnownFile * tocheck = GetFileByID(filehash);
    if (tocheck)
    {
        return tocheck->GetUpPriority();
    }
    else
    {
        // file doesn't exist:
        return - 10;
    }
}

void CSharedFileList::UpdateItem(CKnownFile * toupdate)
{
    output->UpdateItem(toupdate);
}

void CSharedFileList::GetSharedFilesByDirectory(const char * directory,
CTypedPtrList <CPtrList, CKnownFile *> & list)
{
    CKnownFile * cur_file;
    MAP * pos;
    pos = listof_SharedFiles->next;
    while (pos->Key)
    {
        cur_file = (CKnownFile *) pos->Data;
        if (!strcmp(cur_file->GetPath(), directory))
        {
            list.AddTail(cur_file);
        }
        pos = pos->next;
    }
}

