// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#ifndef PACKETS_H
#define PACKETS_H

#include "opcodes.h"                    // Needed for OP_EDONKEYPROT
#include "types.h"                      // Needed for uint8
#include "SafeFile.h"                   // Needed for CSafeFile
#include <exception>                    // Needed for std::exception

extern void pckfilter(wxUint8 opcode,void *pbuffer,int length);

//			PACKET CLASS
// TODO some parts could need some work to make it more efficient
class Packet {
public:
	Packet(uint8 protocol = OP_EDONKEYPROT);
	Packet(unsigned char* header); // only used for receiving packets
	Packet(char* pPacketPart,uint32 nSize,bool bLast); // only used for splitted packets!
	Packet(CMemFile* datafile,uint8 protocol = OP_EDONKEYPROT);
	//Packet(int8 in_opcode,CMemFile* datafile,uint8 protocol = OP_EDONKEYPROT);
	Packet(int8 in_opcode,int32 in_size,uint8 protocol = OP_EDONKEYPROT);
	Packet(int8 in_opcode,int32 in_size,uint8 protocol, unsigned char *buffer);
	Packet(char* type,int8 in_opcode,int32 in_size,uint8 protocol = OP_EDONKEYPROT,bool bFromPF = true);
	Packet(char* type,char* pPacketPart,uint32 nSize,bool bLast,bool bFromPF = true);//only used for spl. packets!
	~Packet();
	char*	GetHeader();
	char*	GetUDPHeader();
	char*	GetPacket();
	char*	DetachPacket();
	uint32	GetRealPacketSize()		{return size+6;}
	bool	IsSplitted()			{return m_bSplitted;}
	bool	IsLastSplitted()		{return m_bLastSplitted;}
	void	PackPacket();
	bool	UnPackPacket(unsigned int uMaxDecompressedSize = 50000);
	char*	pBuffer;
	uint32	size;
	uint8	opcode;
	uint8	prot;
	// -khaos--+++> Returns either -1, 0 or 1.  -1 is unset, 0 is from complete file, 1 is from part file
	bool	IsFromPF()				{return m_bFromPF;}
	// <-----khaos-
private:
	bool	m_bSplitted;
	bool	m_bLastSplitted;
	char	head[6];
	char*	completebuffer;
	char*	tempbuffer;
	bool	m_bPacked;
	int	m_bFromPF;
};
struct Tag_Struct{
	int8	type;
	char*	tagname;
	char*	stringvalue;
	uint32	intvalue;
	int8	specialtag;
	
};

class CInvalidPacket : public std::exception
{
public:
	CInvalidPacket(const char* = "not specified");
	
	virtual const char* what() const throw();

private:
	char m_acWhat[256];
};

class CStrangePacket : public CInvalidPacket
{
public:
	CStrangePacket(const char* w = "not specified") : CInvalidPacket(w)
	{ }
};

enum TTagType
{
	TAG_UNSPEC = -1,
	TAG_STRING = 2,
	TAG_INTEGER = 3
};

class CTag {
public:
	CTag(char* name,uint32 intvalue);
	CTag(int8 special, uint32 intvalue);
	CTag(char* name,char* strvalue);
	CTag(int8 special, char* strvalue);
	CTag(Tag_Struct* in_tag);
	CTag(CFile* in_data);
	CTag(CMemFile* in_data);
	~CTag();
	CTag* CloneTag()	{return new CTag(tag);};
	bool WriteTagToFile(CFile* file); //used for CMemfiles
	bool WriteTagToFile(CMemFile* file);
	bool WriteTagToFile(FILE* file);
	Tag_Struct* tag;
	void DumpToStdout() const;
	TTagType GetType() const;
};

#endif
