// This file is a part of the xMule Project.
// 
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
// 
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.xmule-project.net )
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include <iostream>                         // Needed for std::cout
#include <mcheck.h>
#include <gtk/gtk.h>                        // Needed for GTK_WINDOW_TOPLEVEL
#include <sys/stat.h>                       // Needed for mkdir

#include <wx/clipbrd.h>                     // Needed for wxTheClipboard
#include <wx/msgdlg.h>                      // Needed for wxMessageBox
#include <wx/splash.h>                      // Needed for wxSplashScreen
#include <wx/xrc/xmlres.h>                  // Needed for wxXmlResource

#include "xmule.h"                          // Needed for this Interface's Prototype

#include "ChatWnd.h"                        // Needed for CChatWnd
#include "ClientCredits.h"                  // Needed for CClientCredits
#include "ClientList.h"                     // Needed for CClientList
#include "config.h"                         // Needed for HAVE_SYS_RESOURCE_H
#include "DownloadQueue.h"                  // Needed for CDownloadQueue
#include "NewSockets.h"                     // Needed for NewSocket_Start
#include "ED2KLink.h"                       // Needed for CED2KLink
#include "FlowChart.h"                      // Needed for CFlowChart
#include "FriendList.h"                     // Needed for CFriendList
#include "IPFilter.h"                       // Needed for CIPFilter
#include "ldaemon.h"                        // Needed for CLDaemon
#include "muuli_wdr.h"                      // Needed for ID_FRIENDLIST
#include "PreferencesDlg.h"                 // Needed for CPreferencesDlg
#include "ServerWnd.h"                      // Needed for CServerWnd
#include "SharedFilesWnd.h"                 // Needed for CSharedFilesWnd
#include "StatisticsDlg.h"                  // Needed for CStatisticsDlg
#include "TransferWnd.h"                    // Needed for CTransferWnd
#include "UploadQueue.h"                    // Needed for CUploadQueue
#include "xmuleDlg.h"                       // Needed for CxmuleDlg

#include "DynPrefs/DynPrefs.h"              // Needed for DynamicPreferences

using std::cout;
using std::endl;

IMPLEMENT_APP(CxmuleApp)

void InitSplashXRC();

#ifdef HAVE_SYS_RESOURCE_H
#include <sys/resource.h>
#endif

#ifdef __GLIBC__
# define RLIMIT_RESOURCE __rlimit_resource
#else
# define RLIMIT_RESOURCE int
#endif

static void UnlimitResource(RLIMIT_RESOURCE resType)
{
#if defined(HAVE_GETRLIMIT) && defined(HAVE_SETRLIMIT)
    struct rlimit rl;
    getrlimit(resType, & rl);
    rl.rlim_cur = rl.rlim_max;
    setrlimit(resType, & rl);
#endif
}

static void SetResourceLimits()
{
#ifdef HAVE_SYS_RESOURCE_H
    UnlimitResource(RLIMIT_DATA);
    UnlimitResource(RLIMIT_FSIZE);
    UnlimitResource(RLIMIT_NOFILE);
    UnlimitResource(RLIMIT_RSS);
#endif
}

CxmuleApp::CxmuleApp()
{
}

CxmuleApp::~ CxmuleApp()
{
    listensocket->Destroy();
}

int CxmuleApp::OnExit()
{
    cout << "xMule shutdown completed." << endl;
    return wxApp::OnExit();
}

//CxmuleApp theApp;

extern void InitXmlResource();

bool CxmuleApp::OnInit()
{
//    mtrace();
    for (int i = 1 ; i < argc ; i++)
    {
        if (strncmp(argv[i], "--version", 7) == 0)
        {
            printf("%s version %s\n", PACKAGE_NAME, PACKAGE_VERSION);
            sleep(1);
            exit(0);
        }
        else if (!(strncmp(argv[i], "--nowindow", 10)))
        {
            printf ("Starting without windows\n");
            daemon = true;
            nowindow = true;
        }
    }

//    dyn_prefs = new DynamicPrefs;
    MapData_Init(listof_UpDownClients);
    // catch fatal exceptions
    wxHandleFatalExceptions(true);
    //putenv("LANG=en_US");
    SetResourceLimits();
    // for resources
    wxXmlResource::Get()->InitAllHandlers();
    InitXmlResource();
    printf("Initialising xMule\n");
    close(0);
    //if(ProcessCommandLine())
    //  return FALSE;
    //SetTopWindow(dlg);
    SetVendorName("TikuWarez");
    // Do NOT change this string to xMule nor anything else, it WILL fuck you up.
    SetAppName("eMule");
    m_locale.Init(wxLANGUAGE_DEFAULT);
    m_locale.AddCatalogLookupPathPrefix(LOCALEDIR);
    m_locale.AddCatalog(PACKAGE);
    // Madcat - Check if prefs can be found at ~/.lmule and rename as neccesery.
    wxString OldPrefDir = getenv("HOME") + wxString("/.lmule");
    wxString NewPrefDir = getenv("HOME") + wxString("/.xMule");
    if (wxDirExists(OldPrefDir) && !wxDirExists(NewPrefDir))
    {
        printf("Found old settings, moving to new dir.\n");
        wxRenameFile(OldPrefDir, NewPrefDir);
    }
    if (!wxDirExists(NewPrefDir))
    {
        mkdir(NewPrefDir, 0777);
    }
    if (!wxDirExists(NewPrefDir + wxString("/Incoming")))
    {
        mkdir(NewPrefDir + wxString("/Incoming"), 0777);
    }
    if (!wxDirExists(NewPrefDir + wxString("/Temp")))
    {
        mkdir(NewPrefDir + wxString("/Temp"), 0777);
    }
    wxString filename = NewPrefDir + wxString("/server.met");
    if (!wxFileExists(filename))
    {
        wxFile metfile(filename, wxFile::write_excl);
        if (metfile.IsOpened())
        {
            metfile.Close();
        }
    }
    CxmuleDlg * dlg = new CxmuleDlg(NULL, wxString::Format(wxT("%s v%s"), wxT(PACKAGE_NAME), wxT(PACKAGE_VERSION)));
    xmuledlg = dlg;
    if (nowindow == false)
    {
        dlg->Show(TRUE);
    }
    // Delete old log file.
    wxRemoveFile(wxString::Format("%s/.xMule/logfile", getenv("HOME")));
    glob_prefs = new CPreferences();
    dynprefs = new DynamicPreferences;
    xmuledlg->flowchartwnd = new CFlowChart(xmuledlg);
    xmuledlg->flowchartwnd->Show(false);
    LoadCompatiblePrefs();

    xmuledlg->preferenceswnd->SetPrefs(glob_prefs);
    if (daemon == false)
    {
        xmuledlg->createSystray(wxString::Format(wxT("%s v%s"), wxT(PACKAGE_NAME), wxT(PACKAGE_VERSION)));
    }
    // splashscreen
    if (daemon == false && theApp.glob_prefs->UseSplashScreen() && !theApp.glob_prefs->GetStartMinimized())
    {
        InitSplashXRC();
        wxImage::AddHandler(new wxJPEGHandler);
        wxFileSystem fsys;
        wxFSFile* f = fsys.OpenFile(wxT("memory:About.jpg"));
        wxSplashScreen* splsh = new wxSplashScreen(wxImage(*f->GetStream(), wxBITMAP_TYPE_JPEG), wxSPLASH_CENTRE_ON_SCREEN | wxSPLASH_TIMEOUT, 5000, NULL, - 1, wxDefaultPosition, wxDefaultSize, wxSIMPLE_BORDER | wxSTAY_ON_TOP);
    }

    if (daemon)
        lda->Init();

    clientlist = new CClientList();
    friendlist = new CFriendList();
    knownfiles = new CKnownFileList(glob_prefs->GetAppDir());
    serverlist = new CServerList(glob_prefs);
    serverconnect = new CServerConnect(serverlist, theApp.glob_prefs);
    sharedfiles = new CSharedFileList(glob_prefs, serverconnect, knownfiles);
    printf("*** TCP socket at %d\n", glob_prefs->GetPort());
    wxIPV4address myaddr;
    myaddr.AnyAddress();
    myaddr.Service(glob_prefs->GetPort());
    NewSocket_Start(1, 0, glob_prefs->GetUDPPort());
//    xmuledlg->flowchartwnd->Sync(1, 1, serverconnect->GetLocalIP(), glob_prefs->GetUDPPort(), NULL);    
    // bugfix - do this before creating the uploadqueue:
    downloadqueue = new CDownloadQueue(glob_prefs, sharedfiles);
    uploadqueue = new CUploadQueue(glob_prefs);
    ipfilter = new CIPFilter();
    clientcredits = new CClientCreditsList(glob_prefs);
//    webserver = new CWebServer();
    //INT_PTR nResponse = dlg.DoModal();
    // init statistics stuff, better do it asap
    xmuledlg->statisticswnd->Init();
    xmuledlg->statisticswnd->ShowInterval();
    // must do initialisations here..
    xmuledlg->serverwnd->serverlistctrl->Init(serverlist);
    serverlist->Init();
    // ini. downloadqueue
    theApp.downloadqueue->Init();
    xmuledlg->AddLogLine(true, PACKAGE_STRING);
    //
    theApp.sharedfiles->SetOutputCtrl((CSharedFilesCtrl *) xmuledlg->sharedfileswnd->FindWindowByName("sharedFilesCt"));
    // then init firend list
    theApp.friendlist->SetWindow((CFriendListCtrl *) theApp.xmuledlg->chatwnd->FindWindowById(ID_FRIENDLIST));
    theApp.friendlist->ShowFriends();
    SetTopWindow(dlg);
    // reset statistic values
    theApp.stat_sessionReceivedBytes = 0;
    theApp.stat_sessionSentBytes = 0;
    theApp.stat_reconnects = 0;
    theApp.stat_transferStarttime = 0;
    theApp.stat_serverConnectTime = 0;
    theApp.Start_time = GetTickCount();
    // Initialize and sort all lists.
    // FIX: Remove from here and put these back to the OnInitDialog()s
    // and call the OnInitDialog()s here!
    theApp.xmuledlg->transferwnd->downloadlistctrl->LoadSettings(CPreferences::tableDownload);
    theApp.xmuledlg->transferwnd->downloadlistctrl->InitSort();
    theApp.xmuledlg->transferwnd->uploadlistctrl->LoadSettings(CPreferences::tableUpload);
    theApp.xmuledlg->transferwnd->uploadlistctrl->InitSort();
    theApp.xmuledlg->transferwnd->queuelistctrl->LoadSettings(CPreferences::tableQueue);
    theApp.xmuledlg->transferwnd->queuelistctrl->InitSort();
    theApp.xmuledlg->serverwnd->serverlistctrl->LoadSettings(CPreferences::tableServer);
    theApp.xmuledlg->serverwnd->serverlistctrl->InitSort();
    theApp.xmuledlg->sharedfileswnd->sharedfilesctrl->LoadSettings(CPreferences::tableShared);
    theApp.xmuledlg->sharedfileswnd->sharedfilesctrl->InitSort();
    // call the initializers
    theApp.xmuledlg->transferwnd->OnInitDialog();
    xmuledlg->m_app_state = APP_STATE_RUNNING;
    theApp.sharedfiles->Reload(true, true);
/*    if (glob_prefs->GetWSIsEnabled())
    {
        webserver->ReloadTemplates();
        webserver->StartServer();
    }*/
    myaddr.Service(glob_prefs->GetPort());
    listensocket = new CListenSocket(glob_prefs, myaddr);
    if (!listensocket->Ok())
    {
        xmuledlg->AddLogLine(false, (_("Port %d is not available. You will be LOWID")), glob_prefs->GetPort());
        CString str;
        str.Format(_("Port %d is not available !!\n\nThis will mean that you will be LOWID.\n\nUse netstat to determine when port becomes available\nand try starting xmule again."), glob_prefs->GetPort());
        wxMessageBox(str, _("Error"), wxCENTRE | wxOK | wxICON_ERROR);
    }
    // pretty much ready now. start autoconnect if
    if (theApp.glob_prefs->DoAutoConnect())
    {
        theApp.xmuledlg->OnBnConnect();
    }
    return TRUE;
}

void CxmuleApp::ProcessCommand()
{
    uint32 num,i;
    wxString St1;
    bool notunderstood=true;

    lda->Print (wxString ("Processing command '") + lda->Command + wxString("'"),LD_OUTPUT,true);

    if ((lda->Command.Left (8)) == wxString ("connect "))
    {
        St1=lda->Command.AfterFirst (32);
//        num=serverlist->GetServerCount ();
        notunderstood = false;

        CServer* cur_file;
        for (int a = 0; a < theApp.serverlist->GetServerCount(); ++a)
        {
            cur_file = theApp.serverlist->GetNextServer();
            if (St1 == wxString (cur_file->GetListName()))
            {
                serverconnect->ConnectToServer(cur_file);
                lda->Print(wxString ("Found ") + St1 + wxString (" server. Trying connection"), LD_OUTPUT);
                break;
            }
        }
        delete cur_file;
    }
    else if ((lda->Command.Left (4)) == wxString ("exit"))
    {
        lda->Print ("Exiting xmule",LD_OUTPUT);
        xmuledlg->Close ();
        notunderstood=false;
    }
    else if ((lda->Command.Left (7)) == wxString ("window "))
    {
        St1=lda->Command.AfterFirst (32);
        if (St1 == wxString ("show"))
        {
            nowindow=false;
            notunderstood=false;
            xmuledlg->Show ();
        }
        else if (St1 == wxString ("hide"))
        {
            nowindow=true;
            notunderstood=false;
            xmuledlg->Hide ();
        }
    }
    else if ((lda->Command.Left (4)) == wxString ("help"))
    {
 	notunderstood=false;
	lda->Print ("Available commands are:",LD_OUTPUT);
	lda->Print ("\tconnect <server_name>\tConnect to server",LD_OUTPUT);
	lda->Print ("\texit\t\t\tClose xMule",LD_OUTPUT);
	lda->Print ("\thelp\t\t\tShow this help",LD_OUTPUT);
	lda->Print ("\twindow [show|hide]\tShow or Hide the xMule window",LD_OUTPUT);
    }

    if (notunderstood)
    {
        lda->Print (wxString ("Command ") + lda->Command + wxString(" not understood"),LD_OUTPUT);
	lda->Print ("Use command 'help' for get help",LD_OUTPUT);
    }
    lda->Command="";
}

void CxmuleApp::RefreshFiles()
{
    int i,num;
    CUpDownClient *client;
    CKnownFile *file;
    char buffer[150],username[20],filename[100];
    wxString buf;

    //
    // Upload
    //
    num=xmuledlg->transferwnd->uploadlistctrl->GetItemCount ();
    lda->Delete (LD_UPLO);
    if (num)
    {
        lda->Print ("------------------ ---------------------------------------------------------------------------------- ----------- ----------",LD_UPLO);
        lda->Print ("   Client Name                                     File Name                                             Speed    Transfered",LD_UPLO);
        lda->Print ("------------------ ---------------------------------------------------------------------------------- ----------- ----------",LD_UPLO);
        for (i=0;i<num;++i)
        {
            client = (CUpDownClient *)(xmuledlg->transferwnd->uploadlistctrl->GetItemData (i));
            if (!client)
                return;

            file = sharedfiles->GetFileByID(client->GetUploadFileID());
            strncpy (username,client->GetUserName(),18);
            username[18]=0;
            strncpy (filename,file->GetFileName(),82);
            filename[82]=0;

            sprintf (buffer,"%-18s %-82s %6.1f kB/s %10s",username,filename,(float) client->GetDatarate() /1024,CastItoXBytes(client->GetTransferedUp()).GetData());
            lda->Print (wxString (buffer),LD_UPLO);
        }
    }

    //
    // Download
    //
    buf=xmuledlg->transferwnd->downloadlistctrl->getListforDaemon();
    lda->Delete (LD_DOWN);
    if (buf.Len())
    {
        lda->Print (wxString ("------------------------------------------------------------ ---------- --------- ----------- ------- --------- ------------"),LD_DOWN);
        lda->Print (wxString ("                       FILE NAME                                SIZE    COMPLETED    SPEED    PERCENT   FONTS      STATE"),LD_DOWN);
        lda->Print (wxString ("------------------------------------------------------------ ---------- --------- ----------- ------- --------- ------------"),LD_DOWN);
        lda->Print (buf,LD_DOWN);
    }
}

void CxmuleApp::UpdateReceivedBytes(int32 bytesToAdd)
{
    SetTimeOnTransfer();
    stat_sessionReceivedBytes += bytesToAdd;
}

void CxmuleApp::UpdateSentBytes(int32 bytesToAdd)
{
    SetTimeOnTransfer();
    stat_sessionSentBytes += bytesToAdd;
}

void CxmuleApp::SetTimeOnTransfer()
{
    if (stat_transferStarttime > 0)
    return;
    stat_transferStarttime = GetTickCount();
}

typedef char * LPTSTR;

wxString CxmuleApp::StripInvalidFilenameChars(wxString strText, bool bKeepSpaces)
{
    LPTSTR pszBuffer = (char *) strText.GetData();
    LPTSTR pszSource = pszBuffer;
    LPTSTR pszDest = pszBuffer;
    while ( * pszSource != '\0')
    {
        // lots of invalid chars for filenames in windows :=):
        if (! (( * pszSource <= 31 && * pszSource >= 0) ||
        * pszSource == '\"' || * pszSource == '*' || * pszSource == '<' || * pszSource == '>' || * pszSource == '?' || * pszSource == '|' || * pszSource == '\\' || * pszSource == '/' || * pszSource == ':'))
        {
            if (!bKeepSpaces && * pszSource == ' ')
            {
                * pszDest = '_';
            }
            else
            {
                * pszDest = * pszSource;
            }
            pszDest++;
        }
        pszSource++;
    }
    * pszDest = '\0';
    return strText;
}

wxString CxmuleApp::CreateED2kLink(CAbstractFile * f)
{
    wxString strLink;
    // spaces to dots:
    strLink = strLink.Format("ed2k://|file|%s|%d|%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x|/", StripInvalidFilenameChars(f->GetFileName(), true) .GetData(),
    f->GetFileSize(), f->GetFileHash() [0], f->GetFileHash() [1], f->GetFileHash() [2], f->GetFileHash() [3], f->GetFileHash() [4], f->GetFileHash() [5], f->GetFileHash() [6], f->GetFileHash() [7], f->GetFileHash() [8], f->GetFileHash() [9], f->GetFileHash() [10], f->GetFileHash() [11], f->GetFileHash() [12], f->GetFileHash() [13], f->GetFileHash() [14], f->GetFileHash() [15]);
    return strLink.GetData();
}

wxString CxmuleApp::CreateED2kSourceLink(CAbstractFile * f)
{
    if (!serverconnect->IsConnected() || serverconnect->IsLowID())
    {
        xmuledlg->AddLogLine(true, GetResString(IDS_SOURCELINKFAILED));
        return CString("");
    }
    uint32 dwID = serverconnect->GetClientID();
    wxString strLink;
    // spaces to dots:
    strLink.Printf("ed2k://|file|%s|%u|%s|/|sources,%i.%i.%i.%i:%i|/", StripInvalidFilenameChars(f->GetFileName(), false) .GetData(),
    f->GetFileSize(), EncodeBase16(f->GetFileHash(), 16) .GetData(), (uint8) dwID, (uint8)(dwID >> 8), (uint8)(dwID >> 16), (uint8)(dwID >> 24), glob_prefs->GetPort());
    return strLink;
}

wxString CxmuleApp::CreateHTMLED2kLink(CAbstractFile * f)
{
    wxString strCode = "<a href=\"" + CreateED2kLink(f) + "\">" + StripInvalidFilenameChars(f->GetFileName(), true) + "</a>";
    return strCode;
}

bool CxmuleApp::CopyTextToClipboard(wxString strText)
{
    if (wxTheClipboard->Open())
    {
        wxTheClipboard->UsePrimarySelection(FALSE);
        wxTheClipboard->SetData(new wxTextDataObject(strText));
        wxTheClipboard->Close();
    }
}

 /* Original implementation by Bouc7 of the eMule Project.
 xMule Signature idea was designed by BigBob and implemented
 by Un-Thesis, with design inputs and suggestions from bothie.
    */

    void CxmuleApp::OnlineSig(bool zero /* reset stats (used on shutdown) */

)
{
    // Do not do anything if online signature is disabled in Preferences
    if (!theApp.glob_prefs->IsOnlineSignatureEnabled())
    {
        return;
    }
    // Build the filenames for the two files
    char * emulesig_path = new char[strlen(glob_prefs->GetAppDir()) + 14];
    char * xmulesig_path = new char[strlen(glob_prefs->GetAppDir()) + 13];
    sprintf(emulesig_path, "%sonlinesig.dat", glob_prefs->GetAppDir());
    sprintf(xmulesig_path, "%sxmulesig.dat", glob_prefs->GetAppDir());
    // Open both files for writing
    CFile xmulesig_out, emulesig_out;
    if (!emulesig_out.Open(emulesig_path, CFile::write))
    {
        theApp.xmuledlg->AddLogLine(true, GetResString(IDS_ERROR_SAVEFILE) + wxString(" OnlineSig File"));
    }
    if (!xmulesig_out.Open(xmulesig_path, CFile::write))
    {
        theApp.xmuledlg->AddLogLine(true, GetResString(IDS_ERROR_SAVEFILE) + wxString(" xMule OnlineSig File"));
    }
    char buffer[256];
    if (zero)
    {
        emulesig_out.Write("0\n0.0|0.0|0\n", 12);
        xmulesig_out.Write("0\n0\n0\n0\n0\n0.0\n0.0\n0\n0\n", 22);
    }
    else
    {
        if (serverconnect->IsConnected())
        {
            // We are online
            emulesig_out.Write("1", 1);
            emulesig_out.Write("|", 1);
            // Name of server (Do not use GetRealName()!)
            emulesig_out.Write(serverconnect->GetCurrentServer()->GetListName(), strlen(serverconnect->GetCurrentServer()->GetListName()));
            emulesig_out.Write("|", 1);
            // IP and port of the server
            emulesig_out.Write(serverconnect->GetCurrentServer()->GetFullIP(), strlen(serverconnect->GetCurrentServer()->GetFullIP()));
            emulesig_out.Write("|", 1);
            sprintf(buffer, "%d", serverconnect->GetCurrentServer()->GetPort());
            emulesig_out.Write(buffer, strlen(buffer));
            // Now for xmule sig
            xmulesig_out.Write("1", 1);
            xmulesig_out.Write("\n", 1);
            xmulesig_out.Write(serverconnect->GetCurrentServer()->GetListName(), strlen(serverconnect->GetCurrentServer()->GetListName()));
            xmulesig_out.Write("\n", 1);
            xmulesig_out.Write(serverconnect->GetCurrentServer()->GetFullIP(), strlen(serverconnect->GetCurrentServer()->GetFullIP()));
            xmulesig_out.Write("\n", 1);
            xmulesig_out.Write(buffer, strlen(buffer));
            xmulesig_out.Write("\n", 1);
            // Low- or High-ID (only in xmule sig)
            if (theApp.serverconnect->IsLowID())
            {
                xmulesig_out.Write("L\n", 2);
            }
            else
            {
                xmulesig_out.Write("H\n", 2);
            }
        }
        else
        {
            // Not connected to a server
            emulesig_out.Write("0", 1);
            xmulesig_out.Write("0\n0\n0\n0\n0\n", 10);
        }
        emulesig_out.Write("\n", 1);
        // Datarate for downloads
        sprintf(buffer, "%.1f", (float) downloadqueue->GetDatarate() / 1024);
        emulesig_out.Write(buffer, strlen(buffer));
        emulesig_out.Write("|", 1);
        xmulesig_out.Write(buffer, strlen(buffer));
        xmulesig_out.Write("\n", 1);
        // Datarate for uploads
        sprintf(buffer, "%.1f", (float) uploadqueue->GetDatarate() / 1024);
        emulesig_out.Write(buffer, strlen(buffer));
        emulesig_out.Write("|", 1);
        xmulesig_out.Write(buffer, strlen(buffer));
        xmulesig_out.Write("\n", 1);
        // Number of users waiting for upload
        sprintf(buffer, "%d", uploadqueue->GetWaitingUserCount());
        emulesig_out.Write(buffer, strlen(buffer));
        xmulesig_out.Write(buffer, strlen(buffer));
        xmulesig_out.Write("\n", 1);
        // Number of shared files
        sprintf(buffer, "%d", theApp.sharedfiles->listof_SharedFiles->Data);
        xmulesig_out.Write(buffer, strlen(buffer));
        xmulesig_out.Write("\n", 1);
    }
    /* if (!zero) */
    // Nick on the network
    sprintf(buffer, "%s", theApp.glob_prefs->GetUserNick());
    xmulesig_out.Write(buffer, strlen(buffer));
    xmulesig_out.Write("\n", 1);
    // Total received in GB
    sprintf(buffer, "%.2f", (float)(theApp.stat_sessionReceivedBytes + theApp.glob_prefs->GetTotalDownloaded()) / 1073741824);
    xmulesig_out.Write(buffer, strlen(buffer));
    xmulesig_out.Write("\n", 1);
    // Total sent in GB
    sprintf(buffer, "%.2f", (float)(theApp.stat_sessionSentBytes + theApp.glob_prefs->GetTotalUploaded()) / 1073741824);
    xmulesig_out.Write(buffer, strlen(buffer));
    xmulesig_out.Write("\n", 1);
    // xmule version
    sprintf(buffer, "%s", PACKAGE_VERSION);
    xmulesig_out.Write(buffer, strlen(buffer));
    xmulesig_out.Write("\n", 1);
    // Close the files
    emulesig_out.Close();
    xmulesig_out.Close();
    delete[] emulesig_path;
    delete[] xmulesig_path;
    //End Added By Bouc7:
}

#if defined(__linux__)
    #include <execinfo.h>                   // Needed for backtrace
    #include <string>                       // Needed for std::string
    #include <iostream>                     // Needed for std::cerr
    #include <cxxabi.h>                     // Needed for __cxa_demangle
    #include <wx/utils.h>                   // Needed for wxExecute
#endif

void CxmuleApp::OnFatalException()
{
    // Close sockets first.
/*    if (theApp.listensocket)
    {
        theApp.listensocket->Destroy();
        NewSocket_Stop(1);
    }*/

// (stkn) create backtrace
#if defined(__linux__)
    int status;
    char* realname;
    
    // 100 should be enough ?!?:
    void * bt_array[100];
    char ** bt_strings;
    int num_entries;

    if ((num_entries = backtrace(bt_array, 100)) < 0)
    {
        cerr << "* Could not generate backtrace" << endl;
        return;
    }

    if ((bt_strings = backtrace_symbols(bt_array, num_entries)) == NULL)
    {
        cerr << "* Could not get symbol names for backtrace" << endl;
        return;
    }

    cerr << "\nOOPS! - Seems like xMule crashed\n--== BACKTRACE FOLLOWS: ==--" << endl << endl;

    std::vector<std::string> functions;
    std::vector<std::string> addresses;
    std::vector<std::string> lines;

    std::string addr_str;

    for (int i = 0 ; i < num_entries ; i++)
    {
        std::string mangle(bt_strings[i]);
        std::string address;

        int firstparen, secondparen, firstbrack;


        firstparen = mangle.find("(_Z");
        secondparen = mangle.rfind('+');
        firstbrack = mangle.rfind('[');

        if (firstbrack != string::npos)
        {
            address = mangle.substr(firstbrack + 1, mangle.rfind(']') - firstbrack - 1);
            addr_str = addr_str + " " + address;
            addresses.push_back(address);
        }

        if (secondparen != string::npos)
        {
            if (firstparen != string::npos)
            {
                mangle = mangle.substr(firstparen + 1, secondparen - firstparen - 1);
                mangle = abi::__cxa_demangle(mangle.c_str(), 0, 0, &status);
            }
            else
            {
                firstparen = mangle.find('(');

                mangle = mangle.substr(firstparen + 1, secondparen - firstparen - 1);
            }
        }

        functions.push_back(mangle);
    }

    wxArrayString output;
    pid_t self_pid = getpid();
    std::string line;

    wxExecute(wxString::Format("addr2line -e /proc/%d/exe %s", self_pid, addr_str.c_str()), output);

    for (int a=0; a<output.GetCount(); ++a)
    {
        line = output[a].c_str();

        if (line == "??:0")
        {
            line.clear();
        }
        else
        {
            line = line.substr(line.rfind('/') + 1, line.length() - line.rfind('/') - 1);
        }

        lines.push_back(line);
    }

    for (int a=0; a<functions.size(); ++a)
    {
        cerr << "[" << a << "] " <<  functions[a];
        if (!lines[a].empty())
        {
            cerr << " | " << lines[a] << endl;
        }
        else 
        {
            cerr << " | " << addresses[a] << endl;
        }    
    }

#endif
}

#define wxGTK_WINDOW 1
#define SHIFT (8*(sizeof(short int)-sizeof(char)))

static bool GetColourWidget(int & red, int & green, int & blue, int type)
{
    GtkWidget * widget;
    switch (type)
    {
    case wxGTK_WINDOW:
        widget = gtk_window_new(GTK_WINDOW_TOPLEVEL);
        break;
    default:
        return FALSE;
    }
    GtkStyle * def = gtk_rc_get_style(widget);
    bool ok = false;
    if (!def)
    {
        def = gtk_widget_get_default_style();
    }
    if (def)
    {
        GdkColor * col;
        col = def->bg;
        red = col[GTK_STATE_NORMAL].red;
        green = col[GTK_STATE_NORMAL].green;
        blue = col[GTK_STATE_NORMAL].blue;
        ok = true;
    }
    gtk_widget_destroy(widget);
    return ok;
}

// external helper function
wxColour GetColour(wxSystemColour what)
{
    static wxColour * _systemWindowColour = NULL;
    switch (what)
    {
    case wxSYS_COLOUR_WINDOW:
        if (!_systemWindowColour)
        {
            int red, green, blue;
            if (!GetColourWidget(red, green, blue, wxGTK_WINDOW))
            {
                red = green = blue = 0x9c40;
            }
            _systemWindowColour = new wxColour(red >> SHIFT, green >> SHIFT, blue >> SHIFT);
        }
        return * _systemWindowColour;
    }
}

void CxmuleApp::LoadCompatiblePrefs()
{
    Preferences_Struct* oldprefs = theApp.glob_prefs->prefs;
// General Settings
    dynprefs->Add("nickname", wxString(oldprefs->nick, *wxConvCurrent));
    dynprefs->Add("progress-bar-style", (long)oldprefs->depth3D);
    dynprefs->Add("beep-on-errors", (bool)oldprefs->beepOnError);
    dynprefs->Add("bring-to-front", (bool)oldprefs->bringtoforeground);
    dynprefs->Add("download-doubleclick", (bool)oldprefs->transferDoubleclick);
    dynprefs->Add("mimimize-to-tray", (bool)oldprefs->mintotray);
    dynprefs->Add("online-signature", (bool)oldprefs->onlineSig);
    dynprefs->Add("prompt-on-exit", (bool)oldprefs->confirmExit);
    // * As a temp hack, we subtract 1 from desktopMode because of irregularities in eMule code 
    dynprefs->Add("systray-integration", (long)(oldprefs->desktopMode - 1));
    dynprefs->Add("show-splashscreen", (bool)oldprefs->splashscreen);
    dynprefs->Add("start-minimized", (bool)oldprefs->startMinimized);

// Connection Settings
    dynprefs->Add("limits-download", (long)(oldprefs->maxdownload == 65535 ? 0 : oldprefs->maxdownload));
    dynprefs->Add("limits-upload", (long)(oldprefs->maxupload == 65535 ? 0 : oldprefs->maxupload));
    dynprefs->Add("capacities-download", (long)(oldprefs->maxGraphDownloadRate == 65535 ? 0 : oldprefs->maxGraphDownloadRate));
    dynprefs->Add("capacities-upload", (long)(oldprefs->maxGraphUploadRate == 65535 ? 0 : oldprefs->maxGraphUploadRate));
    dynprefs->Add("tcp-port", (long)oldprefs->port);
    dynprefs->Add("enable-udp", (bool)(oldprefs->udpport == 0 ? false : true));
    dynprefs->Add("udp-port", (long)oldprefs->udpport);
    dynprefs->Add("max-sources", (long)oldprefs->maxsourceperfile);
    dynprefs->Add("autoconnect", (bool)oldprefs->autoconnect);
    dynprefs->Add("reconnect-on-loss", (bool)oldprefs->reconnect);
    dynprefs->Add("show-overhead", (bool)oldprefs->m_bshowoverhead);

// Server Settings
    dynprefs->Add("remove-dead-server", (bool)oldprefs->deadserver);
    dynprefs->Add("server-connect-tries", (long)oldprefs->deadserverretries);
    dynprefs->Add("filter-bad-ip", (bool)oldprefs->filterBadIP);
    dynprefs->Add("autoupdate-server", (bool)oldprefs->autoserverlist);
    dynprefs->Add("add-server-server", (bool)oldprefs->addserversfromserver);
    dynprefs->Add("add-server-client", (bool)oldprefs->addserversfromclient);
    dynprefs->Add("priority-system", (bool)oldprefs->scorsystem);
    dynprefs->Add("smart-lowid-check", (bool)oldprefs->smartidcheck);
    dynprefs->Add("use-safe-connect", (bool)oldprefs->safeServerConnect);
    dynprefs->Add("auto-static", (bool)oldprefs->autoconnectstaticonly);
    dynprefs->Add("add-server-high", (bool)oldprefs->m_bmanualhighprio);

// Files Settings
    dynprefs->Add("see-share", (long)oldprefs->m_iSeeShares);
    dynprefs->Add("last-chunk-first", (bool)oldprefs->m_bpreviewprio);
    dynprefs->Add("start-next-file", (bool)oldprefs->m_bstartnextfile);
    dynprefs->Add("transfer-full-chunks", (bool)oldprefs->m_btransferfullchunks);
    dynprefs->Add("add-paused", (bool)oldprefs->addnewfilespaused);
    dynprefs->Add("enable-ich", (bool)oldprefs->ICH);
    dynprefs->Add("auto-priority-share", (bool)oldprefs->m_bUAP);

// Directories Settings
    dynprefs->Add("incoming-directory", wxString(oldprefs->incomingdir, *wxConvCurrent));
    dynprefs->Add("temp-directory", wxString(oldprefs->tempdir, *wxConvCurrent));
#warning FIXME: -NEED- support for sharing other folders

// Statistics Settings
    dynprefs->Add("graph-delay", (long)oldprefs->trafficOMeterInterval);
    dynprefs->Add("graph-average", (long)oldprefs->statsAverageMinutes);
    dynprefs->Add("tree-delay", (long)oldprefs->statsInterval);

// Send newprefs event
    wxNotifyEvent event(wxEVT_PREFS_CHANGED);
    xmuledlg->flowchartwnd->dynprefs->AddPendingEvent(event);
}

void CxmuleApp::SetCompatiblePrefs()
{
    Preferences_Struct* oldprefs = theApp.glob_prefs->prefs;
// General Settings
    strcpy(oldprefs->nick, dynprefs->Get<wxString>("nickname").c_str());
    oldprefs->depth3D = dynprefs->Get<long>("progress-bar-style");
    oldprefs->beepOnError = dynprefs->Get<bool>("beep-on-errors");
    oldprefs->bringtoforeground = dynprefs->Get<bool>("bring-to-front");
    oldprefs->transferDoubleclick = dynprefs->Get<bool>("download-doubleclick");
    oldprefs->mintotray = dynprefs->Get<bool>("mimimize-to-tray");
    oldprefs->onlineSig = dynprefs->Get<bool>("online-signature");
    oldprefs->confirmExit = dynprefs->Get<bool>("prompt-on-exit");
    // * As a temp hack, we subtract 1 from desktopMode because of irregularities in eMule code 
    oldprefs->desktopMode = dynprefs->Get<long>("systray-integration") + 1;
    oldprefs->splashscreen = dynprefs->Get<bool>("show-splashscreen");
    oldprefs->startMinimized = dynprefs->Get<bool>("start-minimized");

// Connection Settings
    oldprefs->maxupload = dynprefs->Get<long>("limits-upload");
    oldprefs->maxdownload = dynprefs->Get<long>("limits-download");
    oldprefs->maxGraphDownloadRate = dynprefs->Get<long>("capacities-download");
    oldprefs->maxGraphUploadRate = dynprefs->Get<long>("capacities-upload");
    oldprefs->port = dynprefs->Get<long>("tcp-port");
    oldprefs->udpport = dynprefs->Get<long>("udp-port");
    oldprefs->maxsourceperfile = dynprefs->Get<long>("max-sources");
    oldprefs->autoconnect = dynprefs->Get<bool>("autoconnect");
    oldprefs->reconnect = dynprefs->Get<bool>("reconnect-on-loss");
    oldprefs->m_bshowoverhead = dynprefs->Get<bool>("show-overhead");

// Server Settings
    oldprefs->deadserver = dynprefs->Get<bool>("remove-dead-server");
    oldprefs->deadserverretries = dynprefs->Get<long>("server-connect-tries");
    oldprefs->filterBadIP = dynprefs->Get<bool>("filter-bad-ip");
    oldprefs->autoserverlist = dynprefs->Get<bool>("autoupdate-server");
    oldprefs->addserversfromserver = dynprefs->Get<bool>("add-server-server");
    oldprefs->addserversfromclient = dynprefs->Get<bool>("add-server-client");
    oldprefs->scorsystem = dynprefs->Get<bool>("priority-system");
    oldprefs->smartidcheck = dynprefs->Get<bool>("smart-lowid-check");
    oldprefs->safeServerConnect = dynprefs->Get<bool>("use-safe-connect");
    oldprefs->autoconnectstaticonly = dynprefs->Get<bool>("auto-static");
    oldprefs->m_bmanualhighprio = dynprefs->Get<bool>("add-server-high");

// Files Settings
    oldprefs->m_iSeeShares = dynprefs->Get<long>("see-share");
    oldprefs->m_bpreviewprio = dynprefs->Get<bool>("last-chunk-first");
    oldprefs->m_bstartnextfile = dynprefs->Get<bool>("start-next-file");
    oldprefs->m_btransferfullchunks = dynprefs->Get<bool>("transfer-full-chunks");
    oldprefs->addnewfilespaused = dynprefs->Get<bool>("add-paused");
    oldprefs->ICH = dynprefs->Get<bool>("enable-ich");
    oldprefs->m_bUAP = dynprefs->Get<bool>("auto-priority-share");

// Directories Settings
    strcpy(oldprefs->incomingdir, dynprefs->Get<wxString>("incoming-directory").c_str());
    strcpy(oldprefs->tempdir, dynprefs->Get<wxString>("temp-directory").c_str());

// Statistics Settings
    theApp.glob_prefs->SetTrafficOMeterInterval(dynprefs->Get<long>("graph-delay"));
    theApp.glob_prefs->SetStatsAverageMinutes(dynprefs->Get<long>("graph-average"));
    theApp.glob_prefs->SetStatsInterval(dynprefs->Get<long>("tree-delay"));
    theApp.xmuledlg->statisticswnd->ShowInterval();
}
