// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifdef PRECOMP
    #include "xmule-headers.h"
#endif

#include "AddFriend.h"                      // Needed for this Interface's Prototype

#include "FriendList.h"                     // Needed for CFriendList
#include "mfc.h"                            // Needed for CString
#include "muuli_wdr.h"                      // Needed for addFriendDlg
#include "otherfunctions.h"                 // Needed for GetTickCount
#include "resource.h"                       // Needed for IDS_ERR_NOVALIDFRIENDINFO
#include "xmule.h"                          // Needed for theApp

#include <wx/msgdlg.h>                      // Needed for wxMessageBox 
#include <wx/sizer.h>                       // Needed for wxSizer
#include <wx/textctrl.h>                    // Needed for wxTextCtrl

IMPLEMENT_DYNAMIC_CLASS(CAddFriend, wxDialog)

CAddFriend::CAddFriend(wxWindow *parent):
    wxDialog(parent, -1, _("Add a Friend"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE | wxSYSTEM_MENU)
{
    wxSizer* content = addFriendDlg(this, TRUE);
    content->Show(this, TRUE);
    OnInitDialog();
}

CAddFriend::~CAddFriend()
{
}

bool CAddFriend::OnInitDialog()
{
    Localize();
    return true;
}

BEGIN_EVENT_TABLE(CAddFriend, wxDialog)
EVT_BUTTON(ID_ADDFRIEND, CAddFriend::OnAddBtn)
EVT_BUTTON(ID_CLOSEDLG, CAddFriend::OnCloseBtn)
END_EVENT_TABLE()

// CAddFriend message handlers
void CAddFriend::Localize()
{
}

#define GetDlgItem(a,b) wxStaticCast(FindWindowById((a)),b)

void CAddFriend::OnAddBtn(wxCommandEvent &evt)
{
    CString name, userhash, fullip;
    uint32 ip;
    uint16 port;
    ip = port = 0;
    if (GetDlgItem(ID_USERNAME, wxTextCtrl)->GetValue() .Length())
    {
        name.Format("%s", GetDlgItem(ID_USERNAME, wxTextCtrl)->GetValue() .GetData());
    }
    if (GetDlgItem(ID_IPADDRESS, wxTextCtrl)->GetValue() .Length())
    {
        fullip.Format("%s", GetDlgItem(ID_IPADDRESS, wxTextCtrl)->GetValue() .GetData());
    }
    else
    {
        wxMessageBox(GetResString(IDS_ERR_NOVALIDFRIENDINFO));
        return;
    }
    if (GetDlgItem(ID_IPORT, wxTextCtrl)->GetValue() .Length())
    {
        wxString buff = GetDlgItem(ID_IPORT, wxTextCtrl)->GetValue();
        port = (atoi(buff.GetData())) ? atoi(buff.GetData()): 0;
    }
    else
    {
        wxMessageBox(GetResString(IDS_ERR_NOVALIDFRIENDINFO));
        return;
    }

    int a, b, c, d;
    a = b = c = d = 0;
    sscanf(fullip.GetData(), "%d.%d.%d.%d", &a, &b, &c, &d);
    ip = a | (b << 8) | (c << 16) | (d << 24);
    theApp.friendlist->AddFriend(NULL, 0, ip, port, 0, name, 0);
    EndModal(1);
}

void CAddFriend::OnCloseBtn(wxCommandEvent &evt)
{
    EndModal(0);
}

