// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef CLIENTUDP_H
#define CLIENTUDP_H

#include "mfc.h"                            // Needed for CPtrList
#include "types.h"                          // Needed for uint32

#include <wx/socket.h>                      // Needed for wxDatagramSocket

class Packet;

#pragma pack(1)
struct UDPPack{
	Packet* packet;
	uint32 dwIP;
	uint16 nPort;
	int    trial;
};
#pragma pack()

class CClientUDPSocket: public wxDatagramSocket
{
  DECLARE_DYNAMIC_CLASS(CClientUDPSocket)
    CClientUDPSocket(): wxDatagramSocket(useless2) {};
public:
	CClientUDPSocket(wxIPV4address address);
	virtual ~CClientUDPSocket();
	bool	SendPacket(Packet* packet, uint32 dwIP, uint16 nPort);
	bool	IsBusy()	{return m_bWouldBlock;}
	bool	Create();
protected:
	bool	ProcessPacket(unsigned char* packet, int16 size, wxUint8 opcode, wxUint32 hostip, uint16 port);
	
 public:
	virtual void	OnSend(int nErrorCode);	
	virtual void	OnReceive(int nErrorCode);
private:
	void	ClearQueues();	
	bool		SendTo(char* lpBuf,int nBufLen,uint32 dwIP, uint16 nPort);
	bool	m_bWouldBlock;

	CTypedPtrList<CPtrList, UDPPack*> controlpacket_queue;
	wxIPV4address  useless2;
};

#endif
