// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __ColorFrameCtrl_H__
#define __ColorFrameCtrl_H__

#include <wx/setup.h>                       // Needed for wxControl
#include <wx/control.h>                     // Needed for wxControl
#include <wx/dc.h>                          // Needed for wxBrush

#include "wintypes.h"                       // Needed for COLORREF

#ifndef RGB
#define RGB(a,b,c) ((a&0xff)<<16|(b&0xff)<<8|(c&0xff))
#endif

class CColorFrameCtrl: public wxControl
{
// Construction
public:
        CColorFrameCtrl( wxWindow* parent, int id,int wid,int hei );

// Attributes
public:
    void SetFrameColor(COLORREF color);
    void SetBackgroundColor(COLORREF color);

        // Operations
// Implementation
public:
        COLORREF m_crBackColor;        // background color
    COLORREF m_crFrameColor;       // frame color

    virtual ~CColorFrameCtrl();

    // Generated message map functions
protected:
    void OnPaint(wxPaintEvent& evt);
    void OnSize(wxSizeEvent& evt);
    DECLARE_EVENT_TABLE()

    RECT m_rectClient;
    wxBrush m_brushBack, m_brushFrame;
};

/////////////////////////////////////////////////////////////////////////////
#endif
