// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifdef PRECOMP
    #include "xmule-headers.h"
#endif

#include "CommentDialogLst.h"               // Needed for this Interface's Prototype

#include "PartFile.h"                       // Needed for CPartFile
#include "updownclient.h"                   // Needed for CUpDownClient

#include <wx/intl.h>                        // Needed for _
#include <wx/listctrl.h>                    // Needed for wxListCtrl
#include <wx/panel.h>                       // Needed for wxPanel
#include <wx/settings.h>                    // Needed for wxSystemSettings

#if defined(HAVE_XRC)
    #include <wx/xrc/xmlres.h>                  // Needed for wxXmlResource
    #define SMARTID(A) (XRCID(#A))
    #define GetDlgItem(x,clas) XRCCTRL(*this,#x,clas)
#else
    #include <wx/button.h>                  // Needed for wxButton
    #include <wx/stattext.h>                // Needed for wxStaticText

    #define SMARTID(A) (A)
    #define GetDlgItem(id, type) (static_cast<type *>(this->FindWindow(id)))

    enum
    {
        IDC_CMSTATUS,
        IDCOK,
        IDCREF
    };
#endif

//IMPLEMENT_DYNAMIC(CCommentDialogLst, CDialog)
CCommentDialogLst::CCommentDialogLst(wxWindow *parent, CPartFile *file)
//: CDialog(CCommentDialogLst::IDD, 0)
: wxDialog(parent, CCommentDialogLst::IDD, _("File Comments"),
wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE |wxSYSTEM_MENU)
{
    m_file = file;
    //wxSizer* content=commentLstDlg(this,TRUE);
    //content->Show(this,TRUE);
    CCommentDialogLst* content;
#if defined(HAVE_XRC)
    content = wxXmlResource::Get()->LoadPanel(this, "DLG_COMMENTLST");
    SetSize(content->GetSize());
    content->SetBackgroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_WINDOWFRAME));
#else
    content = this;
    wxListCtrl* item2 = new wxListCtrl( content, IDC_LST, wxPoint(7, 14), wxSize(696, 218), wxLC_REPORT|wxSUNKEN_BORDER );
    wxButton* item3 = new wxButton(content, IDCREF, _("Refresh"), wxPoint(456, 238), wxSize(94, 28), 0 );
    wxButton* item4 = new wxButton(content, IDCOK, _("OK"), wxPoint(609, 238), wxSize(94, 28), 0 );
    wxStaticText* item5 = new wxStaticText(content, IDC_CMSTATUS, _("Static"), wxPoint(7, 234), wxSize(413, 18), 0 );
    SetSize(300, 400);
#endif
    Centre();
    pmyListCtrl = GetDlgItem(IDC_LST, wxListCtrl);
    OnInitDialog();
}

CCommentDialogLst::~CCommentDialogLst()
{
}

BEGIN_EVENT_TABLE(CCommentDialogLst, wxDialog)
    EVT_BUTTON(SMARTID(IDCOK), CCommentDialogLst::OnBnClickedApply)
    EVT_BUTTON(SMARTID(IDCREF), CCommentDialogLst::OnBnClickedRefresh)
END_EVENT_TABLE()

void CCommentDialogLst::OnBnClickedApply(wxCommandEvent &evt)
{
    //CDialog::OnOK();
    EndModal(0);
}

void CCommentDialogLst::OnBnClickedRefresh(wxCommandEvent &evt)
{
    CompleteList();
}

#define LVCFMT_LEFT wxLIST_FORMAT_LEFT

BOOL CCommentDialogLst::OnInitDialog()
{
    //CDialog::OnInitDialog();
    pmyListCtrl->InsertColumn(0, GetResString(IDS_CD_UNAME), LVCFMT_LEFT, 130);
    pmyListCtrl->InsertColumn(1, GetResString(IDS_DL_FILENAME), LVCFMT_LEFT, 130);
    pmyListCtrl->InsertColumn(2, GetResString(IDS_QL_RATING), LVCFMT_LEFT, 80);
    pmyListCtrl->InsertColumn(3, GetResString(IDS_COMMENT), LVCFMT_LEFT, 340);
    Localize();
    CompleteList();
    return TRUE;
}

void CCommentDialogLst::Localize(void)
{
    GetDlgItem(IDCOK, wxControl)->SetLabel(GetResString(IDS_CW_CLOSE));
    GetDlgItem(IDCREF, wxControl)->SetLabel(GetResString(IDS_CMT_REFRESH));
    SetTitle(GetResString(IDS_CMT_READALL) + " (" + m_file->GetFileName() + ")");
}

void CCommentDialogLst::CompleteList()
{
    POSITION pos1, pos2;
    CUpDownClient *cur_src;
    int count = 0;
    pmyListCtrl->DeleteAllItems();
    for (int sl = 0 ; sl < SOURCESSLOTS ; sl++) if(!m_file->srclists[sl].IsEmpty())
    for (pos1 = m_file->srclists[sl].GetHeadPosition() ; (pos2 = pos1) != NULL ;)
    {
        m_file->srclists[sl].GetNext(pos1);
        cur_src = m_file->srclists[sl].GetAt(pos2);
        if (cur_src->GetFileComment() .Length() > 0 || cur_src->GetFileRate() > 0)
        {
            pmyListCtrl->InsertItem(count, cur_src->GetUserName());
            pmyListCtrl->SetItem(count, 1, cur_src->GetClientFilename());
            pmyListCtrl->SetItem(count, 2, GetRateString(cur_src->GetFileRate()));
            pmyListCtrl->SetItem(count, 3, cur_src->GetFileComment());
            count++;
        }
    }
    wxString info = "";
    if (count == 0) info = "(" + GetResString(IDS_CMT_NONE) + ")";
    GetDlgItem(IDC_CMSTATUS, wxControl)->SetLabel(info);
    m_file->UpdateFileRatingCommentAvail();
}

