// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// DirectoryTreeCtrl.cpp : implementation file
//
/////////////////////////////////////////////
// written by robert rostek - tecxx@rrs.at //
/////////////////////////////////////////////

#ifdef PRECOMP
    #include "xmule-headers.h"
#endif

#include "DirectoryTreeCtrl.h"              // Needed for this Interface's Prototype

#include <wx/log.h>                         // Needed for wxLogNull

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;

#define new DEBUG_NEW
#endif

#include "pixmaps/folder.xpm"
#include "pixmaps/hdd.xpm"

// CDirectoryTreeCtrl

#undef HTREEITEM
#define HTREEITEM wxCTreeItemId

IMPLEMENT_DYNAMIC_CLASS(CDirectoryTreeCtrl, wxCTreeCtrl)
CDirectoryTreeCtrl::CDirectoryTreeCtrl(wxWindow *parent, int id, const wxPoint &pos, wxSize siz, int flags)
: wxCTreeCtrl(parent, id, pos, siz, flags, wxDefaultValidator, "ShareTree"),
m_image(16, 16)
{
    //m_SharedMenu.m_hMenu = NULL;
    m_bSelectSubDirs = false;
    Init();
}

CDirectoryTreeCtrl::~CDirectoryTreeCtrl()
{
}

BEGIN_EVENT_TABLE(CDirectoryTreeCtrl, wxCTreeCtrl)
END_EVENT_TABLE()

void CDirectoryTreeCtrl::OnTvnItemexpanding(wxCTreeEvent &evt)
{
    //LPNMTREEVIEW pNMTreeView = reinterpret_cast<LPNMTREEVIEW>(pNMHDR);
    //int iAction = pNMTreeView->action;
    //pNMTreeView->itemNew.hItem;:
    HTREEITEM hItem = evt.GetItem();
    // remove all subitems
    DeleteChildren(hItem);
    // get the directory
    wxString strDir = GetFullPath(hItem);
    // fetch all subdirectories and add them to the node
    AddSubdirectories(hItem, strDir);
    // and sort them
    SortChildren(hItem);
    //*pResult = 0;
}

void CDirectoryTreeCtrl::OnLButtonDown(wxCTreeEvent &evt)
{
    //VQB adjustments to provide for sharing or unsharing of subdirectories when control key is Down
    static int __counter = 0;
    //HitTest(point, &uFlags);:
    HTREEITEM hItem = evt.GetItem();
    // VQB mark initial window position:
    GetFirstVisibleItem();
    int flags = 0;
    HitTest(evt.GetPoint(), flags);
    // this event is launced _after_ checkbox value is set.. if it is set at all
    if ((hItem.IsOk()) &&flags &wxCTREE_HITTEST_CHECKBOX)
    {
        // && (uFlags & TVHT_ONITEMSTATEICON)) {
        CheckChanged(hItem, IsChecked(hItem));
        if (evt.IsControlDown())
        {
            // & MK_CONTROL) { // Is control key down?
            bool exp;
            exp = false;
            Toggle(hItem);
            HTREEITEM hChild;
            long cookie = 993 + (++__counter);
            //GetChildItem(hItem);:
            hChild = GetFirstChild(hItem, cookie);
            // != NULL):
            while (hChild.IsOk())
            {
                MarkChilds(hChild, IsChecked(hItem));
                //hChild = GetNextChild(hChild,cookie); //GetNextSiblingItem( hChild );
                hChild = GetNextSibling(hChild);
            }
            Toggle(hItem);
            // font won't get set otherwise...
            Toggle(GetItemParent(hItem));
            Toggle(GetItemParent(hItem));
        }
    }
    //SelectSetFirstVisible(tItem); // VQB - restore window scroll to initial position
    //CTreeCtrl::OnLButtonDown(nFlags, point);
    HasChanged = true;
}

void CDirectoryTreeCtrl::MarkChilds(HTREEITEM hChild, bool mark)
{
    static long int __counter = 1;
    CheckChanged(hChild, mark);
    SetChecked(hChild, mark);
    bool exp;
    exp = false;
    Toggle(hChild);
    HTREEITEM hChild2;
    long int cookie =++__counter;
    //GetChildItem(hChild);:
    hChild2 = GetFirstChild(hChild, cookie);
    while (hChild2.IsOk())
    {
        MarkChilds(hChild2, mark);
        //hChild2 = GetNextChild(hChild,cookie); //GetNextSiblingItem( hChild2 );
        hChild2 = GetNextSibling(hChild2);
    }
    Toggle(hChild);
    //if(exp) {Collapse(hChild);}//, TVE_TOGGLE); // VQB - restore tree to initial disposition
}

void CDirectoryTreeCtrl::Init(void)
{
    // init image(s)
    m_image.Add(wxBitmap(folder_xpm));
    m_image.Add(wxBitmap(hdd_xpm));
    SetImageList( &m_image);
    //DeleteAllItems();
    // no drives. just root!
    HTREEITEM root = AddRoot("/");
    SetItemImage(root, 1);
    AppendItem(root, "Cool. Works");
    //SetChecked(test,TRUE);
    // To set shared unmodified on Init();
    HasChanged = false;
}

HTREEITEM CDirectoryTreeCtrl::AddChildItem(HTREEITEM hRoot, wxString strText)
{
    wxString strPath = GetFullPath(hRoot);
    if (hRoot.IsOk() &&strPath.Right(1) != "/")
    strPath += "/";
    wxString strDir = strPath + strText;
    HTREEITEM item = AppendItem(hRoot, strText);
    // it is folder!:
    SetItemImage(item, 0);
    if (HasSharedSubdirectory(strDir))
    SetItemBold(item, TRUE);
    if (IsShared(strDir))
    SetChecked(item, TRUE);
    if (HasSubdirectories(strDir))
    // trick. will show +:
    AppendItem(item, ".");
    return item;
}

wxString CDirectoryTreeCtrl::GetFullPath(HTREEITEM hItem)
{
    wxString strDir;
    HTREEITEM hSearchItem = hItem;
    // don't traverse to the root item.. it will cause extra / to the path
    // && hSearchItem!=GetRootItem()):
    while (hSearchItem.IsOk())
    {
        strDir = GetItemText(hSearchItem) + "/" + strDir;
        hSearchItem = GetItemParent(hSearchItem);
    }
    return strDir;
}

void CDirectoryTreeCtrl::AddSubdirectories(HTREEITEM hRoot, wxString strDir)
{
    if (strDir.Right(1) != "/")
    strDir += "/";
    wxString fname;
    wxString dirname = strDir + "*";
    // we must collect values first because we'll call FindFirstFile() again in
    // AddChildItem()..
    wxArrayString ary;
    fname = wxFindFirstFile(dirname, wxDIR);
    while (!fname.IsEmpty())
    {
        if (!wxDirExists(fname))
        {
            fname = wxFindNextFile();
            continue;
        }
        if (fname.Find('/', TRUE) != - 1)
        fname = fname.Mid(fname.Find('/', TRUE) + 1);
        ary.Add(fname);
        fname = wxFindNextFile();
    }
    // then add them
    for (unsigned int i = 0 ; i < ary.GetCount() ; i++)
    {
        AddChildItem(hRoot, ary[i]);
    }
}

bool CDirectoryTreeCtrl::HasSubdirectories(wxString strDir)
{
    // prevent stupid log windows if we try to traverse somewhere we:
    wxLogNull logNo;
    // have no access.
    if (strDir.Right(1) != "/")
    strDir += "/";
    wxString fname = wxFindFirstFile(strDir + "*", wxDIR);
    if (!fname.IsEmpty())
    // at least one directory...:
    return TRUE;
    // no match:
    return FALSE;
}

void CDirectoryTreeCtrl::GetSharedDirectories(wxArrayString *list)
{
    //for (POSITION pos = m_lstShared.GetHeadPosition(); pos != NULL; )
    for (unsigned int i = 0 ; i < m_lstShared.GetCount() ; i++)
    list->Add(m_lstShared[i]);
}

void CDirectoryTreeCtrl::SetSharedDirectories(wxArrayString *list)
{
    m_lstShared.Clear();
    for (unsigned int i = 0 ; i < list->GetCount() ; i++)
    {
        //list->GetNext(pos);:
        wxString str = list->Item(i);
        if (str.Right(1) != '/')
        str += '/';
        m_lstShared.Add(str);
    }
    //  Init();
}

bool CDirectoryTreeCtrl::HasSharedSubdirectory(wxString strDir)
{
    if (strDir.Right(1) != '/')
    strDir += "/";
    strDir.MakeLower();
    for (unsigned int i = 0 ; i < m_lstShared.GetCount() ; i++)
    {
        //.GetNext(pos);:
        wxString str = m_lstShared[i];
        str.MakeLower();
        //strDir.GetLength() != str.GetLength()):
        if (str.Find(strDir) == 0 &&strDir != str)
        return true;
    }
    return false;
}

void CDirectoryTreeCtrl::CheckChanged(HTREEITEM hItem, bool bChecked)
{
    wxString strDir = GetFullPath(hItem);
    if (bChecked)
    AddShare(strDir);
    else
    DelShare(strDir);
}

bool CDirectoryTreeCtrl::IsShared(wxString strDir)
{
    if (strDir.Right(1) != '/')
    strDir += '/';
    for (unsigned int i = 0 ; i < m_lstShared.GetCount() ; i++)
    {
        wxString str = m_lstShared[i];
        if (str.Right(1) != '/')
        str += '\\';
        if (str.CmpNoCase(strDir) == 0)
        return true;
    }
    return false;
}

void CDirectoryTreeCtrl::AddShare(wxString strDir)
{
    if (strDir.Right(1) != '/')
    strDir += '/';
    if (IsShared(strDir))
    return;
    m_lstShared.Add(strDir);
}

void CDirectoryTreeCtrl::DelShare(wxString strDir)
{
    if (strDir.Right(1) != '/')
    strDir += '/';
    m_lstShared.Remove(strDir.GetData());
}

void CDirectoryTreeCtrl::UpdateParentItems(HTREEITEM hChild)
{
}

bool CDirectoryTreeCtrl::ProcessEvent(wxEvent& evt)
{
    if (evt.GetEventType() == wxEVT_COMMAND_CTREE_ITEM_EXPANDING)
    {
        OnTvnItemexpanding((wxCTreeEvent &) evt);
        return true;
    }
    if (evt.GetEventType() == wxEVT_COMMAND_CTREE_ITEM_LEFT_CLICK)
    {
        OnLButtonDown((wxCTreeEvent &) evt);
        return true;
    }
    return wxCTreeCtrl::ProcessEvent(evt);
}

