// This file is a part of the xMule Project.
//
// Coded by uploaod & plaenky
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// This file was a part of eMule
// Copyright (c) 2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifdef PRECOMP
    #include "xmule-headers.h"
#endif

#include "FlowChart.h"                      // Needed for this Interface's Prototype

#include "NewFunctions.h"                   // Needed for Menu_Create
#include "Preferences.h"                    // Needed for SetBringToFront
#include "wxTreeMultiCtrl.h"                // Needed for wxTreeMultiCtrl
#include "xmule.h"                          // Needed for theApp

#include "DynPrefs/DynPrefs.h"              // Needed for DynamicPreferences

#include <wx/dc.h>                          // Needed for wxClientDC
#include <wx/dirdlg.h>                      // Needed for wxDirDialog
#include <wx/msgdlg.h>                      // Needed for wxMessageDialog
#include <wx/sizer.h>                       // Needed for wxBoxSizer
#include <wx/statline.h>                    // Needed for wxStaticLine
#include <wx/textdlg.h>                     // Needed for wxTextEntryDialog
#include "wx/xrc/xml.h"                     // Needed for wxXmlResourceHandler

#define	SDMOUSEEVT	(wxObjectEventFunction) (wxEventFunction) (wxMouseEventFunction) &CFlowChart
#define	SDPAINTEVT	(wxObjectEventFunction) (wxEventFunction) (wxPaintEventFunction) &CFlowChart
#define	SDTIMEREVT	(wxObjectEventFunction) (wxEventFunction) (wxTimerEventFunction) &CFlowChart

#define OLDPREF_STATCOL_MASKSTART     21104
#define OLDPREF_SHAREDDIRS_MASKSTART  21010
#define OLDPREF_SHAREDDIRS_LISTSIZE   10

BEGIN_EVENT_TABLE(CFlowChart, wxScrolledWindow)
    EVT_KILL_FOCUS(CFlowChart::OnLoseFocus)
END_EVENT_TABLE()

void CFlowChart::OnLoseFocus(wxFocusEvent& event)
{
    wxMessageBox("focus lost");
}

wxUint16 infonumber = 0;

wxString info[256];

wxUint16 info_type[256];

wxUint16 info_x[256];

wxUint16 info_y[256];

wxUint16 info_width[256];

wxUint16 info_height[256];

wxUint32 info_ip[256];

wxUint16 info_port[256];

wxPen *info_pen[256];

wxBrush *info_brush[256];

wxColour *info_txtbgcolour[256];

wxColour *info_txtfgcolour[256];

int newprefs01_opt[101];
wxString newprefs01_alpha[101];

wxString newprefs01info[256];

int newprefs02_opt[101];

int newprefs03_opt[101];

wxString newprefs03info[256];

int newprefs04_opt[101];

wxString newprefs04info[256];

int oldprefs01_opt[4];

int oldprefs02_opt[15];

int oldprefs03_opt[14];

int oldprefs04_opt[13];

int oldprefs05_opt[11];

int oldprefs06_opt[6];

int oldprefs07_opt[21];

int oldprefs08_opt[9];

int oldprefs09_opt[1];

wxColour *LIGHT_RED = new wxColour(0xe0, 0x90, 0x90);

wxColour *DARK_WHITE;

void SetPenBrushText(wxUint16 index, wxClientDC *dc, wxColour *pencolour, wxColour *brushcolour, wxColour *textbgcolour,
wxColour *textfgcolour, int style)
{
    if (info_pen[index] != NULL)
    {
        delete info_pen[index];
    }
    info_pen[index] = new wxPen( *pencolour, 1, style);
    if (info_brush[index] != NULL)
    {
        delete info_brush[index];
    }
    info_brush[index] = new wxBrush( *brushcolour, style);
    if (info_txtbgcolour[index] != NULL)
    {
        delete info_txtbgcolour[index];
    }
    info_txtbgcolour[index] = new wxColour( *textbgcolour);
    if (info_txtfgcolour[index] != NULL)
    {
        delete info_txtfgcolour[index];
    }
    info_txtfgcolour[index] = new wxColour( *textfgcolour);
}

CFlowChart::CFlowChart(wxWindow *pParent):
    wxScrolledWindow(pParent, IDD, wxDefaultPosition, wxDefaultSize, wxHSCROLL |wxVSCROLL |wxNO_FULL_REPAINT_ON_RESIZE)
{
    Init();
}

void CFlowChart::Init()
{
    SetScrollbars(4, 4, 400, 300);
    wxBoxSizer* root = new wxBoxSizer(wxVERTICAL);

    dynprefs = new DynamicPreferencesCtrl(wxString(wxT("memory:resource/newprefs01.pm"), *wxConvCurrent), this, theApp.dynprefs);
    dynprefs->Show(true);

    root->Add(dynprefs, 1, wxEXPAND);

    this->SetAutoLayout(TRUE);
    this->SetSizer(root);
    root->SetSizeHints(this);
    root->Fit(this);
    root->Show(this, true);
}

CFlowChart::~CFlowChart()
{
}
