// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// FriendListCtrl.cpp : implementation file

#ifdef PRECOMP
    #include "xmule-headers.h"
#endif

#include "FriendListCtrl.h"                 // Needed for this Interface's Prototype

#include "AddFriend.h"                      // Needed for CAddFriend
#include "ChatWnd.h"                        // Needed for StartSession
#include "ClientDetailDialog.h"             // Needed for CClientDetailDialog
#include "ClientList.h"                     // Needed for AddClient
#include "Friend.h"                         // Needed for RemoveFriend
#include "FriendList.h"                     // Needed for CFriendList
#include "ListenSocket.h"                   // Needed for CClientReqServer
#include "opcodes.h"                        // Needed for MP_DETAIL
#include "otherfunctions.h"                 // Needed for GetResString
#include "updownclient.h"                   // Needed for CUpDownClient
#include "xmule.h"                          // Needed for theApp
#include "xmuleDlg.h"                       // Needed for CxmuleDlg

#include <wx/menu.h>                        // Needed for wxMenu

BEGIN_EVENT_TABLE(CFriendListCtrl, CMuleListCtrl)
EVT_RIGHT_DOWN(CFriendListCtrl::OnNMRclick)
END_EVENT_TABLE()

CFriendListCtrl::CFriendListCtrl()
{
}

CFriendListCtrl::~CFriendListCtrl()
{
}

CFriendListCtrl::CFriendListCtrl(wxWindow *&parent, int id, const wxPoint &pos, wxSize siz, int flags)
: CMuleListCtrl(parent, id, pos, siz, flags)
{
    Init();
}

void CFriendListCtrl::Init()
{
    wxRect rc = GetClientRect();
    InsertColumn(0, GetResString(IDS_QL_USERNAME), wxLIST_FORMAT_LEFT, rc.width - 4);
}

void CFriendListCtrl::Localize()
{
}

void CFriendListCtrl::AddFriend(CFriend *toadd)
{
    uint32 itemnr = GetItemCount();
    itemnr = InsertItem(itemnr, toadd->m_strName.GetData());
    SetItemData(itemnr, (long) toadd);
    RefreshFriend(toadd);
}

void CFriendListCtrl::RemoveFriend(CFriend *toremove)
{
    sint32 result = FindItem( - 1, (long) toremove);
    if (result != ( - 1))
    DeleteItem(result);
}

void CFriendListCtrl::RefreshFriend(CFriend *toupdate)
{
    sint32 itemnr = FindItem( - 1, (long) toupdate);
    CString temp;
    temp.Format("%s", toupdate->m_strName.GetData());
    SetItem(itemnr, 0, temp);
    if (itemnr == ( - 1))
    return;
    uint8 image;
    if (!toupdate->m_LinkedClient)
    {
        image = 0;
    }
    else if(toupdate->m_LinkedClient->socket && toupdate->m_LinkedClient->socket->IsConnected())
    {
        image = 2;
    }
    else
    {
        image = 1;
    }
}

void CFriendListCtrl::OnNMRclick(wxMouseEvent &evt)
{
    CFriend *cur_friend = NULL;
    wxMenu *menu = new wxMenu(GetResString(IDS_FRIENDLIST));
    int cursel = GetNextItem( - 1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
    if (cursel != ( - 1))
    {
        cur_friend = (CFriend *) GetItemData(cursel);
        menu->Append(MP_DETAIL, GetResString(IDS_SHOWDETAILS));
        menu->Enable(MP_DETAIL, ((cur_friend->m_LinkedClient) ?TRUE: FALSE));
    }
    menu->Append(MP_ADDFRIEND, GetResString(IDS_ADDAFRIEND));
    if (cursel != ( - 1))
    {
        menu->Append(MP_REMOVEFRIEND, GetResString(IDS_REMOVEFRIEND));
        menu->Append(MP_MESSAGE, GetResString(IDS_SEND_MSG));
        menu->Append(MP_SHOWLIST, GetResString(IDS_VIEWFILES));
        menu->AppendCheckItem(MP_FRIENDSLOT, GetResString(IDS_FRIENDSLOT));
        if (cur_friend->m_LinkedClient)
        {
            menu->Enable(MP_FRIENDSLOT, TRUE);
            menu->Check(MP_FRIENDSLOT, ((cur_friend->m_LinkedClient->GetFriendSlot()) ?TRUE: FALSE));
        }
        else
        menu->Enable(MP_FRIENDSLOT, FALSE);
    }
    PopupMenu(menu, evt.GetPosition());
}

bool CFriendListCtrl::ProcessEvent(wxEvent& evt)
{
    CFriend *cur_friend;
    if (evt.GetEventType() != wxEVT_COMMAND_MENU_SELECTED)
    return CMuleListCtrl::ProcessEvent(evt);
    wxCommandEvent &event = (wxCommandEvent &) evt;
    int cursel = GetNextItem( - 1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
    if (cursel != ( - 1)) cur_friend = (CFriend *) GetItemData(cursel);
    switch (event.GetId())
    {
    case MP_MESSAGE:
        {
            if (cur_friend->m_LinkedClient)
            theApp.xmuledlg->chatwnd->StartSession(cur_friend->m_LinkedClient);
            else
            {
                CUpDownClient *chatclient = new CUpDownClient(cur_friend->m_nLastUsedPort, cur_friend->m_dwLastUsedIP, 0, 0, 0);
                chatclient->SetUserName((char *) cur_friend->m_strName.GetData());
                theApp.clientlist->AddClient(chatclient);
                theApp.xmuledlg->chatwnd->StartSession(chatclient);
            }
            break;
        }
    case MP_REMOVEFRIEND:
        {
            theApp.friendlist->RemoveFriend(cur_friend);
            break;
        }
    case MP_ADDFRIEND:
        {
            CAddFriend *dialog2 = new CAddFriend(this);
            dialog2->ShowModal();
            delete dialog2;
            // hmm.. if not return here, we'll end up in preferences dlg
            return TRUE;
        }
        break;
    case MP_DETAIL:
        if (cur_friend->m_LinkedClient)
        {
            CClientDetailDialog *dialog = new CClientDetailDialog(this, cur_friend->m_LinkedClient);
            dialog->ShowModal();
            delete dialog;
            return TRUE;
        }
        break;
    case MP_SHOWLIST:
        {
            if (cur_friend->m_LinkedClient)
            cur_friend->m_LinkedClient->RequestSharedFileList();
            else
            {
                CUpDownClient *newclient = new CUpDownClient(cur_friend->m_nLastUsedPort, cur_friend->m_dwLastUsedIP, 0, 0, 0);
                newclient->SetUserName((char *) cur_friend->m_strName.GetData());
                theApp.clientlist->AddClient(newclient);
                newclient->RequestSharedFileList();
            }
            break;
        }
    case MP_FRIENDSLOT:
        {
            if (cur_friend->m_LinkedClient)
            {
                bool IsAlready;
                IsAlready = cur_friend->m_LinkedClient->GetFriendSlot();
                theApp.friendlist->RemoveAllFriendSlots();
                if (!IsAlready)
                cur_friend->m_LinkedClient->SetFriendSlot(true);
            }
            break;
        }
    }
    return CMuleListCtrl::ProcessEvent(evt);
}

