// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifdef PRECOMP
    #include "xmule-headers.h"
#endif

#include "PPgGeneral.h"                     // Needed for this Interface's Prototype

#include "otherfunctions.h"                 // Needed for GetResString
#include "Preferences.h"                    // Needed for CPreferences
#include "resource.h"                       // Needed for IDS_DAYS2
#include "xmule.h"                          // Needed for theApp
#include "xmuleDlg.h"                       // Needed for theApp.xmuledlg

#include <wx/checkbox.h>                    // Needed for wxCheckBox
#include <wx/notebook.h>                    // Needed for wxNotebook
#include <wx/slider.h>                      // Needed for wxSlider
#include <wx/textctrl.h>                    // Needed for wxTextCtrl

#include <wx/xrc/xmlres.h>                  // Needed for wxXmlResource

#define ID_DESKTOPMODE 3358

// CPPgGeneral dialog
#define GetDlgItem(x,clas) XRCCTRL(*this,#x,clas)
#define IsDlgButtonChecked2(x,y) XRCCTRL(*this,#x,y)->GetValue()
#define IsDlgButtonChecked(x) XRCCTRL(*this,#x,wxCheckBox)->GetValue()
#define CheckDlgButton3(x,y,z) XRCCTRL(*this,#x,z)->SetValue(y)
#define CheckDlgButton(x,y) XRCCTRL(*this,#x,wxCheckBox)->SetValue(y)

IMPLEMENT_DYNAMIC_CLASS(CPPgGeneral, wxPanel)

CPPgGeneral::CPPgGeneral(wxWindow *parent): wxPanel(parent, CPPgGeneral::IDD)
{
    wxNotebook *book = (wxNotebook *) parent;
    wxPanel *page1 = wxXmlResource::Get()->LoadPanel(this, "DLG_PPG_GENERAL");
    book->AddPage(this, _("General"));
    SetSize(page1->GetSize() .GetWidth(), page1->GetSize() .GetHeight() + 40);
    page1->SetSize(GetSize());
    wxButton *mybtn = new wxButton(page1, ID_DESKTOPMODE, _("Systray Integration"),
    wxPoint(402, 245), wxSize(110, 24));
    Localize();
}

CPPgGeneral::~CPPgGeneral()
{
}

BEGIN_EVENT_TABLE(CPPgGeneral, wxPanel)
EVT_SCROLL(CPPgGeneral::OnHScroll)
EVT_BUTTON(ID_DESKTOPMODE, CPPgGeneral::OnDesktopmode)
END_EVENT_TABLE()

void CPPgGeneral::OnDesktopmode(wxCommandEvent &evt)
{
    theApp.xmuledlg->changeDesktopMode();
}

void CPPgGeneral::LoadSettings(void)
{
    // Barry - Controls depth of 3d colour shading
    wxSlider *slider3D = GetDlgItem(IDC_3DDEPTH, wxSlider);
    slider3D->SetRange(0, 5);
    slider3D->SetValue(app_prefs->Get3DDepth());
    wxSlider *sliderUpdate = GetDlgItem(IDC_CHECKDAYS, wxSlider);
    sliderUpdate->SetRange(2, 7);
    sliderUpdate->SetValue(app_prefs->GetUpdateDays());
    GetDlgItem(IDC_NICK, wxTextCtrl)->SetValue(app_prefs->prefs->nick);
    if (app_prefs->prefs->startMinimized)
    CheckDlgButton(IDC_STARTMIN, 1);
    else
    CheckDlgButton(IDC_STARTMIN, 0);
    if (app_prefs->prefs->mintotray)
    CheckDlgButton(IDC_MINTRAY, 1);
    else
    CheckDlgButton(IDC_MINTRAY, 0);
    if (app_prefs->prefs->onlineSig)
    CheckDlgButton(IDC_ONLINESIG, 1);
    else
    CheckDlgButton(IDC_ONLINESIG, 0);
    if (app_prefs->prefs->beepOnError)
    CheckDlgButton(IDC_BEEPER, 1);
    else
    CheckDlgButton(IDC_BEEPER, 0);
    if (app_prefs->prefs->confirmExit)
    CheckDlgButton(IDC_EXIT, 1);
    else
    CheckDlgButton(IDC_EXIT, 0);
    if (app_prefs->prefs->splashscreen)
    CheckDlgButton(IDC_SPLASHON, 1);
    else
    CheckDlgButton(IDC_SPLASHON, 0);
    if (app_prefs->prefs->transferDoubleclick)
    CheckDlgButton(IDC_DBLCLICK, 1);
    else
    CheckDlgButton(IDC_DBLCLICK, 0);
    if (app_prefs->prefs->bringtoforeground)
    CheckDlgButton(IDC_BRINGTOFOREGROUND, 1);
    else
    CheckDlgButton(IDC_BRINGTOFOREGROUND, 0);
    if (app_prefs->prefs->updatenotify)
    CheckDlgButton(IDC_CHECK4UPDATE, 1);
    else
    CheckDlgButton(IDC_CHECK4UPDATE, 0);
    CString strBuffer;
    strBuffer.Format("%d", app_prefs->prefs->m_iToolDelayTime);
    GetDlgItem(IDC_TOOLTIPDELAY, wxTextCtrl)->SetValue(strBuffer);
    strBuffer.Format("%i %s", app_prefs->prefs->versioncheckdays, GetResString(IDS_DAYS2) .GetData());
    GetDlgItem(IDC_DAYS, wxControl)->SetLabel(strBuffer);
}

void CPPgGeneral::OnApply()
{
    wxString buffer;
    if (GetDlgItem(IDC_NICK, wxTextCtrl)->GetValue() .Length())
    {
        buffer = GetDlgItem(IDC_NICK, wxTextCtrl)->GetValue();
        strcpy(app_prefs->prefs->nick, buffer);
    }
    int8 mintotray_old = app_prefs->prefs->mintotray;
    app_prefs->prefs->startMinimized = (int8) IsDlgButtonChecked(IDC_STARTMIN);
    app_prefs->prefs->mintotray = (int8) IsDlgButtonChecked(IDC_MINTRAY);
    app_prefs->prefs->beepOnError = (int8) IsDlgButtonChecked(IDC_BEEPER);
    app_prefs->prefs->confirmExit = (int8) IsDlgButtonChecked(IDC_EXIT);
    app_prefs->prefs->splashscreen = (int8) IsDlgButtonChecked(IDC_SPLASHON);
    app_prefs->prefs->transferDoubleclick = (int8) IsDlgButtonChecked(IDC_DBLCLICK);
    app_prefs->prefs->bringtoforeground = (int8) IsDlgButtonChecked(IDC_BRINGTOFOREGROUND);
    app_prefs->prefs->updatenotify = (int8) IsDlgButtonChecked(IDC_CHECK4UPDATE);
    app_prefs->prefs->onlineSig = (int8) IsDlgButtonChecked(IDC_ONLINESIG);
    app_prefs->prefs->depth3D = GetDlgItem(IDC_3DDEPTH, wxSlider)->GetValue();
    app_prefs->prefs->versioncheckdays = GetDlgItem(IDC_CHECKDAYS, wxSlider)->GetValue();
    buffer = GetDlgItem(IDC_TOOLTIPDELAY, wxTextCtrl)->GetValue();
    if (atoi(buffer) > 32)
    app_prefs->prefs->m_iToolDelayTime = 32;
    else
    app_prefs->prefs->m_iToolDelayTime = atoi(buffer);
    // no setstyle as we can't do that anyway
    LoadSettings();
}

void CPPgGeneral::Localize(void)
{
    if (1)
    {
        GetDlgItem(IDC_NICK_FRM, wxControl)->SetLabel(GetResString(IDS_PW_NICK));
        GetDlgItem(IDC_LANG_FRM, wxControl)->SetLabel(GetResString(IDS_PW_LANG));
        GetDlgItem(IDC_MISC_FRM, wxControl)->SetLabel(GetResString(IDS_PW_MISC));
        GetDlgItem(IDC_MINTRAY, wxControl)->SetLabel(GetResString(IDS_PW_TRAY));
        GetDlgItem(IDC_BEEPER, wxControl)->SetLabel(GetResString(IDS_PW_BEEP));
        GetDlgItem(IDC_EXIT, wxControl)->SetLabel(GetResString(IDS_PW_PROMPT));
        GetDlgItem(IDC_SPLASHON, wxControl)->SetLabel(GetResString(IDS_PW_SPLASH));
        GetDlgItem(IDC_DBLCLICK, wxControl)->SetLabel(GetResString(IDS_PW_DBLCLICK));
        GetDlgItem(IDC_TOOLTIPDELAY_LBL, wxControl)->SetLabel(GetResString(IDS_PW_TOOL));
        GetDlgItem(IDC_BRINGTOFOREGROUND, wxControl)->SetLabel(GetResString(IDS_PW_FRONT));
        GetDlgItem(IDC_ONLINESIG, wxControl)->SetLabel(GetResString(IDS_PREF_ONLINESIG));
        GetDlgItem(IDC_STARTMIN, wxControl)->SetLabel(GetResString(IDS_PREF_STARTMIN));
        GetDlgItem(IDC_3DDEP, wxControl)->SetLabel(GetResString(IDS_3DDEP));
        GetDlgItem(IDC_FLAT, wxControl)->SetLabel(GetResString(IDS_FLAT));
        GetDlgItem(IDC_WEBSVEDIT, wxControl)->SetLabel(GetResString(IDS_WEBSVEDIT));
        GetDlgItem(IDC_ED2KFIX, wxControl)->SetLabel(GetResString(IDS_ED2KLINKFIX));
        GetDlgItem(IDC_CHECK4UPDATE, wxControl)->SetLabel(GetResString(IDS_CHECK4UPDATE));
        GetDlgItem(IDC_STARTUP, wxControl)->SetLabel(GetResString(IDS_STARTUP));
    }
}

void CPPgGeneral::OnHScroll(wxScrollEvent &evt)
{
    wxSlider *slider = (wxSlider *) evt.GetEventObject();
    if (slider == GetDlgItem(IDC_CHECKDAYS, wxSlider))
    {
        CString text;
        text.Format("%i %s", evt.GetPosition(), GetResString(IDS_DAYS2) .GetData());
        GetDlgItem(IDC_DAYS, wxControl)->SetLabel(text);
    }
}

