// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifdef PRECOMP
    #include "xmule-headers.h"
#endif

#include "PPgNotify.h"                      // Needed for this Interface's Prototype

#include "otherfunctions.h"                 // Needed for GetResString
#include "Preferences.h"                    // Needed for CPreferences
#include "resource.h"                       // Needed for IDS_PW_TBN_USESOUND

#include <wx/xrc/xmlres.h>                  // Needed for wxXmlResource

#include <wx/checkbox.h>                    // Needed for wxCheckBox
#include <wx/filedlg.h>                     // Needed for wxFileSelector
#include <wx/intl.h>                        // Needed for _
#include <wx/notebook.h>                    // Needed for wxNotebook
#include <wx/textctrl.h>                    // Needed for wxTextCtrl

#define GetDlgItem(x,clas) XRCCTRL(*this,#x,clas)
#define IsDlgButtonChecked(x) XRCCTRL(*this,#x,wxCheckBox)->GetValue()

IMPLEMENT_DYNAMIC_CLASS(CPPgNotify, wxPanel)

CPPgNotify::CPPgNotify(wxWindow *parent)
: wxPanel(parent, CPPgNotify::IDD)
{
    wxNotebook *book = (wxNotebook *) parent;
    wxPanel *page1 = wxXmlResource::Get()->LoadPanel(this, "DLG_PPG_NOTIFY");
    book->AddPage(this, _("Notify"));
    // looks stupid? it is :)
    SetSize(page1->GetSize() .GetWidth(), page1->GetSize() .GetHeight() + 48);
    page1->SetSize(GetSize());
    LoadSettings();
    Localize();
}

CPPgNotify::~CPPgNotify()
{
}

void CPPgNotify::LoadSettings(void)
{
}

wxString CPPgNotify::DialogBrowseFile(wxString Filters, wxString DefaultFileName)
{
    return "";
}

void CPPgNotify::Localize(void)
{
    if (1)
    {
        GetDlgItem(IDC_CB_TBN_USESOUND, wxControl)->SetLabel(GetResString(IDS_PW_TBN_USESOUND));
        GetDlgItem(IDC_BTN_BROWSE_WAV, wxControl)->SetLabel(GetResString(IDS_PW_BROWSE));
        GetDlgItem(IDC_CB_TBN_ONLOG, wxControl)->SetLabel(GetResString(IDS_PW_TBN_ONLOG));
        GetDlgItem(IDC_CB_TBN_ONCHAT, wxControl)->SetLabel(GetResString(IDS_PW_TBN_ONCHAT));
        GetDlgItem(IDC_CB_TBN_POP_ALWAYS, wxControl)->SetLabel(GetResString(IDS_PW_TBN_POP_ALWAYS));
        GetDlgItem(IDC_CB_TBN_ONNEWVERSION, wxControl)->SetLabel(GetResString(IDS_CB_TBN_ONNEWVERSION));
        GetDlgItem(IDC_CB_TBN_ONDOWNLOAD, wxControl)->SetLabel(GetResString(IDS_PW_TBN_ONDOWNLOAD));
        GetDlgItem(IDC_TASKBARNOTIFIER, wxControl)->SetLabel(GetResString(IDS_PW_TASKBARNOTIFIER));
        GetDlgItem(IDC_TBN_OPTIONS, wxControl)->SetLabel(GetResString(IDS_PW_TBN_OPTIONS));
    }
}

BEGIN_EVENT_TABLE(CPPgNotify, wxPanel)
EVT_BUTTON(XRCID("IDC_BTN_BROWSE_WAV"), CPPgNotify::OnBnClickedBtnBrowseWav)
END_EVENT_TABLE()

bool CPPgNotify::OnApply()
{
    wxTextCtrl *editPTR;
    wxString buffer;
    app_prefs->prefs->useDownloadNotifier = IsDlgButtonChecked(IDC_CB_TBN_ONDOWNLOAD);
    app_prefs->prefs->useChatNotifier = IsDlgButtonChecked(IDC_CB_TBN_ONCHAT);
    app_prefs->prefs->useLogNotifier = IsDlgButtonChecked(IDC_CB_TBN_ONLOG);
    app_prefs->prefs->useSoundInNotifier = IsDlgButtonChecked(IDC_CB_TBN_USESOUND);
    app_prefs->prefs->notifierPopsEveryChatMsg = IsDlgButtonChecked(IDC_CB_TBN_POP_ALWAYS);
    editPTR = GetDlgItem(IDC_EDIT_TBN_WAVFILE, wxTextCtrl);
    buffer = editPTR->GetValue();
    sprintf(app_prefs->prefs->notifierSoundFilePath, "%s", buffer.GetData());
    return TRUE;
}

void CPPgNotify::OnBnClickedBtnBrowseWav(wxCommandEvent &evt)
{
    wxTextCtrl *editPTR;
    wxString buffer;
    buffer =
    wxFileSelector(_("Browse wav"), "", "", "*.wav", _("File wav (*.wav)|*.wav||"));
    editPTR = (wxTextCtrl *) GetDlgItem(IDC_EDIT_TBN_WAVFILE, wxTextCtrl);
    editPTR->SetValue((buffer));
    // Added by enkeyDEV:
    sprintf(app_prefs->prefs->notifierSoundFilePath, "%s", buffer.GetData());
}

