// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifdef PRECOMP
    #include "xmule-headers.h"
#endif

#include "PPgStats.h"                       // Needed for this Interface's Prototype

#include "otherfunctions.h"                 // Needed for GetResString
#include "Preferences.h"                    // Needed for CPreferences
#include "resource.h"                       // Needed for IDS_GRAPHS
#include "StatisticsDlg.h"                  // Needed for CStatisticsDlg
#include "xmule.h"                          // Needed for theApp
#include "xmuleDlg.h"                       // Needed for CxmuleDlg

#include <wx/colordlg.h>                    // Needed for wxGetColourFromUser
#include <wx/combobox.h>                    // Needed for wxComboBox
#include <wx/notebook.h>                    // Needed for wxNotebook
#include <wx/slider.h>                      // Needed for wxSlider

#include <wx/xrc/xmlres.h>                  // Needed for wxXmlResource

#define GetDlgItem(x,clas) XRCCTRL(*this,#x,clas)
#define IsDlgButtonChecked(x) XRCCTRL(*this,#x,wxCheckBox)->GetValue()
#define CheckDlgButton(x,y) XRCCTRL(*this,#x,wxCheckBox)->SetValue(y)
#define GetRValue(rgb) (((rgb)>>16)&0xff)
#define GetGValue(rgb) (((rgb)>>8)&0xff)
#define GetBValue(rgb) ((rgb)&0xff)
#define RGB(a,b,c) ((a&0xff)<<16|(b&0xff)<<8|(c&0xff))

// CPPgStats dialog

IMPLEMENT_DYNAMIC_CLASS(CPPgStats, wxPanel)

//IMPLEMENT_DYNAMIC(CPPgStats, CPropertyPage)
CPPgStats::CPPgStats(wxWindow *parent)
: wxPanel(parent, CPPgStats::IDD)
{
    wxNotebook *book = (wxNotebook *) parent;
    wxPanel *page1 = wxXmlResource::Get()->LoadPanel(this, "DLG_PPG_STATS");
    book->AddPage(this, _("Statistics"));
    //SetSize(wxSize(320,200));
    // looks stupid? it is :)
    SetSize(page1->GetSize() .GetWidth(), page1->GetSize() .GetHeight() + 48);
    page1->SetSize(GetSize());
    Localize();
}

CPPgStats::~CPPgStats()
{
}

BEGIN_EVENT_TABLE(CPPgStats, wxPanel)
EVT_SCROLL(CPPgStats::OnHScroll)
EVT_BUTTON(XRCID("IDC_COLOR_BUTTON"), CPPgStats::OnChangeColor)
EVT_COMBOBOX(XRCID("IDC_COLORSELECTOR"), CPPgStats::OnCbnSelchangeColorselector)
END_EVENT_TABLE()

void CPPgStats::OnChangeColor(wxCommandEvent&evt)
{
    wxColour newcol = wxGetColourFromUser(this, XRCCTRL( *this, "IDC_COLOR_BUTTON", wxButton)->GetBackgroundColour());
    if (newcol.Ok())
    {
        XRCCTRL( *this, "IDC_COLOR_BUTTON", wxButton)->SetBackgroundColour(newcol);
        // hmm.. ei liiemmin peruta..
        theApp.glob_prefs->SetStatsColor(XRCCTRL( *this, "IDC_COLORSELECTOR", wxComboBox)->GetSelection(),
        RGB(newcol.Red(), newcol.Green(), newcol.Blue()));
    }
}

bool CPPgStats::OnApply()
{
    theApp.glob_prefs->SetTrafficOMeterInterval(mystats1);
    theApp.glob_prefs->SetStatsInterval(mystats2);
    theApp.glob_prefs->SetStatsAverageMinutes(mystats3);
    //arning TODO: STATISTICWND->LOCALIZE
    //theApp.xmuledlg->statisticswnd->Localize();
    theApp.xmuledlg->statisticswnd->ShowInterval();
    //SetModified(FALSE);
    //return CPropertyPage::OnApply();
    return TRUE;
}

void CPPgStats::Localize(void)
{
    if (1)
    {
        GetDlgItem(IDC_GRAPHS, wxControl)->SetLabel(GetResString(IDS_GRAPHS));
        GetDlgItem(IDC_STREE, wxControl)->SetLabel(GetResString(IDS_STREE));
        //SetWindowText(GetResString(IDS_STATSSETUPINFO));
        GetDlgItem(IDC_PREFCOLORS, wxControl)->SetLabel(GetResString(IDS_COLORS));
        m_colors = XRCCTRL( *this, "IDC_COLORSELECTOR", wxComboBox);
        while (m_colors->GetCount() > 0) m_colors->Delete(0);
        m_colors->Append(GetResString(IDS_SP_BACKGROUND));
        m_colors->Append(GetResString(IDS_SP_GRID));
        m_colors->Append(GetResString(IDS_SP_DL1));
        m_colors->Append(GetResString(IDS_SP_DL2));
        m_colors->Append(GetResString(IDS_SP_DL3));
        m_colors->Append(GetResString(IDS_SP_UL1));
        m_colors->Append(GetResString(IDS_SP_UL2));
        m_colors->Append(GetResString(IDS_SP_UL3));
        m_colors->Append(GetResString(IDS_SP_ACTCON));
        m_colors->Append(GetResString(IDS_SP_ACTDL));
        m_colors->Append(GetResString(IDS_SP_ACTUL));
        m_colors->Append(GetResString(IDS_SP_ICONBAR));
        //m_ctlColor.CustomText = _T(GetResString(IDS_COL_MORECOLORS));
        //m_ctlColor.DefaultText = NULL;
        GetDlgItem(IDC_COLOR_BUTTON, wxControl)->SetLabel(GetResString(IDS_COL_MORECOLORS));
        m_colors->SetSelection(0);
        //SetWindowText(GetResString(IDS_STATSSETUPINFO));
        //ShowInterval();
    }
}

void CPPgStats::OnHScroll(wxScrollEvent &evt)
{
    //SetModified(TRUE);
    wxSlider *slider = (wxSlider *) evt.GetEventObject();
    //slider->GetPos();:
    int position = evt.GetPosition();
    if (slider == GetDlgItem(IDC_SLIDER, wxSlider))
    {
        mystats1 = position;
    }
    else if(slider == GetDlgItem(IDC_SLIDER2, wxSlider))
    {
        if (position > 0) position += 4;
        mystats2 = position;
    }
    else mystats3 = position + 1;
    ShowInterval();
}

void CPPgStats::ShowInterval()
{
    CString m_SliderValue;
    if (mystats1 == 0) m_SliderValue.Format(GetResString(IDS_DISABLED));
    else m_SliderValue.Format(GetResString(IDS_STATS_UPDATELABEL), mystats1);
    GetDlgItem(IDC_SLIDERINFO, wxControl)->SetLabel(m_SliderValue);
    if (mystats2 == 0) m_SliderValue.Format(GetResString(IDS_DISABLED));
    else m_SliderValue.Format(GetResString(IDS_STATS_UPDATELABEL), mystats2);
    GetDlgItem(IDC_SLIDERINFO2, wxControl)->SetLabel(m_SliderValue);
    m_SliderValue.Format(GetResString(IDS_STATS_AVGLABEL), mystats3);
    GetDlgItem(IDC_SLIDERINFO3, wxControl)->SetLabel(m_SliderValue);
}

void CPPgStats::LoadSettings()
{
    GetDlgItem(IDC_SLIDER, wxSlider)->SetValue(app_prefs->GetTrafficOMeterInterval());
    GetDlgItem(IDC_SLIDER2, wxSlider)->SetValue(app_prefs->GetStatsInterval() - 4);
    GetDlgItem(IDC_SLIDER3, wxSlider)->SetValue(app_prefs->GetStatsAverageMinutes() - 1);
    mystats1 = app_prefs->GetTrafficOMeterInterval();
    mystats2 = app_prefs->GetStatsInterval();
    mystats3 = app_prefs->GetStatsAverageMinutes();
    wxCommandEvent nullEvt;
    OnCbnSelchangeColorselector(nullEvt);
    ShowInterval();
}

void CPPgStats::OnCbnSelchangeColorselector(wxCommandEvent &evt)
{
    int sel = m_colors->GetSelection();
    COLORREF selcolor = theApp.glob_prefs->GetStatsColor(sel);
    //m_ctlColor.SetColor(selcolor);
    XRCCTRL( *this, "IDC_COLOR_BUTTON", wxButton)->SetBackgroundColour(wxColour(GetRValue(selcolor), GetGValue(selcolor), GetBValue(selcolor)));
    //arning COLOR IS NOT SET
}

