// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef PARTFILE_H
#define PARTFILE_H

#include "KnownFile.h"                      // Needed for CKnownFile
#include "otherfunctions.h"                 // Needed for GetTickCount

#include <wx/thread.h>                      // Needed for wxMutex

class CFile;
class CMemFile;
class CSearchFile;
class CUpDownClient;
class wxMemoryDC;
class wxRect;

struct Gap_Struct;
struct Requested_Block_Struct;

#define	PS_READY			0
#define	PS_EMPTY			1
#define PS_WAITINGFORHASH	2
#define PS_HASHING			3
#define PS_ERROR			4
#define	PS_UNKNOWN			6
#define PS_PAUSED			7
#define PS_COMPLETING		8
#define PS_COMPLETE			9

#define PR_VERYLOW			4 // I Had to change this because it didn't save negative number correctly.. Had to modify the sort function for this change..
#define PR_LOW				0 //*
#define PR_NORMAL			1 // Don't change this - needed for edonkey clients and server!
#define	PR_HIGH				2 //*
#define PR_VERYHIGH			3
#define PR_AUTO				5
#define SRV_PR_LOW			2
#define SRV_PR_NORMAL		0
#define SRV_PR_HIGH			1

#define BUFFER_TIME_LIMIT	5000   // Max milliseconds before forcing a flush

struct PartFileBufferedData
{
	wxByte *data;						// Barry - This is the data to be written
	wxUint32 start;					// Barry - This is the start offset of the data
	wxUint32 end;						// Barry - This is the end offset of the data
	Requested_Block_Struct *block;	// Barry - This is the requested block that this data relates to
};

class CPartFile : public CKnownFile {
public:
	CPartFile();
	CPartFile(CSearchFile* searchresult);  //used when downloading a new file
	CPartFile(CString edonkeylink);
	CPartFile(class CED2KFileLink* fileLink);
	void InitializeFromLink(CED2KFileLink* fileLink);
	virtual ~CPartFile();
	
	void 	SetPartFileStatus(wxUint8 newstatus);
	bool	CreateFromFile(char* directory,char* filename)	{return false;}// not supported in this class
	bool	LoadFromFile(FILE* file)						{return false;}
	bool	WriteToFile(FILE* file)							{return false;}
	bool	IsPartFile()									{return !(status == PS_COMPLETE);}
	wxUint32	Process(wxUint32 reducedownload);
	bool	LoadPartFile(char* in_directory, char* filename); //filename = *.part.met
	bool	SavePartFile(bool Initial=false);
	void	PartFileHashFinished(CKnownFile* result);
	bool	HashSinglePart(wxUint16 partnumber); // true = ok , false = corrupted	

	void	AddGap(wxUint32 start, wxUint32 end);
	void	FillGap(wxUint32 start, wxUint32 end);
	void	DrawStatusBar(wxMemoryDC* dc, wxRect rect, bool bFlat);
	void	DrawShareStatusBar(wxMemoryDC* dc, wxRect rect, bool onlygreyrect, bool bFlat);
	bool	IsComplete(wxUint32 start, wxUint32 end);
	bool	IsPureGap(wxUint32 start, wxUint32 end);
	bool	IsCorruptedPart(wxUint16 partnumber);
	void	UpdateCompletedInfos();
        
	bool	GetNextRequestedBlock(CUpDownClient* sender,Requested_Block_Struct** newblocks,wxUint16* count);
	void	WritePartStatus(CMemFile* file);
	void	AddSources(CMemFile* sources,wxUint32 serverip, wxUint16 serverport);
	wxUint8	GetStatus(bool ignorepause = false);
	void	NewSrcPartsInfo();
	char*	GetPartMetFileName()							{return partmetfilename;}
	wxUint32	GetTransfered()									{return transfered;}
	char*	GetFullName()									{return fullname;}
	wxUint16	GetSourceCount();
	wxUint16	GetTransferingSrcCount()						{return transferingsrc;}
	wxUint32	GetDatarate()									{return datarate;}
	float	GetPercentCompleted()							{return percentcompleted;}
	wxUint16  GetNotCurrentSourcesCount();
	int		GetValidSourcesCount();
	bool	IsMovie();
	bool	IsSound();
	bool	IsArchive(); 
	bool	IsCDImage(); 
	bool 	IsImage();
	bool 	IsText();
	
	
	CString getPartfileStatus(); //<<--9/21/02
	wxInt32	getTimeRemaining(); //<<--9/21/02
	time_t	lastseencomplete;
	int		getPartfileStatusRang();
        CString GetDownloadFileInfo();

	// Barry - Added as replacement for BlockReceived to buffer data before writing to disk
	wxUint32	WriteToBuffer(wxUint32 transize, wxByte *data, wxUint32 start, wxUint32 end, Requested_Block_Struct *block);
	void	FlushBuffer(void);
	// Barry - This will invert the gap list, up to caller to delete gaps when done
	// 'Gaps' returned are really the filled areas, and guaranteed to be in order
	void	GetFilledList(CTypedPtrList<CPtrList, Gap_Struct*> *filled);

	// Barry - Is archive recovery in progress
	volatile bool m_bRecoveringArchive;

	// Barry - Added to prevent list containing deleted blocks on shutdown
	void	RemoveAllRequestedBlocks(void);

	void	RemoveBlockFromList(wxUint32 start,wxUint32 end);
	void	RemoveAllSources(bool bTryToSwap);
	void	DeleteFile();
	void	StopFile();
	void	PauseFile();
	void	ResumeFile();

	virtual	Packet* CreateSrcInfoPacket(CUpDownClient* forClient);
	void	AddClientSources(CMemFile* sources,wxUint8 sourceexchangeversion);

	void	PreviewFile();
	bool	PreviewAvailable();
	wxUint8   GetAvailablePartCount()			{return availablePartsCount;}
	void	UpdateAvailablePartsCount();

	wxUint32	GetLastAnsweredTime()			{ return m_ClientSrcAnswered; }
	void	SetLastAnsweredTime()			{ m_ClientSrcAnswered = ::GetTickCount(); }
	void	SetLastAnsweredTimeTimeout()		{ m_ClientSrcAnswered = 2 * CONNECTION_LATENCY +
											                        ::GetTickCount() - SOURCECLIENTREASK; }
	wxUint64	GetLostDueToCorruption()		{return m_iLostDueToCorruption;}
	wxUint64	GetGainDueToCompression()		{return m_iGainDueToCompression;}
	wxUint32	TotalPacketsSavedDueToICH()		{return m_iTotalPacketsSavedDueToICH;}
	bool	IsStopped() 				{return stopped;}
	bool	HasComment()				{return hasComment;}
	bool	HasRating()				{return hasRating;}
	bool	HasBadRating();
	void	SetHasComment(bool in)			{hasComment=in;}
	void	SetHasRating(bool in)			{hasRating=in;}
	void	UpdateFileRatingCommentAvail();

        wxString GetProgressString(wxUint16 size);

	int		GetCommonFilePenalty();
	void	UpdateDisplayedInfo(bool force=false);
	time_t	GetLastChangeDatetime(bool forcecheck=false);
	wxUint8	GetCategory();
	void	SetCategory(wxUint8 cat)			{m_category=cat;SavePartFile();}

	CFile*	m_hpartfile;	//permanent opened handle to avoid write conflicts
	volatile bool m_bPreviewing;
	void	SetDownPriority(wxUint8 newDownPriority);
	bool	IsAutoDownPriority()	{ return m_bAutoDownPriority; }
	void	SetAutoDownPriority(bool flag) { m_bAutoDownPriority = flag; }
	void	UpdateAutoDownPriority();
	wxUint8	GetDownPriority()	{ return m_iDownPriority; }
        // Acess to Flag for SourceSharing
        bool    GetDisableXS()          { return m_DisableXS; }
        void    SetDisableXS(bool in)   { m_DisableXS = in; }
protected:
	bool	GetNextEmptyBlockInPart(wxUint16 partnumber,Requested_Block_Struct* result);
	bool	IsAlreadyRequested(wxUint32 start, wxUint32 end);
	void	CompleteFile(bool hashingdone);
	void	CreatePartFile();
	void	Init();
	wxMutex 	m_FileCompleteMutex;  // Lord KiRon - Mutex for file completion
private:
	wxUint16	count;
	wxUint16	transferingsrc;
	wxUint32  completedsize;
	wxUint64	m_iLostDueToCorruption;
	wxUint64	m_iGainDueToCompression;
	wxUint32  m_iTotalPacketsSavedDueToICH;
	wxUint32	datarate;
	char*	fullname;
	char*	partmetfilename;
	wxUint32	transfered;
	bool	paused;
	bool	stopped;
        bool    m_DisableXS;                  // Flag for SourceSharing
	wxUint8	m_iDownPriority;
	bool	m_bAutoDownPriority;
	wxUint8	status;
	bool	newdate;	             // indicates if there was a writeaccess to the .part file
	wxUint32	lastsearchtime;
	wxUint32	lastpurgetime;
	wxUint32	m_LastNoNeededCheck;
	CTypedPtrList<CPtrList, Gap_Struct*> gaplist;
	CTypedPtrList<CPtrList, Requested_Block_Struct*> requestedblocks_list;
	CArray<wxUint16,wxUint16> m_SrcpartFrequency;
	float	percentcompleted;
	CList<wxUint16,wxUint16>	corrupted_list;
	wxUint8	availablePartsCount;
	wxUint32	m_ClientSrcAnswered;
	wxUint32	m_nSavedReduceDownload;
	bool	m_bPercentUpdated;
	static	CBarShader s_LoadBar; 
	static	CBarShader s_ChunkBar; 
	bool	hasRating;
	bool	hasComment;
	bool 	PerformFileComplete(); // Lord KiRon
	static wxUint16 CompleteThreadProc(CPartFile* pFile); // Lord KiRon - Used as separate thread to complete file
	void    CharFillRange(wxString* buffer,float start, float end, char color);

	wxUint32	m_lastRefreshedDLDisplay;
	wxUint32   m_lastdatetimecheck;
	time_t	m_lastdatecheckvalue;

	// Barry - Buffered data to be written
	CTypedPtrList<CPtrList, PartFileBufferedData*> m_BufferedData_list;
	wxUint32 m_nTotalBufferData;
	wxUint32 m_nLastBufferFlushTime;
	wxUint8	m_category;
	
	wxUint32	m_LastSourceDropTime;

public:
	CTypedPtrList<CPtrList, CUpDownClient*> srclists[SOURCESSLOTS];
	bool	srcarevisible;		// used for downloadlistctrl
	bool	m_bShowOnlyDownloading;	// used for downloadlistctrl
	bool	hashsetneeded;
	wxUint16	GetMaxSourcesPerFile() { return m_MaxSourcesPerFile; }
	void	SetMaxSourcesPerFile(wxUint16 in) { m_MaxSourcesPerFile=in; }
	wxUint32  GetCompletedSize()   {return completedsize;}
	
	   /* Razor 1a - Modif by MikaelB */

          /* RemoveNoNeededSources function */
          void	RemoveNoNeededSources();

          /* RemoveFullQueueSources function */
          void	RemoveFullQueueSources();

          /* RemoveHighQueueRatingSources function */
          void	RemoveHighQueueRatingSources();

          /* CleanUpSources function */
          void	CleanUpSources();

          /* AddDownloadingSource function */
          void AddDownloadingSource(CUpDownClient* client);
          
          /* RemoveDownloadingSource function */
          void RemoveDownloadingSource(CUpDownClient* client);

          /* A4AF sources list */
          CTypedPtrList<CPtrList, CUpDownClient*> A4AFSourcesList;

          /* SetA4AFAuto function */
          void SetA4AFAuto(bool A4AFauto)
          {
            this->m_IsA4AFAuto = A4AFauto;
          }

          /* IsA4AFAuto function */
          bool IsA4AFAuto()
          {
            return this->m_IsA4AFAuto;
          }

      private:

          /* downloading sources list */
          CTypedPtrList<CPtrList, CUpDownClient*> m_downloadingSourcesList;

          /* A4AF Auto attribute */
          bool m_IsA4AFAuto;
	  wxUint16 	m_MaxSourcesPerFile;

/* End modif */
 
};


#endif
