// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// PreferencesDlg.cpp : implementation file

#ifdef PRECOMP
    #include "xmule-headers.h"
#endif

#include "PreferencesDlg.h"                 // Needed for this Interface's Prototype

#include "PPgGeneral.h"                     // Needed for CPPgGeneral
#include "PPgConnection.h"                  // Needed for CPPgConnection
#include "PPgServer.h"                      // Needed for CPPgServer
#include "PPgDirectories.h"                 // Needed for CPPgDirectories
#include "PPgFiles.h"                       // Needed for CPPgFiles
#include "PPgStats.h"                       // Needed for CPPgStats
#include "PPgNotify.h"                      // Needed for CPPgNotify
#include "PPgTweaks.h"                      // Needed for CPPgTweaks
#include "PPgSourcesDropping.h"             // Needed for CPPgSourcesDropping
#include "Preferences.h"                    // Needed for CPreferences
#include "Wizard.h"                         // Needed for Wizard
#include "xmule.h"                          // Needed for theApp

#include <wx/button.h>                      // Needed for wxButton;
#include <wx/notebook.h>                    // Needed for wxNotebook
#include <wx/xrc/xmlres.h>                  // Needed for wxXmlResource

IMPLEMENT_DYNAMIC_CLASS(CPreferencesDlg, wxDialog)

BEGIN_EVENT_TABLE(CPreferencesDlg, wxDialog)
EVT_BUTTON(wxOK, CPreferencesDlg::OnBtnOk)
EVT_BUTTON(wxCANCEL, CPreferencesDlg::OnBtnCancel)
END_EVENT_TABLE()

CPreferencesDlg::CPreferencesDlg(wxWindow *parent, CPreferences *prefs)
: wxDialog(parent, 9999, _("Preferences"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE |wxSYSTEM_MENU)
{
    //SetFont(wxFont(8,wxSWISS,wxNORMAL,wxNORMAL));
    // here comes brave new resource system
    wxNotebook *book = new wxNotebook(this, 7773, wxPoint(0, 0), wxSize(200, 200));
    wxPanel *page1;
    // load pages
    m_wndGeneral = new CPPgGeneral(book);
    m_wndConnection = new CPPgConnection(book);
    m_wndServer = new CPPgServer(book);
    m_wndFiles = new CPPgFiles(book);
    m_wndDirectories = new CPPgDirectories(book);
    m_wndStats = new CPPgStats(book);
    m_wndNotify = new CPPgNotify(book);
    m_wndTweaks = new CPPgTweaks(book);
    // Creating Sources Dropping window:
    m_wndSourcesDropping = new CPPgSourcesDropping(book);
    // Creating GUI Tweaks window:
    wxSize pageSize(520, 460);
    pageSize = m_wndGeneral->GetSize();
    SetSize(pageSize.GetWidth(), pageSize.GetHeight() + 40);
    book->SetSize(pageSize);
    // then the ok/cancel buttons please
    wxButton *mybut = new wxButton(this, wxOK, _("OK"), wxPoint(pageSize.GetWidth() - 2 *80 - 16, pageSize.GetHeight() + 10), wxSize(80, 24));
    wxButton *otbut = new wxButton(this, wxCANCEL, _("Cancel"), wxPoint(pageSize.GetWidth() - 80 - 8, pageSize.GetHeight() + 10), wxSize(80, 24));
    SetPrefs(prefs);
    Centre();
    // force font small enought to show the pages
    //_setFont(this);
    // now call page initializators
    // no. bad idea. no preferences yet.
    // do it at showmodal instead!
    //m_wndGeneral.LoadSettings();
    Localize();
}

CPreferencesDlg::~CPreferencesDlg()
{
}

int CPreferencesDlg::ShowModal()
{
    // setup pages
    m_wndGeneral->LoadSettings();
    m_wndFiles->LoadSettings();
    m_wndServer->LoadSettings();
    m_wndConnection->LoadSettings();
    m_wndDirectories->LoadSettings();
    m_wndStats->LoadSettings();
    m_wndNotify->LoadSettings();
    m_wndTweaks->LoadSettings();
    // Load settings in Dropping Sources window:
    m_wndSourcesDropping->LoadSettings();
    // and then do the show
    return wxDialog::ShowModal();
}

void CPreferencesDlg::OnBtnWizard(wxCommandEvent&evt)
{
    Wizard *test = new Wizard(this);
    //app_prefs);:
    test->SetPrefs(theApp.glob_prefs);
    test->OnInitDialog();
    test->ShowModal();
    delete test;
}

void CPreferencesDlg::OnBtnOk(wxCommandEvent&evt)
{
    // apply all pages
    m_wndGeneral->OnApply();
    m_wndConnection->OnApply();
    m_wndServer->OnApply();
    m_wndFiles->OnApply();
    m_wndDirectories->OnApply();
    m_wndStats->OnApply();
    m_wndNotify->OnApply();
    m_wndTweaks->OnApply();
    // OnApply in Sources Dropping:
    m_wndSourcesDropping->OnApply();
    // Save Preferences & Shared Directories
    app_prefs->Save(5);

    theApp.LoadCompatiblePrefs();

    EndModal(0);
}

void CPreferencesDlg::OnBtnCancel(wxCommandEvent&evt)
{
    EndModal(0);
}

void CPreferencesDlg::SetPrefs(CPreferences* in_prefs)
{
    app_prefs = in_prefs;
    m_wndGeneral->SetPrefs(in_prefs);
    m_wndConnection->SetPrefs(in_prefs);
    m_wndServer->SetPrefs(in_prefs);
    m_wndDirectories->SetPrefs(in_prefs);
    m_wndFiles->SetPrefs(in_prefs);
    m_wndStats->SetPrefs(in_prefs);
    m_wndNotify->SetPrefs(in_prefs);
    m_wndTweaks->SetPrefs(in_prefs);
    m_wndSourcesDropping->SetPrefs(in_prefs);  // Setting preferences to Sources Dropping
}
