// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef PREFERDLG_H
#define PREFERDLG_H

#include <wx/dialog.h>                      // Needed for wxDialog

class CPPgGeneral;
class CPPgConnection;
class CPPgServer;
class CPPgDirectories;
class CPPgFiles;
class CPPgStats;
class CPPgNotify;
class CPPgTweaks;
class CPPgSourcesDropping;
class CPreferences;

class CPreferencesDlg : public wxDialog
{
    friend class Wizard;
    DECLARE_DYNAMIC_CLASS(CPreferencesDlg)

public:
    CPreferencesDlg() {}
    CPreferencesDlg(wxWindow* parent,CPreferences* prefs);
    virtual ~CPreferencesDlg();
    void SetPrefs(CPreferences* in_prefs);
    virtual int ShowModal();

protected:
    unsigned short int m_nActiveWnd;
private:
    DECLARE_EVENT_TABLE()

    CPPgGeneral* m_wndGeneral;
    CPPgConnection* m_wndConnection;
    CPPgServer* m_wndServer;
    CPPgDirectories* m_wndDirectories;
    CPPgFiles* m_wndFiles;
    CPPgStats* m_wndStats;
    CPPgNotify* m_wndNotify;
    CPPgTweaks* m_wndTweaks;
    CPPgSourcesDropping* m_wndSourcesDropping;
    CPreferences *app_prefs;

    void OnBtnOk(wxCommandEvent& evt);
    void OnBtnCancel(wxCommandEvent& evt);
    void OnBtnWizard(wxCommandEvent& evt);

    void Localize(void) {}
};


#endif
