// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Franz Schneider (sf -at- fsch -dot- net / http://www.xmule.ws/)
//
// This file was a part of eMule
// Copyright (c) 2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef SEARCHDLG_H
#define SEARCHDLG_H

#include <wx/panel.h>                       // Needed for wxPanel
#include <wx/statbmp.h>                     // Needed for wxStaticBitmap

class Packet;
class wxComboBox;
class wxImageList;
class wxListEvent;
class wxTimer;
class wxTimerEvent;

class CSearchDlg: public wxPanel 
{
    DECLARE_DYNAMIC_CLASS(CSearchDlg)
public:
    CSearchDlg() { }
    CSearchDlg(wxWindow* pParent);
    virtual ~CSearchDlg();
    bool CheckTabNameExists(wxString searchString);
    void CreateNewTab(wxString searchString,wxUint32 nSearchID);
    void SearchEnd(char *packet,wxUint32 packetsize,wxUint32 nServerIP,wxUint16 nServerPort);
    void UpdateCatChoice();
    enum 
    {
        IDD_SEARCH,
        IDD = IDD_SEARCH 
    };
    // public member variables
    unsigned char packetbuffer[2048];
    int packetbufferz;
    bool globsearch;
    wxString name,minsize,maxsize,ava,ext;
    void ButtonCancel(wxCommandEvent& evt);
    void ButtonDownload(wxCommandEvent& evt);
    void SearchDialogOnMouse(wxMouseEvent& evt);
private:
    void Init();
    // event handlers
    void ButtonStart(wxCommandEvent& evt);
    void ButtonMore(wxCommandEvent& evt);
    void ButtonStartLink(wxCommandEvent& evt);
    void ButtonClearAll(wxCommandEvent& evt);
    void ButtonReset(wxCommandEvent& evt);
    void ButtonSaveTabs(wxCommandEvent& evt);
    void ButtonLoadTabs(wxCommandEvent& evt);
    void ButtonMouse(wxMouseEvent& evt);
    void ChoiceType(wxCommandEvent& evt);
    void ChoiceMethod(wxCommandEvent& evt);
    void InputName(wxCommandEvent& evt);
    void InputMinSize(wxCommandEvent& evt);
    void InputMaxSize(wxCommandEvent& evt);
    void InputAvailability(wxCommandEvent& evt);
    void InputExtension(wxCommandEvent& evt);
    void InputED2K(wxCommandEvent& evt);
    void ListSelectedSearchMask(wxListEvent& evt);
    void ListSortSearchMasks(wxListEvent& evt);
    void ListSortSearchResults(wxListEvent& evt);
    void PopupSearchResults(wxMouseEvent& evt);
    void PopupSearchMasks(wxMouseEvent& evt);
    void SearchResultsRemoveAll(wxCommandEvent& evt);
    void SearchResultsRemoveSelected(wxCommandEvent& evt);
    void SearchResultsCloseThisRL(wxCommandEvent& evt);
    void SearchResultsCloseAllRL(wxCommandEvent& evt);
    void SearchResultsCloseThisSM(wxCommandEvent& evt);
    void SearchResultsCloseAllSM(wxCommandEvent& evt);
    void OnTimer(wxTimerEvent& evt);
    // private methods
    void ExecuteLinkED2K();
    void ShowSearchMasks();
    void ShowSearchResults();
    wxString CreateWebQuery();
    // private member variables
    int srtab_deep,srtab_lock;
    int smaskhighest,smaskcurrent;

    wxImageList* ImageList;
    wxTimer* m_timer;
    wxStaticBitmap m_ctrlSearchFrm;
    wxStaticBitmap m_ctrlWebSearchFrm;
    wxStaticBitmap m_ctrlDirectDlFrm;
};

enum ESearchType {
    //NOTE: The numbers are *equal* to the entries in the comboxbox->TODO: use item data
    SearchTypeServer = 0,
    SearchTypeGlobal,
    SearchTypeJigleSOAP,
    SearchTypeJigle,
    SearchTypeFileDonkey
};

struct SSearchParams {
    SSearchParams(void) : dwSearchID((wxUint32)-1), eType(SearchTypeServer),
    ulMinSize(0), ulMaxSize(0), iAvailability(-1) {
    }
    wxUint32 dwSearchID;
    ESearchType eType;
    wxUint32 ulMinSize;
    wxUint32 ulMaxSize;
    int iAvailability;
    bool bMatchKeywords;
};

#endif // SEARCHDLG_H
