// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef SERVERLIST_H
#define SERVERLIST_H

#include "mfc.h"                            // Needed for CString

#include <wx/timer.h>                       // Needed for wxTimer

class CPreferences;
class CServer;
class Packet;

class CServerList
{
	friend class CServerListCtrl;
public:
	CServerList(CPreferences* in_prefs);
	~CServerList(void);
	bool		Init();
	bool		AddServer(CServer* in_server );
	void		RemoveServer(CServer* out_server);
	void		RemoveAllServers(void);
	bool		AddServermetToList(CString strFile, bool merge = true);
	void		AddServersFromTextFile(CString strFilename,bool isstaticserver=true);
	bool		SaveServermetToFile(); //<<--9/22/02
	void		ServerStats();
	void		ResetServerPos()	{serverpos = 0;}
	void		ResetSearchServerPos()	{searchserverpos = 0;}
	CServer*	GetNextServer();
	CServer*	GetNextSearchServer();
	CServer*	GetNextStatServer();
	CServer*	GetServerAt(wxUint32 pos);
	wxUint32	GetServerCount();
	CServer*	GetNextServer(CServer* lastserver); // slow
	CServer*	GetServerByIP(wxUint32 nIP);
	CServer*	GetServerByIP(wxUint32 nIP,wxUint16 nPort);
	CServer*	GetServerByAddress(char* address, wxUint16 port);
	bool		IsGoodServerIP( CServer* in_server ); //<<--
	void		GetStatus( wxUint32 &total, wxUint32 &failed, wxUint32 &user, wxUint32 &file, wxUint32 &tuser, wxUint32 &tfile, float &occ);
	void		GetUserFileStatus( wxUint32 &user, wxUint32 &file);
	bool		BroadCastPacket(Packet* packet); //send Packet to all server in the list
	void		CancelUDPBroadcast();
	void		Sort();
	void		MoveServerDown(CServer* aServer);
	wxUint32		GetServerPostion()	{return serverpos;}
	void		SetServerPosition(wxUint32 newPosition) { if (newPosition<(wxUint32)list.GetCount() ) serverpos=newPosition; else serverpos=0;}
	wxUint32		GetDeletedServerCount()		{return delservercount;}
	void		Process();
	void		SendNextPacket();

protected:
	void		AutoUpdate();

private:
	wxUint32		serverpos;
	wxUint32		searchserverpos;
	wxUint32		statserverpos;
	wxUint8		version;
	wxUint32		servercount;
	CTypedPtrList<CPtrList, CServer*>	list;
	CPreferences*	app_prefs;
	wxTimer         udp_timer;
	POSITION	broadcastpos;
	Packet*		broadcastpacket;
	wxUint32		delservercount;
	wxUint32		m_nLastSaved;
};

#endif
