// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifdef PRECOMP
    #include "xmule-headers.h"
#endif

#include <wx/sizer.h>                       // Needed for wxSizer::Show

#include "ServerWnd.h"                      // Needed for this Interface's Prototype

#include "config.h"                         // Needed for PACKAGE_VERSION
#include "HTTPDownloadDlg.h"                // Needed for CHttpDownloadDlg
#include "muuli_wdr.h"                      // Needed for ID_ADDTOLIST
#include "otherfunctions.h"                 // Needed for GetResString
#include "Preferences.h"                    // Needed for CPreferences
#include "server.h"                         // Needed for CServer
#include "ServerList.h"                     // Needed for CServerList
#include "ServerListCtrl.h"                 // Needed for CServerListCtrl
#include "xmule.h"                          // Needed for theApp
#include "xmuleDlg.h"                       // Needed for CxmuleDlg

IMPLEMENT_DYNAMIC_CLASS(CServerWnd, wxPanel)

BEGIN_EVENT_TABLE(CServerWnd, wxPanel)
EVT_BUTTON(ID_ADDTOLIST, CServerWnd::OnBnClickedAddserver)
EVT_BUTTON(ID_UPDATELIST, CServerWnd::OnBnClickedUpdateservermetfromurl)
EVT_BUTTON(ID_BTN_RESET, CServerWnd::OnBnClickedResetLog)
END_EVENT_TABLE()

#include <wx/textctrl.h>

CServerWnd::CServerWnd(wxWindow *pParent): wxPanel(pParent, CServerWnd::IDD)
{
    SetBackgroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_WINDOWFRAME));
    wxSizer *content = serverListDlg(this, TRUE);
    content->Show(this, TRUE);
    // init serverlist
    // no use now. too early.
    CServerListCtrl *list = (CServerListCtrl *) wxFindWindowByName("serverListCtrl");
    serverlistctrl = list;
    wxTextCtrl *cv = (wxTextCtrl *) FindWindowByName("serverInfo");
    cv->AppendText(wxString(_("This is ")) + wxString("xMule") + wxString(" ") + PACKAGE_VERSION + wxString(_(" (based on ")) + wxString(_("eMule")) + wxString(")\n"));
    cv->AppendText(wxString(_("Visit http://xmule.hopto.org/ to check if a new version is available.\n")));
}

CServerWnd::~CServerWnd()
{
}

void CServerWnd::UpdateServerMetFromURL(wxString strURL)
{
    // not a valid URL:
    if (strURL.Find("://") == - 1)
    {
        theApp.xmuledlg->AddLogLine(true, GetResString(IDS_INVALIDURL));
        return;
    }
    wxString strTempFilename;
    strTempFilename = wxString::Format("%stemp-%d-server.met", theApp.glob_prefs->GetAppDir(),::GetTickCount());
    CHTTPDownloadDlg *dlg = new CHTTPDownloadDlg(this, strURL, strTempFilename);
    int retval = dlg->ShowModal();
    if (retval == 0)
    {
        // wget succeeded. proceed with serverlist processing
        serverlistctrl->AddServermetToList(strTempFilename);
        wxRemoveFile(strTempFilename);
        theApp.serverlist->SaveServermetToFile();
    }
    else
    {
        theApp.xmuledlg->AddLogLine(true, GetResString(IDS_ERR_FAILEDDOWNLOADMET) .GetData(), strURL.GetData());
    }
    delete dlg;
}

void CServerWnd::Localize()
{
}

void CServerWnd::OnBnClickedAddserver(wxCommandEvent&evt)
{
    wxString serveraddr;
    if (((wxTextCtrl *) FindWindowByName("ipAddress"))->GetLineText(0) .IsEmpty())
    {
        theApp.xmuledlg->AddLogLine(true, GetResString(IDS_SRV_ADDR));
        return;
    }
    else
    serveraddr = ((wxTextCtrl *) FindWindowByName("ipAddress"))->GetLineText(0);
    if (((wxTextCtrl *) FindWindowByName("portNumber"))->GetLineText(0) .IsEmpty())
    {
        theApp.xmuledlg->AddLogLine(true, GetResString(IDS_SRV_PORT));
        return;
    }
    wxString portstr;
    portstr = ((wxTextCtrl *) FindWindowByName("portNumber"))->GetLineText(0);
    CServer *toadd = new CServer(atoi(portstr.GetData()), (char *) serveraddr.GetData());
    wxString servername;
    servername = ((wxTextCtrl *) FindWindowByName("serverName"))->GetLineText(0);
    if (!servername.IsEmpty())
    {
        toadd->SetListName((char *) servername.GetData());
        //delete[] servername;
    }
    else
    {
        toadd->SetListName((char *) serveraddr.GetData());
    }
    if (!serverlistctrl->AddServer(toadd, true))
    {
        CServer *update = theApp.serverlist->GetServerByAddress(toadd->GetAddress(), toadd->GetPort());
        if (update)
        {
            update->SetListName(toadd->GetListName());
            serverlistctrl->RefreshServer(update);
        }
        delete toadd;
        theApp.xmuledlg->AddLogLine(true, GetResString(IDS_SRV_NOTADDED));
    }
    else theApp.xmuledlg->AddLogLine(true, GetResString(IDS_SERVERADDED) + "%s", toadd->GetListName());
    theApp.serverlist->SaveServermetToFile();
}

void CServerWnd::OnBnClickedUpdateservermetfromurl(wxCommandEvent&evt)
{
    wxString strURL;
    strURL = ((wxTextCtrl *) FindWindowByName("serverlistURL"))->GetLineText(0);
    UpdateServerMetFromURL(strURL);
}

void CServerWnd::OnBnClickedResetLog(wxCommandEvent&evt)
{
    theApp.xmuledlg->ResetLog();
}

void CServerWnd::UpdateMyInfo()
{
    //	printf("TODO: MyInfo @ CServerWnd (GUI missing)\n");
}

